#!/bin/sh

PKG_STR_SHARE_FOLDER_NAME="ชื่อ"
PKG_STR_SHARE_FOLDER_VOLUME="ตำแหน่ง"
PKG_STR_SHARE_COW_ENABLE="เปิดใช้งานการปกป้องการคงสภาพของข้อมูลขั้นสูง"
PKG_STR_VOLUME_FREE_SIZE="พร้อมใช้งาน"
PKG_STR_WIZARD_INSTALL_TITLE="ตั้งค่าโฟลเดอร์เริ่มต้นสำหรับการบันทึก"
PKG_STR_WIZARD_INSTALL_SETTINGS="การตั้งค่าการติดตั้ง"
PKG_STR_CUSTOMIZED_TITLE="ผู้ใช้สามารถลงชื่อเข้าใช้ Surveillance Station โดยตรง ในหน้าต่างเบราว์เซอร์ใหม่โดยไม่ต้องเข้าสู่ DSM เมื่อเปิดใช้งานนามแฝงหรือพอร์ตที่กำหนดเอง"
PKG_STR_CUSTOMIZED_ALIAS="เปิดใช้นามแฝงที่กำหนดเอง"
PKG_STR_CUSTIMIZED_HTTP="เปิดใช้งานพอร์ต HTTP ที่กำหนดเอง"
PKG_STR_CUSTIMIZED_HTTPS="เปิดใช้งานพอร์ต HTTPS ที่กำหนดเอง"
PKG_STR_CUSTIMIZED_HINT="เข้าสู่ระบบที่"
PKG_STR_ALIAS="นามแฝง"
PKG_STR_PORT="พอร์ท"
PKG_STR_INVALID_ALIAS="นามแฝงที่คุณป้อนไม่ถูกต้อง"
PKG_STR_INVALID_PORT="หมายเลขพอร์ทควรมีค่าตั้งแต่ 1 ถึง 65535"
PKG_SELECT_VOLUME_TIP="* เพื่อเพิ่มประสิทธิภาพของการบันทึก โปรดเลือกพื้นที่เก็บข้อมูลที่มีความเร็วสูงสุด และปิดใช้งานฟังก์ชันการปกป้องการคงสภาพของข้อมูลขั้นสูง"

# Copyright (c) 2017 Synology Inc. All rights reserved.

SYNO_SHARE_TOOL="/usr/syno/sbin/synoshare"
DEFAULT_SHARED_FOLER_NAME="surveillance"
DEF_SYNOINFO_CONF="/etc.defaults/synoinfo.conf"
MODEL_NAME="$(/bin/get_key_value "${DEF_SYNOINFO_CONF}" "upnpmodelname")"
FILE_SYSTEM_HFS_PLUS="hfsplus"
LOCAL_IP=$(ifconfig eth0 2>/dev/null|awk '/inet addr:/ {print $2}'|sed 's/addr://')

INSTALL_USER_SETTINGS_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_INSTALL_SETTINGS}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "textfield",
		"desc": "${PKG_STR_CUSTOMIZED_TITLE}",
		"subitems": []
	}, {
		"type": "multiselect",
		"desc": "",
		"subitems": [{
			"key": "chkSVS_Alias",
			"desc": "${PKG_STR_CUSTOMIZED_ALIAS} (${PKG_STR_CUSTIMIZED_HINT}: https://${LOCAL_IP}/cam)",
			"validator": {
				"fn" : "{
					/* DSM ui creates redundant pages when returning to last page multiple times */
					var aliasElems = Ext.select('[name=strSVS_Alias]').elements;
					var aliasField = Ext.getCmp(aliasElems[aliasElems.length - 1].id);
					var chkElems = Ext.select('[name=chkSVS_Alias]').elements;
					var chkBox = Ext.getCmp(chkElems[chkElems.length - 1].id);

					aliasField.setDisabled(false === chkBox.getValue());
				}"
			}
		}]
	}, {
		"type": "textfield",
		"desc": "",
		"subitems": [{
			"key": "strSVS_Alias",
			"indent": 1,
			"desc": "${PKG_STR_ALIAS}",
			"defaultValue": "cam",
			"validator": {
				"allowBlank": false,
				"minLength": 2,
				"maxLength": 20,
				"fn": "{
					var aliasElems = Ext.select('[name=strSVS_Alias]').elements;
					var chkElems = Ext.select('[name=chkSVS_Alias]').elements;
					var userAlias = Ext.getCmp(aliasElems[aliasElems.length - 1].id).getValue();
					var chkBox = Ext.getCmp(chkElems[chkElems.length - 1].id);
					var re = new RegExp('^[A-Za-z0-9][A-Za-z0-9-_]*[A-Za-z0-9]$');
					var ret = userAlias.match(re);

					if (true !== chkBox.apiSent) {
						chkBox.sendWebAPI({
							api: 'SYNO.Core.AppPortal',
							version: 2,
							method: 'list',
							params: { additional: ['default_setting'] },
							callback: function(apiSucc, apiResp, params, opts) {
								if (apiSucc) {
									this.portalInfo = apiResp.portal;
								}
							},
							scope: this
						});
						chkBox.apiSent = true;
					}

					if (true === Ext.isDefined(this.portalInfo)) {
						for (var i = 0; i < this.portalInfo.length; i++) {
							var rec = this.portalInfo[i];

							if ((rec.additional) && (rec.additional.default_setting) &&
								(userAlias === rec.additional.default_setting.alias)) {
								return _T('app_port_alias', 'err_alias_refused');
							}
							if (userAlias === rec.alias) {
								return _T('app_port_alias', 'err_alias_used');
							}
						}
					}

					if ((2 <= userAlias.length) && (20 >= userAlias.length)) {
						chkBox.boxlabelEl.update('${PKG_STR_CUSTOMIZED_ALIAS} (${PKG_STR_CUSTIMIZED_HINT}: https://${LOCAL_IP}/' + userAlias + ')');
					}

					return (ret) ? true : '${PKG_STR_INVALID_ALIAS}';

				}"
			}
		}]
	}, {
		"type": "multiselect",
		"desc": "",
		"subitems": [{
			"key": "chkSVS_HTTP",
			"desc": "${PKG_STR_CUSTIMIZED_HTTP} (${PKG_STR_CUSTIMIZED_HINT}: https://${LOCAL_IP}:9900)",
			"validator": {
				"fn" : "{
					var portElems = Ext.select('[name=strSVS_HTTP]').elements;
					var portField = Ext.getCmp(portElems[portElems.length - 1].id);
					var chkElems = Ext.select('[name=chkSVS_HTTP]').elements;
					var chkBox = Ext.getCmp(chkElems[chkElems.length - 1].id);

					portField.setDisabled(false === chkBox.getValue());
				}"
			}
		}]
	}, {
		"type": "textfield",
		"desc": "",
		"subitems": [{
			"key": "strSVS_HTTP",
			"indent": 1,
			"desc": "${PKG_STR_PORT}",
			"defaultValue": "9900",
			"invalidText": "$PKG_STR_INVALID_PORT",
			"validator": {
				"allowBlank": false,
				"fn": "{
					var boxElems = Ext.select('[name=chkSVS_HTTP]').elements;
					var chkBox = Ext.getCmp(boxElems[boxElems.length - 1].id);
					var port = parseInt(arguments[0]);
					var re = new RegExp('^[0-9]*$');
					var blValid = ((arguments[0].match(re)) && (0 < port) && (65536 > port));

					if (true === blValid) {
						chkBox.boxlabelEl.update('${PKG_STR_CUSTIMIZED_HTTP} (${PKG_STR_CUSTIMIZED_HINT}: https://${LOCAL_IP}/' + port + ')');
						if ('0' === arguments[0][0]) {
							var portElems = Ext.select('[name=strSVS_HTTP]').elements;
							var portField = Ext.getCmp(portElems[portElems.length - 1].id);

							portField.setValue(port.toString());
						}
					}

					return blValid;
				}"
			}
		}]
	}, {
		"type": "multiselect",
		"desc": "",
		"subitems": [{
			"key": "chkSVS_HTTPS",
			"desc": "${PKG_STR_CUSTIMIZED_HTTPS} (${PKG_STR_CUSTIMIZED_HINT}: https://${LOCAL_IP}:9901)",
			"validator": {
				"fn" : "{
					var portElems = Ext.select('[name=strSVS_HTTPS]').elements;
					var portField = Ext.getCmp(portElems[portElems.length - 1].id);
					var chkElems = Ext.select('[name=chkSVS_HTTPS]').elements;
					var chkBox = Ext.getCmp(chkElems[chkElems.length - 1].id);

					portField.setDisabled(false === chkBox.getValue());
				}"
			}
		}]
	}, {
		"type": "textfield",
		"desc": "",
		"subitems": [{
			"key": "strSVS_HTTPS",
			"indent": 1,
			"desc": "${PKG_STR_PORT}",
			"defaultValue": "9901",
			"invalidText": "$PKG_STR_INVALID_PORT",
			"validator": {
				"allowBlank": false,
				"minLength": 1,
				"maxLength": 5,
				"fn": "{
					var boxElems = Ext.select('[name=chkSVS_HTTPS]').elements;
					var chkBox = Ext.getCmp(boxElems[boxElems.length - 1].id);
					var port = parseInt(arguments[0]);
					var re = new RegExp('^[0-9]*$');
					var blValid = ((arguments[0].match(re)) && (0 < port) && (65536 > port));

					if (true === blValid) {
						chkBox.boxlabelEl.update('${PKG_STR_CUSTIMIZED_HTTPS} (${PKG_STR_CUSTIMIZED_HINT}: https://${LOCAL_IP}/' + port + ')');
						if ('0' === arguments[0][0]) {
							var portElems = Ext.select('[name=strSVS_HTTPS]').elements;
							var portField = Ext.getCmp(portElems[portElems.length - 1].id);

							portField.setValue(port.toString());
						}
					}

					return blValid;
				}"
			}
		}]
	}]
}
EOF`

GetLocalVol()
{
	local Location

	if [ "EDS14" == "${MODEL_NAME}" ] ; then
		Location="external"
	else
		Location="internal"
	fi

	env -i HTTP_X_SYNO_RELAY_LANGUAGE=${SYNOPKG_DSM_LANGUAGE} /usr/syno/bin/synowebapi --exec api=SYNO.Core.Storage.Volume method=list version=1 limit=-1 offset=0 location='"'${Location}'"'
}

GetJsonKeyStr()
{
	local Key=$1

	sed -n 's/[[:blank:]]*"'"${Key}"'"[[:blank:]]*:[[:blank:]]*"\([^"]*\)".*/\1/p'
}

ReplaceNewline()
{
	local Filler=$1

	sed ':a;$!N;s/\n/'"${Filler}"'/;ta'
}

CreateJsonStrList()
{
	local Json=$1
	local Key=$2
	local Filler=$3

	echo "${Json}" |\
	GetJsonKeyStr "${Key}" |\
	ReplaceNewline "${Filler} ${Filler}" |\
	sed 's/\(.*\)/'"${Filler}\1${Filler}"'/'
}

GetStrListValue()
{
	local List=$1
	local Idx=$2

	echo "$List" | awk -F '" ' -v idx="$Idx" '{ gsub(/"/, "", $idx); print $idx }'
}

CreateDisplayName()
{
	local StrList=$1
	local Size=$2
	local Idx=$3
	local Name=$(GetStrListValue "${StrList}" ${Idx})

	awk 'BEGIN{printf "'"${Name}"' ('"${PKG_STR_VOLUME_FREE_SIZE}"': %.2f GB)",'${Size}'/1024/1024/1024}'
}

CreateVolStore()
{
	local VolJson=$1
	local NameList=$(CreateJsonStrList "${VolJson}" "display_name" "\"")
	local SizeList=$(CreateJsonStrList "${VolJson}" "size_free_byte" "")
	local PathList=$(CreateJsonStrList "${VolJson}" "volume_path" "\"")
	local FSTypeList=$(CreateJsonStrList "${VolJson}" "fs_type")
	local VolStore Idx RowName RowPath FSType

	#create volume store
	Idx=1
	for Size in ${SizeList}; do
		FSType="$(echo "${FSTypeList}" | awk '{print $'"$Idx"'}')"

		if [ 0 \< ${Size} -a "${FILE_SYSTEM_HFS_PLUS}" != "${FSType}" ]; then
			RowPath=$(GetStrListValue "${PathList}" ${Idx})
			RowName=$(CreateDisplayName "${NameList}" ${Size} ${Idx})

			VolStore="${VolStore},[\"${RowPath}\",\"${RowName}\",\"${FSType}\"]"
		fi
		Idx=$(expr ${Idx} + 1)
	done

	echo "${VolStore}" | sed 's/,\(.*\)/\1/'
}

GetLocalVolListSize()
{
	local VolJson=$1
	local FreeSizeList=$(CreateJsonStrList "${VolJson}" "size_free_byte" "")
	local VolCnt=0

	for FreeSize in ${FreeSizeList}; do
		if [ 0 \< ${FreeSize} ]; then
			VolCnt=$(expr ${VolCnt} + 1)
		fi
	done

	echo ${VolCnt}
}

GetFirstVolume()
{
	local VolStore=$1

	echo "${VolStore}" | sed 's,[^"]*"\([^"]*\)".*,\1,'
}

SearchSharedFolder()
{
	local SharedFolderName="${DEFAULT_SHARED_FOLER_NAME}"

	${SYNO_SHARE_TOOL} --enum ALL | grep -v : | grep "^${SharedFolderName}$"
}

GetSharedFolderPage()
{
	local Page=""

	if [ -n "$(SearchSharedFolder)" ]; then
		echo ""
		return
	fi

	local LocalVolJson=$(GetLocalVol)

	if [ 1 -ge $(GetLocalVolListSize "${LocalVolJson}") ]; then
		echo ""
		return
	fi

	local DsVolStore=$(CreateVolStore "${LocalVolJson}")
	local FirstVol=$(GetFirstVolume "${DsVolStore}")

	Page=`/bin/cat<<EOF
	{
		"step_title": "${PKG_STR_WIZARD_INSTALL_TITLE}",
		"items": [{
			"type": "textfield",
			"subitems": [{
				"key": "share_name",
				"desc": "${PKG_STR_SHARE_FOLDER_NAME}",
				"value": "${DEFAULT_SHARED_FOLER_NAME}",
				"disabled": true
			}]
		}, {
			"type": "combobox",
			"subitems": [{
				"key": "vol_path",
				"desc": "${PKG_STR_SHARE_FOLDER_VOLUME}",
				"editable": false,
				"mode": "local",
				"value": "${FirstVol}",
				"valueField": "volume_path",
				"displayField": "display_name",
				"store": {
					"xtype": "arraystore",
					"fields": ["volume_path", "display_name", "fs_type"],
					"data": [${DsVolStore}]
				}
			}]
		}]
	}
EOF`

	echo "$Page"
}

GetInstallNotePages()
{
	local Pages="$(GetSharedFolderPage)"

	if [ -z "$Pages" ]; then
		Pages="${INSTALL_USER_SETTINGS_PAGE}"
	else
		Pages="${Pages},${INSTALL_USER_SETTINGS_PAGE}"
	fi

	echo "[$Pages]"
}

InstallNotePages="$(GetInstallNotePages)"

if [ "[]" == "$InstallNotePages" ]; then
	exit 0
fi

echo "$InstallNotePages" > $SYNOPKG_TEMP_LOGFILE

exit 0
