#!/bin/sh

PKG_STR_WIZARD_UPGRADE_TITLE="Před pokračováním přečíst"
PKG_STR_WIZARD_UPGRADE_NOTE="Upgradování na Surveillance Station vyžaduje převod databáze, a proto může tato operace chvíli trvat, v závislosti na počtu záznamů v databázi. Trpělivě prosím vyčkejte a během tohoto procesu systém nevypínejte ani neprovádějte odinstalaci balíčků."
PKG_STR_WIZARD_UPGRADE_VS_60_80_NOTE="Tato verze aplikace Surveillance Station je kompatibilní pouze se zařízením VisualStation {0} a novějšími. Modely VS60 a VS80 již nejsou touto verzí aplikace Surveillance Station podporovány."
PKG_STR_WIZARD_UPGRADE_VS_360HD_NOTE="Po upgradu zařízení VS360HD na verzi 4.0 nebo vyšší bude původní funkce párování zařízení Visual Station nahrazena novým mechanismem přihlášení. Do služby Surveillance Station se bude možné přihlásit přímo ze zařízení Synology VisualStation VS360HD. Zařízení VS360HD bude navíc podporovat všechny funkce síťového nahrávání videa obsažené ve službě Surveillance Station.<br><br>Aktuální verze služby Surveillance Station je kompatibilní jak s původní funkcí párování zařízení VisualStation verze 3.0.5, tak s novým mechanismem přihlášení zařízení VisualStation verze 4.0. Původní funkce párování bude ale v dalších aktualizacích ukončena."
PKG_STR_WIZARD_UPGRADE_PSIA_NOTE="Od této verze služba Surveillance Station již nepodporuje standard PSIA. Kamery nastavené pomocí standardu PSIA nelze ve službě Surveillance Station používat."
PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL="Rozumím omezením kompatibility a chci pokračovat v aktualizaci."
PKG_STR_WIZARD_UPGRADE_DOOR_LICENSE="Tato verze služby Surveillance Station používá nové licenční podmínky pro řadiče přístupu.<br><br>Každý nově přidaný řadič přístupu bude považován za jedno sledovací zařízení a bude vyžadovat licenci pro sledovací zařízení podobně jako IP kamery a I/O moduly. Dříve nainstalované řadiče přístupu bude ale možné používat bez licencí i po této aktualizaci."
PKG_STR_WIZARD_DOOR_LICENSE_CHECK_LABEL="Rozumím novým licenčním podmínkám pro řadiče přístupu a chci pokračovat v aktualizaci."
PKG_STR_WIZARD_DOOR_PRIVILEGE_CHECK_NOTE="Po upgradování na tuto verzi bude správa oprávnění ovladačů dveří přesunuta do části Profil oprávnění na stránce Uživatelé."
PKG_STR_WIZARD_UPGRADE_LABEL="Rozumím změnám, které budou provedeny a souhlasím s pokračováním v aktualizaci."

# Copyright (c) 2015 Synology Inc. All rights reserved.

SS_PKG_PATH="/var/packages/SurveillanceStation/"
SS_INFO_FILE=${SS_PKG_PATH}"INFO"
SS_SYSTEM_DB_FILE=${SS_PKG_PATH}"target/system.db"
SS_AXISDOOR_DB_FILE=${SS_PKG_PATH}"target/axisacsctrl.db"
SS_AXISDOORLOG_DB_FILE=${SS_PKG_PATH}"target/@surveillance/axisacsevtlog.db"
SS_VER_KEY="version"
SS_SQLITE3_VER="6.3"
SS_THUMBNAIL_ISSUE_BUILD_VER="3312"
SS_THUMBNAIL_FIXED_BUILD_VER="3352"
SS_ADD_DOORLOG_INDEX_BUILD_VER="5372"
VS_MODELS_60_80="'VS60', 'VS80'"
VS_MODELS_360HD="'VS360HD'"
VS_360HD_NEW_LOGIN_MECHANISM_MIN_VERSION="'4.0'"
SS_UNSUPPORT_VENDOR="('PSIA')"
SS_MIN_VS_60_80_VERSION="2.2-1413"
SS_MIN_VS_360_VERSION="3.1-2500"
SS_SQLITE3="${SS_PKG_PATH}target/bin/sqlite3"
DEF_SQLITE3="/usr/syno/bin/sqlite3"
SS_MIN_DOOR_LICENSE_VERSION="8.0.0-5090"
SS_MIN_DOOR_PRIVILEGE_VERSION="8.1.0-5323"
FN_CHECK_BOX_VALIDATOR="{ var blChecked = arguments[0]; return true === blChecked; }"

UPGRADE_VS_60_80_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "$(echo $PKG_STR_WIZARD_UPGRADE_VS_60_80_NOTE | sed "s/{0}/${SS_MIN_VS_60_80_VERSION}/g")",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_VS_360_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"items": [{
		"desc": "$PKG_STR_WIZARD_UPGRADE_VS_360HD_NOTE"
	}]
}
EOF`

UPGRADE_PSIA_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "${PKG_STR_WIZARD_UPGRADE_PSIA_NOTE}",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_DB_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"desc": "${PKG_STR_WIZARD_UPGRADE_NOTE}"
	}]
}
EOF`

UPGRADE_DOOR_LICENSE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "$PKG_STR_WIZARD_UPGRADE_DOOR_LICENSE",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_DOOR_LICENSE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_DOOR_PRIVILEGE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "${PKG_STR_WIZARD_DOOR_PRIVILEGE_CHECK_NOTE}",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_UPGRADE_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

Sqlite3Exec()
{
	local sqlite_bin=""
	if [ -f "$SS_SQLITE3" ]; then
		sqlite_bin=$SS_SQLITE3
	else
		sqlite_bin=$DEF_SQLITE3
	fi

	$sqlite_bin -init /dev/null -cmd ".timeout 300000" "$@"
}

IsUpgradeToSqlite3()
{
	local PreSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 1)

	if [ ${SS_SQLITE3_VER} \> ${PreSSVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeToDoorLicense()
{
	local TargetSSVer=$(echo ${SS_MIN_DOOR_LICENSE_VERSION} | sed 's/\.//g' | sed 's/-//g')
	local CurrentSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}")

	CurrentSSVer=$(echo ${CurrentSSVer} | sed 's/\.//g' | sed 's/-//g')

	if [ "${TargetSSVer}" -gt "${CurrentSSVer}" ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeThumbnailToFile()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 2)

	if [ ${SS_THUMBNAIL_ISSUE_BUILD_VER} -le ${PreSSBuildVer} ] && [ ${SS_THUMBNAIL_FIXED_BUILD_VER} -gt ${PreSSBuildVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeToDoorPrivilege()
{
	local TargetSSVer=$(echo ${SS_MIN_DOOR_PRIVILEGE_VERSION} | sed 's/\.//g' | sed 's/-//g')
	local CurrentSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}")

	CurrentSSVer=$(echo ${CurrentSSVer} | sed 's/\.//g' | sed 's/-//g')

	if [ "${TargetSSVer}" -ge "${CurrentSSVer}" ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasVS()
{
	local Models="$1"
	local MinVersion="$2"
	local SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models)"

	if [ -n "$MinVersion" ]; then
		SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models) AND version < $MinVersion"
	else
		SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models)"
	fi

	CheckSystemDBItemExist "${SqlCmd}"
}

HasPsiaCam()
{
	local SqlCmd="SELECT COUNT(*) FROM camera WHERE vendor IN ${SS_UNSUPPORT_VENDOR}"

	CheckSystemDBItemExist "${SqlCmd}"
}

HasDoor()
{
	local DoorCount=$(sqlite3 $SS_AXISDOOR_DB_FILE "SELECT COUNT (id) FROM axisacsctrler where id IS NOT NULL")

	if [ $DoorCount -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasLargeDoorLog()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 2)
	local DoorLogCount=$(sqlite3 $SS_AXISDOORLOG_DB_FILE "SELECT COUNT (*) FROM axisacsevtlog")

	if [ ${SS_ADD_DOORLOG_INDEX_BUILD_VER} -gt ${PreSSBuildVer} ] && [ ${DoorLogCount} -gt 60000 ]; then
		echo "true"
	else
		echo "false"
	fi
}

CheckSystemDBItemExist()
{
	local SqlCmd="$1"
	local Cnt=$(Sqlite3Exec $SS_SYSTEM_DB_FILE "$SqlCmd")

	if [ -z "${Cnt}" ]; then
		if [ -f /usr/syno/pgsql/bin/psql ]; then
			Cnt=$(/usr/syno/pgsql/bin/psql -A -t -U postgres surveillance -c "${SqlCmd}")
		else
			Cnt=0
		fi
	fi

	if [ ${Cnt} -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

GetUpgradeNotePages()
{
	local Pages=""

	if [ "true" == $(HasPsiaCam) ]; then
		Pages="${UPGRADE_PSIA_NOTE_PAGE}"
	fi

	if [ "true" == $(HasVS "$VS_MODELS_60_80") ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_VS_60_80_NOTE_PAGE}" \
						|| Pages="${Pages},${UPGRADE_VS_60_80_NOTE_PAGE}"
	fi

	if [ "true" == $(HasVS "$VS_MODELS_360HD" "$VS_360HD_NEW_LOGIN_MECHANISM_MIN_VERSION") ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_VS_360_NOTE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_VS_360_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToSqlite3) ] || [ "true" == $(IsUpgradeThumbnailToFile) ] || [ "true" == $(HasLargeDoorLog) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DB_NOTE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DB_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToDoorLicense) ] && [ "true" == $(HasDoor) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DOOR_LICENSE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DOOR_LICENSE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToDoorPrivilege) ] && [ "true" == $(HasDoor) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DOOR_PRIVILEGE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DOOR_PRIVILEGE_PAGE}"
	fi

	echo "[$Pages]"
}

main()
{
	local UpgradeNotePages="$(GetUpgradeNotePages)"

	if [ "[]" == "$UpgradeNotePages" ]; then
		exit 0
	fi

	echo "$UpgradeNotePages" > $SYNOPKG_TEMP_LOGFILE

	exit 0
}

main "$@"
