#!/bin/sh
# Copyright (c) 2017 Synology Inc. All rights reserved.

# Designed to be sourced by surveillance_share_xxx.sh hook script;
# should contain the following variables:
#   - ORIGIN_SHARE_NAME / SHARE_NAME
#   - ORIGIN_SHARE_PATH / SHARE_PATH

SURVEILLANCE_INC_SCRP=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
. ${SURVEILLANCE_INC_SCRP}

SharePreSetHook()
{
	local ToDisable="$1"
	local ToEncrypt="$2"

	if [ -f "$SS_SYSTEM_DB" ]; then
		local SharePaths=$(Sqlite3Exec "${SS_SYSTEM_DB}" "SELECT path from recordingshare WHERE owner_ds_id = 0 AND mount_type = 0;")
		local IFS=$'\n'

		for Path in $SharePaths; do
			if [ "$Path" == "$ORIGIN_SHARE_PATH" ]; then
				${SS_RECSHARE_CTRL} "pre-set-rec-share" "$ORIGIN_SHARE_PATH" "$ORIGIN_SHARE_NAME" "$ToDisable" "$ToEncrypt"
				break
			fi
		done
	fi
}

SharePostSetHook()
{
	local ToEnable="$1"
	local ToDecrypt="$2"

	if [ "$DEFAULT_SS_SHARE_NAME" == "$SHARE_NAME" ]; then
		HandleSSShareSetForEDS14
		${SS_RECSHARE_CTRL} "update-ss-service-link" # compensate DSM automatically add service link
	fi

	if [ -f "$SS_SYSTEM_DB" ]; then
		local SharePaths=$(Sqlite3Exec "${SS_SYSTEM_DB}" "SELECT path from recordingshare WHERE owner_ds_id = 0 AND mount_type = 0;")
		local IFS=$'\n'

		for Path in $SharePaths; do
			if [ "$Path" == "${ORIGIN_SHARE_PATH}" -o true == $(IsEds14AddSSShare) ]; then
				${SS_RECSHARE_CTRL} "post-set-rec-share" "$ORIGIN_SHARE_PATH" "$SHARE_PATH" \
									"$SHARE_NAME" "$ToEnable" "$ToDecrypt"
				break
			fi
		done
	fi

	if [ "$DEFAULT_SS_SHARE_NAME" == "$SHARE_NAME" ]; then
		CheckToLeaveNonRecModeForEDS14
		CheckSSSharePrivilege
	fi
}

#################
##    Utils    ##
#################

HandleSSShareSetForEDS14()
{
	if [ false == $(IsModelEDS14) ]; then
		return
	fi

	MigrateServiceDataDir
	__CheckSSShareFolderLink
	UpdateActiveVolume

	if [ -z "$ORIGIN_SHARE_PATH" -a -f $SS_SYSTEM_DB ]; then
		$SS_RECSHARE_CTRL "update-default-share"
	fi
}

CheckToLeaveNonRecModeForEDS14()
{
	if [ false == $(IsModelEDS14) -o false == $(IsNonRecordingMode) ]; then
		return
	fi

	if [ true == $(IsServiceDataLinkAlive) ]; then
		CheckToCreateRecDB
		SetNonRecordingMode false share-set "$SHARE_NAME"
	fi
}

MigrateServiceDataDir()
{
	local DstDir=$(dirname $SHARE_PATH)/$SS_SERVICE_DATA_FOLDER_NAME
	local SrcDir=$(GetServiceSrcDirCandidate)

	if [ -d "$SrcDir" -a ! -d "$DstDir" -a "$DstDir" != "$SrcDir" ]; then
		SSDebugLog "Migrate service data folder from [$SrcDir] to [$DstDir]."
		mv -f $SrcDir $DstDir
	fi

	if [ ! -d "$DstDir" ]; then
		PrepareServiceDataDir
	fi
}

GetServiceSrcDirCandidate()
{
	local SrcDir=""

	if [ -n "$ORIGIN_SHARE_PATH" ]; then
		SrcDir=$(dirname $ORIGIN_SHARE_PATH)/$SS_SERVICE_DATA_FOLDER_NAME
	else
		SrcDir=$(readlink $SS_SERVICE_DATA_FOLDER_LINK)
	fi

	if [ ! -d "$SrcDir" ]; then
		SrcDir=$(GetServiceDataVolPath)/$SS_SERVICE_DATA_FOLDER_NAME
	fi

	echo "$SrcDir"
}

IsEds14AddSSShare()
{
	if [ false == $(IsModelEDS14) ]; then
		echo false
		return
	fi

	if [ -z "$ORIGIN_SHARE_PATH" -a -n "$SHARE_PATH" ]; then
		if readlink $SS_SHARE_FOLDER_LINK | grep -q $SHARE_PATH; then
			echo true
		else
			echo false
		fi
	fi
}
