#!/bin/sh
# Copyright (c) 2015 Synology Inc. All rights reserved.

#Include common scripts
. /var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh

# NVR local display related
SS_LOCAL_DISPLAY_DISPLAYD_BIN="displayd"
SS_LOCAL_DISPLAY_PATH="${SS_TARGET_DIR}/local_display"
SS_LOCAL_DISPLAY_DEFAULT_PATH="${SS_TARGET_DIR}/local_display.default"
SS_LOCAL_DISPLAY_BIN_PATH="${SS_LOCAL_DISPLAY_PATH}/bin"
SS_LOCAL_DISPLAY_LIB_PATH="${SS_LOCAL_DISPLAY_PATH}/usr/lib"
LOCAL_DISPLAY_IMG_TOOL="/usr/syno/bin/img_tool"
BOOT_LOGO="${SS_LOCAL_DISPLAY_LIB_PATH}/vs_logo_2k.bmp"
VIDEO_AUDIO_TEST="${SS_LOCAL_DISPLAY_LIB_PATH}/VideoAudioTest"
CHECK_LD_HANG="/var/packages/SurveillanceStation/target/scripts/check_ld_hang.sh"

# Private functions

BlockUntilDaemonKilled()
{
	local daemonAlive=$(ps aux | grep "$1" | grep -v grep)
	local retryCnt=$2

	if [ -z "${retryCnt}" ]; then
		retryCnt=5
	fi

	while [ 0 -lt ${retryCnt} -a -n "${daemonAlive}" ];
	do
		retryCnt=$((retryCnt-1))
		sleep 1
		daemonAlive=$(ps aux | grep "$1" | grep -v grep)
	done
}

Start()
{
	BlockUntilDaemonKilled "${LOCAL_DISPLAY_IMG_TOOL}"
	"${SS_LOCAL_DISPLAY_BIN_PATH}"/"${SS_LOCAL_DISPLAY_DISPLAYD_BIN}" &

	if type ${CHECK_LD_HANG} &> /dev/null; then
		killall -9 check_ld_hang.sh
		${CHECK_LD_HANG} &
	fi
}

Stop()
{
	if type ${CHECK_LD_HANG} &> /dev/null; then
		killall check_ld_hang.sh
	fi
	killall "${SS_LOCAL_DISPLAY_DISPLAYD_BIN}"
	BlockUntilDaemonKilled "${SS_LOCAL_DISPLAY_BIN_PATH}/display*"
	if type ${CHECK_LD_HANG} &> /dev/null; then
		killall -9 check_ld_hang.sh
	fi
	killall -9 "${SS_LOCAL_DISPLAY_DISPLAYD_BIN}"
}

Restore()
{
	/bin/rm -rf "${SS_LOCAL_DISPLAY_PATH}"
	/bin/cp -rpf "${SS_LOCAL_DISPLAY_DEFAULT_PATH}" "${SS_LOCAL_DISPLAY_PATH}"
}

ShowCover()
{
	if type local_display_tool &> /dev/null; then
		local_display_tool show_cover
	fi

	if type img_tool &> /dev/null; then
		killall -9 img_tool
	fi

	if type ${VIDEO_AUDIO_TEST} &> /dev/null; then
		killall -9 VideoAudioTest
		${VIDEO_AUDIO_TEST} -R 0 -r 0
		${VIDEO_AUDIO_TEST} -D 0 -V /dev/null -b ${BOOT_LOGO} -R -1 &
	fi
}

HideCover()
{
	if type local_display_tool &> /dev/null; then
		local_display_tool stop
	fi

	if type img_tool &> /dev/null; then
		killall -9 img_tool
	fi

	if type ${VIDEO_AUDIO_TEST} &> /dev/null; then
		BlockUntilDaemonKilled "$VIDEO_AUDIO_TEST"
		killall -9 VideoAudioTest
	fi
}

KillLocalDisplayTool()
{
	if type local_display_tool &> /dev/null; then
		killall -9 local_display_tool
	fi
}

main()
{
	# Do nothing if this is not NVR platform
	if [ ! -d "${SS_LOCAL_DISPLAY_PATH}" ]; then
		return
	fi

	case $1 in
	"Enable")
		SSDebugLog "Hide local display cover."
		KillLocalDisplayTool
		HideCover
		SSDebugLog "Start local display daemon."
		Start
		;;
	"Disable")
		SSDebugLog "Stop local display daemon."
		Stop "$2"
		SSDebugLog "Show local display cover."
		KillLocalDisplayTool
		ShowCover
		/bin/rm -rf /var/packages/SurveillanceStation/target/@SSData/preference/local_display_login/run
		;;
	"Restore")
		Restore
		;;
	"Restart")
		KillLocalDisplayTool
		HideCover
		SSDebugLog "Restart - stop local display daemon."
		Stop
		SSDebugLog "Restart - start local display daemon."
		Start
		;;
	*)
		SSDebugLog "Unknown Action"
	esac
}

main "$@"
