#!/bin/sh
# Copyright (c) 2016 Synology Inc. All rights reserved.

# --sdk-mod-ver
#								SYNOMODULE="user"
# --name/--pkg-ver/--vendor
#								NONE
# --post
#								NITEMS, SERVER_TYPE, USER_NAME_#, UID_#, RESULT

SS_COMMON_SCRIPT=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
. ${SS_COMMON_SCRIPT}

PostUserDelete()
{
	local IdList

	for i in $(seq 1 ${NITEMS}); do
		eval "UserId=\"\${UID_${i}}\""

		IdList="${IdList}","${UserId}"
	done

	IdList=$(echo "${IdList}" | sed 's/^.//')

	if [ -n "${IdList}" ]; then
		${SS_USER_SYNC} "delete-user-uid" "${IdList}"
	fi
}

main()
{
	PackageInfoGet

	case $1 in
		--sdk-mod-ver)
			echo "1.0"
		;;
		--name)
			echo ${SURVEILLANCE_PKG_NAME}
		;;
		--pkg-ver)
			echo ${SURVEILLANCE_PKG_VERSION}
		;;
		--vendor)
			echo ${SURVEILLANCE_PKG_VENDOR}
		;;
		--post)
			PostUserDelete
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--post"
		;;
	esac
}

main "$@"
