#!/bin/sh
# Copyright (c) 2000-2015 Synology Inc. All rights reserved.

###############################################################
#   This script should be hooked when invoking SLIBNetService()
#   Usable environment variable:
#       PATH, SERVICE_IP_CHANGE, SERVICE_HOSTNAME_CHANGE,
#       SERVICE_MTU_CHANGE, SERVICE_DAEMON_ACTION, RESULT
#
#   Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
SURVEILLANCE_INC_SCRP=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
if [ -f "${SURVEILLANCE_INC_SCRP}" ]; then
	. ${SURVEILLANCE_INC_SCRP}
else
	echo "$(date +'%b %e %H:%M:%S') $(basename ${SURVEILLANCE_INC_SCRP}) not found." >> "/var/log/surveillance/surveillance.log"
	exit 0
fi

#At begining, acquire package settings
PackageInfoGet;

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "1.0"
	;;
	--name)
		#Print package name
		echo ${SURVEILLANCE_PKG_NAME};
	;;
	--pkg-ver)
		#Print package version
		echo ${SURVEILLANCE_PKG_VERSION};
	;;
	--vendor)
		#Print package vendor
		echo ${SURVEILLANCE_PKG_VENDOR};
	;;
	--pre)
	;;
	--post)
		${S82_SCRIPT} trigger-ssctl update-archive-local-port

		if [ -f "${SS_PKG_ENABLED_FILE}" ] && [ "${HTTP_PORT}" != "${ORIGIN_HTTP_PORT}" -o "${HTTPS_PORT}" != "${ORIGIN_HTTPS_PORT}" -o "${SSL_ENABLED}" != "${ORIGIN_SSL_ENABLED}" ]; then
			SSDebugLog "SurveillanceStationRestart";
			SurveillanceStationRestart;
		fi
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

