#!/bin/sh
# Copyright (c) 2017 Synology Inc. All rights reserved.

# Check http://synowiki.synology.com/index.php/SYNOShareTransform

ORIGIN_SHARE_NAME=$SHARE_NAME
ORIGIN_SHARE_PATH=$SHARE_PATH

HOOK_SCRP=/var/packages/SurveillanceStation/target/scripts/ShareHookCommon.sh
. $HOOK_SCRP

PrintArgs()
{
	local Msg="$1"

	SSDebugLog "[$Msg] NAME: $ORIGIN_SHARE_NAME => $SHARE_NAME"
	SSDebugLog "[$Msg] PATH: $ORIGIN_SHARE_PATH => $SHARE_PATH"
	SSDebugLog "[$Msg] ENC_ACTION $ENC_ACTION"
	SSDebugLog "[$Msg] RESULT: $RESULT"
}

SSShareEncActBegin()
{
	if [ "encrypt" == "$ENC_ACTION" ]; then
		SharePreSetHook false true
	fi
}

SSShareEncActEnd()
{
	if [ "decrypt" == "$ENC_ACTION" ]; then
		SharePostSetHook false true
	fi
}

main()
{
	PackageInfoGet;

	case $1 in
		--sdk-mod-ver)
			echo "2.0"
		;;
		--name)
			echo ${SURVEILLANCE_PKG_NAME};
		;;
		--pkg-ver)
			echo ${SURVEILLANCE_PKG_VERSION};
		;;
		--vendor)
			echo ${SURVEILLANCE_PKG_VENDOR};
		;;
		--pre)
			SSShareEncActBegin
		;;
		--post)
			SSShareEncActEnd;
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
	esac
}

main "$@"
