#!/bin/sh
# Copyright (c) 2014 Synology Inc. All rights reserved.

#	--sdk-mod-ver
#								SYNOMODULE=”share”
#	--name/--pkg-ver/--vendor
#								NONE
#	--pre/--post
#								SHARE_NAME,
#								SHARE_PATH,
#								NEW_SHARE_NAME(available at CLONE action),
#								NEW_SHARE_PATH(available at CLONE action),
#								SNAPSHOT(CREATE: snapshot to be created, RESTORE: snapshot to restore from, CLONE_SNAP: snapshot to clone from),
#								RESULT(0 for success, the others for failure),
#								ACTION(CREATE, RESTORE, CLONE_SHARE, CLONE_SNAP),
#								ENC_STATUS(0: normal share, 1: encrypted share, 2: decrypted share)

SS_COMMON_SCRIPT=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
. ${SS_COMMON_SCRIPT}

PrintArgs()
{
	SSDebugLog "SHARE_NAME: ${SHARE_NAME}"
	SSDebugLog "SHARE_PATH: ${SHARE_PATH}"
	SSDebugLog "NEW_SHARE_NAME: ${NEW_SHARE_NAME}"
	SSDebugLog "NEW_SHARE_PATH: ${NEW_SHARE_PATH}"
	SSDebugLog "SNAPSHOT: ${SNAPSHOT}"
	SSDebugLog "RESULT: ${RESULT}"
	SSDebugLog "ACTION: ${ACTION}"
	SSDebugLog "ENC_STATUS: ${ENC_STATUS}"
}

IsRecShare()
{
	local SqlCmd="SELECT 1 FROM recordingshare WHERE owner_ds_id = 0 AND name = '${SHARE_NAME}' AND mount_type = 0;"

	Sqlite3Exec "${SS_SYSTEM_DB}" "${SqlCmd}"
}

PreSnapshot()
{
	if [ true == $(IsNonRecordingMode) ]; then
		return
	fi

	case "${ACTION}" in
		"CREATE")
			if [ "1" == "$(IsRecShare)" ]; then
				SSDebugLog "Pre-take snapshot of rec share folder [$SHARE_NAME]."
				$SS_RECSHARE_CTRL "pre-rec-share-snapshot-create" "$SHARE_NAME" "$SHARE_PATH"
			fi
			;;
		"RESTORE")
			if [ "1" == "$(IsRecShare)" ]; then
				SSDebugLog "Pre-restore snapshot of rec share folder [$SHARE_NAME]."
				$SS_RECSHARE_CTRL "pre-rec-share-snapshot-restore" "$SHARE_NAME" "$SHARE_PATH"
			fi
			;;

		*)
		;;
	esac
}

PostSnapshot()
{
	if [ true == $(IsNonRecordingMode) ]; then
		return
	fi

	case "${ACTION}" in
		"CREATE")
			if [ "1" == "$(IsRecShare)" ]; then
				SSDebugLog "Post-take snapshot of rec share folder [$SHARE_NAME]."
				$SS_RECSHARE_CTRL "post-rec-share-snapshot-create" "$SHARE_NAME" "$SHARE_PATH"
			fi
			;;
		"RESTORE")
			if [ "1" == "$(IsRecShare)" ]; then
				SSDebugLog "Snapshot of shared folder has been restored."
				PrepareServiceDataDir
				$SS_RECSHARE_CTRL "post-rec-share-snapshot-restore" "$SHARE_NAME" "$SHARE_PATH"
			fi
			;;
		*)
			;;
	esac
}

main()
{
	PackageInfoGet

	case $1 in
		--sdk-mod-ver)
			echo "2.0"
		;;
		--name)
			echo ${SURVEILLANCE_PKG_NAME}
		;;
		--pkg-ver)
			echo ${SURVEILLANCE_PKG_VERSION}
		;;
		--vendor)
			echo ${SURVEILLANCE_PKG_VENDOR}
		;;
		--pre)
			PreSnapshot
		;;
		--post)
			PostSnapshot
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--post"
		;;
	esac
}

main "$@"
