#!/bin/sh
# Copyright (c) 2017 Synology Inc. All rights reserved.

###############################################################
#   This script should be hooked when EDS power is turned on or off
#   Usable environment variable:
#		POWER_STATUS
#
#   Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
SS_COMMON_SCRIPT=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
. ${SS_COMMON_SCRIPT}

FlushDiskBuffer()
{
	local DiskDevs=$(synodiskport -internal)

	for DevName in $DiskDevs; do
		hdparm -fF /dev/$DevName
	done
}

DelayedStopRecording()
{
	SSDebugLog "EDS power outage! Start to stop all recording files."

	local TmStart=$(date +%s%3N)

	$SS_CAMERA -S
	Sqlite3Exec "${SS_REC_DB}" "PRAGMA wal_checkpoint(PASSIVE);" > /dev/null 2>&1
	FlushDiskBuffer

	local TmDur=$(($(date +%s%3N) - $TmStart))

	SSDebugLog "EDS power outage! Finished stopping all recording files. Elapsed time: [$TmDur] ms"
	sync
}

ClearDelayedStopRecording()
{
	SSDebugLog "EDS power resume! Start to resume camera recordings."

	$SS_CAMERA -R

	SSDebugLog "EDS power resumes! Finished resuming camera recordings."
}

ControlRecByPowerStatus()
{
	if [ "$POWER_STATUS" == "power_off" ]; then
		DelayedStopRecording
	elif [ "$POWER_STATUS" == "power_on" ]; then
		ClearDelayedStopRecording
	fi
}

main()
{
	PackageInfoGet

	case $1 in
		--sdk-mod-ver)
			echo "1.0"
		;;
		--name)
			echo ${SURVEILLANCE_PKG_NAME}
		;;
		--pkg-ver)
			echo ${SURVEILLANCE_PKG_VERSION}
		;;
		--vendor)
			echo ${SURVEILLANCE_PKG_VENDOR}
		;;
		--post)
			ControlRecByPowerStatus
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--post"
		;;
	esac
}

main "$@"
