CREATE TABLE archive_push_task (
	id						integer PRIMARY KEY AUTOINCREMENT,
	src_type				integer DEFAULT 0,
	src_dir					varchar(256) DEFAULT '',
	dest_type				integer DEFAULT 0,
	dest_ip					varchar(256) DEFAULT '',
	dest_port				integer DEFAULT 0,
	dest_username			varchar(256) DEFAULT '',
	dest_password			varchar(256) DEFAULT '',
	did_code				varchar(256) DEFAULT '',
	rec_db_path				varchar(256) DEFAULT '',
	rm_after_archive		boolean DEFAULT '0',
	https					boolean DEFAULT '0',
	process_flag			integer DEFAULT 0,
	db_rm_method			integer DEFAULT 0
);

CREATE TABLE archive_file (
	id						integer PRIMARY KEY AUTOINCREMENT,
	task_id					integer DEFAULT 0,
	cam_id					integer DEFAULT 0,
	file_type				integer DEFAULT 0,
	file_path				varchar(256) DEFAULT '',
	dest_dir				varchar(256) DEFAULT '',
	process_flag			integer DEFAULT 0,
	file_type_id			integer DEFAULT 0
);

CREATE TABLE archive_pull_task (
    id                      integer PRIMARY KEY AUTOINCREMENT,
    tiering_task_id         integer DEFAULT 0,
	src_ds_id		        integer DEFAULT -1,
    task_type               integer DEFAULT 0,
    status                  integer DEFAULT 0,
    exec_time               integer DEFAULT 0,
    protocol                integer DEFAULT 0,
    port                    integer DEFAULT 0,
    day_limit               integer DEFAULT 30,
    size_limit_gb           integer DEFAULT 10,
    occupied_size           integer DEFAULT 0,
    last_event_id           integer DEFAULT 0,
    event_written_byte      integer DEFAULT 0,
    remux_event_idx         integer DEFAULT 0,
	expect_total_evt_size   integer DEFAULT 0,
	daily_recv_evt_cnt		integer DEFAULT 0,
	last_connect_time		integer DEFAULT 0,
    enabled                 boolean DEFAULT '0',
    use_custom_folder       boolean DEFAULT '0',
    limit_by_size           boolean DEFAULT '0',
    rotate_files            boolean DEFAULT '0',
    is_deleted              boolean DEFAULT '0',
    name                    text UNIQUE,
    hostname                text DEFAULT '',
    did_code                text DEFAULT '',
    username                text DEFAULT '',
    passwd                  text DEFAULT '',
    storage_path            text DEFAULT '',
    custom_folder           text DEFAULT '',
    filter_param            text DEFAULT '',
	last_event_id_by_cam    text DEFAULT '',
	end_event_id_by_cam		text DEFAULT '',
    dsSerial                text DEFAULT '',
    schedule                text DEFAULT '111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111',
	writingEvtPath			text DEFAULT '',
	limit_by_date           boolean DEFAULT '0'
);

CREATE TABLE archive_bw_control (
	id                      integer PRIMARY KEY REFERENCES archive_pull_task(id),
    bandwidth_limit1        integer DEFAULT 1000,
    bandwidth_limit2        integer DEFAULT 1000,
    bw_schedule             text DEFAULT '111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111'
);

CREATE TRIGGER pull_task_del_trigger AFTER DELETE ON archive_pull_task BEGIN DELETE FROM archive_pull_task WHERE id=OLD.tiering_task_id; END;
CREATE TRIGGER pull_task_del_bw_trigger AFTER DELETE ON archive_pull_task WHEN OLD.task_type!=4 BEGIN DELETE FROM archive_bw_control WHERE id=OLD.id; END;
CREATE TRIGGER pull_task_ins_bw_trigger AFTER INSERT ON archive_pull_task WHEN NEW.task_type!=4 BEGIN INSERT INTO archive_bw_control (id, bw_schedule) VALUES (NEW.id, NEW.schedule); END;
