
CREATE TABLE event (
	id							integer PRIMARY KEY AUTOINCREMENT,
	camera_id					integer,
	ds_id						integer DEFAULT 0,
	start_time					integer,
	stop_time					integer,
	update_time					integer,
	status_flags				integer DEFAULT 0,
	recording					boolean DEFAULT '0',
	archived					boolean DEFAULT '0',
	mark_as_del					boolean DEFAULT '0',
	closing 					boolean DEFAULT '0',
	id_on_rec_server			integer DEFAULT 0,
	cam_id_on_rec_server		integer DEFAULT 0,
	edge_storage_recording_id	integer DEFAULT -1,
	for_rotation_only			boolean DEFAULT '0',
	fisheye_origin_view			boolean DEFAULT '1',
	cause						integer,
	filesize					integer,
	video_width					integer,
	video_height				integer,
	framecount					integer,
	video_type					integer,
	audfmt						text,
	path						text,
	snapshot_small				text,
	snapshot_medium				text
);

CREATE INDEX IF NOT EXISTS event_camera_id_idx ON event(camera_id,start_time,stop_time);
CREATE INDEX IF NOT EXISTS event_update_time_idx ON event(update_time);
CREATE INDEX IF NOT EXISTS event_start_time_idx ON event(start_time);
CREATE INDEX IF NOT EXISTS event_stop_time_idx ON event(stop_time);
CREATE INDEX IF NOT EXISTS event_id_on_rec_server_idx ON event(id_on_rec_server);
CREATE INDEX IF NOT EXISTS event_recording_idx ON event(recording) WHERE recording = 1;
CREATE INDEX IF NOT EXISTS event_archived_idx ON event(archived) WHERE archived = 1;
CREATE INDEX IF NOT EXISTS event_mark_as_del_idx ON event(mark_as_del) WHERE mark_as_del = 1;

CREATE TRIGGER IF NOT EXISTS event_auto_update AFTER UPDATE ON event BEGIN UPDATE OR IGNORE event SET update_time = (SELECT MAX(update_time) FROM event) + 1 WHERE id = new.id; END;
CREATE TRIGGER IF NOT EXISTS event_auto_update_insert AFTER INSERT ON event BEGIN UPDATE OR IGNORE event SET update_time = (SELECT MAX(update_time) FROM event) + 1 WHERE id = new.id; END;

CREATE TABLE analyticsEvent (
	id				integer PRIMARY KEY AUTOINCREMENT,
	user_id			integer DEFAULT 0,
	ds_id			integer DEFAULT 0,
	camera_id		integer DEFAULT 0,
	camera_name		varchar(256),
	event_id		integer DEFAULT 0,
	type			integer DEFAULT 0,
	start_time		integer DEFAULT 0,
	stop_time		integer DEFAULT 0,
	archived		boolean DEFAULT '0',
	video_width		integer,
	video_height	integer,
	framecount		integer,
	path			text,
	filesize		integer,
	video_type		integer,
	audfmt			text,
	recording		boolean DEFAULT '0',
	closing			boolean DEFAULT '0',
	mark_as_del		boolean DEFAULT '0'
);

CREATE TABLE alertevent (
	id				integer PRIMARY KEY AUTOINCREMENT,
	ds_id			integer DEFAULT 0,
	camera_id		integer DEFAULT 0,
	camera_name		varchar(256),
	event_id		integer DEFAULT 0,
	type			integer DEFAULT 0,
	start_time		integer DEFAULT 0,
	stop_time		integer DEFAULT 0,
	archived		boolean DEFAULT '0',
	video_width		integer,
	video_height	integer,
	framecount		integer,
	path			text,
	filesize		integer,
	video_type		integer,
	audfmt			text,
	recording		boolean DEFAULT '0',
	closing			boolean DEFAULT '0',
	mark_as_del			boolean DEFAULT '0',
	mark_as_file_del	integer DEFAULT 0,
	viewed			boolean DEFAULT '0',
	update_seq		integer DEFAULT 0,
	device_type		integer DEFAULT 1,
	port_idx		integer,
	sub_type		integer DEFAULT 0
);
CREATE INDEX IF NOT EXISTS alert_event_start_time_idx ON alertevent(start_time);
CREATE INDEX IF NOT EXISTS alert_event_update_seq_idx ON alertevent(update_seq);
CREATE TRIGGER IF NOT EXISTS alert_event_auto_update AFTER UPDATE ON alertevent BEGIN UPDATE OR IGNORE alertevent SET update_seq = (SELECT MAX(update_seq) FROM alertevent) + 1 WHERE id = new.id; END;
CREATE TRIGGER IF NOT EXISTS alert_event_auto_update_insert AFTER INSERT ON alertevent BEGIN UPDATE OR IGNORE alertevent SET update_seq = (SELECT MAX(update_seq) FROM alertevent) + 1 WHERE id = new.id; END;

CREATE TABLE edgevideoclip (
	id						integer PRIMARY KEY AUTOINCREMENT,
	cam_id					integer DEFAULT 0,
	status					integer DEFAULT 0,
	start_time				bigint DEFAULT 0,
	stop_time				bigint DEFAULT 0,
	video_type				integer DEFAULT 0,
	audio_type				integer DEFAULT 0,
	owner_ds_id				integer DEFAULT 0,
	path					text DEFAULT '',
	streaming_type			integer DEFAULT 0,
	media_port				integer DEFAULT -1,
	retrieve_method			integer DEFAULT 0,
	width					integer DEFAULT 0,
	height					integer DEFAULT 0,
	framerate				integer DEFAULT 0,
	fisheye_view			boolean DEFAULT '0',
	enable_audio			boolean DEFAULT '0',
	download_type			integer DEFAULT 0
);

CREATE TABLE customaudiopattern (
	id				integer PRIMARY KEY AUTOINCREMENT,
	name			varchar(256) DEFAULT '',
	length			integer default 0,
	description		varchar(256) DEFAULT '',
	filefmt			varchar(8) DEFAULT '',
	is_default		boolean DEFAULT '0'
);
INSERT INTO customaudiopattern (id) SELECT 10 WHERE NOT EXISTS (SELECT * from customaudiopattern);

CREATE TABLE posevent (
	id						integer PRIMARY KEY AUTOINCREMENT,
	camera_id				integer DEFAULT 0,
	video_width				integer,
	video_height			integer,
	start_time				integer DEFAULT 0,
	stop_time				integer DEFAULT 0,
	framecount				integer,
	archived				boolean DEFAULT '0',
	path					text,
	filesize				integer,
	video_type				integer,
	recording				boolean DEFAULT '0',
	audfmt					text,
	closing					boolean DEFAULT '0',
	camera_name				text,
	g726_decode_by_le		boolean DEFAULT '0'
);

CREATE INDEX IF NOT EXISTS posevent_camera_id_start_time ON posevent(camera_id, start_time);

CREATE TABLE IF NOT EXISTS sharerecording (
	id								INTEGER PRIMARY KEY ASC AUTOINCREMENT,
	hash							TEXT NOT NULL,
	event_id						INTEGER DEFAULT 0,
	event_db_type					INTEGER DEFAULT 0,
	event_src_id					INTEGER DEFAULT 0,
	file_path						TEXT NOT NULL,
	camera_id						INTEGER DEFAULT 0
);

CREATE UNIQUE INDEX IF NOT EXISTS share_recording_hash ON sharerecording (hash);
CREATE INDEX IF NOT EXISTS share_recording_event_id ON sharerecording (event_id);
CREATE INDEX IF NOT EXISTS share_recording_event_db_type ON sharerecording (event_db_type);
CREATE INDEX IF NOT EXISTS share_recording_event_src_id ON sharerecording (event_src_id);

CREATE TABLE lapse_recording (
	id							integer PRIMARY KEY AUTOINCREMENT,
	task_id						integer,
	camera_id					integer,
	start_time					integer,
	stop_time					integer,
	update_time					integer,
	range_minute				integer,
	recording					boolean DEFAULT '0',
	archived					boolean DEFAULT '0',
	mark_as_del					boolean DEFAULT '0',
	closing 					boolean DEFAULT '0',
	filesize					integer,
	video_width					integer,
	video_height				integer,
	framecount					integer,
	video_type					integer,
	path						text
);

CREATE INDEX IF NOT EXISTS lapse_recording_task_id_idx ON lapse_recording(task_id,start_time,stop_time);
CREATE INDEX IF NOT EXISTS lapse_recording_start_time_idx ON lapse_recording(start_time);
CREATE INDEX IF NOT EXISTS lapse_recording_archived_idx ON lapse_recording(archived) WHERE archived = 1;
CREATE INDEX IF NOT EXISTS lapse_recording_mark_as_del_idx ON lapse_recording(mark_as_del) WHERE mark_as_del = 1;

CREATE TRIGGER IF NOT EXISTS lapse_recording_auto_update AFTER UPDATE ON lapse_recording BEGIN UPDATE OR IGNORE lapse_recording SET update_time = (SELECT MAX(update_time) FROM lapse_recording) + 1 WHERE id = new.id; END;
CREATE TRIGGER IF NOT EXISTS lapse_recording_auto_update_insert AFTER INSERT ON lapse_recording BEGIN UPDATE OR IGNORE lapse_recording SET update_time = (SELECT MAX(update_time) FROM lapse_recording) + 1 WHERE id = new.id; END;

CREATE TABLE ivarecording (
	id						integer PRIMARY KEY AUTOINCREMENT,
	camera_id				integer,
	ds_id					integer,
	task_id					integer,
	start_time				integer,
	stop_time				integer,
	update_time				integer,
	archived				boolean DEFAULT '0',
	path					text,
	filesize				integer,
	video_type				integer,
	recording				boolean DEFAULT '0',
	audfmt					text,
	closing					boolean DEFAULT '0',
	event_type				integer,
	id_on_rec_server		integer DEFAULT 0,
	cam_id_on_rec_server	integer DEFAULT 0,
	video_width				integer,
	video_height			integer,
	framecount				integer,
	mark_as_del				boolean DEFAULT '0'
);
