
CREATE TABLE camera (
	id							integer PRIMARY KEY AUTOINCREMENT,
	enabled						boolean,
	name						varchar(256),
	type						integer,
	api							integer,
	vendor						varchar(128),
	model						varchar(128),
	firmware					varchar(64) DEFAULT '',
	hostname					varchar(256),
	port						integer,
	media_port					integer,
	live_media_port				integer,
	stmout_port					integer,
	path						varchar(512),
	live_path					varchar(512),
	username					varchar(128),
	password					varchar(128),
	fps							integer,
	fps_2						integer DEFAULT 0,
	image_width					integer,
	image_height				integer,
	rec_time					integer,
	enable_audio				boolean DEFAULT '0',
	recording_path				varchar(256),
	recording_prefix			varchar(256),
	set_rec_folder				boolean,
	set_evt_prefix				boolean,
	recording_capacity			integer,
	recording_days				integer,
	enable_capacity				boolean,
	enable_days					boolean,
	motion_sensitivity			integer,
	motion_threshold			integer,
	motion_object_size			integer,
	motion_percentage			integer,
	enable_motionlog			boolean,
	schedule					varchar(512),
	notifyschedule				varchar(2048) DEFAULT 'FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF,FFFFF',
	resolution					varchar(128),
	video_type					integer,
	streaming_type				integer,
	enable_camera_motion		boolean,
	enable_io_log				boolean,
	liveview_all				boolean,
	quality						varchar(128),
	live_quality				varchar(128),
	live_resolution				varchar(128),
	live_fps					integer DEFAULT 0,
	channel						varchar(128),
	liveview_mode				integer DEFAULT 0,
	rotation_option				integer DEFAULT 0,
	pre_rec_time				integer DEFAULT 5,
	post_rec_time				integer DEFAULT 5,
	audio_format				integer DEFAULT 0,
	exporting					integer DEFAULT 0,
	enable_manual_rec			boolean DEFAULT '0',
	cap_file_path				varchar(128),
	is_deleted					boolean DEFAULT '0',
	status_flags				integer DEFAULT 0,
	occupied_size				integer DEFAULT 0,
	live_analytics_type			integer DEFAULT 0,
	live_analytics_setting		integer DEFAULT 0,
	live_analytics_sensitivity	integer DEFAULT 0,
	live_analytics_dwell_time	integer DEFAULT 5,
	live_analytics_direction	integer DEFAULT 1,
	live_analytics_width		integer DEFAULT 0,
	live_analytics_height		integer DEFAULT 0,
	live_analytics_obj_size		integer DEFAULT 0,
	live_analytics_region		varchar(800),
	mount_type					integer DEFAULT 0,
	param_chklist				integer DEFAULT 0,
	time_server					text,
	osd_status					boolean DEFAULT '1',
	osd_position				integer DEFAULT 0,
	osd_format					integer DEFAULT 0,
	exposure_mode				integer DEFAULT 0,
	daybegin					integer DEFAULT 0,
	dayend						integer DEFAULT 0,
	video_mirror				boolean DEFAULT '1',
	video_flip					boolean DEFAULT '1',
	video_rotation				integer DEFAULT 0,
	exposure_control			integer DEFAULT 0,
	onvif_profile				varchar(256),
	tunneling 					boolean DEFAULT '0',
	owner_ds_id 				integer DEFAULT 0,
	id_on_rec_server 			integer DEFAULT 0,
	status_on_rec_server		integer DEFAULT 0,
	rec_status_on_rec_server	integer DEFAULT 0,
	device_type					integer DEFAULT 1,
	fov							varchar(256) DEFAULT '',
	rec_stream_no				integer DEFAULT 0,
	live_stream_no				integer DEFAULT 0,
	rec_bitrate_ctrl			integer DEFAULT 1,
	live_bitrate_ctrl			integer DEFAULT 1,
	rec_cbr_bitrate				integer DEFAULT 0,
	live_cbr_bitrate			integer DEFAULT 0,
	tv_standard					integer DEFAULT 0,
	rtsp_protocol				integer DEFAULT 0,
	edge_storage_enabled		boolean DEFAULT '0',
	edge_storage_sch			varchar(512) DEFAULT '111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111',
	brightness					integer DEFAULT 0,
	contrast					integer DEFAULT 0,
	saturation					integer DEFAULT 0,
	sharpness					integer DEFAULT 0,
	volume						integer DEFAULT 50,
	mobile_media_port			integer DEFAULT 0,
	mobile_quality				varchar(128),
	mobile_resolution			varchar(128),
	mobile_fps					integer DEFAULT 0,
	mobile_path					varchar(512),
	mobile_stream_no			integer DEFAULT 0,
	mobile_bitrate_ctrl			integer DEFAULT 1,
	mobile_cbr_bitrate			integer DEFAULT 0,
	mute						boolean DEFAULT '0',
	update_time					integer DEFAULT 0,
	pt_speed					integer DEFAULT 3,
	zoom_speed					integer DEFAULT 3,
	ptz_speed_keep_origin		boolean DEFAULT '0',
	ui_stream_no				text,
	custom_detect				integer DEFAULT 1,
	custom_alarm_detect			integer DEFAULT -1,
	alert_event					integer DEFAULT 0,
	recording_disabled			boolean DEFAULT '0',
	audio_recording_disabled	boolean DEFAULT '0',
	enable_multicast 			boolean DEFAULT '0',
	multicast_grp_addr 			varchar(64),
	multicast_video_port 		integer DEFAULT 0,
	multicast_audio_port 		integer DEFAULT 0,
	enable_multicast_mobile 	boolean DEFAULT '0',
	multicast_grp_addr_mobile 	varchar(64),
	multicast_video_port_mobile integer DEFAULT 0,
	multicast_audio_port_mobile integer DEFAULT 0,
	rec_storage_status			integer DEFAULT 0,
	enable_codec_optimization 	boolean DEFAULT '0',
	codec_optimization			integer DEFAULT 0,
	codec_optimization_text		text,
	rtsp_keep_alive				integer DEFAULT 0,
	custom1_detect				integer DEFAULT 1,
	custom1_alarm_detect		integer DEFAULT -1,
	mobile_liveview_mode		integer DEFAULT 0,
	key_frame_interval			integer DEFAULT -1,
	dynamic_key_frame			boolean DEFAULT '0',
	auto_pan_init_pos			integer DEFAULT -2,
	auto_pan_pre_sleep_time		integer DEFAULT 10,
	ext_di_enable				boolean DEFAULT '0',
	ext_di_dev_id				integer DEFAULT 0,
	ext_di_port					integer DEFAULT -1,
	restart_day					integer DEFAULT 0,
	last_restart_time			text,
	period_sync_time_hour		integer DEFAULT 0,
	last_sync_time				text,
	rec_storage_mount_type		integer DEFAULT 0,
	profile_setting_list		text DEFAULT '',
	adv_contious_trig_event		integer DEFAULT 0,
	enable_adv_contious_rec		boolean DEFAULT '0',
	high_avg_bitrate			integer DEFAULT 0,
	med_avg_bitrate				integer DEFAULT 0,
	low_avg_bitrate				integer DEFAULT 0,
	adv_live_trig_event			integer DEFAULT 0,
	enable_adv_live				boolean DEFAULT '0',
	enable_third_stream_profile	boolean DEFAULT '0',
	rtsp_path_timeout			integer DEFAULT 0,
	removable_lens				boolean DEFAULT '0',
	adv_contious_min_duration	integer DEFAULT 10,
	adv_live_min_duration		integer DEFAULT 10,
	adv_live_trig_auto_adjust	boolean DEFAULT '1',
	adv_live_trig_single_view	boolean DEFAULT '0',
	connected_wire				varchar(3) DEFAULT '',
	intercom_acs_duration		integer DEFAULT 0,
	enable_calling_notify		boolean DEFAULT '0',
	calling_notify_ado_src_id	integer DEFAULT 0,
	calling_notify_duration		integer DEFAULT 0,
	alert_di					integer DEFAULT 0,
	dynamic_fps					boolean DEFAULT '0',
	video_mode					varchar(128) DEFAULT '',
	paired_speaker_enabled		boolean DEFAULT '0',
	paired_speaker_id			integer DEFAULT 0,
	last_key_frame_interval		integer DEFAULT -1
);

CREATE INDEX IF NOT EXISTS camera_update_time_idx ON camera (update_time);
CREATE TRIGGER IF NOT EXISTS camera_auto_update AFTER UPDATE ON camera BEGIN UPDATE OR IGNORE camera SET update_time = (SELECT MAX(update_time) FROM camera) + 1 WHERE id = new.id; END;
CREATE TRIGGER IF NOT EXISTS camera_auto_update_insert AFTER INSERT ON camera BEGIN UPDATE OR IGNORE camera SET update_time = (SELECT MAX(update_time) FROM camera) + 1 WHERE id = new.id; END;

CREATE TABLE motion (
	id			integer PRIMARY KEY AUTOINCREMENT,
	camera_id	integer,
	name		varchar(256),
	top			integer,
	bottom		integer,
	m_left		integer,
	m_right		integer
);

CREATE TABLE notification (
	type					integer,
	server					varchar(256),
	port					integer,
	needauth				integer,
	username				varchar(128),
	password				varchar(128),
	refresh_token				varchar(128),
	expires_in				integer,
	needssl					boolean,
	sendtestmail			boolean,
	email					varchar(512),
	email2					varchar(512),
	subject_prefix			varchar(128) DEFAULT '',
	sender_name				varchar(128) DEFAULT '',
	sender_mail				varchar(512) DEFAULT '',
	attach_snapshot			boolean default '1',
	enable_msg_interval		boolean default '0',
	msg_interval			integer default 1
);

INSERT INTO notification(type, server, port, needauth, username, password, refresh_token, expires_in, needssl, sendtestmail, email, email2)
SELECT 0, '', 25, 0, '', '', '', 0, '0', '0', '', '' WHERE NOT EXISTS (SELECT * from notification);

CREATE TABLE camerastatus (
	cameraid	integer PRIMARY KEY,
	status		integer,
	pid			integer,
	updatetime	integer
);

CREATE TABLE licensekey (
	id				integer PRIMARY KEY AUTOINCREMENT,
	camera_count	integer,
	key				text,
	serial			varchar(64),
	owner_ds_id		integer DEFAULT 0,
	install_date	integer DEFAULT 0,
	is_restored		text DEFAULT '',
	expired_date	text,
	id_on_rec		text DEFAULT '',
	activated		varchar(16)
);

CREATE TABLE account (
	id								integer PRIMARY KEY AUTOINCREMENT,
	uid								bigint DEFAULT 0,
	name							text,
	privilege						integer,
	privprofileid					integer DEFAULT 0,
	init_module						varchar(64) DEFAULT '',
	def_layout_id					integer DEFAULT -1,
	def_timeline_layout_id			integer DEFAULT -1,
	def_arch_timeline_layout_id_map	varchar(256) DEFAULT '',
	photo_name						varchar(256),
	photo_width						integer,
	photo_height					integer,
	photo_tmstmp					integer DEFAULT 0,
	view_mode						text DEFAULT '',
	status							integer DEFAULT 1,
	remind_quickconnect_tunnel		boolean DEFAULT '1',
	dual_auth_enabled				boolean DEFAULT '0',
	dual_auth_privprofileid			integer DEFAULT 0,
	dual_auth_supervisor_uids		varchar(256) DEFAULT '',
	dual_auth_schedule				text DEFAULT '111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111'
);

INSERT INTO account(name, privilege, privprofileid, uid) SELECT 'admin', 0, 3, 1024
WHERE NOT EXISTS (SELECT * from account);

CREATE TABLE visualstation (
	id					integer PRIMARY KEY AUTOINCREMENT,
	enabled				boolean,
	name				text,
	mac_addr			varchar(64),
	camgrpid			integer DEFAULT -1,
	layout				integer,
	channel_1			integer,
	channel_2			integer,
	channel_3			integer,
	channel_4			integer,
	channel_5			integer,
	channel_6			integer,
	dhcp				boolean DEFAULT '1',
	ip					varchar(64),
	mask				varchar(64),
	gateway				varchar(64) DEFAULT '0.0.0.0',
	version				varchar(32),
	platform			varchar(32) DEFAULT 'VS60',
	max_ch				integer DEFAULT 6,
	channel_list		varchar(1024),
	def_layout			text,
	playing_layout		text,
	timezone			text,
	language			text,
	capflags			integer DEFAULT 0,
	notifyschedule		varchar(2048) DEFAULT 'F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F',
	owner_ds_id 		integer DEFAULT 0,
	id_on_rec_server	integer DEFAULT 0,
	dns					varchar(64) DEFAULT '0.0.0.0',
	ss_min_ver			varchar(64) DEFAULT '0000'
);

CREATE TABLE vslayout (
	id					integer PRIMARY KEY AUTOINCREMENT,
	name				varchar(256),
	vs_id				integer,
	emap_id				integer,
	camgrp_id			integer DEFAULT -1,
	type				integer,
	is_default			boolean,
	fix_aspect_ratio	boolean DEFAULT '0',
	custom_pos_list		text
);

CREATE TABLE vslayoutchannel (
	id			integer PRIMARY KEY AUTOINCREMENT,
	layout_id	integer,
	location	integer,
	type		integer,
	ds_id		integer,
	item_id		integer,
	ds_name		varchar(256),
	item_name	varchar(256)
);

CREATE TABLE nvrconfig (
	id			integer PRIMARY KEY AUTOINCREMENT,
	def_layout	text,
	capflags	integer DEFAULT 0
);

INSERT INTO nvrconfig (def_layout)
SELECT '0,0' WHERE NOT EXISTS (SELECT * from nvrconfig);

CREATE TABLE nvrlayout (
	id					integer PRIMARY KEY AUTOINCREMENT,
	name				varchar(256),
	emap_id				integer,
	camgrp_id			integer DEFAULT -1,
	type				integer,
	is_default			boolean,
	fix_aspect_ratio	boolean DEFAULT '0',
	custom_pos_list		text
);

INSERT INTO nvrlayout (name, emap_id, camgrp_id, type, is_default, fix_aspect_ratio, custom_pos_list)
SELECT 'Default', 0, -1, 6, '1', '0', '' WHERE NOT EXISTS (SELECT * from nvrlayout);

CREATE TABLE nvrlayoutchannel (
	id			integer PRIMARY KEY AUTOINCREMENT,
	layout_id	integer,
	location	integer,
	type		integer,
	ds_id		integer,
	item_id		integer,
	ds_name		varchar(256),
	item_name	varchar(256)
);

CREATE TABLE smsprovider (
	id			integer PRIMARY KEY AUTOINCREMENT,
	name		text,
	port		integer,
	fullurl		text,
	template	text,
	sepchar		varchar(4),
	needssl		boolean
);

INSERT INTO smsprovider(name, port, fullurl, template, sepchar, needssl)
SELECT 'clickatell', 80, 'http://api.clickatell.com/http/sendmsg?user=Syno&password=1234&api_id=&to=886&text=Hello+world',
		'https://api.clickatell.com/http/sendmsg?user=@@USER@@&password=@@PASS@@&api_id=&to=@@PHONE@@&text=@@TEXT@@',
		'+', '1' WHERE NOT EXISTS (SELECT * from smsprovider);

CREATE TABLE notificationsms (
	type			integer,
	server			varchar(512),
	username		varchar(128),
	password		varchar(128),
	phone1prefix	varchar(4),
	phone1code		varchar(10),
	phone1num		varchar(512),
	phone2prefix	varchar(4),
	phone2code		varchar(10),
	phone2num		varchar(512),
	needinterval	boolean,
	interval		integer
);

INSERT INTO notificationsms(type,server,username,password,phone1prefix,phone1code,phone1num,phone2prefix,phone2code,phone2num,needinterval,interval)
SELECT 0,'clickatell','','','','','','','','','0',1 WHERE NOT EXISTS (SELECT * from notificationsms);

CREATE TABLE notificationfilter (
	addcamera				integer,
	deletecamera			integer,
	connectionlost			integer,
	connectionresume		integer,
	recordingfailed			integer,
	motiondetected			integer,
	alarmtriggered			integer,
	motionalarmtriggered	integer,
	rotationlimitreached	integer,
	vsadded					integer,
	vsdeleted				integer,
	vsconnectionlost		integer,
	vsconnectionresume		integer,
	rec_storage_removed		integer DEFAULT 1,
	rec_storage_installed	integer DEFAULT 1
);

CREATE TABLE notificationpushservice (
	mobile_enable			boolean,
	msn_enable				boolean,
	skype_enable			boolean,
	msn_account				varchar(256),
	msn_bot					varchar(256),
	skype_account			varchar(256),
	skype_bot				varchar(256),
	syno_mail_enable		boolean DEFAULT '0',
	mail_account			varchar(1024) DEFAULT '',
	ds_serial				varchar(64) DEFAULT '--',
	attach_snapshot			boolean default '1',
	enable_msg_interval		boolean default '0',
	msg_interval			integer default 1,
	enable_push_service		boolean DEFAULT '0'
);

INSERT INTO notificationpushservice(mobile_enable, msn_enable, skype_enable, msn_account, msn_bot, skype_account, skype_bot)
SELECT '0','0','0','','--','','--' WHERE NOT EXISTS (SELECT * from notificationpushservice);

INSERT INTO notificationfilter(addcamera, deletecamera, connectionlost,connectionresume,
recordingfailed, motiondetected, alarmtriggered, motionalarmtriggered, rotationlimitreached,
vsadded, vsdeleted, vsconnectionlost, vsconnectionresume, rec_storage_removed, rec_storage_installed)
SELECT 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 WHERE NOT EXISTS (SELECT * from notificationfilter);

CREATE TABLE notificationadvance (
	enable_compact_msg		boolean default '0',
	compact_msg_interval	integer default 60,
	ss_pkg_name				varchar(256),
	mute_time				integer default 30,
	enable_mute				boolean default '0',
	start_mute_time			integer default 0,
	snapshot_type			integer default 1,
	snapshot_post_evt_time	integer default 5
);

INSERT INTO notificationadvance(enable_compact_msg, compact_msg_interval)
SELECT '0', 0 WHERE NOT EXISTS (SELECT * from notificationadvance);

CREATE TABLE layout (
	id					integer PRIMARY KEY AUTOINCREMENT,
	name				varchar(256),
	emapid				integer,
	camgrpid			integer DEFAULT -1,
	type				integer,
	interval			integer,
	isdefault			boolean,
	fix_aspect_ratio	boolean DEFAULT '0',
	custom_pos_list		text,
	app_type			integer
);

CREATE TABLE layoutcamera (
	id					integer PRIMARY KEY AUTOINCREMENT,
	layoutid			integer,
	location			integer,
	dsid				integer,
	cameraid			integer,
	regionid			integer,
	dsname				varchar(256),
	cameraname			varchar(256),
	fisheye_type		integer,
	region_name			varchar(256),
	region_type			integer,
	item_type			integer,
	mountid				integer,
	analytics_enabled	boolean DEFAULT '0',
	item_id				integer DEFAULT -1,
	archive_task_id		integer DEFAULT 0
);

CREATE TABLE ssgeneric (
	central_enable			boolean,
	central_mode			integer,
	central_key				varchar(256),
	central_use_https		boolean DEFAULT '0',
	central_host_ds_name	varchar(256) DEFAULT '',
	central_host_mac		varchar(256) DEFAULT '',
	central_host_ip			varchar(256) DEFAULT '',
	central_host_port		integer DEFAULT 0,
	central_host_model		varchar(256) DEFAULT '',
	notifyschedule			varchar(2048),
	vsnotifyschedule		varchar(2048),
	central_ds_name_on_host	varchar(256) DEFAULT '',
	nvr_enable				boolean,
	central_host_serial_num		varchar(256) DEFAULT 'serial_never_set',
	central_failover_status	integer DEFAULT 0,
	central_failover_reason	integer DEFAULT 0
);

INSERT INTO ssgeneric (central_enable, central_mode, central_key, central_host_ds_name, central_host_mac, central_host_ip, central_host_port, central_host_model, notifyschedule, vsnotifyschedule, nvr_enable, central_host_serial_num)
SELECT '0', 2, '', '', '', '', 0, '', '7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF',
'F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F', '1', 'serial_never_set'
WHERE NOT EXISTS (SELECT * from ssgeneric);

CREATE TABLE slaveds (
	id						integer PRIMARY KEY AUTOINCREMENT,
	name					varchar(256),
	ip						varchar(256),
	port					integer,
	key						varchar(256),
	ss_version				varchar(256) DEFAULT '',
	dp_version				varchar(256) DEFAULT '',
	ds_model				varchar(256) DEFAULT '',
	enable					boolean,
	cms_locked				boolean DEFAULT '0',
	type					integer DEFAULT 0,
	max_cam_num				integer DEFAULT 1,
	default_license_cnt		integer DEFAULT 0,
	status					integer DEFAULT 0,
	cookie					varchar(256) DEFAULT '',
	mac_addr				varchar(256) DEFAULT '',
	camera_count			integer DEFAULT 0,
	admin_username			varchar(128) DEFAULT 'admin',
	admin_passwd			varchar(256) DEFAULT '',
	failed_sync_log_id		integer DEFAULT 0,
	failed_sync_rec_id		integer DEFAULT 0,
	cms_masked				boolean DEFAULT '0',
	cms_sync_time			boolean DEFAULT '0',
	volSpace				numeric DEFAULT 0,
	verify					text,
	status_flags			integer DEFAULT 0,
	serial_num				varchar(256) DEFAULT '',
	dsm_version				varchar(256) DEFAULT '',
	event_sync_id			integer DEFAULT 1,
	event_hist_sync_id		integer DEFAULT 0,
	event_resync_flag		boolean DEFAULT '0',
	rtsp_key				varchar(64) DEFAULT '',
	iomodule_count			integer DEFAULT 0,
	max_io_num				integer DEFAULT 10,
	did_code				varchar(256) DEFAULT '',
	login_error				integer DEFAULT 0,
	connect_type			integer DEFAULT 0,
	quick_connect_id		varchar(128) DEFAULT '',
	protocol				integer DEFAULT 0,
	log_sync_id				integer DEFAULT 1,
	log_hist_sync_id		integer DEFAULT 0,
	log_resync_flag			boolean DEFAULT '0',
	slave_mode				integer DEFAULT 0,
	failover_pair_id		integer DEFAULT -1,
	failover_status			integer DEFAULT 0,
	failover_server_list	varchar(256) DEFAULT '',
	failover_reason			integer DEFAULT 0,
	failover_retry_act		integer DEFAULT 0,
	pkg_status				integer DEFAULT 0,
	vol_status				integer DEFAULT 0,
	trans_dev_count			integer DEFAULT 0,
	max_trans_dev_num		integer DEFAULT 10,
	enabled_addons		 	integer DEFAULT 0,
	speaker_dev_count		integer DEFAULT 0,
	max_speaker_dev_num		integer DEFAULT 10
);

CREATE TABLE failoversetting (
	cam_cap					integer DEFAULT 0,
	discon_tm				integer DEFAULT 60,
	check_storage_err		boolean DEFAULT '0',
	storage_err_cond		integer DEFAULT 0,
	sync_recording			boolean DEFAULT '1',
	enable_auto_failover	boolean DEFAULT '1',
	enable_auto_restore		boolean DEFAULT '1',
	check_ss_pkgsts			boolean DEFAULT '0',
	check_ss_uninstall		boolean DEFAULT '0',
	check_ss_disable		boolean DEFAULT '0'
);

INSERT INTO failoversetting (cam_cap, discon_tm, check_storage_err, storage_err_cond, sync_recording, enable_auto_failover, check_ss_pkgsts, check_ss_uninstall, check_ss_disable)
SELECT 0, 60, '0', 0, '1', '1', '0', '0', '0' WHERE NOT EXISTS (SELECT * from failoversetting);

CREATE TABLE patrol (
	id			integer PRIMARY KEY AUTOINCREMENT,
	camid		integer,
	name		varchar(256),
	stayTime	integer DEFAULT 5,
	speed		integer DEFAULT 3
);

CREATE TABLE patrolPresetData (
	id			integer PRIMARY KEY AUTOINCREMENT,
	patrolId	integer,
	camId		integer,
	position	integer,
	name		varchar(256),
	sequence	integer,
	stayTime	integer DEFAULT 5,
	speed		integer DEFAULT 3,
	type		integer DEFAULT 0,
	from_camera	boolean DEFAULT '0'
);

CREATE TABLE guard (
	camid		integer PRIMARY KEY,
	cycle		integer,
	interval	integer
);

CREATE TABLE guardSchedule (
	id			integer PRIMARY KEY AUTOINCREMENT,
	camid		integer,
	day			integer,
	halfHour	integer,
	type		integer,
	patrolId	integer
);

CREATE TABLE emap (
	id					integer PRIMARY KEY AUTOINCREMENT,
	name				varchar(256),
	filename			varchar(256),
	imgW				integer,
	imgH				integer,
	owner_ds_id			integer DEFAULT 0,
	id_on_rec_server	integer DEFAULT 0,
	hide_item_name		boolean,
	small_item_size		boolean
);

CREATE TABLE emapItem (
	id				integer PRIMARY KEY AUTOINCREMENT,
	emapId  		integer,
	type			integer,
	refId			integer,
	refName			varchar(256),
	dsId			integer,
	xPos			integer,
	yPos			integer,
	direction		integer,
	txtPos			integer,
	iconCenterX		integer DEFAULT 0,
	iconCenterY		integer DEFAULT 0,
	portIdx			integer DEFAULT -1
);

CREATE TABLE preset (
	id			integer PRIMARY KEY AUTOINCREMENT,
	camid		integer,
	position	integer,
	name		varchar(256),
	speed		integer DEFAULT 3,
	type		integer DEFAULT 0,
	from_camera	boolean DEFAULT '0'
);

CREATE TABLE eventexport (
	id				integer PRIMARY KEY AUTOINCREMENT,
	name			varchar(256),
	expid			varchar(64),
	camlistid		varchar(128),
	dstdir			varchar(1024),
	start_time		integer,
	stop_time		integer,
	export_time		integer,
	total_size		integer,
	total_count		integer,
	exported_count	integer,
	status			integer,
	src_ds_id		integer DEFAULT 0,
	src_arch_id		integer DEFAULT 0,
	src_arch_name	varchar(128) DEFAULT '',
	dst_ds_id		integer DEFAULT 0
);

CREATE TABLE eventmount (
	id			integer PRIMARY KEY AUTOINCREMENT,
	ds_id 		integer DEFAULT 0,
	name		varchar(256),
	expid		varchar(64),
	camlist		varchar(1024),
	srcdir		varchar(1024),
	share_name	varchar(1024),
	start_time	integer,
	stop_time	integer,
	enable		boolean,
	version 	integer DEFAULT 0,
	db_status	integer DEFAULT 0
);

CREATE TABLE privilege (
	id			integer PRIMARY KEY AUTOINCREMENT,
	uid			integer,
	dsId		integer,
	inaCamIds	text
);

CREATE TABLE sswebinfo (
	init_module	varchar(64)
);

INSERT INTO sswebinfo (init_module)
SELECT '' WHERE NOT EXISTS (SELECT * from sswebinfo);

CREATE TABLE cameragroup (
	id				integer PRIMARY KEY AUTOINCREMENT,
	name			varchar(256),
	description		varchar(256)
);

CREATE TABLE cameragroupcam (
	id						integer PRIMARY KEY AUTOINCREMENT,
	camgrpid				integer,
	dsid					integer,
	cameraid				integer,
	cam_id_on_rec_server	integer DEFAULT 0,
	dsname					varchar(256),
	cameraname				varchar(256)
);

CREATE TABLE privilegeprofile (
	id						integer PRIMARY KEY AUTOINCREMENT,
	name					varchar(256),
	privilege				integer,
	inacamids				text DEFAULT '',
	inacamgrpids			text DEFAULT '',
	allcamdsids				text DEFAULT '',
	custom_uid				integer,
	description				varchar(256),
	ina_emap_ids			text DEFAULT '',
	ina_layout_ids			text DEFAULT '',
	ina_adv_oper			integer DEFAULT 0,
	all_emap_ds_ids			text DEFAULT '',
	all_layout_type			interger DEFAULT 0,
	ina_edit_emap_ids		text DEFAULT '-1',
	ina_edit_layout_ids		text DEFAULT '-1',
	all_edit_emap_ds_ids	text DEFAULT '',
	all_edit_layout_type	integer DEFAULT 0,
	ina_iomodule_ids		text DEFAULT '',
	all_iomodule_ds_ids		text DEFAULT '0',
	ina_server_ids			text DEFAULT '',
	all_server_avail		boolean DEFAULT 0,
	ina_ipspeaker_ids		text DEFAULT '',
	all_ipspeaker_ds_ids	text DEFAULT '',
	ina_ipspeaker_grp_ids	text DEFAULT ''
);

INSERT INTO privilegeprofile(name, privilege, inacamids, inacamgrpids, allcamdsids, custom_uid, description)
SELECT 'All-Object Manager', 1, '', '', '', 0, 'System default manager' WHERE NOT EXISTS (SELECT * from privilegeprofile) UNION ALL
SELECT 'All-Object Spectator', 2, '', '', '', 0, 'System default spectator' WHERE NOT EXISTS (SELECT * from privilegeprofile) UNION ALL
SELECT '', 0, '', '', '', 0, 'System default admin' WHERE NOT EXISTS (SELECT * from privilegeprofile);

CREATE TABLE privilegeprofilecam (
	id				integer PRIMARY KEY AUTOINCREMENT,
	privprofileid	integer,
	dsid			integer,
	inacamids		text
);

CREATE TABLE fisheyeregion (
	id				integer PRIMARY KEY AUTOINCREMENT,
	name			varchar(256),
	camera_id		integer DEFAULT 0,
	type			integer DEFAULT 0,
	position_x		integer DEFAULT 0,
	position_y		integer DEFAULT 0,
	zoom			integer DEFAULT 0,
	subregion_info	varchar(512) DEFAULT ''
);

CREATE TABLE migration (
	id					integer PRIMARY KEY AUTOINCREMENT,
	dstCamId			integer DEFAULT 0,
	srcCamId			integer DEFAULT 0,
	camName				varchar(256) DEFAULT '',
	ip					varchar(256) DEFAULT '',
	size				integer DEFAULT 0,
	status				integer DEFAULT 0,
	progress			real DEFAULT 0,
	src					integer DEFAULT 0,
	dst					integer DEFAULT 0
);

CREATE TABLE joystick (
	model				varchar(128) PRIMARY KEY,
	options				varchar(2048),
	speed_control		interger DEFAULT 0
);

CREATE TABLE privilegepercamera (
	id						integer PRIMARY KEY AUTOINCREMENT,
	privprofile_id			integer,
	ina_live_cam_ids		text DEFAULT '',
	ina_play_cam_ids		text DEFAULT '',
	ina_lens_cam_ids		text DEFAULT '',
	ina_audio_cam_ids		text DEFAULT '',
	ina_digiout_cam_ids		text DEFAULT '',
	ina_live_camgrp_ids		text DEFAULT '',
	ina_play_camgrp_ids		text DEFAULT '',
	ina_lens_camgrp_ids		text DEFAULT '',
	ina_audio_camgrp_ids	text DEFAULT '',
	ina_digiout_camgrp_ids	text DEFAULT '',
	live_allcamds_ids		text default '',
	play_allcamds_ids		text default '',
	lens_allcamds_ids		text default '',
	audio_allcamds_ids		text default '',
	digiout_allcamds_ids	text default ''
);

INSERT INTO privilegepercamera(privprofile_id, ina_live_cam_ids, ina_play_cam_ids, ina_lens_cam_ids, ina_audio_cam_ids, ina_digiout_cam_ids,
							   ina_live_camgrp_ids, ina_play_camgrp_ids, ina_lens_camgrp_ids, ina_audio_camgrp_ids, ina_digiout_camgrp_ids,
							   live_allcamds_ids, play_allcamds_ids, lens_allcamds_ids, audio_allcamds_ids, digiout_allcamds_ids)
SELECT 1, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '' WHERE NOT EXISTS (SELECT * from privilegepercamera) UNION ALL
SELECT 2, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '' WHERE NOT EXISTS (SELECT * from privilegepercamera) UNION ALL
SELECT 3, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '' WHERE NOT EXISTS (SELECT * from privilegepercamera);

CREATE TABLE privilegeperdoor (
	id								integer PRIMARY KEY AUTOINCREMENT,
	privprofile_id					integer UNIQUE,
	ina_authorize_door_ids			text DEFAULT '',
	ina_manual_lock_door_ids		text DEFAULT '',
	ina_manual_unlock_door_ids		text DEFAULT '',
	ina_manual_access_door_ids		text DEFAULT '',
	authorize_alldoords_ids			text default '',
	manual_lock_alldoords_ids		text default '',
	manual_unlock_alldoords_ids		text default '',
	manual_access_alldoords_ids		text default ''
);

INSERT INTO privilegeperdoor(privprofile_id, ina_authorize_door_ids, ina_manual_lock_door_ids, ina_manual_unlock_door_ids, ina_manual_access_door_ids,
							 authorize_alldoords_ids, manual_lock_alldoords_ids, manual_unlock_alldoords_ids, manual_access_alldoords_ids)
SELECT 1, '', '', '', '', '', '', '', '' WHERE NOT EXISTS (SELECT * from privilegeperdoor) UNION ALL
SELECT 2, '', '', '', '', '', '', '', '' WHERE NOT EXISTS (SELECT * from privilegeperdoor) UNION ALL
SELECT 3, '', '', '', '', '', '', '', '' WHERE NOT EXISTS (SELECT * from privilegeperdoor);

CREATE TABLE edgestoragesettings (
	id  					integer PRIMARY KEY AUTOINCREMENT,
	cam_id 					integer DEFAULT 0,
	cam_id_on_rec_server 	integer DEFAULT 0,
	owner_ds_id				integer DEFAULT 0,
	enabled 				boolean DEFAULT '0',
	edge_pre_rec_time		integer DEFAULT 5,
	edge_post_rec_time		integer DEFAULT 5,
	edge_cam_rec_time		integer DEFAULT 60,
	retrieve_enabled		boolean DEFAULT '0',
	retrieve_method			integer DEFAULT 0,
	download_sch 			varchar(512) DEFAULT '111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111',
	edge_rec_sch_days		integer DEFAULT 127,
	edge_rec_start_time		string DEFAULT '00:00',
	edge_rec_stop_time		string DEFAULT '00:00',
	edge_rec_mode			integer DEFAULT 0,
	last_download_clip_id	integer DEFAULT 0,
	last_getlost_clip_id	integer DEFAULT 0
);

CREATE TABLE actionrule (
	id  				integer PRIMARY KEY AUTOINCREMENT,
	name 				varchar(512),
	status				integer DEFAULT 0,
	rule_type			integer DEFAULT 0,
	act_type			integer DEFAULT 0,
	evt_source			integer DEFAULT 0,
	evt_server_id		integer DEFAULT 0,
	evt_device_id		integer DEFAULT 0,
	evt_id				integer DEFAULT 0,
	evt_item			integer DEFAULT -1,
	evt_min_interval	integer DEFAULT 10,
	act_source			integer DEFAULT 0,
	act_server_id		integer DEFAULT 0,
	act_device_id		integer DEFAULT 0,
	act_id				integer DEFAULT 0,
	act_item_id			integer DEFAULT 0,
	act_times			integer DEFAULT 1,
	act_time_unit		integer DEFAULT 1,
	act_time_duration	integer DEFAULT 10,
	act_return_pos		integer DEFAULT 0,
	schedule 			varchar(512) DEFAULT '111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111',
	ext_url				text,
	username			varchar(128),
	password			varchar(128),
	enabled				boolean DEFAULT '1',
	multi_rule_id		integer DEFAULT 0,
	multi_evt_setting	integer DEFAULT 0,
	multi_evt_ids		varchar(16)
);

CREATE TABLE actionrulemultirule (
	id					integer PRIMARY KEY AUTOINCREMENT
);

CREATE TABLE actionruleevent (
	id  				integer PRIMARY KEY AUTOINCREMENT,
	evt_source			integer DEFAULT 0,
	evt_server_id		integer DEFAULT 0,
	evt_device_id		integer DEFAULT 0,
	evt_id				integer DEFAULT 0,
	evt_item			integer DEFAULT -1,
	evt_trigger			integer DEFAULT -1,
	evt_status			integer DEFAULT 1
);

CREATE TABLE camdeviceoutput (
	id						integer PRIMARY KEY AUTOINCREMENT,
	cam_id					integer DEFAULT 0,
	cam_id_on_rec_server 	integer DEFAULT 0,
	owner_ds_id				integer DEFAULT 0,
	type					integer DEFAULT 0,
	keep					boolean DEFAULT '1',
	idx						integer DEFAULT 0,
	audio_gain				varchar(32) DEFAULT '0',
	normal_state			integer DEFAULT 0,
	trigger					boolean DEFAULT '0',
	name					varchar(128)
);

CREATE TABLE audiopattern (
	id				integer PRIMARY KEY AUTOINCREMENT,
	name			varchar(256) DEFAULT '',
	length			integer default 0,
	description		varchar(256) DEFAULT '',
	filefmt			varchar(8) DEFAULT '',
	is_default		boolean DEFAULT '0'
);

CREATE TABLE camdetsetting (
	id						integer PRIMARY KEY AUTOINCREMENT,
	cam_id					integer DEFAULT 0,
	cam_id_on_rec_server	integer DEFAULT 0,
	owner_ds_id				integer DEFAULT 0,
	type					integer DEFAULT 0,
	keep					boolean DEFAULT '1',
	mode_flag				integer DEFAULT 0,
	idx						integer DEFAULT 0,
	det_src					integer DEFAULT 0,
	sensitivity				integer DEFAULT 0,
	threshold				integer DEFAULT 0,
	object_size				integer DEFAULT 0,
	percentage				integer DEFAULT 0,
	history					integer DEFAULT 0,
	duration				integer DEFAULT 0,
	normal_state			integer DEFAULT 0,
	level					integer DEFAULT 0,
	notifyschedule			text DEFAULT '7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF',
	region					varchar(305) DEFAULT 'FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF',
	show_area_flag			integer DEFAULT 0,
	name					varchar(128),
	shortlivesecond			integer DEFAULT 0,
	trigger_motion			boolean DEFAULT '0'
);

CREATE TABLE autoupdateid (
	id						integer
);
INSERT INTO autoupdateid (id) SELECT strftime('%s','now') WHERE NOT EXISTS (SELECT * from autoupdateid);

CREATE TABLE recordingshare (
	id						integer PRIMARY KEY AUTOINCREMENT,
	name					varchar(64) DEFAULT '',
	volume					varchar(32) DEFAULT '',
	path					varchar(256) DEFAULT '',
	owner_ds_id				integer DEFAULT 0,
	id_on_rec				integer DEFAULT 0,
	hide_network_place		boolean DEFAULT '0',
	description				varchar(128) DEFAULT '',
	mount_source			varchar(256) DEFAULT '',
	mount_type				integer DEFAULT 0,
	auto_mount				boolean DEFAULT '0',
	fs_type					integer DEFAULT -1,
	total_size				integer DEFAULT 0,
	mount_status			integer DEFAULT 0,
	enc_type				integer DEFAULT 0,
	migrating				boolean DEFAULT '0',
	enable_rec_limit		boolean DEFAULT '0',
	rec_limit_gb			integer DEFAULT 100,
	status					integer DEFAULT 0
);

CREATE TABLE localdisplayuser (
	id			integer PRIMARY KEY AUTOINCREMENT,
	password	varchar(128) DEFAULT '',
	language	varchar(4) DEFAULT 'def'
);

INSERT INTO localdisplayuser (id)
SELECT 1 WHERE NOT EXISTS (SELECT * from localdisplayuser) UNION ALL
SELECT 2 WHERE NOT EXISTS (SELECT * from localdisplayuser);

CREATE TABLE localdisplayinfo (
	auto_login	boolean,
	login_user	integer
);
INSERT INTO localdisplayinfo (auto_login, login_user) SELECT 0, 1 WHERE NOT EXISTS (SELECT * from localdisplayinfo);

CREATE TABLE iomodule (
	id							integer PRIMARY KEY AUTOINCREMENT,
	enabled						boolean,
	name						varchar(256),
	vendor						varchar(128),
	model						varchar(128),
	hostname					varchar(256),
	port						integer,
	media_port					integer,
	liveview_mode				integer DEFAULT 0,
	rtsp_protocol				integer DEFAULT 0,
	streaming_type				integer,
	channel						varchar(128),
	audio_format				integer DEFAULT 0,
	path						varchar(512),
	username					varchar(128),
	password					varchar(128),
	enable_audio				boolean DEFAULT '0',
	update_time					integer DEFAULT 0,
	owner_ds_id 				integer DEFAULT 0,
	id_on_rec_server 			integer DEFAULT 0,
	status_on_rec_server		integer DEFAULT 0,
	status_flags				integer DEFAULT 0,
	alert_event					integer DEFAULT 0,
	enable_ntp					boolean DEFAULT '0',
	time_server					varchar(64),
	cap_file_path				varchar(128),
	is_deleted					boolean DEFAULT '0',
	notifyschedule				varchar(2048) DEFAULT '7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF'
);

CREATE INDEX IF NOT EXISTS iomodule_update_time_idx ON iomodule (update_time);
CREATE TRIGGER IF NOT EXISTS iomodule_auto_update AFTER UPDATE ON iomodule BEGIN UPDATE OR IGNORE iomodule SET update_time = (SELECT MAX(update_time) FROM iomodule) + 1 WHERE id = new.id; END;
CREATE TRIGGER IF NOT EXISTS iomodule_auto_update_insert AFTER INSERT ON iomodule BEGIN UPDATE OR IGNORE iomodule SET update_time = (SELECT MAX(update_time) FROM iomodule) + 1 WHERE id = new.id; END;

CREATE TABLE iomoduleiosetting (
	id								integer PRIMARY KEY AUTOINCREMENT,
	iomodule_id						integer DEFAULT 0,
	iomodule_id_on_rec_server		integer DEFAULT 0,
	owner_ds_id						integer DEFAULT 0,
	type							integer DEFAULT 0,
	keep							boolean DEFAULT '1',
	idx								integer DEFAULT 0,
	audio_gain						varchar(32) DEFAULT '0',
	normal_state					integer DEFAULT 0,
	trigger							boolean DEFAULT '0',
	notifyschedule					varchar(2048) DEFAULT '7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF',
	name							varchar(128)
);

CREATE TABLE IF NOT EXISTS iomodulecampairing (
	id                              integer PRIMARY KEY AUTOINCREMENT,
	iomodule_id                     integer DEFAULT 0,
	port_idx                        integer DEFAULT 0,
	enable_pairing                  boolean DEFAULT '0',
	cam_ds_id						integer DEFAULT 0,
	cam_id                          integer DEFAULT 0
);

CREATE TABLE iomodulestatus (
	iomodule_id	integer PRIMARY KEY,
	status		integer,
	pid			integer,
	updatetime	integer
);

CREATE TABLE alertsettings (
	log_rot_day		integer,
	rec_rot_day		integer,
	rec_rot_size	integer,
	rec_rot_by_size	boolean
);

INSERT INTO alertsettings (log_rot_day, rec_rot_day, rec_rot_size, rec_rot_by_size) SELECT 90, 1, 10, '0' WHERE NOT EXISTS (SELECT * from alertsettings);

CREATE TABLE logadvanced (
	ss_log_type	integer PRIMARY KEY,
	enable		boolean DEFAULT '1'
);

CREATE TABLE snapshotadvance (
	add_timestamp		boolean DEFAULT '0',
	limit_total_size	boolean DEFAULT '1',
	timestamp_position	integer DEFAULT  0,
	limit_size_in_mb	integer DEFAULT  1000,
	display_snapshot	boolean DEFAULT '1',
	display_duration	integer DEFAULT  3,
	storage_path		varchar(256) DEFAULT '',
	limit_by_time		boolean DEFAULT '0',
	limit_time_in_date	integer DEFAULT  30,
	sort_info			integer DEFAULT  0,
	naming_rule			integer DEFAULT  0
);

INSERT INTO snapshotadvance (add_timestamp, limit_total_size, timestamp_position, limit_size_in_mb, display_snapshot, display_duration)
SELECT '0', '1', 0, 1000, '1', 3 WHERE NOT EXISTS (SELECT * from snapshotadvance);

CREATE TABLE logininfo (
	id					integer PRIMARY KEY AUTOINCREMENT,
	sid					varchar(256) DEFAULT '',
	client_type			integer DEFAULT 0,
	client_login_time	integer DEFAULT 0,
	client_version		varchar(256) DEFAULT '',
	uid					integer DEFAULT 0,
	dual_auth_session	boolean DEFAULT '0'
);

CREATE TABLE log_rotate_settings (
	tbl_name			text DEFAULT '',
	grp_col_name		text DEFAULT '',
	grp_val				text DEFAULT '',
	kept_days			integer DEFAULT 90,
	limit_by_size		integer DEFAULT 0,
	limit_by_num		integer DEFAULT 0,
	size_limit_mb		integer DEFAULT 256,
	num_limit			integer DEFAULT 100000,
	archive				integer DEFAULT 0,
	archive_path		text DEFAULT '',
	archive_in_text		integer DEFAULT 0,
	compress_archive	integer DEFAULT 0,
	PRIMARY KEY (tbl_name, grp_col_name, grp_val)
);

INSERT OR IGNORE INTO log_rotate_settings(tbl_name, kept_days) VALUES('log', 90);
INSERT OR IGNORE INTO log_rotate_settings(tbl_name, kept_days) VALUES('message', 30);
INSERT OR IGNORE INTO log_rotate_settings(tbl_name, kept_days) VALUES('actrulehistory', 30);
INSERT OR IGNORE INTO log_rotate_settings(tbl_name, kept_days) VALUES('iomodulelog', 90);
INSERT OR IGNORE INTO log_rotate_settings(tbl_name, kept_days) VALUES('ivareport', 90);
INSERT OR IGNORE INTO log_rotate_settings(tbl_name, kept_days, size_limit_mb) VALUES('ivarecording', 7, 10240);

CREATE TABLE syslog_settings (
	tbl_name			text PRIMARY KEY,
	enable_send			boolean DEFAULT 0,
	enable_ssl			boolean DEFAULT 0,
	destination_ip		varchar(256) DEFAULT '0',
	port				integer DEFAULT 0,
	protocol			text,
	format				text
);

INSERT OR IGNORE INTO syslog_settings(tbl_name, enable_send, enable_ssl, destination_ip, port, protocol, format) VALUES('sendLog', 0, 0, '' , 514, 'udp', 'BSD');

CREATE TABLE IF NOT EXISTS iva_setting (
	id						integer PRIMARY KEY AUTOINCREMENT,
	name					varchar(300),
	camera_id				integer DEFAULT 0,
	analyze_type			integer DEFAULT -1,
	owner_ds_id				integer DEFAULT 0,
	enable					boolean DEFAULT '0',
	status_flags			integer DEFAULT 0,
	trigger_alert			integer DEFAULT 0,
	stream_profile			integer DEFAULT 1,
	event_type				integer DEFAULT 0,
	sensitivity				integer DEFAULT 0,
	min_duration			integer DEFAULT 0,
	min_obj_size			float DEFAULT 1,
	min_obj_size_option		integer DEFAULT 0,
	people_mode				integer DEFAULT 0,
	people_enable_stay_max	boolean DEFAULT '0',
	people_stay_max			integer DEFAULT 100,
	people_display_info		integer DEFAULT 0,
	people_size				integer DEFAULT 0,
	people_cnt				integer DEFAULT 10,
	people_enter			integer DEFAULT 0,
	people_exit				integer DEFAULT 2,
	people_region			varchar(300),
	people_hint_pos			varchar(300),
	region_type				integer DEFAULT 0,
	reset_cnt_frequency		integer DEFAULT 1,
	reset_weekday			integer DEFAULT 0,
	reset_date				integer DEFAULT 1,
	reset_time_hour			integer DEFAULT 0,
	reset_time_minute		integer DEFAULT 0,
	ignore_bg_event			integer DEFAULT 0,
	ignore_bg_obj			integer DEFAULT 0,
	det_fg_obj				integer DEFAULT 0,
	det_region_cnt			integer DEFAULT 1,
	det_region				varchar(300),
	area_grid				varchar(300),
	area_line				varchar(240),
	area_region				varchar(240),
	enable_schedule			boolean DEFAULT '0',
	schedule				varchar(512) DEFAULT '111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111'
);

CREATE TABLE homemodesetting (
	home_mode_on					boolean DEFAULT '0',
	mode_schedule_on				boolean DEFAULT '1',
	mode_schedule_next_time			integer DEFAULT '-1',
	rec_schedule_on					boolean DEFAULT '0',
	notify_on						boolean DEFAULT '0',
	streaming_on					boolean DEFAULT '0',
	actrule_on						boolean DEFAULT '0',
	reason							integer DEFAULT 0,
	stream_profile					text DEFAULT '1,1,1,1,1,1',
	actrules						text DEFAULT '-1',
	cameras							text DEFAULT '-1',
	io_modules						text DEFAULT '-1',
	geo_lat							float DEFAULT 0,
	geo_lng							float DEFAULT 0,
	geo_radius						integer DEFAULT 100,
	geo_delay_time					integer DEFAULT 60,
	custom1_det						integer DEFAULT 1,
	custom2_det						integer DEFAULT 1,
	custom1_di						integer DEFAULT 1,
	custom2_di						integer DEFAULT 1,
	mode_schedule					varchar(512) DEFAULT '000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
	rec_schedule					varchar(512) DEFAULT '111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111',
	wifi_ssid						text DEFAULT '',
	onetime_enable_on				boolean DEFAULT '0',
	onetime_disable_on				boolean DEFAULT '0',
	onetime_enable_time				integer DEFAULT 0,
	onetime_disable_time			integer DEFAULT 0,
	next_switch_reason				integer DEFAULT 0
);

INSERT INTO homemodesetting (home_mode_on) VALUES ('0');

CREATE TABLE homemodenotifyfilter (
	cam_connection_lost					integer DEFAULT 0,
	cam_connection_resumed				integer DEFAULT 0,
	motion_detected						integer DEFAULT 0,
	cam_di_triggered					integer DEFAULT 0,
	cam_ext_di_triggered				integer DEFAULT 0,
	cam_audio_detected					integer DEFAULT 0,
	cam_tampering_detected				integer DEFAULT 0,
	cam_pir_detected					integer DEFAULT 0,
	cam_app_triggered					integer DEFAULT 0,
	rotation_limit_reached				integer DEFAULT 0,
	stop_rec_limit_reached				integer DEFAULT 0,
	vs_connection_lost					integer DEFAULT 0,
	vs_connection_resumed				integer DEFAULT 0,
	slave_ds_connection_lost			integer DEFAULT 0,
	slave_ds_connection_resumed			integer DEFAULT 0,
	failover_start						integer DEFAULT 0,
	failover_recover_start				integer DEFAULT 0,
	failover_recover_stop				integer DEFAULT 0,
	failover_finished					integer DEFAULT 0,
	add_device							integer DEFAULT 0,
	delete_device						integer DEFAULT 0,
	connection_lost						integer DEFAULT 0,
	connection_resumed					integer DEFAULT 0,
	recording_failed					integer DEFAULT 0,
	rec_storage_removed					integer DEFAULT 0,
	rec_storage_installed				integer DEFAULT 0,
	ext_device_01						integer DEFAULT 0,
	ext_device_02						integer DEFAULT 0,
	ext_device_03						integer DEFAULT 0,
	ext_device_04						integer DEFAULT 0,
	ext_device_05						integer DEFAULT 0,
	ext_device_06						integer DEFAULT 0,
	ext_device_07						integer DEFAULT 0,
	ext_device_08						integer DEFAULT 0,
	ext_device_09						integer DEFAULT 0,
	ext_device_10						integer DEFAULT 0,
	snapshot_limit_reached				integer DEFAULT 0,
	door_conn_lost						integer DEFAULT 0,
	door_conn_resumed					integer DEFAULT 0,
	door_access_granted					integer DEFAULT 0,
	door_access_denied					integer DEFAULT 0,
	door_alarm_detected					integer DEFAULT 0,
	door_tampering_detected				integer DEFAULT 0,
	acs_ctrler_alarm_logged				integer DEFAULT 0,
	acs_ctrler_casing_open				integer DEFAULT 0,
	vs_fan_failed						integer DEFAULT 0,
	vs_overheat							integer DEFAULT 0,
	iomodule_di_triggered				integer DEFAULT 0,
	iomodule_conn_lost					integer DEFAULT 0,
	iomodule_conn_resumed				integer DEFAULT 0,
	home_mode_enter						integer DEFAULT 0,
	home_mode_leave						integer DEFAULT 0,
	iva_event_detection					integer DEFAULT 0,
	intercom_doorbell					integer DEFAULT 0,
	intercom_access						integer DEFAULT 0,
	pos_new_transaction					integer DEFAULT 0,
	pos_user_defined1					integer DEFAULT 0,
	pos_user_defined2					integer DEFAULT 0,
	pos_user_defined3					integer DEFAULT 0,
	pos_user_defined4					integer DEFAULT 0,
	pos_user_defined5					integer DEFAULT 0,
	archive_file_complete				integer DEFAULT 0,
	archive_server_disconn				integer DEFAULT 0,
	archive_server_resume				integer DEFAULT 0,
	archive_rotate_file					integer DEFAULT 0,
	archive_no_space					integer DEFAULT 0,
	arch_daily_archived_recordings		integer DEFAULT 0,
	archive_stop_rec_limit_reached		integer DEFAULT 0,
	ipspeaker_conn_lost					integer DEFAULT 0,
	ipspeaker_conn_resumed				integer DEFAULT 0,
	cam_app_vmd_triggered				integer DEFAULT 0
);

INSERT INTO homemodenotifyfilter (cam_connection_lost) VALUES (0);

CREATE TABLE mobiles (
	id								integer PRIMARY KEY AUTOINCREMENT,
	user_id							integer,
	os_type							integer,
	device_id						text UNIQUE,
	name							text,
	ds_cam_version					text,
	at_home							boolean DEFAULT '0',
	bind_wifi						boolean DEFAULT '0'
);

CREATE TABLE sharedfolderstorage (
	name							varchar(256) PRIMARY KEY,
	-- map to id in table `recordingshare`
	share_id						int,
	application_id					int
);

CREATE TABLE youtubelive (
	rtmp_path						text,
	key								text,
	cam_id							integer DEFAULT 0,
	stream_profile					integer DEFAULT 1,
	live_on							boolean DEFAULT '0'
);

INSERT INTO youtubelive (rtmp_path) SELECT 'rtmp://a.rtmp.youtube.com/live2' WHERE NOT EXISTS (SELECT * from youtubelive);

CREATE TABLE systemwisesetting (
	name							varchar(256) PRIMARY KEY,
	value							text
);
