BEGIN;

-- add to camera table
ALTER TABLE camera
	ADD COLUMN resolution			varchar(128),
	ADD COLUMN video_type			integer,
	ADD COLUMN enable_camera_motion	boolean,
	ADD COLUMN enable_io_log		boolean;

-- convert camera names
UPDATE camera
	set (model) = ('207')
	where model = '207/207W/210/211';
UPDATE camera
	set (model) = ('BB-HCM311')
	where model = 'BB-HCM311/BB-HCM331';
UPDATE camera
	set (model) = ('BL-C30')
	where model = 'BL-C30/BL-C131';
UPDATE camera
	set (model) = ('BL-C1')
	where model = 'BL-C1/BL-C20';
UPDATE camera
	set (model) = ('BB-HCM511')
	where model = 'BB-HCM511/BB-HCM531/BB-HCM515';
-- convert width/height to string
UPDATE camera
	SET (resolution) = ('320x240')
    where image_width = 320 and
		(vendor = 'AXIS' or vendor = 'Panasonic');
UPDATE camera
	SET (resolution) = ('640x480')
    where image_width = 640 and
		(vendor = 'AXIS' or vendor = 'Panasonic');
-- set default values for existing camera entries
UPDATE camera
	set (enabled, video_type, enable_camera_motion, enable_io_log) =
		('1', 1, '0', '0');

-- add to event table
ALTER TABLE event
	ADD COLUMN video_type	integer;
-- set default value for existing entries
UPDATE event
	SET video_type = 1;

-- convert coordinates
UPDATE motion SET (top, bottom, m_left, m_right) =
	(top * 10000 / camera.image_height,
    bottom * 10000 / camera.image_height,
    m_left * 10000 / camera.image_width,
    m_right * 10000 / camera.image_width)
    from camera
    where motion.camera_id = camera.id;

END;

