
#!/bin/sh
# Copyright (c) 2015 Synology Inc. All rights reserved.

ExecuteSqlCmd "system" \
"DROP TRIGGER IF EXISTS camera_update_time; \
DROP TRIGGER IF EXISTS camera_update_time_insert;"

TestTableColumnToRunScript -t "autoupdateid" -c "id" -s "222_sequence_auto_update.sql"

ExecuteSqlCmd "snapshot" \
"CREATE INDEX IF NOT EXISTS snapshot_update_time_idx ON snapshot(update_time); \
CREATE TRIGGER IF NOT EXISTS snapshot_auto_update AFTER UPDATE ON snapshot BEGIN UPDATE OR IGNORE snapshot SET update_time = (SELECT MAX(update_time) FROM snapshot) + 1 WHERE id = new.id; END; \
CREATE TRIGGER IF NOT EXISTS snapshot_auto_update_insert AFTER INSERT ON snapshot BEGIN UPDATE OR IGNORE snapshot SET update_time = (SELECT MAX(update_time) FROM snapshot) + 1 WHERE id = new.id; END;"
