BEGIN;

CREATE TABLE iomodule (
	id							integer PRIMARY KEY AUTOINCREMENT,
	enabled						boolean,
	name						varchar(256),
	vendor						varchar(128),
	model						varchar(128),
	hostname					varchar(256),
	port						integer,
	media_port					integer,
	liveview_mode				integer DEFAULT 0,
	rtsp_protocol				integer DEFAULT 0,
	streaming_type				integer,
	channel						varchar(128),
	audio_format				integer DEFAULT 0,
	path						varchar(512),
	username					varchar(128),
	password					varchar(128),
	enable_audio				boolean DEFAULT '0',
	update_time					integer DEFAULT 0,
	owner_ds_id 				integer DEFAULT 0,
	id_on_rec_server 			integer DEFAULT 0,
	status_on_rec_server		integer DEFAULT 0,
	status_flags				integer DEFAULT 0,
	cap_file_path				varchar(128),
	is_deleted					boolean DEFAULT '0'
);

CREATE INDEX IF NOT EXISTS iomodule_update_time_idx ON iomodule (update_time);
CREATE TRIGGER IF NOT EXISTS iomodule_auto_update AFTER UPDATE ON iomodule BEGIN UPDATE OR IGNORE iomodule SET update_time = (SELECT MAX(update_time) FROM iomodule) + 1 WHERE id = new.id; END;
CREATE TRIGGER IF NOT EXISTS iomodule_auto_update_insert AFTER INSERT ON iomodule BEGIN UPDATE OR IGNORE iomodule SET update_time = (SELECT MAX(update_time) FROM iomodule) + 1 WHERE id = new.id; END;

CREATE TABLE iomoduleiosetting (
	id								integer PRIMARY KEY AUTOINCREMENT,
	iomodule_id						integer DEFAULT 0,
	iomodule_id_on_rec_server		integer DEFAULT 0,
	owner_ds_id						integer DEFAULT 0,
	type							integer DEFAULT 0,
	keep							boolean DEFAULT '1',
	idx								integer DEFAULT 0,
	audio_gain						varchar(32) DEFAULT '0',
	normal_state					integer DEFAULT 0,
	trigger							boolean DEFAULT '0'
);

CREATE TABLE iomodulestatus (
	iomodule_id	integer PRIMARY KEY,
	status		integer,
	pid			integer,
	updatetime	integer
);

COMMIT;
