BEGIN;

CREATE TABLE log_cnt (
	dsid				integer PRIMARY KEY,
	cnt					integer DEFAULT 0
);

DROP TRIGGER IF EXISTS log_auto_update;
CREATE TRIGGER IF NOT EXISTS log_auto_update AFTER UPDATE ON log BEGIN UPDATE OR IGNORE log SET update_time = (SELECT MAX(update_time) FROM log) + 1 WHERE id = new.id; END;

DROP TRIGGER IF EXISTS log_auto_update_insert;
CREATE TRIGGER log_auto_update_insert AFTER INSERT ON log BEGIN
	UPDATE OR IGNORE log SET update_time = (SELECT MAX(update_time) FROM log) + 1 WHERE id = new.id;
	UPDATE log_cnt SET cnt = (cnt+1) WHERE dsid = NEW.dsid;
END;

DROP TRIGGER IF EXISTS log_auto_update_delete;
CREATE TRIGGER log_auto_update_delete AFTER DELETE ON log BEGIN
	UPDATE log_cnt SET cnt = (cnt-1) WHERE dsid = OLD.dsid;
END;

COMMIT;
