#!/bin/sh
# Copyright (c) 2016 Synology Inc. All rights reserved.

TestTableColumnToRunScript -d "recording" -t "event" -c "snapshot_small" -s "254_recording_snapshot_small.sql"
TestTableColumnToRunScript -d "recording" -t "event" -c "fisheye_origin_view" -s "254_recording_fisheye_origin_view.sql"
TestTableColumnToRunScript -d "recording" -t "event" -c "for_rotation_only" -s "254_recording_for_rotation_only.sql"
TestTableColumnToRunScript -d "recording" -t "event" -c "update_time" -s "254_recording_update_time.sql"
TestTableColumnToRunScript -d "recording" -t "event" -c "status_flags" -s "254_recording_status_flags.sql"

ExecuteSqlCmd "recording" \
"CREATE TRIGGER IF NOT EXISTS event_auto_update AFTER UPDATE ON event BEGIN UPDATE OR IGNORE event SET update_time = (SELECT MAX(update_time) FROM event) + 1 WHERE id = new.id; END; \
CREATE TRIGGER IF NOT EXISTS event_auto_update_insert AFTER INSERT ON event BEGIN UPDATE OR IGNORE event SET update_time = (SELECT MAX(update_time) FROM event) + 1 WHERE id = new.id; END;"
