BEGIN;

CREATE TABLE IF NOT EXISTS archive_pull_task (
    id                      integer PRIMARY KEY AUTOINCREMENT,
    tiering_task_id         integer DEFAULT 0,
    task_type               integer DEFAULT 0,
    status                  integer DEFAULT 0,
    exec_time               integer DEFAULT 0,
    protocol                integer DEFAULT 0,
    port                    integer DEFAULT 0,
    day_limit               integer DEFAULT 30,
    size_limit_gb           integer DEFAULT 10,
    occupied_size           integer DEFAULT 0,
    last_event_id           integer DEFAULT 0,
    event_written_byte      integer DEFAULT 0,
    remux_event_idx         integer DEFAULT 0,
    enabled                 boolean DEFAULT '0',
    use_custom_folder       boolean DEFAULT '0',
    limit_by_size           boolean DEFAULT '0',
    rotate_files            boolean DEFAULT '0',
    name                    text UNIQUE,
    hostname                text DEFAULT '',
    did_code                text DEFAULT '',
    username                text DEFAULT '',
    passwd                  text DEFAULT '',
    storage_path            text DEFAULT '',
    custom_folder           text DEFAULT '',
    filter_param            text DEFAULT '',
    dsSerial                text DEFAULT '',
	writingEvtPath			text DEFAULT '',
    schedule                text DEFAULT '111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111'
);

CREATE TABLE IF NOT EXISTS archive_bw_control (
    id                      integer PRIMARY KEY REFERENCES archive_pull_task(id),
    bandwidth_limit1        integer DEFAULT 1000,
    bandwidth_limit2        integer DEFAULT 1000,
    bw_schedule              text DEFAULT '111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111'
);

CREATE TRIGGER IF NOT EXISTS pull_task_del_trigger AFTER DELETE ON archive_pull_task BEGIN DELETE FROM archive_pull_task WHERE id=OLD.tiering_task_id; END;
CREATE TRIGGER IF NOT EXISTS pull_task_del_bw_trigger AFTER DELETE ON archive_pull_task WHEN OLD.task_type!=4 BEGIN DELETE FROM archive_bw_control WHERE id=OLD.id; END;
CREATE TRIGGER IF NOT EXISTS pull_task_ins_bw_trigger AFTER INSERT ON archive_pull_task WHEN NEW.task_type!=4 BEGIN INSERT INTO archive_bw_control (id, bw_schedule) VALUES (NEW.id, NEW.schedule); END;
COMMIT;
