#!/bin/bash
# Copyright (c) 2017 Synology Inc. All rights reserved.

sql="SELECT sql FROM sqlite_master WHERE type='index' and name='event_stop_time_idx'"
db=$(GetSqliteDBPath "$DB_INST_RECORDING")

if [ -f "$db" ]; then
	if sqlite3 "$db" "$sql" | grep -q "WHERE ds_id"; then
		sqlite3 "$db" <<-EOF
			BEGIN;
				DROP INDEX IF EXISTS event_stop_time_idx;
				CREATE INDEX IF NOT EXISTS event_stop_time_idx ON event(stop_time);
			COMMIT;
		EOF
	fi
fi
