BEGIN;

CREATE TABLE lapse_recording (
	id							integer PRIMARY KEY AUTOINCREMENT,
	task_id						integer,
	camera_id					integer,
	start_time					integer,
	stop_time					integer,
	update_time					integer,
	range_hour					integer,
	recording					boolean DEFAULT '0',
	archived					boolean DEFAULT '0',
	mark_as_del					boolean DEFAULT '0',
	closing 					boolean DEFAULT '0',
	filesize					integer,
	video_width					integer,
	video_height				integer,
	framecount					integer,
	video_type					integer,
	path						text
);

CREATE INDEX IF NOT EXISTS lapse_recording_task_id_idx ON lapse_recording(task_id,start_time,stop_time);
CREATE INDEX IF NOT EXISTS lapse_recording_start_time_idx ON lapse_recording(start_time);
CREATE INDEX IF NOT EXISTS lapse_recording_archived_idx ON lapse_recording(archived) WHERE archived = 1;
CREATE INDEX IF NOT EXISTS lapse_recording_mark_as_del_idx ON lapse_recording(mark_as_del) WHERE mark_as_del = 1;

CREATE TRIGGER IF NOT EXISTS lapse_recording_auto_update AFTER UPDATE ON lapse_recording BEGIN UPDATE OR IGNORE lapse_recording SET update_time = (SELECT MAX(update_time) FROM lapse_recording) + 1 WHERE id = new.id; END;
CREATE TRIGGER IF NOT EXISTS lapse_recording_auto_update_insert AFTER INSERT ON lapse_recording BEGIN UPDATE OR IGNORE lapse_recording SET update_time = (SELECT MAX(update_time) FROM lapse_recording) + 1 WHERE id = new.id; END;

COMMIT;
