#!/bin/bash
# Copyright (c) 2017 Synology Inc. All rights reserved.

if [ true == $(IsNonRecordingMode) ]; then
	return 0
fi

DBInstance="videoanalytics"
TableName="video_analytics_cnt"
ColumnName="utc_n570, utc_n510, utc_n150, utc_510, utc_525, utc_765, utc_825, utc_840"

echo "Test $TableName table to check if column ($ColumnName) exists"
ExecuteSqlCmd "$DBInstance" "SELECT $ColumnName FROM $TableName LIMIT 1;"

if [ 0 != $? ]; then
	echo "Re-create [$SS_VIDEO_ANALYTICS_DB_NAME]."
	RecreateDb "$SS_VIDEO_ANALYTICS_DB" "$SS_VIDEO_ANALYTICS_SQL_SCRIPT"
fi
