#!/bin/sh

# MUST BE RUN ON DS

BATCH_ADD_DS_NUM=4
BATCH_ADD_WAIT_INTVAL=5

Usage()
{
	cat <<EOF
Usage: $(basename $0) [-h] -p PASSWD [-i "DS_ID_LIST"] [-n ADD_CNT] [-P DSM_PORT]
    -h:             show help
    -p PASSWD:      admin password to slaveds
    -i DS_ID_LIST:  specify which ds to add by dsId, must be quoted and seperated by space
                    (if not specified, each DS in DB will be used)
    -n ADD_CNT:     number of ds to add (default: 5)
    -P DSM_PORT:    dsm port            (default: 5000)
EOF
}

ExecSqlOnSysDb()
{
	local db="/var/packages/SurveillanceStation/target/system.db"
	local sqlite3="/var/packages/SurveillanceStation/target/bin/sqlite3"
	local sql="$1"

	echo $($sqlite3 -batch -noheader -cmd ".timeout 5000" "$db" "$sql")
}

WaitUntilSaveDone()
{
	local tr_sts_of_last_ds=""

	while true; do
		tr_sts_of_last_ds=$(ExecSqlOnSysDb "SELECT status_flags FROM slaveds ORDER BY id DESC LIMIT 1")
		[ "$tr_sts_of_last_ds" -eq 0 ] && break
		printf "waiting...\n"
		sleep $BATCH_ADD_WAIT_INTVAL
	done
	printf "\n"

	# wait a while for sscmshostd to establish cms mf conn
	sleep $BATCH_ADD_WAIT_INTVAL
}

admin_passwd=""
dsm_port=5000
num_ds=5
dsId=0
dsIds=""

# Options
while getopts ":hp:i:n:P:" opt; do
    case $opt in
        h) Usage && exit 0 ;;
		p) admin_passwd=$OPTARG ;;
		i) dsIds=$OPTARG ;;
		n) num_ds=$OPTARG ;;
		P) dsm_port=$OPTARG ;;
        \?) Usage && exit 1 ;;
    esac
done
shift $(($OPTIND - 1))

# Check pass_word specified
if [ -z "$admin_passwd" ]; then
	Usage
	exit 1
fi

# Check db record exist
if [ -n "$dsIds" ]; then
	for dsId in $dsIds; do
		if [ 1 -ne $(ExecSqlOnSysDb "SELECT count(1) FROM slaveds WHERE id=$dsId") ]; then
			printf "No DS [%d] record in db!\n" $dsId
			exit 1
		fi
	done
else
	dsIds=$(ExecSqlOnSysDb "SELECT id FROM slaveds")
fi

# Confirm with user
printf "\nMake sure the following settings are correct:\n"
printf "=> admin_passwd to slave ds: %s\n" $admin_passwd
printf "=> dsm_port: %s\n" $dsm_port
printf "=> num_ds: %s\n\n" $num_ds

read -rp "press any key to continue [Ctrl-c to break]  " ans
printf "\n"

# Add slaveds by running synowebapi
max_id=$(ExecSqlOnSysDb "SELECT max(id) FROM slaveds")
i=1
while [ $i -le $num_ds ]; do
	for dsId in $dsIds; do
		printf "add DS [%d] %d... " $dsId $i

		ExecSqlOnSysDb "SELECT name,ds_model,port,ss_version,max_cam_num,ip,camera_count,admin_username FROM slaveds WHERE id=$dsId" | \
			while IFS="|" read name ds_model port ss_version max_cam_num ip camera_count admin_username; do
				name=${name}-$(($max_id + $i))
				/usr/syno/bin/synowebapi --exec api=SYNO.SurveillanceStation.CMS.SlavedsWizard method=Save version=1 slavedsName=\"${name}\" slavedsModel=\"${ds_model}\" slavedsPort=${port} slavedsVersion=\"${ss_version}\" slavedsMaxCamNum=${max_cam_num} slavedsId="" slavedsIP=\"${ip}\" slavedsEnable=1 slavedsCamCnt=${camera_count} adminUsername=\"${admin_username}\" cms_sync_time=true adminPasswd=\"${admin_passwd}\" cms_locked=false cms_masked=false 2>/dev/null
			done
		printf "\n"

		# wait for a while per batch
		[ $(($i%$BATCH_ADD_DS_NUM)) -eq 0 ] && WaitUntilSaveDone

		i=$(($i + 1))
		[ $i -gt $num_ds ] && break
	done
done

printf "\n"
