#!/usr/bin/python

import time
import subprocess
import threading
import json
import os

event_data = {}

def LiveviewThread(run_event, camid, ip):
	while(run_event.is_set()):
		p = subprocess.call('curl -b cookie' + ip.replace('.', '') + '.txt -y 10 -Y 1 "http://' + ip + ':5000/webapi/entry.cgi?api=SYNO.SurveillanceStation.Player.LiveviewSrc&version=1&method=Play&isFromPlugin=1&camera=' + str(camid) + '&isCrossSite=0&itemType=0" > /dev/null 2>&1', shell=True)
		time.sleep(15)

def GetEventData(stream_data, camid, lock):
	stream_data = []

	lock.acquire()
	if 0 < len(event_data):
		stream_data = event_data.get(camid)
	lock.release()

	return stream_data

def TimelineThread(run_event, camid, ip, lock):
	stream_data = []

	while(run_event.is_set()):
		stream_data = GetEventData(stream_data, camid, lock)

		if 0 >= len(stream_data):
			print 'wait for camID:' + str(camid) + ' stream_data'
			time.sleep(10)
			continue

		while (0 < len(stream_data)) and run_event.is_set():
			eventinfo = stream_data.pop()
			event_id = eventinfo['id']
			event_time = eventinfo['stopTime']-eventinfo['startTime']
			event_size = eventinfo['event_size']
			band_width = int(round(event_size * 1024 * 1024 / event_time))

			p = subprocess.call('curl -b cookie' + ip.replace('.', '') + '.txt -y 10 -Y 1 --limit-rate ' + str(band_width) + 'B "http://' + ip + ':5000/webapi/entry.cgi?api=SYNO.SurveillanceStation.Stream&version=1&method=EventStream&eventId=' + str(event_id) + '" > /dev/null 2>&1', shell=True)

def TaskqueueThread(run_event, ip, user, password):
	while(run_event.is_set()):
		time.sleep(10)
		try:
			p = subprocess.check_output('curl -s -b cookie' + ip.replace('.', '') + '.txt -d "stop_when_error=false&mode=%22parallel%22&compound=%5B%7B%22api%22%3A%22SYNO.SurveillanceStation.TaskQueue%22%2C%22method%22%3A%22List%22%2C%22version%22%3A1%2C%22isReading%22%3Afalse%2C%22nonRecMode%22%3Afalse%7D%5D&api=SYNO.Entry.Request&method=request&version=1" "http://' + ip + ':5000/webapi/entry.cgi"', shell=True)
			# Check if need to re-authorized
			if p.find('"code":105') >= 0:
				p = subprocess.call('curl -c cookie' + ip.replace('.', '') + '.txt "http://' + ip + ':5000/webman/login.cgi?username=' + user + '&passwd=' + password + '" > /dev/null 2>&1', shell=True)

		except subprocess.CalledProcessError, e:
			print "Taskqueue Error\n"

def GetMidnightTimeStamp():
	now = int(time.time())
	return now - now % 86400

def EnumIntervalThread(run_event, camera_array, ip, lock):
	while(run_event.is_set()):
		try:
			daystart = GetMidnightTimeStamp()
			resp = subprocess.check_output('curl -s -b cookie' + ip.replace('.', '') + '.txt -d "api=%22SYNO.SurveillanceStation.RecordingPicker%22&content=%5B%7B%22archId%22%3A0%2C%22camGrpId%22%3A0%2C%22camList%22%3A%5B'+ '%2C'.join([str(x) for x in camera_array]) +'%5D%2C%22dsId%22%3A0%2C%22mountId%22%3A0%7D%5D&from='+ str(daystart) +'&method=%22EnumInterval%22&recording=true&to='+ str(daystart + 86400) +'&version=1" "http://' + ip + ':5000/webapi/entry.cgi"', shell=True)
			json_data = json.loads(resp)
			lock.acquire()
			for caminfo in json_data['data']['cameras'][0]:
				event_data[caminfo['camera_id']] = caminfo['event']
			lock.release()
		except subprocess.CalledProcessError, e:
			print "RecordingPicker Error\n"

		time.sleep(60)


def CompoundThread(run_event, ip):
	while(run_event.is_set()):
		time.sleep(60)
		p = subprocess.call('curl -b cookie' + ip.replace('.', '') + '.txt -d "stop_when_error=false&mode=%22parallel%22&compound=%5B%7B%22api%22%3A%22SYNO.Entry.Request%22%2C%22method%22%3A%22request%22%2C%22version%22%3A1%2C%22compound%22%3A%5B%7B%22api%22%3A%22SYNO.SurveillanceStation.License%22%2C%22method%22%3A%22Load%22%2C%22version%22%3A1%2C%22num_only%22%3A1%7D%2C%7B%22api%22%3A%22SYNO.SurveillanceStation.CMS%22%2C%22method%22%3A%22GetInfo%22%2C%22version%22%3A1%2C%22isPolling%22%3Atrue%7D%5D%7D%5D&api=SYNO.Entry.Request&method=request&version=1" "http://' + ip + ':5000/webapi/entry.cgi" > /dev/null 2>&1', shell=True)

def CheckAddOnUpdateThread(run_event, ip):
	while(run_event.is_set()):
		time.sleep(3600)
		p = subprocess.call('curl -b cookie' + ip.replace('.', '') + '.txt -d "stop_when_error=false&mode=%22parallel%22&compound=%5B%7B%22api%22%3A%22SYNO.SurveillanceStation.AddOns%22%2C%22method%22%3A%22GetUpdateInfo%22%2C%22version%22%3A2%2C%22blRefresh%22%3Afalse%7D%5D&api=SYNO.Entry.Request&method=request&version=1" "http://' + ip + ':5000/webapi/entry.cgi" > /dev/null 2>&1', shell=True)

def CameraStatusThread(run_event, ip, camera_array):
	camera_list = '"'
	for camid in camera_array:
		if camid == camera_array[-1]:
			camera_list = camera_list + str(camid) + '"'
		else:
			camera_list = camera_list + str(camid) + ','
	import urllib
	webapi = '"http://' + ip + ':5000/webapi/entry.cgi?api=SYNO.SurveillanceStation.Camera.Status&version=1&method=Cycle&' + urllib.urlencode({'id_list' : camera_list, 'doorIds' : '""'}) + '&cycle_time=1&includeDeleted=true" > /dev/null 2>&1'
	while(run_event.is_set()):
		p = subprocess.call('curl -b cookie' + ip.replace('.', '') + '.txt ' + webapi, shell=True)

def Simulation(args):
	ip = args.ip
	user = args.username
	passwd = args.password
	offset = args.offset
	limit = args.limit
	SimulationThreads = []
	run_event = threading.Event()
	run_event.set()
	Dir = os.path.dirname(os.path.abspath(__file__))
	lock = threading.Lock()

	try:
		# Login and get cookie
		print "Authorizing " + ip + ", " + user + " / " + passwd
		p = subprocess.call('curl -c cookie' + ip.replace('.', '') + '.txt "http://' + ip + ':5000/webman/login.cgi?username=' + user + '&passwd=' + passwd + '" > /dev/null 2>&1', shell=True)

		# Get camera list
		print "Get camera list"
		camera_array = []
		json_camera_data = []

		while True:
			CurlCam = os.popen('curl -s -b cookie' + ip.replace('.', '') + '.txt "http://' + ip + ':5000/webapi/entry.cgi?api=SYNO.SurveillanceStation.Camera&method=List&version=8&ownerDsId=0&blServerChecked=true&basic=true&start=' + str(offset) + '&limit=' + str(limit) + '"').read()

			if CurlCam.find('"code":105') >= 0:
				print "Get cam list Fail, wait 5 mins."
				time.sleep(300)
			else:
				json_camera_data = json.loads(CurlCam)
				Counter = 0;
				while Counter < len(json_camera_data['data']['cameras']):
					if json_camera_data['data']['cameras'][Counter]['enabled'] == True:
						camera_array.append(json_camera_data['data']['cameras'][Counter]['id'])
					Counter = Counter + 1
				break

		print "  Enabled camera count: " + str(len(camera_array))
		for Counter in range(len(camera_array)):
			print "  " + json_camera_data ['data']['cameras'][Counter]['name'] + ", id = ", camera_array[Counter]
		del json_camera_data

		print "Init threading"

		# Init EnumInterval webapi simulation thread
		thread = threading.Thread(target = EnumIntervalThread, args = (run_event, camera_array, ip, lock))
		thread.start()
		SimulationThreads.append(thread)

		# Init liveview source simulation threads
		for camid in camera_array:
			thread = threading.Thread(target = LiveviewThread, args = (run_event, camid, ip))
			thread.start()
			SimulationThreads.append(thread)
			thread = threading.Thread(target = TimelineThread, args = (run_event, camid, ip, lock))
			thread.start()
			SimulationThreads.append(thread)

		# Init taskqueue simulation thread
		Taskqueue = threading.Thread(target = TaskqueueThread, args = (run_event, ip, user, passwd))
		Taskqueue.start()
		SimulationThreads.append(Taskqueue)

		# Init web UI compound webapi simulation thread
		Compound = threading.Thread(target = CompoundThread, args = (run_event, ip))
		Compound.start()
		SimulationThreads.append(Compound)

		# Init web UI check AddOn update webapi simulation thread
		AddOnUpdate = threading.Thread(target = CheckAddOnUpdateThread, args = (run_event, ip))
		AddOnUpdate.start()
		SimulationThreads.append(AddOnUpdate)

		# Init liveview camera status webapi simulation thread
		CameraStatus = threading.Thread(target = CameraStatusThread, args = (run_event, ip, camera_array))
		CameraStatus.start()
		SimulationThreads.append(CameraStatus)
		time.sleep(5)

		print "Start liveview simulation, use Ctrl + C to exit"
		while True:
			time.sleep(600)
	except KeyboardInterrupt:
		print "\nStop liveview simulation"
		run_event.clear()
		for thread in SimulationThreads:
			thread._Thread__stop()
		# kill child subprocess
		p = subprocess.call('pkill -P ' + str(os.getpid()) + ' > /dev/null 2>&1', shell=True)

#want to add different email setting!
if __name__ == "__main__":
	import sys
	import argparse
	import re

	# autotune.py [-h] [-u USERNAME] [-p PASSWORD] IpPort
	parser = argparse.ArgumentParser()
	parser.add_argument("ip", help = "set ip")
	parser.add_argument("-u", "--username", default = "ss-viewer", help = "set login user name (default = ss-viewer)")
	parser.add_argument("-p", "--password", default = "123456", help = "set login user password (default = 123456)")
	parser.add_argument("-o", "--offset", default = 0, type=int, help = "set camera list offset (default = 0)")
	parser.add_argument("-l", "--limit", default = 0, type=int, help = "set camera list limit (default = 0)")
	args = parser.parse_args()

	# roughly match ip
	try:
		if None == re.match(r'^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$', args.ip):
			raise ValueError()
	except ValueError as e:
		print __file__ + ': error: invaild IpPort: {0}'.format(args.ip)
		sys.exit()

	# Main Simulation
	Simulation(args)
	sys.exit()
