#!/bin/sh

. "$(dirname $0)/define.sh"

print_help()
{
	cat << EOF
Log analytics utilities.
If filename not assigned, default log path ${SZF_DEF_LOG_FILE} will be used.

Usage: $(basename $0) [OPTION] [FILE]
	-r	show all cgi response time
EOF
}

main()
{
	local file_path=""

	if [ -n "$2" ]; then
		file_path="$2"
	else
		file_path="${SZF_DEF_LOG_FILE}"
	fi

	case $1 in
		-h)
			print_help
		;;
		-r)
			if [ ! -f  "${file_path}" ]; then
				echo "Log file ${file_path} not found."
				exit 1
			fi

			cat "${file_path}" | grep "${SZ_CGI_RESP}:" | awk '{ print $3 }'
		;;
		*)
			echo "Invalid input: $1"
			print_help
		;;
	esac
}

main "$@"
