#!/bin/sh

. "$(dirname $0)/define.sh"

#---------------------------- Definitions -------------------------------------
readonly SS_PRIVILEGE="SYNO.SDS.SurveillanceStation"
readonly DEF_CAMERA_MAX=9999
readonly SZK_SS_CAM_MAX="surveillance_camera_max"
readonly SZF_SYNOINFO="/etc.defaults/synoinfo.conf"

#---------------------------- Functions ---------------------------------------
print_help()
{
	cat << EOF
Performance evaluation utilities.

Usage: $(basename $0) [OPTION]
	-h	show this help and exit
	-c	print cpu info
	-m	print memory info
	-a	add user \"${SZ_DEF_USER_NAME}\" as a SS spectator
	-x	set ${SZK_SS_CAM_MAX} to ${DEF_CAMERA_MAX}
EOF
}

main()
{
	case $1 in
		-h)
			print_help
		;;
		-c)
			cat /proc/cpuinfo
		;;
		-m)
			cat /proc/meminfo
		;;
		-a)
			if [[ -z "$(synouser --enum | grep ${SZ_DEF_USER_NAME})" ]]; then
				echo "User ${SZ_DEF_USER_NAME} doesn't exist. Adding."
				synouser --add ${SZ_DEF_USER_NAME} ${SZ_DEF_USER_PASSWD} "" 0 "" ${SS_PRIVILEGE}
			else
				echo "User ${SZ_DEF_USER_NAME} already exists."
			fi
		;;
		-x)
			local camera_max=$(get_key_value ${SZF_SYNOINFO} ${SZK_SS_CAM_MAX})
			if [[ ${DEF_CAMERA_MAX} -gt ${camera_max} ]]; then
				echo "Current camera max is ${camera_max}. Will be enlarged to ${DEF_CAMERA_MAX}."
				sed -i "s/${SZK_SS_CAM_MAX}=.*/${SZK_SS_CAM_MAX}=\"${DEF_CAMERA_MAX}\"/g" ${SZF_SYNOINFO}
			else
				echo "Current camera max is ${camera_max} and large enough."
			fi
		;;
		*)
			echo "Invalid input: $1"
			print_help
		;;
	esac
}

main "$@"
