1. 目的	為加速測試 nvr performance 流程，希望未來測試者只需按照此說明檔設定即可進行觀察，獲得 max Camera 與 total FS 結果

2. 流程
	首次運行，假設欲測試的 DS 上 DSM 與 SS 皆已安裝完成，請遵循以下步驟:
	2.1 將以下檔案複製到 linux 開發機，若僅進行 rtsp 或 virtual cam 其中一種，則只需確保對應檔案有複製過去
		1. maxCamSearch.py   (both)
		2. conf.json         (both)
		3. totalFpsSearch.py (for rtsp)
		4. addRtspCam.py     (for rtsp)
		5. rtspConf.json     (for rtsp)
		6. videoInfo.json    (for rtsp)
		7. addVirtualCam.py  (for virtual cam)
		8. vCamConf.json     (for virtual cam)
		9. liveviewsim.py    (both)
	   10. 02_Tools          (both，存有 SS80.sh 的觀測工具資料夾)
	   11. video_pattern     (for rtsp，存有 rtsp video 的影片資料夾，FPS 與對應檔名已填好在 videoInfo.json 中)
	2.2 在測試的 DS 上進行以下動作
	    1. 建 RAID 5，新增儲存空間，新增共用資料夾
		2. 控制台開啟 ssh 功能
	    3. 至 SS 中加入收 liveview 帳戶及對應密碼( 亦即 ss-viewer )，並設定此帳戶為物件管理者，僅為觀看者會無法跑 liveviewsim.py
	2.3 填妥對應 json 設定檔，其中 rtspConf.json 中的 ['totalFpsSetting']['maxCam'] 可暫時不填 (個別設定檔說明詳見 4.)
	2.4 進行 maxCamSearch.py (詳見 3.1)
	2.5 若是 rtsp camera，填妥 rtspConf.json 中的 ['totalFpsSetting']['maxCam']，可繼續進行 totalFpsSearch.py 以獲得 total FPS (詳見3.2)

3. script 說明
	3.1 maxCamSearch.py
		usage: maxCamSearch.py [-h] -t CAMTYPE [-s SCPENABLE]

		optional arguments:
		-h, --help           								show this help message and exit
		-t CAMTYPE, --camType CAMTYPE                       set camera type (0: rtsp, 1: virtual)
		-s SCPENABLE, --scpEnable SCPENABLE                 only scp monitor file and liveviewsim (0: disable scp, 1: enable scp, default = 0)

		1. 首次進行請加上參數 -s 1，讓 liveviewsim、觀測工具被複製到對應 DS，若 CAMTYPE == 0 時也會將 video file 複製到 rtsp server 上:
			python maxCamSearch.py -t 0 -s 1
		   注意複製的 video 檔案，會以 rtspConf.json 中的 totalFpsSetting 中所指定的 FPS 為範圍複製到 rtsp server 上
		2. 之後開始尋找 max cam 後，便不需要再加上 -s 1 的參數，如下:
			python maxCamSearch.py -t 0
		3. maxCamSearch.py 讀取 conf.json，以 binary search 的方式開始觀測 target DS，並尋找適合的 max camera 的數目
		   根據 CAMTYPE 會呼叫 addRtspCamera.py 或者 addVirutalCam.py 將攝影機加入至測試 DS 中
		4. 在觀測過程中，可 ssh 至測試 DS 中，執行 sskit 觀察 script 是否正常運作，如下列指令:
			/var/packages/SurveillanceStation/target/bin/sskit

	3.2 totalFpsSearch.py
		usage: totalFpsSearch.py [-h] [-s SCPENABLE]

		optional arguments:
		-h, --help           								show this help message and exit
		-s SCPENABLE, --scpEnable SCPENABLE                 set scp enable (0: disable scp, 1: scp enabled, default = 0)

		1. 進行前請先將 3.1 獲得的 max camera 結果填至 rtspConf.json 中的 totalFpsSetting
		2. 這裡也可以加上參數 -s 1，執行的功能與 maxCamSearch 加上 -s 1 是一樣的
		3. totalFpsSearch 目前只能用在 rtsp camera 上，將讀取 conf.json, rtspConf.json, videoInfo.json 中的設定並架起 conf 中 maxCam 數目的 rtsp streams，
		   找到合格狀態下最大的 FPS
		4. 不同 video type 及不同畫質設定下的 total FPS 都會找到結果

	3.3 addRtspCam.py
		usage: addRtspCam.py [-h] [-n STREAMNUM] [-t VIDEOTYPEIDX] [-r VIDEORESO] [-f VIDEOFPS] [-s SCPENABLE]

		optional arguments:
		-h, --help           								show this help message and exit
		-n STREAMNUM, --streamNum STREAMNUM 				set stream number (default = 0)
		-t VIDEOTYPEIDX, --videoTypeIdx VIDEOTYPEIDX 		set video type (0 for h.264, 1 for mjpeg, default = 0)
		-r VIDEORESO, --videoReso VIDEORESO 				set video resolution (720P, 1080P, 3M, 5M, default = 720P)
		-f VIDEOFPS, --videoFps VIDEOFPS                    set video Fps bewteen min and max FPS in rtspConf (default = 30)
		-s SCPENABLE, --scpEnable SCPENABLE 				only scp video file (default = 0)

		若有僅需要加入 rtsp camera 而不想要跑 maxCam 或 totalFps 時，才需要直接呼叫此 script
		其中 -n 後面所加數目的攝影機會加入到 target DS 上，並將 rtsp server 架在 rtspConf.json 中的設定
		video source 則是根據參數中的 videoTypeIdx, videoReso 與 videoFps 來選擇對應之影片
		注意這裡的 videoReso 必須在 720P, 1080P, 3M, 5M 其中選擇，FPS 必須落在則是在 rtspConf.json 中 totalFpsSetting 的 minFPS - FPS 之間

	3.4 addVirtualCam.py
		usage: addVirtualCam.py [-h] -n STREAMNUM

		optional arguments:
		-h, --help     								        show this help message and exit
		-n STREAMNUM, --streamNum STREAMNUM                 set stream number

		若有僅需要加入 rtsp camera 而不想要跑 maxCam 時，才需要直接呼叫此 script
		其中 -n 後面所加數目的攝影機會加入到 target DS 上，根據 vCamConf.json 中的 virtual camera server 架起

4. 設定檔說明

	4.1 conf.json

		- viewerDs                  運行 live view script 的 DS，可自由增減
		- path 					    liveviewsim.py 所欲複製到的的路徑
		- liveviewSimFileName       發送 live view webapi 的 script 名稱 (亦即 liveviewsim.py)
		- liveviewSimAccount        在進行測試的 DS 上，接收 live view 的使用者帳戶名稱
		- liveviewSimPassword       在進行測試的 DS 上，接收 live view 的使用者帳戶密碼

		- targetDs                  進行測試的 DS 資訊
		- path                      觀測工具資料夾所欲複製到的路徑
		- localHost
		- username				    在 linux 開發機上的帳戶，進行完實驗的 nvr_performance.log 會被存到 /home/$username
		- liveviewSimFilePath       在 linux 開發機上，liveviewSim.py 檔案的路徑
		- monitorDirPath	        在 linux 開發機上，包含SS80等一系列觀測工具的資料夾路徑
		- monitorDirName	        在 linux 開發機上，包含SS80等一系列觀測工具的資料夾名稱 (亦即 02_Tools)

		- maxCamSearch
			- streamLowerBound, streamUpperBound  運行 maxCamSearch.py 時，測試者可調整 binary search 攝影機數目上下界

		- monitorFileName           monitor 檔案名稱 (亦即 SS80.sh)
		- monitorParams
			- monitorStartAfterHr   設定一段時間，經過此時間後假設狀態穩定，開始進行觀測
			- monitorPeriodHr       設定總觀測時間長度
			- monitorCheckFreqHr    設定在觀測時間中，週期性檢查目前的結果是否符合預期
			- acceptRatio			設定合格比例
			ex: monitorStartAfterHr = 0.25, monitorPeriodHr = 24, monitorCheckFreqHr = 1, acceptRatio = 90%
			亦即，15 分鐘後開始進行 24 小時的觀測，當中每小時檢查是否合格，當 SS80 回傳的事件合格比率在 90% 以下則認定不通過

		- testingCondition: 欲進行觀測的項目，使用者可自行增減，預設下為符合測試要求，需要使用者修改 memory 需求 (主記憶體 * 0.75)

	4.2 rtspConf.json

		- rtspServer                作為 rtspServer 的 DS 資訊，可自由增減
			- streamPerCamera       代表一台 rtsp camera 會在 target DS 上架設多少個串流
		- rtspCamSetting            預設不需修改
		- targetDs                  進行測試的 DS 資訊
		- localHost                 在 linux 開發機上，應該複製 video file 作為 rtsp video source
			- videoDirPath          在 linux 開發機上，欲複製至 rtsp server 的 video file 所在的資料夾路徑
			- videoDirName          在 linux 開發機上，欲複製至 rtsp server 的 video file 所在的資料夾名稱
		- streamSetting
			- recordingKeepSize     target DS 上的串流儲存空間限制為 1G，為標準 nvr performance 測試之設定，請勿修改
			- recordTime            target DS 上的串流每 5 分鐘儲存一次，為標準 nvr performance 測試之設定，請勿修改
		- totalFpsSetting
			- maxCam                須填入 maxCamSearch.py 的結果
			- FpsBound              進行 totalFpsSearch.py 時，各項畫質設定下的 FPS bound，下限為 minFPS, 上限為FPS
									模擬將由此處所指定的 FPS 作為上限，若不成功則遞減進行測試，直到測試完 minFPS 為止

	4.3 videoInfo.json
		- 在 rtspConf.json 的設定中，記載 localHost 中的 videoDir 中所包含的 rtsp video 的解析度、FPS、filename等設定
		- 若影片名稱與 FPS 對應有修改才需要更動，預設不需修改

	4.4 vCamConf.json
		- virtualCam				virtual camera server 對應資訊，可自由增減
		- targetDs                  進行測試的 DS 資訊

5. 範例流程

	5.1 max camera (rtsp)

		修改 rtspConf.json
		- ['rtspServer']['data']                             rtsp server 帳號, 密碼, ip 與放置 video file 之路徑，可增減數目
		- ['targetDs']                                       進行測試之 NAS 帳號, 密碼, ip
		- ['localHost']                                      linux 機器上放置 video file 之資料夾路徑
		- ['totalFpsSetting']['FpsBound']                    欲進行複製的 rtsp video file

		修改 conf.json
		- ['viewerDs']['data']								 接收即時串流之 NAS 帳號,密碼, ip 與複製後 liveviewsim.py 存放路徑，可增減數目
		- ['targetDs']                                       進行測試之 NAS 帳號, 密碼, ip 與複製後 monitor 資料夾存放路徑
		- ['localHost']										 linux 機器上之使用者名稱，liveviesim.py 路徑與 monitor 資料夾路徑與名稱
		- ['maxCamSearch']									 欲進行搜尋之 max camera 數目上下限
		- ['monitorParams']									 進行觀測的時間長度與規則設定

		執行 script
		$ ./maxCamSearch.py -t 0 -s 1						 scp video file, liveviewsim.py and monitor file

		$ ./maxCamSearch.py -t 0							 find max cameras

    5.2 total FPS

		修改 rtspConf.json
		- ['totalFpsSetting']['maxCam']						 將 max camera 數目填入

		執行 script
		$ ./totalFpsSearch.py								 <== find total FPS

	5.3 [Optional] Add rtsp camera

		$ ./addRtspCam.py -n 100 -t 0 -r 1080P -f 27		 <== add 100 rtsp cameras with H.264, 1080P and FPS 27

	5.4 [Optional] Add virtual camera

		$ ./addVirtualCam.py -n 100						     <== add 100 virtual cameras
