#!/usr/bin/python

gblCamNumDisableDetection = 10
gblErrorFlag = False
gblRtspCamIdx = 0
gblVideoType = ""
VIDEO_TYPE_TO_CODEC = {"H.264": 3, "H.265": 6, "MJPEG": 1}
EVENT_DETECTION_RETRY_TIMES = 3

import sys
import time
import subprocess
import threading
import json
import os
import pexpect
import urllib
import argparse

from nvrTestUtils import *

def EnableRtspServerSSHRootLogin(config):
    print "Enable rtsp servers direct ssh via ip ..."

    for server in config['rtspServer']['data']:
        EnableSSHRootLogin(server['ip'], server['username'], server['password'])

def ScpVideoFileToRtspServer(config, configVideo):
    print "Scp video files ..."

    for server in config['rtspServer']['data']:
        user = server['username']
        passwd = server['password']
        ip = server['ip']
        path = server['path']

        print "Copy video file to rtsp server %s ..." % ip
        for videoType in configVideo['videoType']['data']:

            for resolutionData in config['totalFpsSetting']['FpsBound'][videoType]['data']:
                minFPS = resolutionData['minFPS']
                maxFPS = resolutionData['FPS']
                resolution = resolutionData['resolution']

                for fps in xrange(minFPS, maxFPS + 1):
                    fileName = configVideo['rtspVideoFile'][videoType][resolution]['data'][fps - 1]['fileName']
                    scpCmd = 'scp {0} {1}@{2}:{3}/'.format(config['localHost']['videoPath'] + "/" + fileName, user, ip, path)
                    print scpCmd
                    child = pexpect.spawn(scpCmd, logfile = sys.stdout, timeout = None)

                    if False == ScpExpectRoutine(child, passwd):
                        return False
    return True

def AddRtspCam(config, videoName, streamNum, sids, saveEvent):
    streamPerCamera = config['rtspServer']['streamPerCamera']
    AddCamThreadList = []
    cameraNum = GetNumberPerUnit(streamNum, streamPerCamera)
    ratio = GetRatio(config['rtspServer']['ratio'], len(config['rtspServer']['data']))

    print "Start to add rtsp cameras ..."

    try:
        for camIdx in xrange(0, cameraNum):
            thread = threading.Thread(target = AddCamThread, args = (config, camIdx, cameraNum, sids, videoName, ratio, saveEvent))
            thread.start()
            AddCamThreadList.append(thread)

        for thread in AddCamThreadList:
            thread.join()

        if True == gblErrorFlag:
            return False

        return True

    except KeyboardInterrupt:
        print "\nStop adding cameras"
        for thread in AddCamThreadList:
            thread._Thread__stop()

        killCmd = 'pkill -P %s > /dev/null 2>&1' % str(os.getpid())
        subprocess.call(killCmd, shell = True)

def AddCamThread(config, cameraIdx, cameraTotal, sids, videoName, ratio, saveEvent):
    rtspServerNum = len(config['rtspServer']['data'])
    camIp = config['rtspCamSetting']['ip']
    camPort = config['rtspCamSetting']['port']
    camModel = config['rtspCamSetting']['model']
    camVendor = config['rtspCamSetting']['vendor']
    namingPrefix = config['rtspCamSetting']['namingPrefix']
    global gblErrorFlag, gblVideoType

    serverIdx, serverCamIdx = GetServerAndCameraIdx(cameraIdx, cameraTotal, rtspServerNum, ratio)
    camName = namingPrefix + str(serverIdx) + "_" + str(serverCamIdx)

    disableRecParam = "&disableRec=1" if (1 != saveEvent) else ""

    user = config['rtspServer']['data'][serverIdx]['username']
    passwd = config['rtspServer']['data'][serverIdx]['password']
    ip = config['rtspServer']['data'][serverIdx]['ip']
    path = config['rtspServer']['data'][serverIdx]['path'] + '/' + videoName
    videoCodec = VIDEO_TYPE_TO_CODEC[gblVideoType]

    addCmd = ('curl -s -b cookie{0}.txt '
    '"http://{1}:5000/webapi/entry.cgi?api=SYNO.SurveillanceStation.Camera&method=%22Save%22&version=9'
    '&newName={2}'
    '&vendor={3}'
    '&model={4}'
    '&ip=%22{5}%22'
    '&port={6}'
    '&videoCodec={7}'
    '&rtspPathTimeout=1'
    '&userDefinePath=file%3A/{8}'
    '{9}'
    '&userName=root&password=password&_sid={10}"'
    .format(ip.replace('.',''), ip, camName, camVendor, camModel, camIp, str(camPort), str(videoCodec), path, disableRecParam, sids[serverIdx]))

    curlAddCam = os.popen(addCmd).read()

    if 0 <= curlAddCam.find('error'):
        gblErrorFlag = True

        if 0 <= curlAddCam.find('420'):
            print "Camera name repetition with %s" % camName
        else:
            print "Add camera failed with the following API response."
            print curlAddCam

def GetServerAndCameraIdx(cameraIdx, cameraTotal, serverNum, ratio):
    ratioIdx = 0
    serverIdx = 0
    accRatio = 0
    tmpIdx = cameraIdx
    totalRatio = sum(ratio)
    cameraNumPerRatio = GetNumberPerUnit(cameraTotal, totalRatio)

    while ratioIdx < totalRatio and (ratioIdx + 1) * cameraNumPerRatio <= cameraIdx:
        ratioIdx += 1

    accRatio = ratio[serverIdx]
    while ratioIdx + 1 > accRatio:
        tmpIdx -= ratio[serverIdx] * cameraNumPerRatio
        serverIdx += 1
        accRatio += ratio[serverIdx]

    return serverIdx, tmpIdx

def AddStreamOnTargetDs(config, streamNum, targetDsSid, rtspSids):
    rtspServerNum = len(config['rtspServer']['data'])
    streamPerCamera = config['rtspServer']['streamPerCamera']
    namingPrefix = config['rtspCamSetting']['namingPrefix']
    SimulationThreads = []
    FinishCamIds = []
    jsonData = []
    disableEventDetectCount = 0
    addCams = 0
    blLastCamera = False
    global gblErrorFlag

    lastCameraStreamNum = GetLastRtspStreamNum(streamNum, streamPerCamera, rtspServerNum)
    print "Start to add rtsp streamings on target DS ... "
    print "(Wait and disable event detection every " + str(gblCamNumDisableDetection) + " cameras)"

    try:
        for serverIdx in xrange(0, rtspServerNum):
            ip = config['rtspServer']['data'][serverIdx]['ip']
            sid = rtspSids[serverIdx]
            res, jsonData = GetCameraListOnDs(ip, sid)

            if False == res:
                break

            for cameraIdx in xrange(0, len(jsonData['data']['cameras'])):
                if True == blLastCamera:
                    break

                if addCams + streamPerCamera >= streamNum:
                    blLastCamera = True

                camId = jsonData['data']['cameras'][cameraIdx]['id']
                camName = jsonData['data']['cameras'][cameraIdx]['newName']

                if 0 > camName.find(namingPrefix):
                    continue

                if (True != blLastCamera):
                    thread = threading.Thread(target = AddRtspStreamThread, args = (config, serverIdx, camId, streamPerCamera, targetDsSid))
                    addCams += streamPerCamera
                else:
                    thread = threading.Thread(target = AddRtspStreamThread, args = (config, serverIdx, camId, lastCameraStreamNum, targetDsSid))
                    addCams += lastCameraStreamNum

                thread.start()
                SimulationThreads.append(thread)

                if gblCamNumDisableDetection * (disableEventDetectCount + 1) <= addCams or True == blLastCamera:
                    disableEventDetectCount += 1
                    for thread in SimulationThreads:
                        thread.join()

                    SimulationThreads = []
                    DisableEventDetection(config['targetDs']['ip'], targetDsSid, namingPrefix, False, FinishCamIds)

        if True == gblErrorFlag:
            return False

        return True

    except KeyboardInterrupt:
        print "\nStop adding cameras"
        for thread in SimulationThreads:
            thread._Thread__stop()

        killCmd = 'pkill -P %s > /dev/null 2>&1' % str(os.getpid())
        subprocess.call(killCmd, shell=True)

def GetLastRtspStreamNum(streamTotal, streamPerCam, serverNum):
    cameraNum = GetNumberPerUnit(streamTotal, streamPerCam)
    cameraNumOneServer = GetNumberPerUnit(cameraNum, serverNum)

    lastCamIdx = cameraNum - (cameraNumOneServer * (serverNum - 1)) -1
    lastStreamNum = streamTotal - (cameraNum -1) * streamPerCam

    return lastStreamNum

def AddRtspStreamThread(config, serverIdx, camId, times, sid):
    ip = config['rtspServer']['data'][serverIdx]['ip']
    rtspAccount =  config['rtspServer']['data'][serverIdx]['username']
    rtspPasswd =  config['rtspServer']['data'][serverIdx]['password']
    recordTime = config['streamSetting']['recordTime']
    recordingKeepSize = config['streamSetting']['recordingKeepSize']
    namingPrefix = config['rtspCamSetting']['namingPrefix']
    targetDsIp = config['targetDs']['ip']
    jsonData = []
    global gblErrorFlag, gblRtspCamIdx, gblVideoType

    pathCmd = ('curl -s -b cookie{0}.txt '
    '"http://{1}:5000/webapi/entry.cgi?'
    'cameraIds={2}&api=SYNO.SurveillanceStation.Camera&method=GetStmUrlPath&version=8"'
    .format(ip.replace('.', ''), ip, str(camId)))

    curlRtspPath = os.popen(pathCmd).read()
    jsonData = json.loads(curlRtspPath)

    if False == jsonData['success']:
        print "Get Rtsp camera path failed."
        gblErrorFlag = True
        return

    videoCodec = VIDEO_TYPE_TO_CODEC[gblVideoType]

    if "MJPEG" != gblVideoType:
        # rtspPath = jsonData['data']['pathInfos'][0]['unicastPath']
        # camUser, camPasswd, camPort, userDefinedPath = ReadH264InfoFromRtspPath(rtspPath, rtspAccount, rtspPasswd)
        rtspOverHttpPath = jsonData['data']['pathInfos'][0]['unicastOverHttpPath']
        camUser, camPasswd, camPort, userDefinedPath = ReadH264InfoFromRtspOverHttpPath(rtspOverHttpPath, rtspAccount, rtspPasswd)
    else:
        rtspPath = jsonData['data']['pathInfos'][0]['mjpegHttpPath']
        camUser, camPasswd, camPort, userDefinedPath = ReadMjpegInfoFromRtspPath(rtspPath)

    for addCamCount in xrange(0, times):
        camName = namingPrefix + str(gblRtspCamIdx)
        gblRtspCamIdx += 1
        addCmd = ('curl -s -b cookie{0}.txt '
        '"http://{1}:5000/webapi/entry.cgi?api=SYNO.SurveillanceStation.Camera&method=%22Save%22&version=9'
        '&newName={2}&vendor=User&model=Define'
        '&ip=%22{3}%22'
        '&port={4}'
        '&videoCodec={5}'
        '&rtspPathTimeout=1'
        '&userDefinePath=%22{6}%22'
        '&recordTime={7}'
        '&recordingKeepSize={8}'
        '&preRecordTime=10'
        '&enableAdvCont=true'
        '&userName=%22{9}%22'
        '&password=%22{10}%22'
        '&_sid={11}"'
        .format(targetDsIp.replace('.',''), targetDsIp, camName, ip, camPort, str(videoCodec), userDefinedPath, str(recordTime), str(recordingKeepSize), camUser, camPasswd, sid))

        curlAddCam = os.popen(addCmd).read()

        if 0 <= curlAddCam.find('error'):
            gblErrorFlag = True

            if 0 <= curlAddCam.find('420'):
                print "Camera name repetition with " + camName
            else:
                print "Add camera failed with the following API response"
                print curlAddCam

def ReadH264InfoFromRtspPath(path, account, passwd):
    camUser = ""
    camPasswd = ""
    path = path[path.find(':') + 1:]
    path = path[path.find(':') + 1:]
    port = path[path.find(':') + 1:path.find('/')]
    smsPath = path[path.find('/'):]
    smsPath += "&account=" + account
    smsPath += "&password=" + passwd
    smsPath = urllib.quote(smsPath)

    return camUser, camPasswd, port, smsPath

def ReadH264InfoFromRtspOverHttpPath(path, account, passwd):
    camUser = ""
    camPasswd = ""
    path = path[path.find(':') + 1:]
    path = path[path.find(':') + 1:]
    port = path[0:path.find('/')]
    smsPath = path[path.find('/'):]
    smsPath += "&account=" + account
    smsPath += "&password=" + passwd
    smsPath = urllib.quote(smsPath)

    return camUser, camPasswd, port, smsPath

def ReadMjpegInfoFromRtspPath(path):
    camPort = '5000'
    camUser = 'root'
    camPasswd = ''
    userDefinedPath = path[path.find('webapi'):]
    pos = userDefinedPath.find('StmKey')
    userDefinedPath = userDefinedPath[:pos + 7] + '\\"' +  userDefinedPath[pos + 8: len(userDefinedPath)-1] + '\\"'
    userDefinedPath = urllib.quote(userDefinedPath)

    return camUser, camPasswd, camPort, userDefinedPath

def WaitCamConnectedOnRtspServers(config, sids):
    rtspServerNum = len(config['rtspServer']['data'])
    namingPrefix = config['rtspCamSetting']['namingPrefix']
    print "Wait for every rtsp camera to be connected ..."

    for serverIdx in xrange(0, rtspServerNum):
        ip = config['rtspServer']['data'][serverIdx]['ip']
        WaitCamConnected(ip, sids[serverIdx], namingPrefix)

def ClearAllCameraOnRtspServers(config, sids):
    rtspServerNum = len(config['rtspServer']['data'])

    print "Clear all cameras on rtsp servers ..."

    for serverIdx in xrange(0, rtspServerNum):
        ip = config['rtspServer']['data'][serverIdx]['ip']
        if False == ClearAllCameraOnDs(ip, sids[serverIdx]):
            return False

    return True

def DisableEventDetection(ip, sid, namingPrefix, blLastCheck, alreadyDisabled = None):
    WaitCamConnected(ip, sid, namingPrefix)

    res, jsonData = GetCameraListOnDs(ip, sid)

    for camera in jsonData['data']['cameras']:
        camId = camera['id']

        if None != alreadyDisabled and camId in alreadyDisabled:
            continue

        disableEventDetectionCmd = ('curl -s -b cookie{0}.txt '
        '"http://{1}:5000/webapi/entry.cgi?api=SYNO.SurveillanceStation.Camera.Event&method=%22MDParamSave%22&version=1'
        '&camId={2}&source=-1&mode=0'
        '&_sid={3}"'
        .format(ip.replace('.',''), ip, str(camId), sid))

        response = os.popen(disableEventDetectionCmd).read()

        if True == blLastCheck:
            blSucc = False
            retryTimes = 0

            while True != blSucc and retryTimes <= EVENT_DETECTION_RETRY_TIMES:
                response = os.popen(disableEventDetectionCmd).read()
                response = json.loads(response)
                blSucc = response['success']
                retryTimes += 1

            if False == blSucc:
                print "Camera {0} fails to disable event detection".format(camId)

        if None != alreadyDisabled:
            alreadyDisabled.append(camId)

def GetRtspServerSids(config):
    sids = []

    for server in config['rtspServer']['data']:
        user = server['username']
        passwd = server['password']
        ip = server['ip']
        authRes, sid = AuthDsAndGetSid(ip, user, passwd)

        if False == authRes:
            return False, None

        sids.append(sid)

    return True, sids

def DisableEventDetectionOnRtspServers(config, rtspSids):
    rtspServerNum = len(config['rtspServer']['data'])
    namingPrefix = config['rtspCamSetting']['namingPrefix']
    print "Disable event detection on rtsp servers ..."

    for serverIdx in xrange(0, rtspServerNum):
        ip = config['rtspServer']['data'][serverIdx]['ip']
        DisableEventDetection(ip, rtspSids[serverIdx], namingPrefix, True)

def SetRecAndLiveFps(config, fps):
    targetDsIp = config['targetDs']['ip']
    targetDsUser = config['targetDs']['username']
    targetDsPassword = config['targetDs']['password']

    print "Restart SS to set recording and liveview FPS limit ..."
    '''
    sshCmd = "ssh {0}".format(targetDsIp)
    scriptCmd = "/var/packages/SurveillanceStation/target/bin/sscamera -l"
    child = pexpect.spawn(sshCmd, logfile = None, timeout = None)
    SSHLoginToSUAndRunScript(child, scriptCmd, "", targetDsPassword, False)

    responseLines = child.before.split('\n')
    camIds = responseLines[1].split()

    script = "/var/packages/SurveillanceStation/target/bin/sscamera "
    print "Editing rec and live fps ..."
    for camIdStr in camIds:
        scriptCmd =  script + "-s {0} 'live_fps={1}' -s {0} 'rec_fps={1}' ".format(camIdStr, str(fps))
        child.send(scriptCmd + '\n')
        child.expect("root@.*#")

    child.close(force = True)
    '''

    sshCmd = "ssh {0}@{1}".format(targetDsUser, targetDsIp)
    scriptCmd = "/usr/syno/bin/synopkg stop SurveillanceStation"
    child = pexpect.spawn(sshCmd, logfile = None, timeout = None)
    SSHLoginToSUAndRunScript(child, scriptCmd, "", targetDsPassword, False)

    scriptCmd = "sqlite3 /var/packages/SurveillanceStation/target/system.db 'update camera set fps={0}, fps_2={0}, live_fps={0}'".format(str(fps))
    child.send(scriptCmd + '\n')
    child.expect("root@.*#")

    # Force to clean up tmp files
    print "Force to clean up tmp files..."
    scriptCmd = "rm -rf /volume1/surveillance/@eaDir/@tmp/surveillance/"
    child.send(scriptCmd + '\n')
    child.expect("root@.*#")

    scriptCmd = "/usr/syno/bin/synopkg start SurveillanceStation"
    child.send(scriptCmd + '\n')
    child.expect("root@.*#")

    child.close(force = True)

def SetArgs():
    parser = argparse.ArgumentParser()
    parser.add_argument("-n", "--streamNum", default = 0, type = int, help = "set stream number (default = 0)")
    parser.add_argument("-t", "--videoTypeIdx", default = 0, type = int, help = "set video type (0 for h.264, 1 for mjpeg, 2 for h.265, default = 0)")
    parser.add_argument("-r", "--videoReso", default = "720P",  type = str, help = "set video resolution (720P, 1080P, 3M, 5M, 4K, default = 720P)")
    parser.add_argument("-f", "--videoFps", default = 30, type = int, help = "set video FPS bewteen min and max FPS in rtspConf[totalFpsSetting] (default = 30)")
    parser.add_argument("-s", "--scpEnable", default = 0, type = int, help = "only scp video file (default = 0)")
    parser.add_argument("-a", "--addCamera", default = 0, type = int, help = "only add camera on rtsp servers (default = 0)")
    parser.add_argument("-e", "--saveEvent", default = 0, type = int, help = "cameras save recording event (default = 0)")

    return parser.parse_args()

def FetchConfig():
    with open('rtspConf.json') as jsonData:
        config = json.load(jsonData)

    with open('videoInfo.json') as jsonData:
        configVideo = json.load(jsonData)

    return config, configVideo

def AssertSetting(config, configVideo, args):
    assert 0 < args.streamNum
    assert args.videoTypeIdx < len(configVideo['videoType']['data'])
    assert args.videoReso in configVideo['videoReso']['data']

    videoType = configVideo['videoType']['data'][args.videoTypeIdx]

    for resoIdx in xrange(0, len(config['totalFpsSetting']['FpsBound'][videoType]['data'])):
        if (args.videoReso == config['totalFpsSetting']['FpsBound'][videoType]['data'][resoIdx]['resolution']):
            minFPS = config['totalFpsSetting']['FpsBound'][videoType]['data'][resoIdx]['minFPS']
            maxFPS = config['totalFpsSetting']['FpsBound'][videoType]['data'][resoIdx]['FPS']
            assert args.videoFps >= minFPS, "Test FPS is lower than minimum FPS in rtspConf.json"
            assert args.videoFps <= maxFPS, "Test FPS is higher than maximum FPS in rtspConf.json"

def AddOnRtspServers(config, rtspSids, streamNum, videoName, saveEvent):
    if False == ClearAllCameraOnRtspServers(config, rtspSids):
        print "Clear rtsp cameras failed."
        sys.exit(1)

    if False == AddRtspCam(config, videoName, streamNum, rtspSids, saveEvent):
        print "Adding rtsp cameras failed."
        sys.exit(1)

    DisableEventDetectionOnRtspServers(config, rtspSids)
    print "Adding cameras on rtsp servers finished."

def AddOnTargetDs(config, targetDsSid, rtspSids, streamNum, videoFps):
    if False == ClearAllCameraOnTargetDs(config, targetDsSid):
        print "Clear target Ds cameras failed."
        sys.exit(1)

    if False == AddStreamOnTargetDs(config, streamNum, targetDsSid, rtspSids):
        print "Adding camera on target Ds failed."
        sys.exit(1)

    SetRecAndLiveFps(config, videoFps)

    DisableEventDetection(config['targetDs']['ip'], targetDsSid, config['rtspCamSetting']['namingPrefix'], True)

    if True == IsAllCamConnected(config['targetDs']['ip'], targetDsSid, config['rtspCamSetting']['namingPrefix']):
        print "All cameras are connected."

if __name__ == "__main__":
    args = SetArgs()
    config, configVideo = FetchConfig()
    gblVideoType = configVideo['videoType']['data'][args.videoTypeIdx]

    if 1 == args.scpEnable:
        if False == ScpVideoFileToRtspServer(config, configVideo):
            sys.exit(1)
        sys.exit()

    AssertSetting(config, configVideo, args)
    streamNum = args.streamNum
    videoType = configVideo['videoType']['data'][args.videoTypeIdx]
    videoName = configVideo['rtspVideoFile'][videoType][args.videoReso]['data'][args.videoFps - 1]['fileName']
    videoFps = configVideo['rtspVideoFile'][videoType][args.videoReso]['data'][args.videoFps - 1]['FPS']

    resRtsp, rtspSids = GetRtspServerSids(config)
    if False == resRtsp:
        print "Getting sid failed. Exit."
        sys.exit(1)

    AddOnRtspServers(config, rtspSids, streamNum, videoName, args.saveEvent)

    if 1 == args.addCamera:
        sys.exit()

    resTarget, targetDsSid = GetTargetDsSid(config)
    if False == resTarget:
        print "Getting sid failed. Exit."
        sys.exit(1)

    AddOnTargetDs(config, targetDsSid, rtspSids, streamNum, videoFps)

    sys.exit()
