#!/usr/bin/python

gblErrorFlag = False

import time
import subprocess
import threading
import json
import os
from nvrTestUtils import *

def AddCamThread(config, streamIdx, streamNum, sid):
    targetDsIp = config['targetDs']['ip']
    camHostNum = len(config['virtualCam']['data'])
    recordingKeepSize = config['streamSetting']['recordingKeepSize']
    recordTime = config['streamSetting']['recordTime']
    resolution = config['streamSetting']['resolution']
    fps = config['streamSetting']['fps']
    global gblErrorFlag

    if 0 == (streamNum % camHostNum):
        streamNumOneServer = streamNum / camHostNum
    else:
        streamNumOneServer = (streamNum / camHostNum) + 1

    serverIdx = 0

    while ((serverIdx + 1)*streamNumOneServer <= streamIdx and (serverIdx + 1)  < camHostNum):
        serverIdx += 1

    camIp = config['virtualCam']['data'][serverIdx]['ip']
    camPort = config['virtualCam']['data'][serverIdx]['port']
    camId = streamIdx - (serverIdx * streamNumOneServer)
    camName = config['virtualCam']['namingPrefix'] + str(serverIdx) + "_" + str(camId)

    addCmd = ('curl -s -b cookie{0}.txt '
    '"http://{1}:5000/webapi/entry.cgi?api=SYNO.SurveillanceStation.Camera&method=%22Save%22&version=9'
    '&newName={2}&vendor=AXIS&model=%22Virtual%20Camera%22'
    '&ip=%22{3}%22'
    '&port={4}'
    '&recordingKeepSize={5}'
    '&recordTime={6}'
    '&Stream1=%7B%22resolution%22%3A%22{7}%22,%22fps%22%3A{8}%7D'
    '&userName=root&password=password&_sid={9}"'
    .format(targetDsIp.replace('.',''), targetDsIp, camName, camIp, str(camPort), str(recordingKeepSize), str(recordTime), resolution, str(fps), sid))

    curlAddCam = os.popen(addCmd).read()

    if 0 <= curlAddCam.find('error'):
        if 0 <= curlAddCam.find('420'):
            print "Camera name repetition with %s. Break." % camName
        else:
            print "Add camera failed with the following API response"
            print curlAddCam

        gblErrorFlag = True
        return

def Simulation(config, streamNum, sid):
    SimulationThreads = []
    global gblErrorFlag
    print "Start to add cameras ..."

    try:
        for streamIdx in xrange(0, streamNum):
            thread = threading.Thread(target = AddCamThread, args = (config, streamIdx, streamNum, sid))
            thread.start()
            SimulationThreads.append(thread)

        for thread in SimulationThreads:
            thread.join()

        if gblErrorFlag == True:
            return False
        return True

    except KeyboardInterrupt:
        print "\nStop adding cameras"
        for thread in SimulationThreads:
            thread._Thread__stop()
        killCmd = 'pKill -P %s > /dev/null 2>&1' % str(os.getpid())
        p = subprocess.call(killCmd, shell=True)

if __name__ == "__main__":
    import sys
    import argparse

    parser = argparse.ArgumentParser()
    parser.add_argument("-n", "--streamNum", type = int, help = "set stream number", required = True)
    args = parser.parse_args()
    streamNum = args.streamNum

    with open('vCamConf.json') as jsonData:
        config = json.load(jsonData)

    res, sid = GetTargetDsSid(config)
    if False == res:
        print "Getting sid failed. Exit."
        sys.exit(1)

    if False == ClearAllCameraOnTargetDs(config, sid):
        print "Clear cameras failed."
        sys.exit(1)

    if False == Simulation(config, streamNum, sid):
        print "Add virtual cams failed."
        sys.exit(1)

    WaitCamConnectedOnTargetDs(config, sid,config['virtualCam']['namingPrefix'])

    sys.exit()
