#!/usr/bin/python

gblSignal = False
RTSP_CAM_TYPE = 0

import time
import subprocess
import threading
import json
import os
import pexpect
import time
import sys
import argparse

from nvrTestUtils import *

def RunAddCamScript(streamNum, camType):
    if RTSP_CAM_TYPE == camType:
        script = "addRtspCam.py"
    else:
        script = "addVirtualCam.py"

    scriptCmd = "python %s -n %s" % (script, str(streamNum))

    return ShowAndWaitCommand(scriptCmd)

def binarySearchMaxCam(config, camType):
    initSuccess = False
    streamLower = config['maxCamSearch']['streamLowerBound']
    streamUpper = config['maxCamSearch']['streamUpperBound']

    while (streamLower <= streamUpper):
        streamMid = (streamLower + streamUpper) / 2
        print "Start to add cameras ..."
        res = RunAddCamScript(streamMid, camType)

        if False == res:
            print "Add camera failed. Check add camera script."
            sys.exit(1)

        logName = "nvr_performance_maxCam_%s.log" % str(streamMid)
        monitorResult, condValList = Simulation(config, streamMid, logName)

        if True == GetSignalStatus():
            break

        if True == monitorResult:
            streamLower = streamMid + 1
            print "======= Simulation with %s streams succeeds ========\n" % str(streamMid)
            if False == initSuccess:
                initSuccess = True
        else:
            print "======= Simulation with %s streams fails ========\n" % str(streamMid)
            streamUpper = streamMid - 1

    if True == GetSignalStatus():
        print "Ctrl-C was triggered. Exit."
    elif False == initSuccess:
        print "Not exists"
    else:
        print "Max camera: %s" % str(streamLower - 1)

if __name__ == "__main__":
    with open('conf.json') as json_data:
        config = json.load(json_data)

    parser = argparse.ArgumentParser()
    parser.add_argument("-t", "--camType", type = int, help = "set camera type (0: rtsp, 1: virtual)", required = True)
    parser.add_argument("-s", "--scpEnable", default = 0, type = int, help = "only scp monitor file and liveviewsim (0: disable scp, 1: enable scp, default = 0)")
    args = parser.parse_args()

    camType = args.camType
    scpEnable = args.scpEnable

    EnableTargetDsSSHRootLogin(config)
    EnableViewerSSHRootLogin(config)

    EditMaxCameraConf(config)

    if True == scpEnable:
        res = AddAccountAndScpFile(config)

        if False == res:
            sys.exit(1)

        if RTSP_CAM_TYPE == camType:
            res = RunScpRtspVideoDirCommand()
            if False == res:
                sys.exit(1)

        sys.exit()

    binarySearchMaxCam(config, camType)

    sys.exit()
