#!/usr/bin/python

import time
import subprocess
import threading
import json
import os
import pexpect
import sys
import time
import argparse

from nvrTestUtils import *

def RunAddRtspCamScript(streamNum, typeIdx, videoReso, fpsIdx):
    scriptCmd = "python addRtspCam.py -n %s -t %s -r %s -f %s" % (str(streamNum), str(typeIdx), videoReso, str(fpsIdx))

    return ShowAndWaitCommand(scriptCmd)

def FindNextFpsSetting(videoConfig, videoType, videoReso, currentFps, minFps):
    count = len(videoConfig['rtspVideoFile'][videoType][videoReso]['data'])

    for fpsIdx in xrange(count - 1, minFps - 2, -1):
        targetFps = videoConfig['rtspVideoFile'][videoType][videoReso]['data'][fpsIdx]['FPS']
        if targetFps <= currentFps:
            return True, fpsIdx

    return False, None

def GetTotalFps(config, videoConfig, rtspConfig):
    typeCount = len(videoConfig['videoType']['data'])
    resultCamFpsMap = {}
    resultCondMap = {}

    try:
        for typeIdx in xrange(0, typeCount):
            videoType = videoConfig['videoType']['data'][typeIdx]
            resultCamFpsMap[videoType] = {}
            resultCondMap[videoType] = {}

            if videoType not in rtspConfig['totalFpsSetting']['FpsBound']:
                continue

            for resolutionItem in rtspConfig['totalFpsSetting']['FpsBound'][videoType]['data']:
                currentFps = resolutionItem['FPS']
                minFps = max(resolutionItem['minFPS'], 10)
                resolution = resolutionItem['resolution']
                currentCam = rtspConfig['totalFpsSetting']['maxCam']
                blEnterFps10 = False

                # H. 264, 720P has already been performed in maxCamSearch.py
                if "H.264" == videoType and "720P" == resolution:
                    continue

                if "MJPEG" == videoType and "4K" == resolution:
                    continue

                while True:
                    if False == blEnterFps10:
                        res, fpsIdx = FindNextFpsSetting(videoConfig, videoType, resolution, currentFps, minFps)
                    else:
                        currentCam -= 1
                        res = (0 < currentCam)

                    if False == res:   # searching ends with no success record
                        resultCamFpsMap[videoType][resolution] = None
                        resultCondMap[videoType][resolution] = None
                        break

                    currentFps = videoConfig['rtspVideoFile'][videoType][resolution]['data'][fpsIdx]['FPS']

                    if 10 == currentFps and False == blEnterFps10:
                        blEnterFps10 = True
                        currentCam = resolutionItem['CHtoDecreaseFromWhenFps10'] \
                                     if ('CHtoDecreaseFromWhenFps10' in resolutionItem ) \
                                     else rtspConfig['totalFpsSetting']['maxCam']

                    simRes = AddCameraAndRunSimulation(resultCamFpsMap, resultCondMap, config, currentCam, currentFps, \
                                                        videoType, typeIdx, resolution)
                    if -1 == simRes:   # error happens
                        return resultCamFpsMap, resultCondMap
                    elif 1 == simRes:  # result found
                        break
                    else:
                        currentFps -= 1

        return resultCamFpsMap, resultCondMap

    except KeyboardInterrupt:
        resultCamFpsMap[videoType][resolution] = None
        resultCondMap[videoType][resolution] = None
        return resultCamFpsMap, resultCondMap

def AddCameraAndRunSimulation(camFpsMap, condMap, config, currentCam, currentFps, videoType, typeIdx, resolution):
    res = RunAddRtspCamScript(currentCam, typeIdx, resolution, currentFps)
    if False == res:
        print "Add camera failed. Check add camera script."
        return -1

    print "======== current run: resolution %s FPS %d Camera %d =======" % (resolution, currentFps, currentCam)
    logName = "nvr_performance_totalFps_{0}_{1}_{2}_{3}.log".format(videoType, resolution, currentFps, currentCam)
    monitorResult, condValList = Simulation(config, currentCam, logName)

    if True == GetSignalStatus():
        print "Searching total fps failed."
        return -1

    if True == monitorResult:
        print "======== %s %s with FPS %d Camera %d is passed ========" %(videoType, resolution, currentFps, currentCam)
        camFpsMap[videoType][resolution] = (currentCam, currentFps)
        condMap[videoType][resolution] = condValList
        return 1

    return 0

def PrintResult(config, videoConfig, fpsMap, condMap, maxCam):
    headItem = ["Video type", "Resolution", "cameras", "FPS", "Total FPS", \
                "CPU Avg. %", "Mem %", "Webapi", "Recording", "Liveview"]

    print "\nTotal FPS result"
    for item in headItem:
        print '{0:>12}'.format(item),
    print ''

    for videoType in videoConfig['videoType']['data']:
        if videoType not in fpsMap:
            continue

        for resolutionItem in rtspConfig['totalFpsSetting']['FpsBound'][videoType]['data']:
            resolution = resolutionItem['resolution']
            if resolution not in fpsMap[videoType]:
                continue

            resultCamFps = fpsMap[videoType][resolution]
            if None != resultCamFps:
                camNum = resultCamFps[0]
                fps = resultCamFps[1]
                sys.stdout.write('{0:>12} {1:>12} {2:>12} {3:>12} {4:>12} '.format(videoType, resolution, camNum, fps, camNum * fps))
            else:
                sys.stdout.write('{0:>12} {1:>12} {2:>12} {3:>12} {4:>12} '.format(videoType, resolution, "not found", "not found", "0"))

            if None != condMap[videoType][resolution]:
                for value in condMap[videoType][resolution]:
                    sys.stdout.write('{0:>12} '.format(value))
            print ''

def FetchConfig():
    with open('conf.json') as jsonData:
        config = json.load(jsonData)

    with open('videoInfo.json') as jsonData:
        videoConfig = json.load(jsonData)

    with open('rtspConf.json') as jsonData:
        rtspConfig = json.load(jsonData)

    return config, videoConfig, rtspConfig

if __name__ == "__main__":
    config, videoConfig, rtspConfig = FetchConfig()

    parser = argparse.ArgumentParser()
    parser.add_argument("-s", "--scpEnable", default = 0, type = int, help = "set scp enable (0: disable scp, 1: scp enabled, default = 0)")
    args = parser.parse_args()
    scpEnable = args.scpEnable

    EnableTargetDsSSHRootLogin(config)
    EnableViewerSSHRootLogin(config)
    EditMaxCameraConf(config)

    if True == scpEnable:
        if False == AddAccountAndScpFile(config):
            sys.exit(1)

        if False == RunScpRtspVideoDirCommand():
            sys.exit(1)

        sys.exit()

    camFpsMap, condMap = GetTotalFps(config, videoConfig, rtspConfig)
    PrintResult(config, videoConfig, camFpsMap, condMap, rtspConfig['totalFpsSetting']['maxCam'])

    sys.exit()
