/* Copyright (c) 2018 Synology Inc. All rights reserved. */

Ext.define("SYNO.SS.App.Client.ConnStatusPanel",{extend:"SYNO.ux.Panel",itemId:"SYNO.SS.App.Client.ConnStatusPanel",panelGridContainer:null,btnKill:null,btnUpdate:null,btnSetLayout:null,constructor:function(){this.Init();var a=function(){return(0===this.dsClient.getTotalCount())};this.callParent([{border:false,layout:"fit",title:_T("ss_client","connected_clients"),items:this.panelGridContainer,tbar:new SYNO.ux.Toolbar({items:[this.btnKill,this.btnUpdate,this.btnSetLayout]}),listeners:{activate:this.OnRefresh},emptyStyleMonStore:this.dsClient,emptyStyleTip:_T("ss_client","no_client_found"),fnNeedApplyEmptyStyle:a.createDelegate(this),scope:this}]);this.InitEventHandler()},Init:function(){this.dsClient=new SYNO.API.JsonStore({appWindow:this,api:"SYNO.SurveillanceStation.Info",method:"GetLoginInfo",version:1,root:"loginList",id:"loginId",fields:[{name:"id"},{name:"user"},{name:"ip"},{name:"client_type"},{name:"client_version"},{name:"client_login_time"},{name:"dual_auth_session"}],sortInfo:{field:"id",direction:"ASC"},scope:this});this.btnKill=new SYNO.ux.Button({text:_T("ss_client","kill_conn"),handler:this.OnKill,disabled:true,scope:this});this.btnUpdate=new SYNO.ux.Button({text:_T("ss_client","update_firmware"),handler:this.OnUpdateWin,disabled:true,scope:this});this.btnSetLayout=new SYNO.ux.Button({text:_T("ss_client","config_layout"),handler:this.OpenSetLayoutWin,disabled:true,scope:this});this.columnModel=new Ext.grid.ColumnModel([{sortable:false,align:"center",header:_T("ss_common","common_type"),dataIndex:"client_type",renderer:this.RenderClientType.createDelegate(this)},{sortable:false,dataIndex:"ip",align:"center",header:_T("ss_common","ip"),dataIndex:"ip"},{sortable:false,id:"user",align:"center",header:_T("ss_common","common_user"),dataIndex:"user",renderer:this.RenderClientName.createDelegate(this)},{sortable:false,dataIndex:"client_login_time",align:"center",header:_T("ss_common","time"),renderer:function(a){return SYNO.SS.Grid.GenDateAndTimeStrOnly(a/TRANS_MILLISECOND/TRANS_MILLISECOND,{},undefined,false)}},{sortable:false,dataIndex:"client_version",align:"center",header:_T("ss_common","version")}]);this.gridClientList=new SYNO.SS.Grid.GridPanel({cm:this.columnModel,store:this.dsClient,border:false,autoExpandColumn:"user",viewConfig:{forceFit:true},sm:new Ext.grid.RowSelectionModel({listeners:{selectionchange:function(){this.btnKill.setDisabled(this.IsBtnKillDisabled());this.btnUpdate.setDisabled(this.IsBtnUpdateDisabled());this.btnSetLayout.setDisabled(this.IsBtnSetLayoutDisabled())}.createDelegate(this)}})});this.panelGridContainer=new SYNO.SS.Pgls.PglsGridContainerPanel({grid:this.gridClientList,store:this.dsClient,refreshFunction:this.OnRefresh,refreshFunctionScope:this})},IsBtnKillDisabled:function(){return((SYNO.SS.UserPrivType.ADMIN!==_S("USER_PRIVILEGE"))||(0===this.gridClientList.getSelectionModel().getCount()))},IsBtnSetLayoutDisabled:function(){return((SYNO.SS.UserPrivType.ADMIN!==_S("USER_PRIVILEGE"))||(1!==this.gridClientList.getSelectionModel().getCount())||(false===this.IsSetLayoutAvail(this.gridClientList.getSelectionModel().getSelections()[0])))},IsBtnUpdateDisabled:function(){var a;if(SYNO.SS.UserPrivType.ADMIN!==_S("USER_PRIVILEGE")){return true}if(1!==this.gridClientList.getSelectionModel().getCount()){return true}a=this.gridClientList.getSelectionModel().getSelections()[0];return((SYNO.SS.Client.Type.VS_360!==a.get("client_type"))&&(SYNO.SS.Client.Type.VS_960!==a.get("client_type")))},IsSetLayoutAvail:function(a){var b=a.get("client_type");return !((SYNO.SS.Client.Type.DS_CAM_ANDROID===b)||(SYNO.SS.Client.Type.DS_CAM_IOS===b)||(SYNO.SS.Client.Type.LIVECAM_ANDROID===b)||(SYNO.SS.Client.Type.LIVECAM_IOS===b)||(SYNO.SS.Client.Type.ARCH_TASK===b))},InitEventHandler:function(){this.mon(SYNO.SDS.StatusNotifier,"clientUpdate",function(a){this.dsClient.load()},this)},OpenSetLayoutWin:function(){var a=new SYNO.SS.App.Client.SetLayoutWindow({owner:this.findAppWindow(),store:this.gridClientList.getSelectionModel().getSelections()[0]});a.open()},OnRefresh:function(){this.dsClient.load()},OnKill:function(){if(SYNO.SS.UserPrivType.ADMIN!==_S("USER_PRIVILEGE")){return}var c=this.gridClientList.getSelectionModel();var b=[];var a=false;c.getSelections().each(function(d){if(_S("USER_NAME")===d.get("user")){a=true}b.push(d.get("id"))});if(true===a){this.findAppWindow().getMsgBox().confirm(_T("ss_client","kill_conn"),_T("ss_client","confirm_kick_self"),function(d,e){if(d=="yes"){this.KillConn(b)}},this)}else{this.KillConn(b)}},KillConn:function(a){this.sendWebAPI({api:"SYNO.SurveillanceStation.Info",method:"KillSession",version:1,params:{idList:a.join(","),blKillSameLoginInfoSess:true},callback:this.OnRefresh,scope:this})},RenderClientType:function(c,a,b){return SYNO.SS.App.Client.Utils.GetClientTypeStr(c,b.json.me)},RenderClientName:function(c,a,b){return SYNO.SS.App.Client.Utils.GetClientNameStr(c,b.json.dual_auth_session)},OnUpdateWin:function(){var a=new SYNO.SS.App.Client.UpdateFirmwareWizard({owner:this.findAppWindow(),record:this.gridClientList.getSelectionModel().getSelections()[0]});a.open()}});Ext.define("SYNO.SS.App.Client.SetLayoutWindow",{extend:"SYNO.SDS.ModalWindow",WIDTH:600,HEIGHT:400,SECOND_SCREEN_HEIGHT:520,COMBO_WIDTH:175,FIELD_LABEL_WIDTH:260,cmbIndex:{LAYOUT:0,FULLSCREEN:1,ALERTPANEL:2},screenIndex:{FIRST:0,SECOND:1},firstFieldSet:null,secondFieldSet:null,store:null,itemsArray:null,blSecondScreen:false,constructor:function(a){this.Init(a);Ext.apply(a,{width:this.WIDTH,height:(this.blSecondScreen?this.SECOND_SCREEN_HEIGHT:this.HEIGHT),title:_T("ss_client","config_layout"),padding:"15px 0 0 0",buttons:[{xtype:"syno_button",text:_T("ss_common","common_save"),btnStyle:"blue",handler:this.OnSave,scope:this},{xtype:"syno_button",text:_T("ss_common","close"),handler:this.close,scope:this}],items:this.itemsArray});this.callParent([a]);this.GetUserPrivData()},Init:function(a){this.store=a.store;this.blSecondScreen=((SYNO.SS.Client.Type.VS_360===this.store.get("client_type"))||(SYNO.SS.Client.Type.VS_960===this.store.get("client_type")));this.itemsArray=[];this.itemsArray.push({xtype:"label",cls:"client-set-layout-desc",text:_T("ss_client","remote_config_hint")});this.firstFieldSet=this.CreateFieldSet(this.screenIndex.FIRST);this.itemsArray.push(this.firstFieldSet);if(true===this.blSecondScreen){this.secondFieldSet=this.CreateFieldSet(this.screenIndex.SECOND);this.itemsArray.push(this.secondFieldSet)}},GetUserPrivData:function(){this.setStatusBusy();this.sendWebAPI({api:"SYNO.SurveillanceStation.UserPrivilege",version:1,method:"LoadProfile",params:{user:this.store.get("user"),loadDualAuthProfile:(true===this.store.get("dual_auth_session"))?"true":"false"},callback:function(d,b,c,a){this.clearStatusBusy();if(true===d){this.UpdateLayoutInfo(b)}},scope:this})},UpdateLayoutInfo:function(a){var b=[];a.authLayoutList.each(function(c){if((SYNO.SS.App.User.Def.PrivObj.ALL_LAYOUT===c.type)||(false===c.access)||(LAYOUT_APPTYPE_LIVEVIEW!==c.groupingId)){return}b.push([c.name,c.objId])});if(true===Ext.isEmpty(b)){return}this.firstFieldSet.getComponent(this.cmbIndex.LAYOUT).getStore().loadData(b,true);if(true===this.blSecondScreen){this.secondFieldSet.getComponent(this.cmbIndex.LAYOUT).getStore().loadData(b,true)}},CreateFieldSet:function(f){var e,a,c,b,d;b=[[_T("ss_client","by_current_settings"),SYNO.SS.App.Client.Def.OPTION_DEFAULT],[_T("extlang","yes"),SYNO.SS.App.Client.Def.OPTION_YES],[_T("extlang","no"),SYNO.SS.App.Client.Def.OPTION_NO]];d=[[_T("ss_client","by_current_settings"),SYNO.SS.App.Client.Def.OPTION_DEFAULT]];e=new SYNO.ux.ComboBox({name:"cmb_layout",width:this.COMBO_WIDTH,fieldLabel:_T("visualstation","layout"),forceSelection:true,displayField:"display",valueField:"id",value:SYNO.SS.App.Client.Def.OPTION_DEFAULT,store:{xtype:"arraystore",autoDestroy:true,fields:["display","id"],data:d}});a=new SYNO.ux.ComboBox({name:"cmb_fullscreen",width:this.COMBO_WIDTH,fieldLabel:_T("visualstation","full_screen"),forceSelection:true,displayField:"display",valueField:"value",hidden:SYNO.SS.Client.Type.WEB===this.store.get("client_type"),value:SYNO.SS.App.Client.Def.OPTION_DEFAULT,store:{xtype:"arraystore",autoDestroy:true,fields:["display","value"],data:b}});c=new SYNO.ux.ComboBox({name:"cmb_alertpanel",width:this.COMBO_WIDTH,fieldLabel:_T("desktop","expend_alert_panel"),forceSelection:true,displayField:"display",valueField:"value",value:SYNO.SS.App.Client.Def.OPTION_DEFAULT,store:{xtype:"arraystore",autoDestroy:true,fields:["display","value"],data:b}});return new SYNO.ux.FieldSet({title:String.format(_T("ss_client","monitor"),(f+1)),name:"screen_field",cls:"client-set-layout-cfg-fldset",labelWidth:this.FIELD_LABEL_WIDTH,autoHeight:true,collapsible:true,items:[e,a,c]})},OnSave:function(){var a,b=[];a={monitor:this.screenIndex.FIRST,layoutId:this.firstFieldSet.getComponent(this.cmbIndex.LAYOUT).getValue(),fullscreen:this.firstFieldSet.getComponent(this.cmbIndex.FULLSCREEN).getValue(),alertPanel:this.firstFieldSet.getComponent(this.cmbIndex.ALERTPANEL).getValue()};b.push(a);if(true===this.blSecondScreen){a={monitor:this.screenIndex.SECOND,layoutId:this.secondFieldSet.getComponent(this.cmbIndex.LAYOUT).getValue(),fullscreen:this.secondFieldSet.getComponent(this.cmbIndex.FULLSCREEN).getValue(),alertPanel:this.secondFieldSet.getComponent(this.cmbIndex.ALERTPANEL).getValue()};b.push(a)}this.sendWebAPI({api:"SYNO.SurveillanceStation.Info",method:"SetCurLayout",version:1,params:{connectionId:this.store.get("id"),layoutConf:b},callback:function(){this.close()},scope:this})}});Ext.define("SYNO.SS.App.Client.UpdateFirmwareWizard",{extend:"SYNO.SDS.Wizard.ModalWindow",WIDTH_DEF:720,HEIGHT_DEF:440,pageItemId:{UPLOAD:"upload",PROGRESS:"progress"},blCloseCheck:false,firmwareInfo:null,pollingTask:null,pageUpload:null,pageProgress:null,btnUpload:null,pieChart:null,constructor:function(a){this.InitUI(a);this.callParent([Ext.applyIf(a,{title:_T("ss_client","firmware_update_wizard"),banner:false,width:this.WIDTH_DEF,height:this.HEIGHT_DEF,steps:this.steps,useStatusBar:true,listeners:{beforeclose:this.OnBeforeClose,scope:this}})])},InitUI:function(b){var a={api:"SYNO.SurveillanceStation.VisualStation.Install",version:1,method:"Upload"};if(LOCAL_DS_ID!==b.owner.appDSId){a={api:"SYNO.SurveillanceStation.CMS",method:"RedirectUpload",version:1,params:{dsId:b.owner.appDSId,isUpload:true,blRepackUpload:false,webAPI:a}}}this.btnUpload=new SYNO.ux.FileButton({fieldLabel:_T("ss_client","firmware_location"),buttonText:"",name:"vsFirmware",blBtnOnly:false,textConfig:{width:360,allowBlank:false,validate:function(){if(this.validateValue(this.processValue(this.getRawValue()))){this.clearInvalid();return true}return false}},buttonConfig:{width:32,height:32,btnStyle:"none",iconCls:"btn_upload_icon"}});this.pageUpload=new SYNO.ux.FormPanel({title:_T("ss_client","upload_firmware"),url:this.getBaseURL(a),fileUpload:true,isUpload:true,bwrapStyle:"padding-left: 8px",labelWidth:190,items:[{xtype:"syno_displayfield",fieldLabel:_T("ss_common","model"),value:SYNO.SS.App.Client.Utils.GetClientTypeStr(b.record.get("client_type"),false)},{xtype:"syno_displayfield",fieldLabel:_T("ss_common","ip_address"),value:b.record.get("ip")},{xtype:"syno_displayfield",fieldLabel:_T("visualstation","current_version"),value:b.record.get("client_version")},{xtype:"syno_displayfield",fieldLabel:_T("ss_client","minimum_compatible_version"),value:this.GetLatestCompatibleVersion(b.record.get("client_type"))},this.btnUpload],nextId:this.pageItemId.PROGRESS,itemId:this.pageItemId.UPLOAD,owner:this,getNext:function(){if(true===this.owner.btnUpload.fileTextField.validate()){this.owner.CheckPkg()}return false}});this.pieChart=new SYNO.SDS.Utils.canvas.circlegradient({radius:60,gradientWidth:20,height:120,width:120,canvasConfig:{height:120,width:120},stopColor:"#00AAFF",middleColor:"#00AAFF",startColor:"#00AAFF"});this.pageProgress=new SYNO.ux.FormPanel({title:_T("ss_client","upgrade_vs"),nextId:null,itemId:this.pageItemId.PROGRESS,layout:"fit",items:{xtype:"container",layout:"vbox",layoutConfig:{align:"center"},ctCls:"sm-infocenter-vol",items:[{xtype:"container",height:40},this.pieChart,{xtype:"container",height:60},{xtype:"label",width:"100%",style:"text-align: center",text:_T("ss_client","upgrade_vs_hint")}]}});this.steps=[this.pageUpload,this.pageProgress]},GetLatestCompatibleVersion:function(a){switch(a){case SYNO.SS.Client.Type.VS_360:return _S("SS_VS360HD_LOGIN_MIN_VERSION");case SYNO.SS.Client.Type.VS_960:return _S("SS_VS960HD_MIN_VERSION");default:return"--"}},CheckPkg:function(){var d=this.btnUpload.fileTextField.getValue();var a,b,c;if(null===d.match(/.*\.pat$/)){this.getMsgBox().alert(this.title,_T("visualstation","error_filename_pat"));return}a=this.ParseFileVersion(d);if(false===Ext.isNumber(a)){this.getMsgBox().alert(this.title,_T("visualstation","error_verify_patch"));return}b=this.ParseMinorVersion(this.GetLatestCompatibleVersion(this.record.get("client_type")));if((false===Ext.isNumber(b))||(b>a)){this.getMsgBox().alert(this.title,String.format(_T("ss_client","upload_firmware_incompatible"),"<b>"+a+"</b>"));return}c=this.ParseMinorVersion(this.record.get("client_version"));if((false===Ext.isNumber(c))||(c>a)){this.getMsgBox().confirm(this.title,String.format(_T("ss_client","upgrade_vs_confirm_small_version"),"<b>"+a+"</b>"),function(e){if("yes"===e){this.UploadPkg()}},this);return}this.UploadPkg()},ParseFileVersion:function(c){var a,b;switch(this.record.get("client_type")){case SYNO.SS.Client.Type.VS_360:a="VS360HD";break;case SYNO.SS.Client.Type.VS_960:a="VS960HD";break;default:return NaN}b=c.match(new RegExp("^"+a+"_(\\d+)\\.pat$"));if(true==Ext.isArray(b)){return parseInt(b[1],10)}return NaN},ParseMinorVersion:function(a){var b=a.match(/^\d+\.\d+\.\d+-(\d+)$/);if(true==Ext.isArray(b)){return parseInt(b[1],10)}return NaN},UploadPkg:function(){this.firmwareInfo=null;this.setStatusBarBusy({text:_T("ss_common","uploading")});this.pageUpload.getForm().submit({success:function(a,b){this.clearStatusBusy();this.firmwareInfo=b.result.data.firmwareInfo;this.getMsgBox().confirm("",_T("ss_client","upgrade_vs_start_confirm"),function(c){if("yes"===c){this.StartUpdate()}},this)},failure:function(a,b){this.clearStatusBusy();this.OnApiError(b.result.error)},scope:this})},OnConfirmUpdate:function(){this.blCloseCheck=true;this.pieChart.draw(0);this.goNext(this.pageUpload.nextId,false);this.getButton("next").disable()},StartUpdate:function(){this.sendWebAPI({api:"SYNO.SurveillanceStation.VisualStation.Install",version:1,method:"Start",params:{filePath:this.firmwareInfo.filePath,connectionId:this.record.get("id")},dsId:this.owner.appDSId,appDSId:this.owner.appDSId,callback:function(d,b,c,a){if(false==d){this.OnApiError(b);return}this.OnConfirmUpdate();this.StartPollTask(b.pid)},scope:this})},StartPollTask:function(a){this.pollingTask=new SYNO.SS.WebAPIPollTask({api:"SYNO.SurveillanceStation.VisualStation.Install",version:1,method:"GetProgress",params:{pid:a},dsId:this.owner.appDSId,handler:this.HandleProgressPoll,scope:this});this.pollingTask.StartAutoRefresh(1,false)},HandleProgressPoll:function(a,c,b){if(true===c){this.pieChart.draw(b.progress/100);if(100<=b.progress){this.ProgressComplete()}}else{this.CancelPollTask();this.OnApiError(b)}},ProgressComplete:function(){this.blCloseCheck=false;this.CancelPollTask();this.getButton("next").enable();this.getButton("cancel").disable();this.sendWebAPI({api:"SYNO.SurveillanceStation.VisualStation.Install",version:1,method:"Finish",dsId:this.owner.appDSId,params:{connectionId:this.record.get("id")}});this.firmwareInfo=null},CancelPollTask:function(){if(this.pollingTask){this.pollingTask.StopAutoRefresh();this.pollingTask=null}},OnBeforeClose:function(){if(false===this.blCloseCheck){this.OnConfirmClose();return true}this.getMsgBox().confirm("",_T("ss_client","upgrade_vs_confirm"),function(a){if("yes"===a){this.blCloseCheck=false;this.close()}},this);return false},OnConfirmClose:function(){this.CancelPollTask();if(this.firmwareInfo){this.sendWebAPI({api:"SYNO.SurveillanceStation.VisualStation.Install",version:1,method:"Cancel",dsId:this.owner.appDSId,params:{connectionId:this.record.get("id")}})}this.firmwareInfo=null},OnApiError:function(a){this.blCloseCheck=false;this.getMsgBox().alert("",SYNO.API.getErrorString(a))}});Ext.namespace("SYNO.SS.App.Client");Ext.define("SYNO.SS.App.Client.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SS.App.Client.MainWindow"});Ext.define("SYNO.SS.App.Client.MainWindow",{extend:"SYNO.SDS.TabPanelAppWindow",WIN_MIN_WIDTH:1000,WIN_MIN_HEIGHT:560,panelDownload:null,panelConnClients:null,panelRestrictConn:null,panelList:null,tabIndex:{NONE:-1,CONN_STATUS:0,RESTRICT_CONN:1},constructor:function(a){SYNO.SS.App.Client.winInst=this;this.Init();this.callParent([Ext.apply({width:this.WIN_MIN_WIDTH,height:this.WIN_MIN_HEIGHT,minWidth:this.WIN_MIN_WIDTH,minHeight:this.WIN_MIN_HEIGHT,layout:"fit",resizable:false,maximizable:false,tabIndex:this.tabIndex,panelList:this.panelList,listeners:{beforeclose:this.OnBeforeClose,scope:this}},a)]);this.mon(this.tabPanel,"beforetabchange",this.OnBeforeTabChange,this)},onBeforeDestroy:function(){SYNO.SS.App.Client.winInst=null;this.callParent(arguments)},Init:function(){this.panelList=[];this.panelConnClients=new SYNO.SS.App.Client.ConnStatusPanel();this.panelList.push(this.panelConnClients);if(SYNO.SS.UserPrivType.ADMIN===_S("USER_PRIVILEGE")){this.panelRestrictConn=new SYNO.SS.App.Client.RestrictConnPanel({owner:this});this.panelList.push(this.panelRestrictConn)}},getHelpParam:function(){if(this.tabIndex.CONN_STATUS===this.GetCurrentTabIndex()){return"client_conn.html"}else{if(this.tabIndex.RESTRICT_CONN===this.GetCurrentTabIndex()){return"client_advanced.html"}else{return""}}},OnBeforeTabChange:function(b,c,a){if((!a)||(false===Ext.isFunction(a.IsDirty))||(false===a.IsDirty())){return true}this.getMsgBox().confirm(this.title,_T("ss_common","confirm_lostchange"),function(d){if("yes"===d){a.ResetForm();b.setActiveTab(c.getItemId())}});return false},OnBeforeClose:function(){var a=this.panelList.some(function(b){return(true===Ext.isFunction(b.IsDirty))&&(true===b.IsDirty())});if(false===a){return true}this.getMsgBox().confirm(this.title,_T("ss_common","confirm_lostchange"),function(b){if("yes"===b){this.panelList.forEach(function(c){if(true===Ext.isFunction(c.ResetForm)){c.ResetForm()}});this.close()}},this);return false}});