/* Copyright (c) 2018 Synology Inc. All rights reserved. */

Ext.define("SYNO.SS.App.Event.ExportCamera",{extend:"SYNO.ux.FormPanel",EVENT_EXPORT_COLUMN_CHECK_INDEX:0,srcDsId:LOCAL_DS_ID,srcArchId:0,parentWin:null,dsCamList:null,labelCamDesp:null,gridCamera:null,blFirstShow:true,constructor:function(a){this.parentWin=a.parentWin;this.InitForm(a.camList);Ext.applyIf(a,{title:_T("event_achieving","export_wizard_camera"),trackResetOnLoad:true,layout:"fit",items:[this.gridCamera],listeners:{activate:function(c){var b=this.gridCamera.getColumnModel();if(true===this.IsSrcArchTask()){b.setHidden(b.findColumnIndex("camStatus"),true);b.setHidden(b.findColumnIndex("occupiedSizeGB"),false)}else{b.setHidden(b.findColumnIndex("camStatus"),false);b.setHidden(b.findColumnIndex("occupiedSizeGB"),true)}},beforeshow:function(c){var b=this.dsCamList;if((true===this.blFirstShow)||(b.baseParams.dsId!=this.srcDsId)||(b.baseParams.archId!=this.srcArchId)){b.baseParams.dsId=this.srcDsId;b.baseParams.archId=this.srcArchId;b.load();this.blFirstShow=false}},scope:this},emptyStyleMonStore:this.dsCamList,emptyStyleTip:_T("ss_privilege","no_camera_found")});this.callParent([a]);this.InitEventHandler()},InitForm:function(c){var d={dsId:this.srcDsId,archId:this.srcArchId};if(c&&(0<c.length)){d.cameralists=c.join(",")}this.dsCamList=new SYNO.API.JsonStore({appWindow:this,api:"SYNO.SurveillanceStation.Recording.Export",method:"CamEnum",version:1,baseParams:d,autoDestroy:true,root:"camlist",fields:[{name:"checked",type:"boolean"},{name:"id",type:"int"},{name:"archId",type:"int"},{name:"idOnRecServ",type:"int"},{name:"name"},{name:"ipaddr"},{name:"enable",type:"boolean"},{name:"camStatus",type:"int",mapping:"status"},{name:"occupiedSizeGB",type:"int"},{name:"deleted",type:"boolean"},{name:"isCheckDisabled",type:"boolean",defaultValue:false},{name:"blDisableRec",type:"boolean",defaultValue:false},{name:"camRecStorageStatus",type:"int"}],listeners:{load:function(g,f,h){var e=false;g.each(function(i){e=(SYNO.SS.CamSts.MIGRATING===i.data.camStatus)?true:false;i.set("isCheckDisabled",e);i.commit()},this)},scope:this}});var b=SYNO.SS.Grid.CreateCheckColumnModel([{dataIndex:"checked"},{header:_T("camera","camera_attr_name"),align:"center",width:200,sortable:true,dataIndex:"name",renderer:this.RenderGrayIfCheckDisabled},{header:_T("ss_common","ip_address_header"),align:"center",width:150,sortable:true,dataIndex:"ipaddr",renderer:this.RenderGrayIfCheckDisabled},{id:"exp_cam_status",header:_T("camera","conn_status"),align:"center",sortable:true,dataIndex:"camStatus",renderer:this.RenderStatus},{header:_T("ss_common","occupied")+" ("+_T("ss_common","size_gb")+")",align:"center",sortable:true,dataIndex:"occupiedSizeGB",renderer:this.RenderGrayIfCheckDisabled}],this.EVENT_EXPORT_COLUMN_CHECK_INDEX);var a=new Ext.grid.RowSelectionModel();this.gridCamera=new SYNO.SS.Grid.GridPanel({store:this.dsCamList,autoExpandColumn:"exp_cam_status",cm:b,sm:a,height:280,viewConfig:{forceFit:true,markDirty:false},listeners:{render:function(e){e.tip=new Ext.ToolTip({target:e.getView().mainBody,delegate:".x-grid3-row",trackMouse:true,renderTo:document.body,listeners:{beforeshow:function(h){var i=e.getView();var g=e.getStore();if(!i||!g){return false}var j=i.findRowIndex(h.triggerElement);var f=g.getAt(j);if(true===f.data.isCheckDisabled){h.body.dom.innerHTML=_T("event_achieving","cannot_export_during_migration");return true}return false}}})}}})},IsSrcArchTask:function(){return(0<this.srcArchId)},FieldInputCheck:function(){return this.getForm().isValid()},InitEventHandler:function(){this.gridCamera.regCheckEvent("checked",this.EVENT_EXPORT_COLUMN_CHECK_INDEX,"",false,"isCheckDisabled");this.dsCamList.on("beforeload",function(){this.parentWin.setStatusBusy()},this);this.dsCamList.on("load",function(){this.parentWin.clearStatusBusy();if(MODULE_ID_EVENT_PLAYBACK==GetActivateModuleID()){this.gridCamera.fireEvent("headerclick",this.gridCamera,this.EVENT_EXPORT_COLUMN_CHECK_INDEX)}},this);this.dsCamList.on("exception",function(){this.parentWin.clearStatusBusy();this.parentWin.getMsgBox().alert(_T("event_achieving","export_wizard_camera"),_T("ss_centralized","msg_connect_failed"))},this)},RenderGrayIfCheckDisabled:function(c,d,a){var b=(false===a.data.isCheckDisabled)?SYNO.SS.Color.NORMAL_BLACK:SYNO.SS.Color.DISABLED_GRAY;return String.format("<span style='color:{0}'>{1}</span>",b,c)},RenderStatus:function(b,c,a){return(0<a.get("archId"))?"-":SYNO.SS.App.Camera.Utils.RenderStatus(b,c,a)},GetSelCamIds:function(a){var b=[];this.dsCamList.each(function(c){if(true==c.data.checked){if(LOCAL_DS_ID===a){b.push(c.data.id)}else{b.push(c.data.idOnRecServ)}}});return b}});Ext.define("SYNO.SS.App.Event.ExportDest",{extend:"SYNO.ux.FormPanel",EVT_EXP_LABEL_WIDTH:150,EVT_EXP_LIST_WIDTH:250,srcDsId:-1,lastSelSrc:null,lastSelDestDsId:LOCAL_DS_ID,parentWin:null,dsShareList:null,panelNameDesp:null,panelExportName:null,fldExportName:null,cmbSrc:null,cmbDest:null,panelDestDesp:null,cmbDestShare:null,dsSrc:null,dsDest:null,constructor:function(a){this.parentWin=a.parentWin;this.InitForm();Ext.applyIf(a,{title:_T("event_achieving","export_wizard_name"),trackResetOnLoad:true,items:[{xtype:"syno_panel",layout:"form",labelWidth:this.EVT_EXP_LABEL_WIDTH,items:[this.panelNameDesp,this.panelExportName,this.cmbSrc,this.cmbDest,this.panelDestDesp,this.cmbDestShare]}]});this.callParent([a]);this.InitEvents()},InitForm:function(){this.dsSrc=this.GetSrcStore();this.dsDest=SYNO.SS.GblStore.GetSlaveDSStoreCopy(null,{blStatusNormalOnly:true});this.dsShareList=new SYNO.API.JsonStore({appWindow:this,api:"SYNO.SurveillanceStation.Share",method:"List",version:1,baseParams:{sharePriv:SYNO.SS.SharePriv.RW},autoDestroy:true,getDsId:Ext.createDelegate(this.GetSelectedDsId,this),root:"sharelist",id:"value",timeout:10000,fields:[{name:"value"},{name:"freesize"},{name:"display"}],listeners:{load:function(c,b,d){SYNO.SS.Utils.ConvertShareFolderDisplayName(c);this.cmbDestShare.emptyText=(0===c.getCount())?_T("share_folder","no_avaliable_folder"):_T("ss_common","common_select");this.cmbDestShare.applyEmptyText();if(-1<c.findExact("value",PUBLIC_FOLDER)){this.cmbDestShare.setValue(PUBLIC_FOLDER)}else{this.cmbDestShare.setValue("");this.cmbDestShare.clearInvalid()}},exception:function(){var b=parseInt(this.cmbDest.getValue(),10);var e=this.dsDest.getById(b).get("name");var c=this.parentWin.getMsgBox();var d=String.format(_T("ss_common","sever_conn_failed"),e);c.alert(_T("event_achieving","export_wizard_name"),d,function(){this.cmbDest.setValue(this.lastSelDestDsId);this.LoadShareList()},this)},scope:this}});this.fldExportName=new SYNO.SS.Form.NameTextField({fieldLabel:_T("event_achieving","export_name"),width:this.EVT_EXP_LIST_WIDTH,maxLength:32});this.panelExportName=new SYNO.ux.Panel({layout:"form",items:[this.fldExportName]});var a='<tpl for="."><tpl if="-1 !== id"><div class="x-combo-list-item indent-sel-item" ext:qtip="{name}">{name}</div></tpl><tpl if="-1 === id"><div class="x-combo-list-item">{name}</div></tpl></tpl>';this.cmbSrc=new SYNO.ux.ComboBox({tpl:a,lazyInit:false,fieldLabel:_T("event_achieving","source_server"),emptyText:_T("event_achieving","select_server"),store:this.dsSrc,width:this.EVT_EXP_LIST_WIDTH,valueField:"typeAndId",value:SYNO.SS.EvtExpSrcType.SERVER+":"+LOCAL_DS_ID,displayField:"name",mode:"local",forceSelection:true,triggerAction:"all",editable:false,listeners:{beforeselect:function(){this.lastSelSrc=this.cmbSrc.getValue()},select:function(){var c=this.GetSrcDsId();var b=_T("event_achieving","export_wizard_name");var d=function(){this.cmbSrc.setValue(this.lastSelSrc)};if(LOCAL_DS_ID===c){return}SYNO.SS.Utils.CheckServerConnection(this.parentWin.getMsgBox(),c,true,b,Ext.emptyFn,d,this)},scope:this}});this.cmbDest=new SYNO.ux.ComboBox({fieldLabel:_T("event_achieving","dest_server"),emptyText:_T("event_achieving","select_server"),store:this.dsDest,width:this.EVT_EXP_LIST_WIDTH,valueField:"id",value:LOCAL_DS_ID,displayField:"name",mode:"local",forceSelection:true,triggerAction:"all",editable:false,listeners:{beforeselect:function(){this.lastSelDestDsId=parseInt(this.cmbDest.getValue(),10)},select:function(){var c=parseInt(this.cmbDest.getValue(),10);var b=_T("event_achieving","export_wizard_name");var d=function(){this.cmbDest.setValue(this.lastSelDestDsId);this.LoadShareList()};if(LOCAL_DS_ID===c){this.LoadShareList();return}SYNO.SS.Utils.CheckServerConnection(this.parentWin.getMsgBox(),c,true,b,this.LoadShareList,d,this)},scope:this}});this.panelNameDesp=new SYNO.ux.Panel({layout:"form",style:"padding-bottom: 4px;",items:[{xtype:"label",text:_T("event_achieving","export_name_describe"),style:"font-size: 12px; line-height: 28px;"}]});this.panelDestDesp=new SYNO.ux.Panel({layout:"form",style:"padding: 16px 0 4px 0",items:[{xtype:"label",text:_T("event_achieving","export_dest_describe"),style:"font-size: 12px; line-height: 28px;"}]});this.cmbDestShare=new SYNO.ux.ComboBox({fieldLabel:_T("event_achieving","export_dest"),emptyText:_T("ss_common","common_select"),store:this.dsShareList,width:this.EVT_EXP_LIST_WIDTH,valueField:"value",displayField:"display",mode:"local",forceSelection:true,allowBlank:false,triggerAction:"all",editable:false,scope:this});if(true===IsCMSHost()){this.panelNameDesp.setVisible(false);this.panelDestDesp.setVisible(false)}else{if(false===this.HasArchTask()){this.cmbSrc.setVisible(false)}this.cmbDest.setVisible(false)}},InitEvents:function(){this.mon(this.cmbSrc,"afterrender",function(){this.mon(this.cmbSrc.view,"beforeselect",function(b,c,a){return(true===c.hasClassName("indent-sel-item"))})},this,{single:true})},GetSrcDsId:function(){return SYNO.SS.EvtExpSrcType.GetDsId(this.cmbSrc.getValue())},GetSrcArchId:function(){return SYNO.SS.EvtExpSrcType.GetArchId(this.cmbSrc.getValue())},HasArchTask:function(){return(0<SYNO.SS.GblStore.dsArchiveTask.getCount())},GetSrcStore:function(){var b=new Ext.data.ArrayStore({data:[],fields:[{name:"type",type:"int"},{name:"id",type:"int"},{name:"typeAndId"},{name:"name"}]});var a=Ext.data.Record.create(b.fields);var c=[];c.push(new a({type:SYNO.SS.EvtExpSrcType.TITLE,id:-1,name:_T("ss_centralized","label_server")}));c.push(new a({type:SYNO.SS.EvtExpSrcType.SERVER,id:LOCAL_DS_ID,name:_T("ss_common","local_host")}));SYNO.SS.GblStore.dsSlaveDS.each(function(d){if((true===d.get("enable"))&&(SYNO.SS.CmsDsSts.NORMAL===d.get("status"))){c.push(new a({type:SYNO.SS.EvtExpSrcType.SERVER,id:d.get("id"),name:d.get("name")}))}});if(true===this.HasArchTask()){c.push(new a({type:SYNO.SS.EvtExpSrcType.TITLE,id:-1,name:_T("archive","archive_task")}));SYNO.SS.GblStore.dsArchiveTask.each(function(d){c.push(new a({type:SYNO.SS.EvtExpSrcType.ARCH_TASK,id:d.get("id"),name:d.get("name")}))})}c.forEach(function(d){d.set("typeAndId",d.get("type")+":"+d.get("id"))});b.add(c);return b},FieldInputCheck:function(){return this.getForm().isValid()},GetSelectedDsId:function(){var a=LOCAL_DS_ID;if((true===IsCMSHost()&&this.cmbDest)){a=this.cmbDest.getValue()}return a},LoadShareList:function(){this.parentWin.setStatusBarBusy();this.dsShareList.load({callback:function(){this.parentWin.clearStatusBusy()},scope:this})},InitData:function(){this.LoadShareList()}});Ext.define("SYNO.SS.App.Event.ExportPeriod",{extend:"SYNO.ux.FormPanel",EVENT_EXPORT_PERIOD_DEF_TIME:"00:00",DATE_FILED_WIDTH:116,TIME_FIELD_WIDTH:96,SLASH_WIDTH:15,LABEL_PADDING:20,FIELD_PADDING:10,panelPeriod:null,labelFrom:null,dateFrom:null,timeFrom:null,labelTo:null,dateTo:null,timeTo:null,constructor:function(a){this.InitForm();Ext.applyIf(a,{xtype:"syno_panel",title:_T("event_achieving","export_wizard_range"),trackResetOnLoad:true,items:[this.panelPeriod]});this.callParent([a])},InitForm:function(){this.labelFrom=new Ext.form.Label({text:_T("event_achieving","start_datetime")+":",style:"font-size: 12px;"});this.dateFrom=new SYNO.ux.DateField({name:"dateFrom",width:this.DATE_FILED_WIDTH,emptyText:"Select date",format:"Y/m/d",hideLabel:true,editable:false});this.timeFrom=new SYNO.ux.TimeField({name:"timeFrom",width:this.TIME_FIELD_WIDTH,hideLabel:true,emptyText:"Select time",format:"H:i",editable:false});var b=new Ext.form.Label({text:"/",style:"font-size: 12px;"});this.labelTo=new Ext.form.Label({text:_T("event_achieving","stop_datetime")+":",style:"font-size: 12px;"});this.dateTo=new SYNO.ux.DateField({name:"dateTo",width:this.DATE_FILED_WIDTH,emptyText:"Select date",format:"Y/m/d",hideLabel:true,editable:false});var d=new Ext.form.Label({text:"/",style:"font-size: 12px;"});this.timeTo=new SYNO.ux.TimeField({name:"timeTo",width:this.TIME_FIELD_WIDTH,hideLabel:true,emptyText:"Select time",format:"H:i",editable:false});var c=(this.labelFrom.text.length>this.labelTo.text.length)?this.labelFrom:this.labelTo;var a=SYNO.SS.Utils.GetRenderWidth(c.text);this.panelPeriod=new SYNO.ux.Panel({cls:"evt-export-wizard-period",autoHeight:true,width:650,layout:"form",defaults:{xtype:"syno_panel"},items:[{layout:"form",height:30,items:[{xtype:"label",text:_T("event_achieving","export_range_describe"),style:"font-size:12px;"}]},{layout:"table",layoutConfig:{columns:4},height:30,defaults:{xtype:"syno_panel"},items:[{width:a+this.LABEL_PADDING,items:this.labelFrom},{width:this.DATE_FILED_WIDTH+this.FIELD_PADDING,items:this.dateFrom},{width:this.SLASH_WIDTH,items:b},{width:this.TIME_FIELD_WIDTH+this.FIELD_PADDING,items:this.timeFrom}]},{layout:"table",layoutConfig:{columns:4},height:30,defaults:{xtype:"syno_panel"},items:[{width:a+this.LABEL_PADDING,items:this.labelTo},{width:this.DATE_FILED_WIDTH+this.FIELD_PADDING,items:this.dateTo},{width:this.SLASH_WIDTH,items:d},{width:this.TIME_FIELD_WIDTH+this.FIELD_PADDING,items:this.timeTo}]}]})},FieldInputCheck:function(){return this.getForm().isValid()},InitData:function(){var g,e,f;var d,b;var c=new Date();var a=new Date(c.valueOf()+DAY_MILLISECOND);this.timeFrom.setValue(this.EVENT_EXPORT_PERIOD_DEF_TIME);this.timeTo.setValue(this.EVENT_EXPORT_PERIOD_DEF_TIME);this.dateFrom.setValue(c);this.dateTo.setValue(a)}});Ext.define("SYNO.SS.App.Event.ExportWizard",{extend:"SYNO.SDS.Wizard.ModalWindow",TITLE:_T("event_achieving","wizard_export"),exportName:null,destShare:null,isOverwrite:false,steps:null,PAGE_DEST:"dest",PAGE_CAMERA:"camera",PAGE_PERIOD:"peroid",pageDest:null,pageCamera:null,pagePeriod:null,constructor:function(c,a){this.InitSteps();var b={id:c,owner:a,title:this.TITLE,width:760,height:435,layout:"fit",bodyCssClass:"ss_wizard",bodyStyle:"padding:0px;",buttonAlign:"right",listeners:{afterrender:function(){this.pageDest.InitData();this.pagePeriod.InitData()},scope:this},banner:false,steps:this.steps,useStatusBar:true};SYNO.SS.Utils.PrepareWndHelpIcon(b,MODULE_ID_EVENT_LIST,"export");this.callParent([b])},InitSteps:function(){var a=function(){if(true===Ext.isDefined(this.form)){this.getForm().clearInvalid()}};this.pageDest=new SYNO.SS.App.Event.ExportDest({parentWin:this,itemId:this.PAGE_DEST,nextId:this.PAGE_CAMERA,getNext:function(){if(true===this.FieldInputCheck()){this.parentWin.CheckArchiveName()}else{this.parentWin.setStatusBarError({text:_T("ss_common","forminvalid"),clear:true})}return false},activate:a});this.pageCamera=new SYNO.SS.App.Event.ExportCamera({parentWin:this,itemId:this.PAGE_CAMERA,nextId:this.PAGE_PERIOD,getNext:function(){if(true===this.FieldInputCheck()){this.parentWin.SelectTargetCamera()}return false},activate:a});this.pagePeriod=new SYNO.SS.App.Event.ExportPeriod({parentWin:this,itemId:this.PAGE_PERIOD,nextId:null,getNext:function(){if(true===this.FieldInputCheck()){this.parentWin.OnPreSubmit()}return false},activate:a});this.steps=[this.pageDest,this.pageCamera,this.pagePeriod]},CheckArchiveName:function(){var b=this.pageDest.GetSrcDsId();var a=this.pageDest.GetSrcArchId();var c=this.pageDest.cmbDest.getValue();this.setStatusBarBusy({text:_T("ss_common","common_saving")});this.isOverwrite=false;this.exportName=this.pageDest.fldExportName.getValue();this.destShare=this.pageDest.cmbDestShare.getValue();this.pageCamera.srcDsId=b;this.pageCamera.srcArchId=a;this.sendWebAPI({api:"SYNO.SurveillanceStation.Recording.Export",version:1,method:"CheckName",params:{dsId:c,name:this.pageDest.fldExportName.getValue(),share:this.pageDest.cmbDestShare.getValue()},callback:this.OnConflictChkDone,scope:this})},SelectTargetCamera:function(){var a=true;this.pageCamera.dsCamList.each(function(b){if(true==b.data.checked){a=false}},this);if(true==a){this.getMsgBox().alert(this.TITLE,_T("event_achieving","export_msg_no_select"))}else{this.ActiveNextPage()}},ActiveNextPage:function(){this.goNext(this.getActiveStep().nextId,true)},GetHourFromStr:function(c){var d=("string"==(typeof c))?c:c.toString();var b=d.indexOf(":");var a=parseInt(d.substr(0,b),10);return a},GetMinFromStr:function(b){var d=("string"==(typeof b))?b:b.toString();var a=d.indexOf(":");var c=parseInt(d.substr(a+1),10);return c},OnPreSubmit:function(){var a;var d;if(false===IsCMSHost()){this.OnSubmit()}else{var b=this.pageDest.GetSrcDsId();var c=this.pageDest.cmbDest.getValue();if((LOCAL_DS_ID===b)&&(LOCAL_DS_ID===c)){this.OnSubmit()}else{this.setStatusBarBusy();this.sendWebAPI({api:"SYNO.SurveillanceStation.CMS",version:1,method:"BatCheckSambaService",params:{dsIdList:b+","+c},callback:this.OnCheckSambaEnabledDone,scope:this})}}},OnCheckSambaEnabledDone:function(e,c,d,b){var a=this.getMsgBox();this.clearStatusBusy();if(!e){a.alert(this.TITLE,_T("ss_common","error_system"));return}if(true===c.allSambaEnabled){this.OnSubmit()}else{a.confirm(this.TITLE,_T("event_achieving","samba_is_not_enable_warning"),function(f){if("yes"==f){this.OnSubmit()}},this)}},OnSubmit:function(){var f=this.pageDest.GetSrcDsId();var k=this.pageDest.GetSrcArchId();var i=(true===IsCMSHost())?this.pageDest.cmbDest.getValue():LOCAL_DS_ID;var c=this.pageCamera.GetSelCamIds(f);var g=new Date(this.pagePeriod.dateFrom.getValue());var h=new Date(this.pagePeriod.dateTo.getValue());g.setHours(this.GetHourFromStr(this.pagePeriod.timeFrom.getValue()),this.GetMinFromStr(this.pagePeriod.timeFrom.getValue()));h.setHours(this.GetHourFromStr(this.pagePeriod.timeTo.getValue()),this.GetMinFromStr(this.pagePeriod.timeTo.getValue()));var a=g.getTime()/TRANS_MILLISECOND;var j=h.getTime()/TRANS_MILLISECOND;a=ConvertTimestamp(a,false);j=ConvertTimestamp(j,false);if(a>=j){this.getMsgBox().alert(this.TITLE,_T("event_achieving","export_msg_invalid_range"));return}var d=this.pageDest.dsShareList.findExact("value",this.pageDest.cmbDestShare.getValue());var b=this.pageDest.dsShareList.getAt(d).data.freesize;var e={name:this.pageDest.fldExportName.getValue(),srcDsId:f,srcArchId:k,srcArchName:SYNO.SS.GblStore.GetArchTaskName(k),dstDsId:i,dstdir:this.pageDest.cmbDestShare.getValue(),camlistid:c.join(","),freesize:b,start_time:a,stop_time:j,isoverwrite:(this.isOverwrite)?1:0};this.setStatusBarBusy({text:_T("ss_common","common_saving")});this.sendWebAPI({api:"SYNO.SurveillanceStation.Recording.Export",version:1,method:"Save",params:e,callback:this.OnWizardModeDone,scope:this})},OnConflictChkDone:function(b,d,e,c){var a=this.getMsgBox();this.clearStatusBusy();if(b){if(true==d.permission_denied){a.alert(this.TITLE,_T("cam_archiving","export_fail_folder_deny"))}else{if(0==d.conflict){this.ActiveNextPage()}else{if(1==d.conflict){a.confirm(this.TITLE,_T("event_achieving","export_msg_name_overwrite"),function(f){if("yes"==f){this.isOverwrite=true;this.ActiveNextPage()}},this)}else{a.alert(this.TITLE,_T("event_achieving","export_msg_name_exist"))}}}}else{SYNO.SS.Utils.WebAPIAlert(a,this.TITLE,d)}},OnWizardModeDone:function(b,d,e,c){var a=this.getMsgBox();this.clearStatusBusy();if(b){SYNO.SDS.StatusNotifier.fireEvent("eventExported",{key:"msg_export_starting"});this.fireEvent("wizarddone");this.close()}else{a.alert(this.TITLE,SYNO.API.getErrorString(d.code))}}});Ext.define("SYNO.SS.App.Event.Export",{extend:"SYNO.ux.Panel",parentWin:null,dsExport:null,grid:null,panelGridContainer:null,btnAdd:null,btnDelete:null,contextMenu:null,timerUpdateTimeout:null,dlgEventExportWizard:null,constructor:function(c){this.parentWin=c;this.Init();var a=new SYNO.ux.Toolbar([this.btnAdd,this.btnDelete]);var b=Ext.apply({},{cls:"management_panel",title:_T("event_achieving","event_export"),tbar:a,items:[this.panelGridContainer]});this.callParent([b]);this.mon(this,"afterrender",function(){this.InitEventHandler()},this)},ClearUpdateTimeout:function(){if(this.timerUpdateTimeout){window.clearTimeout(this.timerUpdateTimeout);delete this.timerUpdateTimeout;this.timerUpdateTimeout=null}},Resize:function(){this.panelGridContainer.setWidth(this.getInnerWidth());this.panelGridContainer.setHeight(this.getInnerHeight());this.panelGridContainer.syncSize()},Init:function(){this.dsExport=new SYNO.API.JsonStore({appWindow:this,api:"SYNO.SurveillanceStation.Recording.Export",method:"Load",version:1,baseParams:{blGetSortInfo:true},blSortCaseSensitive:false,root:"exporttask",totalProperty:"evtexptotal",fields:[{name:"id",type:"int"},{name:"name"},{name:"dstdir"},{name:"srcDsId",type:"int"},{name:"srcArchId",type:"int"},{name:"srcArchName"},{name:"dstDsId",type:"int"},{name:"start_time",type:"int"},{name:"stop_time",type:"int"},{name:"exported_count",type:"int"},{name:"total_count",type:"int"},{name:"status",type:"int"},{name:"srcDsName"},{name:"dstDirName"}],sort:function(e,d){return SYNO.SS.Sort.GridSort("export","name",e,d,this)}});var b=new Ext.grid.ColumnModel([{id:"name",header:_T("event_achieving","export_name"),align:"center",sortable:true,dataIndex:"name"},{header:_T("event_achieving","start_time"),align:"center",sortable:true,dataIndex:"start_time",renderer:this.RenderTime},{header:_T("event_achieving","stop_time"),align:"center",sortable:true,dataIndex:"stop_time",renderer:this.RenderTime},{header:_T("event_achieving","source"),align:"center",sortable:true,dataIndex:"srcDsName",renderer:this.RenderSource},{header:_T("event_achieving","destination"),align:"center",sortable:true,dataIndex:"dstDirName",renderer:this.RenderDstDir},{id:"status",header:_T("camera","conn_status"),align:"center",sortable:true,dataIndex:"status",renderer:this.RenderStatus}]);this.btnAdd=new SYNO.ux.Button({text:_T("ss_common","common_add"),handler:this.OnEventExportAdd,scope:this});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),handler:this.DeletePreProcess,disabled:true,scope:this});var a=new Ext.grid.RowSelectionModel();this.grid=new SYNO.SS.Grid.GridPanel({cls:"grid_row_height_fixed",store:this.dsExport,border:false,viewConfig:{forceFit:true},cm:b,sm:a,autoExpandColumn:"status",scope:this,bShiftCtrlPressed:false,listeners:{rowcontextmenu:this.OnContextMenu},plugins:SYNO.SS.Pgls.CreatePglsPlugin({ptype:"synoSSPglsPlugin",store:this.dsExport})});var c=function(){this.parentWin.panelEvtExport.OnEventExportAdd()};this.panelGridContainer=new SYNO.SS.Pgls.PglsGridContainerPanel({grid:this.grid,refreshFunction:function(){this.OnRefresh(true)},refreshFunctionScope:this,emptyStyleMonStore:this.dsExport,emptyStyleTip:_T("event_achieving","no_export_tip"),emptyStyleTipFunc:c.createDelegate(this)});this.blDataInited=false},InitData:function(){this.OnRefresh()},Activate:function(){if(false===this.blDataInited){this.InitData();this.blDataInited=true}},GetSelectedItems:function(){var a=this.grid.getSelectionModel().getSelections();var b=[];Ext.each(a,function(d){var c=d.get("dstDsId");if((LOCAL_DS_ID===c)||(true===SYNO.SS.Utils.IsSlaveDsOnline(c))){b.push(d.get("id"))}});if(0==b.length){return null}return b.join(",")},OnEventExportAdd:function(){if(this.dlgEventExportWizard&&(false==this.dlgEventExportWizard.hidden)){return}this.dlgEventExportWizard=new SYNO.SS.App.Event.ExportWizard("dlgEventExportWizard",this.parentWin);this.mon(this.dlgEventExportWizard,"wizarddone",this.OnRefresh,this);this.dlgEventExportWizard.open()},DeletePreProcess:function(){if(null===this.GetSelectedItems()){this.parentWin.getMsgBox().alert(_T("event_achieving","export_wizard_name"),_T("ss_centralized","msg_connect_failed"));return}(new SYNO.SS.Window.RadioOptionWindow({owner:this.parentWin,width:400,height:220,title:_T("event_achieving","event_export"),desc:_T("event_achieving","export_confirm_del"),rdoLabelList:[_T("event_achieving","export_del_file"),_T("event_achieving","export_keep_file")],okCallback:this.OnEventExportDelete,scope:this})).show()},OnEventExportDelete:function(a){this.parentWin.setStatusBusy();this.sendWebAPI({api:"SYNO.SurveillanceStation.Recording.Export",version:1,method:"Delete",params:{exportlist:this.GetSelectedItems(),deletefile:(0===a)?1:0},callback:function(c,b){this.parentWin.clearStatusBusy();if(!c){this.parentWin.getMsgBox().alert(_T("event_achieving","event_export"),SYNO.API.getErrorString(b))}this.OnRefresh(true,true)},scope:this})},OnRefresh:function(a,b){this.ClearUpdateTimeout();this.dsExport.load({needMask:a,params:{start:0,limit:SYNO.SS.Event.EXPORT_PAGE_SIZE,blGetSortInfo:true},callback:function(c,d,e){if((true===e)&&(true===b)){SYNO.SDS.StatusNotifier.fireEvent("evtExpDataUpdated")}}})},OnContextMenu:function(a,f,c){if(!this.contextMenu){this.contextMenu=new SYNO.ux.Menu({id:"cameraContextMenu",items:[{id:"cmDelExport",text:_T("ss_common","common_delete"),scope:this,handler:function(){this.scope.DeletePreProcess()}}]})}var d=this.scope.grid.getSelectionModel();if(false===d.isSelected(f)){d.selectRow(f)}c.stopEvent();var b=Ext.getCmp("cmDelExport");if(b&&(false===b.disabled)){this.contextMenu.showAt(c.getXY())}},RenderTime:function(b,c,a){return String.format("<span style='color:{0}'>{1}</span>",SYNO.SS.Color.NORMAL_BLACK,GenLocalDateTimeStr(b*TRANS_MILLISECOND,false))},RenderSource:function(c,d,a){var f=a.get("srcArchId");var g=a.get("srcArchName");var e=SYNO.SS.GblStore.GetDsName(a.get("srcDsId"));var b=(0<f)?("Archiving - "+g):e;a.data.srcDsName=b;return b},RenderDstDir:function(c,d,a){var b=a.get("dstdir");if(true===IsCMSHost()){b=SYNO.SS.GblStore.GetDsName(a.get("dstDsId"))+" / "+b}a.data.dstDirName=b;return b},RenderStatus:function(e,g,c){var b;var d;var a=c.data.status;switch(a){case SYNO.SS.App.Event.Def.EXPORT_STS_EXPORTING:var f=0;if(0<c.data.total_count){f=parseInt((c.data.exported_count*100)/c.data.total_count,10)}b=_T("event_achieving","export_status_exporting")+" ("+f+"%)";d=SYNO.SS.Color.NORMAL_BLACK;break;case SYNO.SS.App.Event.Def.EXPORT_STS_COMPLETE:b=_T("event_achieving","export_status_complete");d=SYNO.SS.Color.NORMAL_BLACK;break;case SYNO.SS.App.Event.Def.EXPORT_STS_NO_SPACE:b=_T("event_achieving","export_status_no_space");d=SYNO.SS.Color.ALERT_RED;break;default:b=_T("event_achieving","export_status_failed");d=SYNO.SS.Color.ALERT_RED}return String.format("<span valign='center' style='color:{0}'>{1}</span>",d,b)},InitEventHandler:function(){this.dsExport.on("beforeload",function(d,c){var b=(undefined!=c.needMask)?c.needMask:true;if(true==b){this.parentWin.setStatusBusy()}},this);this.dsExport.on("load",function(e,c,d){this.ChgButtonStatus();var b=(undefined!=d.needMask)?d.needMask:true;if(true==b){this.parentWin.clearStatusBusy()}this.SetupUpdateTimer();SYNO.SS.Sort.SetJsonStoreDefSortInfo("name",e.reader.jsonData.sortInfo,this.dsExport)},this);this.grid.getSelectionModel().on("rowselect",function(){this.ChgButtonStatus()},this);this.grid.getSelectionModel().on("rowdeselect",function(){this.ChgButtonStatus()},this);var a=function(){this.OnRefresh(true)};this.mon(SYNO.SDS.StatusNotifier,"cmsDataUpdated",a,this)},ChgButtonStatus:function(){var b=this.grid.getSelectionModel().getSelections();var c=Ext.getCmp("cmDelExport");var a=(0!==b.length);this.btnDelete.setDisabled(false===a);if(c){c.setDisabled(false===a)}},ProgressQuery:function(){this.dsExport.load()},SetupUpdateTimer:function(){var a=(function(){this.OnRefresh(false)}).createDelegate(this);if(0<=this.dsExport.findExact("status",SYNO.SS.App.Event.Def.EXPORT_STS_EXPORTING)){this.timerUpdateTimeout=window.setTimeout(a,5000)}}});Ext.define("SYNO.SS.App.Event.MountWizard",{extend:"SYNO.SDS.ModalWindow",WINDOW_WIDTH:750,COLUMN_CHECK_INDEX:0,LABEL_WIDTH:150,LIST_WIDTH:250,lastSelDsId:LOCAL_DS_ID,panelForm:null,dsServer:null,dsShareList:null,dsBackupList:null,cmbServer:null,cmbSourceShare:null,gridBackup:null,btnOk:null,btnCacel:null,constructor:function(c,a){var b={id:c,xtype:"syno_panel",owner:a,title:_T("event_achieving","wizard_mount"),width:this.WINDOW_WIDTH,height:450,layout:"fit",bodyStyle:"padding:0px;",buttonAlign:"right",items:this.GetForm(),buttons:[this.btnOk,this.btnCancel]};SYNO.SS.Utils.PrepareWndHelpIcon(b,MODULE_ID_EVENT_LIST,"mount");this.callParent([b])},GetForm:function(){this.btnOk=new SYNO.ux.Button({name:"btnOk",btnStyle:"blue",text:_T("ss_common","common_ok"),minWidth:75,handler:this.OnPreSubmit,scope:this});this.btnCancel=new SYNO.ux.Button({name:"btnCancel",text:_T("ss_common","common_cancel"),minWidth:75,handler:this.close,scope:this});this.dsServer=new Ext.data.ArrayStore({autoDestroy:true,data:[],fields:["id","name"]});this.cmbServer=new SYNO.ux.ComboBox({fieldLabel:_T("ss_centralized","source"),width:this.LIST_WIDTH,store:this.dsServer,valueField:"id",displayField:"name",mode:"local",editable:false,forceSelection:true,triggerAction:"all",hidden:!IsCMSHost(),listeners:{beforeselect:function(){this.lastSelDsId=parseInt(this.cmbServer.getValue(),10)},select:function(){var c=parseInt(this.cmbServer.getValue(),10);var b=_T("event_achieving","wizard_mount");var d=function(){this.cmbServer.setValue(this.lastSelDsId);this.LoadShareList()};if(LOCAL_DS_ID===c){this.LoadShareList();return}SYNO.SS.Utils.CheckServerConnection(this.getMsgBox(),c,true,b,this.LoadShareList,d,this)},scope:this}});this.dsShareList=new SYNO.API.JsonStore({appWindow:this,api:"SYNO.SurveillanceStation.Share",method:"List",version:1,baseParams:{sharePriv:SYNO.SS.SharePriv.RO|SYNO.SS.SharePriv.RW},getDsId:Ext.createDelegate(this.GetSelectedDsId,this),root:"sharelist",id:"value",timeout:10000,fields:[{name:"value"},{name:"display"}],listeners:{load:function(d,c,f){SYNO.SS.Utils.ConvertShareFolderDisplayName(d);var e=-1;var b;this.cmbSourceShare.setDisabled(false);e=d.findExact("value",PUBLIC_FOLDER);if(-1!==e){b=d.getAt(e);this.cmbSourceShare.setValue(b.get("value"));this.cmbSourceShare.fireEvent("select",this.cmbSourceShare,b,e)}else{this.cmbSourceShare.setValue("");this.cmbSourceShare.clearInvalid();SYNO.ux.EmptyStyle.ApplyStyle(this.gridBackup,_T("event_achieving","no_archive_avail"),null,true)}},exception:function(){var b=parseInt(this.cmbServer.getValue(),10);var d=this.dsServer.getById(b).get("name");var c=String.format(_T("ss_common","sever_conn_failed"),d);this.getMsgBox().alert(_T("event_achieving","wizard_mount"),c,function(){this.cmbServer.setValue(this.lastSelDsId);this.LoadShareList()},this)},scope:this}});this.dsBackupList=new SYNO.API.JsonStore({appWindow:this,api:"SYNO.SurveillanceStation.Recording.Mount.Wizard",getDsId:this.GetSelectedDsId.createDelegate(this),method:"BackupEnum",version:1,root:"backuplist",id:"value",autoDestroy:true,fields:[{name:"checked",type:"boolean"},{name:"name"},{name:"expid"},{name:"camlist"},{name:"srcdir"},{name:"start_time",type:"int"},{name:"stop_time",type:"int"}],listeners:{beforeload:function(b,c,d){this.setStatusBusy()},load:function(c,b,d){this.clearStatusBusy()},loadexception:function(c,b){this.clearStatusBusy()},exception:function(){this.clearStatusBusy()},scope:this}});this.cmbSourceShare=new SYNO.ux.ComboBox({fieldLabel:_T("event_achieving","mount_src"),emptyText:_T("ss_common","common_select"),width:this.LIST_WIDTH,store:this.dsShareList,valueField:"value",displayField:"display",mode:"local",forceSelection:true,allowBlank:false,triggerAction:"all",editable:false,listeners:{select:function(e,d,b){var c=d.data.value;this.dsBackupList.removeAll();this.dsBackupList.baseParams.shareName=c;this.dsBackupList.load();this.gridBackup.updateColHeaderCheck(false)},scope:this}});var a=SYNO.SS.Grid.CreateCheckColumnModel([{dataIndex:"checked"},{header:_T("event_achieving","mount_name"),align:"center",width:150,sortable:true,dataIndex:"name",maxLength:32},{header:_T("event_achieving","export_camera"),align:"center",width:150,sortable:true,dataIndex:"camlist"},{header:_T("event_achieving","start_datetime_head"),align:"center",width:150,sortable:true,dataIndex:"start_time",renderer:this.RenderTime},{id:"evt_mnt_stop_datetime",header:_T("event_achieving","stop_datetime_head"),align:"center",width:150,sortable:true,dataIndex:"stop_time",renderer:this.RenderTime}],this.COLUMN_CHECK_INDEX);this.gridBackup=new SYNO.SS.Grid.GridPanel({store:this.dsBackupList,height:230,autoExpandColumn:"evt_mnt_stop_datetime",cm:a,sm:new Ext.grid.RowSelectionModel(),viewConfig:{forceFit:true,markDirty:false},bShiftCtrlPressed:false,listeners:{rowmousedown:function(b,d,c){if((c.button===0)&&(c.shiftKey||c.ctrlKey)){this.bShiftCtrlPressed=true}else{if(this.bShiftCtrlPressed){this.getSelectionModel().clearSelections();this.bShiftCtrlPressed=false}}}},emptyStyleMonStore:this.dsBackupList,emptyStyleTip:_T("event_achieving","no_archive_avail"),emptyStyleShowHeader:true});this.gridBackup.regCheckEvent("checked",this.COLUMN_CHECK_INDEX);this.panelForm=new SYNO.ux.FormPanel({bodyStyle:"padding: 15px;",trackResetOnLoad:true,defaults:{xtype:"syno_panel"},items:[{layout:"form",height:25,hidden:IsCMSHost(),items:[new Ext.form.Label({text:_T("event_achieving","mount_src_describe"),style:"font-size: 12px;"})]},{layout:"form",labelWidth:this.LABEL_WIDTH,items:[this.cmbServer,this.cmbSourceShare,{xtype:"syno_displayfield",fieldLabel:_T("camera","recording")}]},this.gridBackup]});return this.panelForm},GetSelectedDsId:function(){var a=LOCAL_DS_ID;if((true===IsCMSHost())&&this.cmbServer){a=this.cmbServer.getValue()}return a},RenderTime:function(b,c,a){return GenLocalDateTimeStr(b*TRANS_MILLISECOND,false)},OnPreSubmit:function(){var a;if(false===this.panelForm.getForm().isValid()){this.setStatusError({text:_T("ss_common","forminvalid"),clear:true});return}if(false===IsCMSHost()){this.OnSubmit()}else{a=this.GetSelectedDsId();if(LOCAL_DS_ID===a){this.OnSubmit()}else{this.setStatusBusy();this.sendWebAPI({api:"SYNO.SurveillanceStation.CMS",version:1,method:"BatCheckSambaService",params:{dsIdList:a},callback:this.OnCheckSambaEnabledDone,scope:this})}}},OnCheckSambaEnabledDone:function(e,c,d,b){var a=this.getMsgBox();this.clearStatusBusy();if(!e){a.alert(_T("event_achieving","wizard_mount"),_T("ss_common","error_system"));return}if(true===c.allSambaEnabled){this.OnSubmit()}else{a.confirm(_T("event_achieving","wizard_mount"),_T("event_achieving","samba_is_not_enable_warning"),function(f){if("yes"==f){this.OnSubmit()}},this)}},UpdateServerList:function(){var b={blEnabledOnly:true,blIncludeLocalHost:true};this.dsServer=SYNO.SS.GblStore.GetSlaveDSStoreCopy(this.dsServer,b);var a;if(0<this.dsServer.getCount()){a=this.dsServer.getAt(0);this.cmbServer.setValue(a.get("id"));this.LoadShareList()}},LoadShareList:function(){this.cmbSourceShare.setDisabled(true);this.dsBackupList.removeAll();this.setStatusBusy();this.dsShareList.load({callback:function(){this.clearStatusBusy()},scope:this})},OnSubmit:function(){var g=this.cmbSourceShare.getValue();var f=this.GetSelectedDsId();var a=this.getMsgBox();var h=[];for(var e=0;e<this.dsBackupList.getCount();e++){var c=this.dsBackupList.getAt(e);if(true==c.get("checked")){var k=SYNO.SS.GblStore.dsEventMount;for(var d=0;d<k.getCount();d++){if(c.get("expid")==k.getAt(d).get("expid")){a.alert(_T("event_achieving","wizard_mount"),_T("event_achieving","mount_msg_is_mounted"));return}}var b=Ext.apply({},c.data);h.push(b)}}if(0>=h.length){a.alert(_T("event_achieving","wizard_mount"),_T("event_achieving","mount_msg_no_select"));return}else{if(SYNO.SS.App.Event.Def.EVENT_MOUNT_NUM_LIMIT<SYNO.SS.GblStore.dsEventMount.getCount()+h.length){a.alert(_T("event_achieving","event_mount"),String.format(_T("event_achieving","event_mount_alert_num_limit"),SYNO.SS.App.Event.Def.EVENT_MOUNT_NUM_LIMIT));return}}this.setStatusBusy({text:_T("ss_common","common_saving")});this.sendWebAPI({api:"SYNO.SurveillanceStation.Recording.Mount.Wizard",method:"Save",version:1,params:{dsId:f,shareName:this.cmbSourceShare.getValue(),bkplist:Ext.encode({data:h})},callback:this.OnSubmitDone,scope:this})},OnSubmitDone:function(c,b){var a=this.getMsgBox();this.clearStatusBusy();if(c){this.fireEvent("wizarddone",true);this.close()}else{this.getMsgBox().alert(_T("event_achieving","wizard_mount"),SYNO.API.getErrorString(b))}},Activate:function(){if(false===IsCMSHost()){this.LoadShareList()}else{this.UpdateServerList()}}});Ext.define("SYNO.SS.App.Event.Mount",{extend:"SYNO.ux.Panel",parentWin:null,grid:null,panelGridContainer:null,btnAdd:null,btnDelete:null,menuItemEnable:null,menuItemDisable:null,btnEnable:null,btnBrowseEvents:null,contextMenu:null,timerUpdateTimeout:null,dlgEventMountWizard:null,dlgBrowseEvents:null,constructor:function(c){this.parentWin=c;this.Init();var a=new SYNO.ux.Toolbar([this.btnAdd,this.btnDelete,this.btnEnable,this.btnBrowseEvents]);var b=Ext.apply({},{cls:"management_panel",title:_T("event_achieving","event_mount"),tbar:a,items:[this.panelGridContainer]});this.callParent([b]);this.mon(this,"afterrender",function(){this.InitEventHandler()},this)},Resize:function(){this.panelGridContainer.setWidth(this.getInnerWidth());this.panelGridContainer.setHeight(this.getInnerHeight());this.panelGridContainer.syncSize()},Init:function(){var a=new Ext.grid.ColumnModel([{align:"center",sortable:true,fixed:true,width:45,renderer:this.RenderStatusIcon.createDelegate(this)},{header:_T("event_achieving","mount_name"),width:1,align:"center",sortable:true,dataIndex:"name",renderer:this.RenderName.createDelegate(this)},{header:_T("event_achieving","start_time"),width:1,align:"center",sortable:true,dataIndex:"start_time",renderer:this.RenderTime.createDelegate(this)},{header:_T("event_achieving","stop_time"),width:1,align:"center",sortable:true,dataIndex:"stop_time",renderer:this.RenderTime.createDelegate(this)},{header:_T("ss_centralized","from_server"),width:1,align:"center",sortable:true,dataIndex:"dsName",hidden:!IsCMSHost(),renderer:this.RenderServer.createDelegate(this)},{header:_T("camera","conn_status"),width:1,align:"center",sortable:true,dataIndex:"status",renderer:this.RenderStatus.createDelegate(this)}]);this.btnAdd=new SYNO.ux.Button({text:_T("ss_common","common_add"),handler:this.OnEventMountAdd,scope:this});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),handler:this.DeletePreProcess,scope:this});this.menuItemEnable=new Ext.menu.Item({text:_T("ss_common","common_enable"),handler:this.OnEventMountEnable,scope:this});this.menuItemDisable=new Ext.menu.Item({text:_T("ss_common","common_disable"),handler:this.OnEventMountDisable,scope:this});this.btnEnable=new SYNO.ux.Button({text:_T("ss_common","common_enable"),menu:{items:[this.menuItemEnable,this.menuItemDisable]}});this.btnBrowseEvents=new SYNO.ux.Button({text:_T("event_achieving","mount_browse_events"),handler:this.OnBrowseEvents,scope:this});this.grid=new SYNO.SS.Grid.GridPanel({cls:"grid_row_height_fixed",store:SYNO.SS.GblStore.dsEventMount,border:false,viewConfig:{forceFit:true},deferRowRender:false,cm:a,sm:new Ext.grid.RowSelectionModel(),listeners:{rowcontextmenu:this.OnContextMenu,scope:this}});var b=function(){this.parentWin.panelEvtMount.OnEventMountAdd()};this.panelGridContainer=new SYNO.SS.Pgls.PglsGridContainerPanel({grid:this.grid,refreshFunction:this.OnRefresh,refreshFunctionScope:this,emptyStyleMonStore:SYNO.SS.GblStore.dsEventMount,emptyStyleTip:_T("event_achieving","no_mount_tip"),emptyStyleTipFunc:b.createDelegate(this)});this.blDataInited=false},InitData:function(){this.OnRefresh()},InitEventHandler:function(){this.grid.getSelectionModel().on("rowselect",this.ChgButtonStatus,this);this.grid.getSelectionModel().on("rowdeselect",this.ChgButtonStatus,this);this.grid.on("celldblclick",this.OnBrowseEvents,this);var a=function(){this.OnRefresh()};this.mon(SYNO.SDS.StatusNotifier,"cmsDataUpdated",a,this);this.mon(SYNO.SDS.StatusNotifier,"evtExpDataUpdated",a,this)},Activate:function(){if(false===this.blDataInited){this.InitData();this.blDataInited=true}},RegStoreEvent:function(a){if(true===a){this.OnStoreLoad();SYNO.SS.GblStore.dsEventMount.on("beforeload",this.OnRefresh,this);SYNO.SS.GblStore.dsEventMount.on("load",this.OnStoreLoad,this)}else{SYNO.SS.GblStore.dsEventMount.un("beforeload",this.OnRefresh,this);SYNO.SS.GblStore.dsEventMount.un("load",this.OnStoreLoad,this);SYNO.SS.GblStore.dsEventMount.sortInfo=null}},GetSelectedItems:function(d){var a=this.grid.getSelectionModel().getSelections();var b=[];var c;for(c=0;c<a.length;c++){if((SYNO.SS.Event.MntStatus.DELETING!==a[c].data.status)&&(SYNO.SS.Event.MntStatus.CONFIGURING!==a[c].data.status)){if("delete"===d){b.push(a[c].id)}else{if(("enable"===d)!==a[c].data.enable){b.push(a[c].id)}}}}if(0==b.length){return null}return b.join(",")},OnEventMountAdd:function(){if(SYNO.SS.App.Event.Def.EVENT_MOUNT_NUM_LIMIT<=SYNO.SS.GblStore.dsEventMount.getCount()){this.parentWin.getMsgBox().alert(_T("event_achieving","event_mount"),String.format(_T("event_achieving","event_mount_alert_num_limit"),SYNO.SS.App.Event.Def.EVENT_MOUNT_NUM_LIMIT));return}if(this.dlgEventMountWizard&&(false==this.dlgEventMountWizard.hidden)){return}this.dlgEventMountWizard=new SYNO.SS.App.Event.MountWizard("dlgEventMountWizard",this.parentWin);this.mon(this.dlgEventMountWizard,"wizarddone",this.OnSubmitAddingMount,this);this.dlgEventMountWizard.show();this.dlgEventMountWizard.Activate()},DeletePreProcess:function(){this.parentWin.getMsgBox().confirm(_T("event_achieving","event_mount"),_T("event_achieving","mount_confirm_del"),this.OnEventMountDelete,this)},OnEventMountDelete:function(a){if("yes"===a){this.AjaxRequest({method:"Delete",params:{eventmountlist:this.GetSelectedItems("delete")},version:1})}},OnEventMountEnable:function(){var a=this.GetSelectedItems("enable");if(null!==a){this.AjaxRequest({method:"Enable",params:{eventmountlist:a},version:1})}},OnEventMountDisable:function(){var a=this.GetSelectedItems("disable");if(null!==a){this.AjaxRequest({method:"Disable",params:{eventmountlist:a},version:1})}},OnBrowseEvents:function(){var c=this.GetMountsStatus();var a,b;if(SYNO.SS.Event.MntStatus.NORMAL===c){this.ShowBrowseEvents(true)}else{switch(c){case SYNO.SS.Event.MntStatus.DISABLE:a=_T("event_achieving","mount_status_disabled");break;case SYNO.SS.Event.MntStatus.UNREACHABLE:a=_T("event_achieving","mount_status_unreachable");break;case SYNO.SS.Event.MntStatus.SERVER_DISCONN:a=_T("camera","conn_status_server_disconn");break;case SYNO.SS.Event.MntStatus.CONFIGURING:a=_T("visualstation","vs_status_configuring");break;case SYNO.SS.Event.MntStatus.DELETING:a=_T("camera","conn_status_deleting");break;default:a=_T("event_achieving","mount_status_unreachable");break}b=String.format(_T("event_achieving","mount_msg_unbrowasble_event"),a);this.Alert(b)}},GetMountsStatus:function(){var b=this.grid.getSelectionModel().getSelections();var c=b.length;var a;var d;for(a=0;a<c;a++){d=b[a].get("status");if(SYNO.SS.Event.MntStatus.NORMAL!==d){return d}}return SYNO.SS.Event.MntStatus.NORMAL},ShowBrowseEvents:function(e){var d=SYNO.SS.Utils.StoreCopy(SYNO.SS.GblStore.dsEventMount,true,true);d.filter([{property:"status",value:SYNO.SS.Event.MntStatus.NORMAL,anyMatch:true,caseSensitive:true}]);var a=null;var c,f;var b=-1;if(true==e){f=this.grid.getSelectionModel().getSelected();if(!f){return}a=f.data.id;if(-1==d.findExact("id",f.data.id)){c=d.findExact("enable",true);if(-1==c){return}else{a=d.getAt(c).data.id}}}else{d.each(function(g){b=Math.max(b,g.get("id"))});c=d.getCount()-1;a=b}this.dlgBrowseEvents=Ext.WindowMgr.get("dlgBrowseEvents");if(!this.dlgBrowseEvents){this.dlgBrowseEvents=new SYNO.SS.App.Event.BrowseEvents("dlgBrowseEvents",this.parentWin,a,d)}this.dlgBrowseEvents.show();this.dlgBrowseEvents.Activate()},SubmitAddingLoadDone:function(a){if(!a){this.parentWin.getMsgBox().confirm(_T("event_achieving","event_mount"),_T("event_achieving","mount_auto_browse_events"),this.SubmitAddingLoadDone,this)}else{if(a=="yes"){this.ShowBrowseEvents(false)}}},OnRefresh:function(a){this.ClearUpdateTimeout();this.parentWin.setStatusBusy();SYNO.SS.GblStore.EventMountLoad(function(){this.parentWin.clearStatusBusy();if(Ext.isFunction(a)){a.call(this)}},this,{blGetSortInfo:true})},OnSubmitAddingMount:function(){this.parentWin.setStatusBusy();SYNO.SS.GblStore.EventMountLoad(function(){this.parentWin.clearStatusBusy();this.SubmitAddingLoadDone()},this,{blGetSortInfo:true})},OnContextMenu:function(c,g,d){var b;var a=false;if(!this.contextMenu){this.contextMenu=new SYNO.ux.Menu({items:[{itemId:"cmEnableMount",text:_T("ss_common","common_enable"),scope:this,handler:this.OnEventMountEnable},{itemId:"cmDisableMount",text:_T("ss_common","common_disable"),scope:this,handler:this.OnEventMountDisable},{itemId:"cmSeparatorMount",xtype:"menuseparator"},{itemId:"cmDeleteMount",text:_T("ss_common","common_delete"),scope:this,handler:this.DeletePreProcess}]})}if(false===this.grid.getSelectionModel().isSelected(g)){this.grid.getSelectionModel().selectRow(g)}if((true===this.menuItemEnable.disabled)&&(true===this.menuItemDisable.disabled)&&(true===this.btnDelete.disabled)){return}if((false===this.menuItemEnable.disabled)||(false===this.menuItemDisable.disabled)){if(false===this.btnDelete.disabled){a=true}}var f=this.contextMenu;f.getComponent("cmEnableMount").setVisible(false===this.menuItemEnable.disabled);f.getComponent("cmDisableMount").setVisible(false===this.menuItemDisable.disabled);f.getComponent("cmSeparatorMount").setVisible(true===a);f.getComponent("cmDeleteMount").setVisible(false===this.btnDelete.disabled);d.stopEvent();this.contextMenu.showAt(d.getXY())},OnStoreLoad:function(){var b=SYNO.SS.GblStore.dsEventMount;var a=this.grid.getSelectionModel();if(0==a.getSelections().length){a.selectFirstRow()}this.ChgButtonStatus();if((0<=b.findExact("status",SYNO.SS.Event.MntStatus.CONFIGURING))||(0<=b.findExact("status",SYNO.SS.Event.MntStatus.DELETING))){this.timerUpdateTimeout=window.setTimeout(function(){SYNO.SS.GblStore.EventMountLoad(undefined,undefined,{blGetSortInfo:true})},5000)}},ChgButtonStatus:function(){var g=this.grid.getSelectionModel().getSelections();var a=true;var f=false;var d=false;var c=SYNO.SS.GblStore.dsEventMount.getCount();var e=this.GetMountsStatus();var b;for(b=0;b<g.length;b++){if((SYNO.SS.Event.MntStatus.CONFIGURING===g[b].data.status)||(SYNO.SS.Event.MntStatus.DELETING===g[b].data.status)){a=false}if(true===g[b].data.enable){f=true}else{d=true}}this.btnBrowseEvents.disable();this.btnDelete.disable();this.btnEnable.disable();this.btnBrowseEvents.disable();this.menuItemEnable.setDisabled(true);this.menuItemDisable.setDisabled(true);if(0<g.length){if(true==a){this.btnDelete.enable();this.btnEnable.enable();this.menuItemEnable.setDisabled(false===d);this.menuItemDisable.setDisabled(false===f)}if(SYNO.SS.Event.MntStatus.NORMAL===e){this.btnBrowseEvents.enable()}}},Alert:function(b){var a=(b)?b:_T("ss_common","error_system");this.parentWin.getMsgBox().alert(_T("event_achieving","event_mount"),a)},ClearUpdateTimeout:function(){if(this.timerUpdateTimeout){window.clearTimeout(this.timerUpdateTimeout);delete this.timerUpdateTimeout;this.timerUpdateTimeout=null}},AjaxRequest:function(a){this.parentWin.setStatusBusy();this.sendWebAPI(Ext.apply({api:"SYNO.SurveillanceStation.Recording.Mount",callback:this.OnAjaxRequestDone,scope:this},a))},OnAjaxRequestDone:function(d,a,b){var c=null;this.parentWin.clearStatusBusy();if(d){c=function(){SYNO.SDS.StatusNotifier.fireEvent("updateCamera",b.eventmountlist,SYNO.SS.App.TaskQ.Def.UPDATE_TYPE.UPDATE_MOUNT)}}else{this.Alert(SYNO.API.getErrorString(a))}this.OnRefresh(c)},RenderRowColor:function(a){var b=SYNO.SS.Color.NORMAL_BLACK;if(SYNO.SS.Event.MntStatus.DISABLE===a.get("status")){b=SYNO.SS.Color.DISABLED_GRAY}return b},RenderStatusIcon:function(d,f,b){var e=b.get("status");var c="";var a;if((SYNO.SS.Event.MntStatus.CONFIGURING===e)||(SYNO.SS.Event.MntStatus.DELETING===e)){if(SYNO.SS.Event.MntStatus.CONFIGURING===e){a=_T("visualstation","vs_status_configuring")}else{if(SYNO.SS.Event.MntStatus.DELETING===e){a=_T("camera","conn_status_deleting")}}c=String.format('<img src="{0}" ext:qtip="{1}" width="16" height="16" style="vertical-align: middle;">',_IMG(SYNO.SS.Image.Loading16),a)}return c},RenderName:function(c,d,a){var b=this.RenderRowColor(a);return String.format("<span style='color:{0}'>{1}</span>",b,c)},RenderTime:function(c,d,a){var b=this.RenderRowColor(a);return String.format("<span style='color:{0}'>{1}</span>",b,GenLocalDateTimeStr(c*TRANS_MILLISECOND,false))},RenderServer:function(c,e,a){var b=this.RenderRowColor(a);var d=SYNO.SS.GblStore.GetDsName(a.get("dsId"));a.data.dsName=d;return String.format("<span style='color:{0}'>{1}</span>",b,d)},RenderStatus:function(d,e,b){var a;var c;switch(d){case SYNO.SS.Event.MntStatus.NORMAL:a=_T("event_achieving","mount_status_normal");c=SYNO.SS.Color.NORMAL_BLACK;break;case SYNO.SS.Event.MntStatus.DISABLE:a=_T("event_achieving","mount_status_disabled");c=SYNO.SS.Color.DISABLED_GRAY;break;case SYNO.SS.Event.MntStatus.UNREACHABLE:a=_T("event_achieving","mount_status_unreachable");c=SYNO.SS.Color.ALERT_RED;break;case SYNO.SS.Event.MntStatus.SERVER_DISCONN:a=_T("camera","conn_status_server_disconn");c=SYNO.SS.Color.ALERT_RED;break;case SYNO.SS.Event.MntStatus.CONFIGURING:a=_T("visualstation","vs_status_configuring");c=SYNO.SS.Color.NORMAL_BLACK;break;case SYNO.SS.Event.MntStatus.DELETING:a=_T("camera","conn_status_deleting");c=SYNO.SS.Color.NORMAL_BLACK;break;default:a=_T("event_achieving","mount_status_unreachable");c=SYNO.SS.Color.ALERT_RED;break}return String.format("<span valign='center' style='color:{0}'>{1}</span>",c,a)}});Ext.define("SYNO.SS.App.Event.BrowseEvents",{extend:"SYNO.SDS.ModalWindow",mountId:0,filteredStore:null,panel:null,labelSelectMount:null,cmbboxMount:null,btnOK:null,btnCancel:null,winInst:null,constructor:function(e,a,d,c){this.mountId=d;this.filteredStore=c;this.winInst=a;this.Init();var b={id:e,owner:a,title:_T("event_achieving","mount_browse_events"),width:480,height:400,layout:"fit",bodyStyle:"padding: 0px;",items:[this.panel],buttons:[this.btnOK,this.btnCancel]};SYNO.SS.Utils.PrepareWndHelpIcon(b,MODULE_ID_EVENT_LIST,"b_events");this.callParent([b])},Init:function(){this.btnOK=new SYNO.ux.Button({text:_T("ss_common","common_ok"),btnStyle:"blue",handler:this.OnOK,scope:this});this.btnCancel=new SYNO.ux.Button({text:_T("ss_common","common_cancel"),handler:this.close,scope:this});this.labelSelectMount=new Ext.form.Label({cls:"x-form-item margin_bottom_12",text:_T("event_achieving","mount_select_mount")});this.cmbboxMount=new SYNO.ux.ComboBox({fieldLabel:_T("event_achieving","event_mount"),width:215,labelStyle:"width: "+130+"px;",store:this.filteredStore,valueField:"id",displayField:"name",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,lastQuery:"",listeners:{select:this.LoadCamList,scope:this}});this.dsCamList=new Ext.data.JsonStore({autoDestroy:true,root:"camera",fields:[{name:"name"}]});this.gridCamera=new SYNO.SS.Grid.GridPanel({store:this.dsCamList,width:400,height:200,cls:"evt-mount-browse-grid",autoExpandColumn:"browse_cam_name",cm:new Ext.grid.ColumnModel([{id:"browse_cam_name",header:_T("camera_group","camera_group_cameras"),sortable:true,dataIndex:"name"}]),sm:new Ext.grid.RowSelectionModel(),viewConfig:{forceFit:true}});this.panel=new SYNO.ux.FormPanel({bodyStyle:"padding: 15px;",items:[this.labelSelectMount,this.cmbboxMount,this.gridCamera]})},LoadCamList:function(){var d;var e=[];var b=null;var c=this.cmbboxMount.getValue();var a=this.filteredStore.findExact("id",c);if(-1===a){return}b=this.filteredStore.getAt(a).data.camlist;for(d=0;d<b.length;d++){e.push({name:b[d].name})}this.dsCamList.loadData({camera:e})},Activate:function(){this.cmbboxMount.setValue(this.mountId);this.LoadCamList()},OnOK:function(){this.close();this.winInst.FilterMountEvtById(this.cmbboxMount.getValue())}});