/* Copyright (c) 2018 Synology Inc. All rights reserved. */

Ext.define("SYNO.SS.App.Snapshot.SnapshotFilter",{extend:"SYNO.SS.Form.FilterPanel",chkboxLocked:null,cmbLocked:null,chkboxModified:null,cmbModified:null,chkboxDateFrom:null,chkboxDateTo:null,dateFrom:null,timeFrom:null,dateTo:null,timeTo:null,chkboxKeyword:null,fldKeyword:null,parentWin:null,constructor:function(c){this.parentWin=c;this.Init();var b={cls:"filter-panel-lhs",defaults:{cls:"filter-setting-group"},items:[{items:[this.chkboxLocked,this.cmbLocked]},{items:[this.chkboxModified,this.cmbModified]},{items:[this.chkboxDateFrom,{cls:"filter-date-and-time",layout:"hbox",items:[this.dateFrom,this.timeFrom]}]},{items:[this.chkboxDateTo,{cls:"filter-date-and-time",layout:"hbox",items:[this.dateTo,this.timeTo]}]},{items:[this.chkboxKeyword,this.fldKeyword]}]};var a={layout:"column",items:[b],blOneColumn:true,okHandler:this.OnOK,cancelHandler:this.OnCancel,btnHandlerScope:this};this.callParent([a])},Init:function(){this.chkboxLocked=new SYNO.ux.Checkbox({boxLabel:_T("event","event_col_archive"),listeners:{check:function(b,a){if(a){this.cmbLocked.enable()}else{this.cmbLocked.disable()}},scope:this}});this.cmbLocked=new SYNO.ux.ComboBox({blInFilterPanel:true,store:new Ext.data.ArrayStore({data:[[SYNO.SS.App.Snapshot.Def.IMG_LOCKED,_T("extlang","yes")],[SYNO.SS.App.Snapshot.Def.IMG_UNLOCKED,_T("extlang","no")]],fields:["id","name"]}),valueField:"id",displayField:"name",value:SYNO.SS.App.Snapshot.Def.IMG_LOCKED,mode:"local",editable:false,disabled:true,forceSelection:true});this.chkboxModified=new SYNO.ux.Checkbox({boxLabel:_T("snapshot","modified"),listeners:{check:function(b,a){if(a){this.cmbModified.enable()}else{this.cmbModified.disable()}},scope:this}});this.cmbModified=new SYNO.ux.ComboBox({blInFilterPanel:true,store:new Ext.data.ArrayStore({data:[[SYNO.SS.App.Snapshot.Def.IMG_MODIFIED,_T("extlang","yes")],[SYNO.SS.App.Snapshot.Def.IMG_NOT_MODIFIED,_T("extlang","no")]],fields:["id","name"]}),valueField:"id",displayField:"name",value:SYNO.SS.App.Snapshot.Def.IMG_MODIFIED,mode:"local",editable:false,disabled:true,forceSelection:true});this.chkboxDateFrom=new SYNO.ux.Checkbox({boxLabel:_T("event","event_time_from"),listeners:{check:function(b,a){if(a){this.dateFrom.enable();this.timeFrom.enable()}else{this.dateFrom.disable();this.timeFrom.disable()}this.SetProperDateTo(this.dateFrom,this.dateFrom.getValue())},scope:this}});this.dateFrom=new SYNO.ux.DateField({emptyText:"Select date",format:"Y/m/d",blInFilterPanel:true,hideLabel:true,disabled:true,editable:false,value:new Date(),menu:new Ext.menu.DateMenu({hideOnClick:false,allowOtherMenus:true,ignoreParentClicks:true}),listeners:{select:this.SetProperDateTo,scope:this}});this.timeFrom=new SYNO.ux.TimeField({blInFilterPanel:true,hideLabel:true,emptyText:"Select time",format:"H:i",disabled:true,editable:false,value:"00:00",listeners:{select:this.SetProperTimeTo,scope:this}});this.chkboxDateTo=new SYNO.ux.Checkbox({boxLabel:_T("event","event_time_to"),listeners:{check:function(b,a){if(a){this.dateTo.enable();this.timeTo.enable()}else{this.dateTo.disable();this.timeTo.disable()}this.SetProperDateFrom(this.dateTo,this.dateTo.getValue())},scope:this}});this.dateTo=new SYNO.ux.DateField({emptyText:"Select date",format:"Y/m/d",blInFilterPanel:true,hideLabel:true,disabled:true,editable:false,value:new Date(new Date().getTime()+DAY_MILLISECOND),menu:new Ext.menu.DateMenu({hideOnClick:false,focusOnSelect:false,allowOtherMenus:true}),listeners:{select:this.SetProperDateFrom,scope:this}});this.timeTo=new SYNO.ux.TimeField({name:"timeTo",blInFilterPanel:true,hideLabel:true,emptyText:"Select time",format:"H:i",disabled:true,editable:false,value:"00:00"});this.chkboxKeyword=new SYNO.ux.Checkbox({boxLabel:_T("ss_common","keyword"),listeners:{check:function(b,a){if(a){this.fldKeyword.enable();this.fldKeyword.focus()}else{this.fldKeyword.disable();this.fldKeyword.clearInvalid()}},scope:this}});this.fldKeyword=new SYNO.ux.TextField({maxLength:64,hideLabel:true,disabled:true,allowBlank:false})},SetProperDateTo:function(c,b){if(true===c.disabled){this.dateTo.setMinValue(null)}else{this.dateTo.setMinValue(b)}var a=new Date();if(b.getTime()>this.dateTo.getValue().getTime()){a.setTime(b.getTime()+DAY_MILLISECOND);this.dateTo.setValue(a)}this.SetProperTimeTo()},SetProperDateFrom:function(c,b){if(true===c.disabled){this.dateFrom.setMaxValue(null)}else{this.dateFrom.setMaxValue(b)}var a=new Date();if(b.getTime()<this.dateFrom.getValue().getTime()){a.setTime(b.getTime()-DAY_MILLISECOND);this.dateFrom.setValue(a)}this.SetProperTimeTo()},SetProperTimeTo:function(){var b=Date.parseDate(this.timeFrom.getValue(),"H:i");var a;if(this.dateFrom.getValue().getTime()===this.dateTo.getValue().getTime()){a=(true===this.dateFrom.disabled)?"00:00":this.timeFrom.getValue();this.timeTo.setMinValue(a);if(Date.parseDate(this.timeFrom.getValue(),"H:i").getTime()>Date.parseDate(this.timeTo.getValue(),"H:i").getTime()){if(b.getHours()==23){this.timeTo.setValue("23:45")}else{this.timeTo.setValue((b.getHours()+1)+":"+((b.getMinutes()==0)?"00":b.getMinutes()))}}}else{this.timeTo.setMinValue("00:00")}},DateToTimestamp:function(d,e){var c=d.format("Y/m/d")+" "+e+":00";var b=new Date(c);var a=ConvertTimestamp((b.getTime()/TRANS_MILLISECOND),false);return{convertedTimestamp:a,cmbTimestamp:(b.getTime()/TRANS_MILLISECOND)}},OnOK:function(){if(false===this.fldKeyword.isValid()){return}if(this.chkboxLocked.getValue()){this.parentWin.filterSetting.Locked=this.cmbLocked.getValue();this.parentWin.filterSetting.chkLocked=true}else{this.parentWin.filterSetting.Locked=0;this.parentWin.filterSetting.chkLocked=false}if(this.chkboxModified.getValue()){this.parentWin.filterSetting.Modified=this.cmbModified.getValue();this.parentWin.filterSetting.chkModified=true}else{this.parentWin.filterSetting.Modified=0;this.parentWin.filterSetting.chkModified=false}var a;if(this.chkboxDateFrom.getValue()){a=this.DateToTimestamp(this.dateFrom.getValue(),this.timeFrom.getValue());this.parentWin.filterSetting.timestampFrom=a.convertedTimestamp;this.parentWin.filterSetting.timestampClientFrom=a.cmbTimestamp;this.parentWin.filterSetting.chkDateFrom=true}else{this.parentWin.filterSetting.chkDateFrom=false;this.parentWin.filterSetting.timestampFrom=0;this.parentWin.filterSetting.timestampClientFrom=0}if(this.chkboxDateTo.getValue()){a=this.DateToTimestamp(this.dateTo.getValue(),this.timeTo.getValue());this.parentWin.filterSetting.timestampTo=a.convertedTimestamp;this.parentWin.filterSetting.timestampClientTo=a.cmbTimestamp;this.parentWin.filterSetting.chkDateTo=true}else{this.parentWin.filterSetting.chkDateTo=false;this.parentWin.filterSetting.timestampTo=0;this.parentWin.filterSetting.timestampClientTo=0}this.parentWin.filterSetting.chkKeyword=this.chkboxKeyword.getValue();if(true===this.parentWin.filterSetting.chkKeyword){this.parentWin.filterSetting.strKeyword=this.fldKeyword.getValue()}else{this.parentWin.filterSetting.strKeyword=""}this.parentWin.ShowFilterPanel(this.IsNeedFilter());this.parentWin.StartFilter();this.HideBox()},OnCancel:function(){this.HideBox()},OnReset:function(){var a=new Date();var b=new Date(a.getTime()+DAY_MILLISECOND);this.chkboxLocked.setValue(false);this.chkboxModified.setValue(false);this.chkboxKeyword.setValue(false);this.chkboxDateFrom.setValue(false);this.dateFrom.setValue(a);this.dateFrom.clearInvalid();this.timeFrom.reset();this.chkboxDateTo.setValue(false);this.dateTo.setValue(b);this.dateTo.clearInvalid();this.timeTo.reset();this.fldKeyword.setValue("")},IsNeedFilter:function(){var b=false;var a=[this.chkboxLocked,this.chkboxModified,this.chkboxDateFrom,this.chkboxDateTo,this.chkboxKeyword];Ext.each(a,function(c){if(true==c.getValue()){b=true;return false}});return b}});Ext.define("SYNO.SS.App.Snapshot.AdvancedPanel",{extend:"SYNO.SDS.Utils.FormPanel",parentWin:null,advancedSetting:{},chkAddTimestamp:null,cmbboxPosition:null,cmbboxSortInfo:null,cmbboxNamingRule:null,chkLimitSize:null,textLimitSizeInMB:null,dsRecShareList:null,cmbboxSharelist:null,panelSharePath:null,chkLimitTime:null,textLimitTimeInDate:null,WAITING_IMG_ID:"SNAPSHOT_ADVANCE_WAITING_IMG",WAITING_TEXT_ID:"SNAPSHOT_ADVANCE_WAITING_TEXT",CHKBOX_WIDTH:345,CMBBOX_WIDTH:200,UPDATE_POLLING_INTVAL_MS:5000,ROTATION_BY_DATE_MAX:1000,MIN_SNAPSHOT_LIMIT_SIZE_MB:10,constructor:function(a){this.parentWin=a;this.Init();this.callParent([{border:false,trackResetOnLoad:true,cls:"management_panel snapshot_advance_panel",title:_T("ss_common","advanced"),bodyStyle:"padding:0px 0px 0px 0px",disabled:(SYNO.SS.UserPrivType.ADMIN!==_S("USER_PRIVILEGE")),buttons:[new SYNO.ux.Button({text:_T("ss_mail","mail_save"),btnStyle:"blue",handler:this.OnSave,scope:this}),new SYNO.ux.Button({text:_T("ss_common","close"),handler:function(){this.parentWin.close()},scope:this})],items:[new SYNO.ux.FieldSet({title:_T("watermark","setting"),autoHeight:true,collapsible:true,items:[this.cmbboxSortInfo,this.cmbboxNamingRule,this.chkAddTimestamp,this.cmbboxPosition]}),new SYNO.ux.FieldSet({title:_T("snapshot","archive"),autoHeight:true,collapsible:true,items:[{xtype:"container",layout:"hbox",items:[this.chkLimitSize,this.textLimitSizeInMB],style:"padding-bottom: 5px"},{xtype:"container",layout:"hbox",items:[this.chkLimitTime,this.textLimitTimeInDate],style:"padding-bottom: 5px"},this.cmbboxSharelist,this.fieldSharePath]})],scope:this}]);this.WAITING_IMG_ID=this.WAITING_IMG_ID+"-"+this.id;this.WAITING_TEXT_ID=this.WAITING_TEXT_ID+"-"+this.id;this.mon(this,"open",this.onOpen,this);this.mon(SYNO.SDS.StatusNotifier,"snapshot_share_edited",this.LoadShareList,this)},Activate:function(){this.LoadShareList()},onOpen:function(){SYNO.SS.App.Snapshot.Utils.WebAPIRequestForSetting(this.LoadSetting.createDelegate(this),this.parentWin.ownerDsId)},Init:function(){this.advancedSetting=SYNO.SS.App.Snapshot.Utils.advancedSetting;this.cmbboxSortInfo=new SYNO.ux.ComboBox({name:"sortInfo",value:0,fieldLabel:_T("snapshot","snapshot_sort_rule"),labelWidth:this.CHKBOX_WIDTH,valueField:"value",displayField:"sortInfo",boxMaxWidth:this.CMBBOX_WIDTH,store:new Ext.data.ArrayStore({autoDestroy:true,fields:["value","sortInfo"],data:[[SYNO.SS.App.Snapshot.Def.TimeInfo.TAKE_SNAPSHOT_TIME,_T("snapshot","snapshot_time")],[SYNO.SS.App.Snapshot.Def.TimeInfo.VIDEO_TIME,_T("snapshot","video_time")]]})});this.cmbboxNamingRule=new SYNO.ux.ComboBox({name:"namingRule",value:0,fieldLabel:_T("snapshot","naming_rule"),labelWidth:this.CHKBOX_WIDTH,valueField:"value",displayField:"namingRule",boxMaxWidth:this.CMBBOX_WIDTH,store:new Ext.data.ArrayStore({autoDestroy:true,fields:["value","namingRule"],data:[[SYNO.SS.App.Snapshot.Def.TimeInfo.TAKE_SNAPSHOT_TIME,_T("snapshot","snapshot_time")],[SYNO.SS.App.Snapshot.Def.TimeInfo.VIDEO_TIME,_T("snapshot","video_time")]]})});this.chkAddTimestamp=new SYNO.SS.Form.Checkbox({name:"addTimestamp",boxLabel:_T("snapshot","append_timestamp"),hideLabel:true,autoHeight:true,handler:function(a,b){this.cmbboxPosition.setDisabled(!b)},scope:this});this.cmbboxPosition=new SYNO.ux.ComboBox({name:"timestampPosition",disabled:true,value:LOCAL_DS_ID,fieldLabel:_T("camera","cam_param_position"),valueField:"id",displayField:"name",labelWidth:this.CHKBOX_WIDTH,indent:1,boxMaxWidth:this.CMBBOX_WIDTH,store:new Ext.data.ArrayStore({autoDestroy:true,fields:["id","name"],data:[[SYNO.SS.App.Snapshot.Def.TimestampPosition.TOP,_T("camera","cam_param_top")],[SYNO.SS.App.Snapshot.Def.TimestampPosition.BOTTOM,_T("camera","cam_param_bottom")]]})});this.chkLimitSize=new SYNO.SS.Form.Checkbox({name:"limitTotalSize",boxLabel:_T("snapshot","filesize_limit")+" ("+_T("ss_common","size_mb")+")",hideLabel:true,autoHeight:true,width:this.CHKBOX_WIDTH,scope:this,handler:function(a,b){this.textLimitSizeInMB.setDisabled(!b)}});this.textLimitSizeInMB=new SYNO.ux.TextField({name:"limitSizeInMB",hideLabel:true,width:this.CMBBOX_WIDTH,disabled:true,allowBlank:false,vtype:"integer",validator:this.IsValidVolSize.createDelegate(this),validateOnBlur:true,validationEvent:"blur"});this.chkLimitTime=new SYNO.SS.Form.Checkbox({name:"limitByTime",boxLabel:_T("camera","camera_rotate_by_date")+" ("+_T("camera","camera_rotate_days")+")",hideLabel:true,autoHeight:true,width:this.CHKBOX_WIDTH,scope:this,handler:function(a,b){this.textLimitTimeInDate.setDisabled(!b)}});this.textLimitTimeInDate=new SYNO.ux.TextField({name:"limitTimeInDate",hideLabel:true,width:this.CMBBOX_WIDTH,maxLength:5,disabled:true,allowBlank:false,vtype:"integer",validator:this.IsValidDateLimit.createDelegate(this),validateOnBlur:true,validationEvent:"blur",invalidText:String.format(_T("event_detection","enter_value_between"),1,this.ROTATION_BY_DATE_MAX)});this.dsRecShareList=new SYNO.API.JsonStore({appWindow:this,api:"SYNO.SurveillanceStation.Share",method:"ListRecShare",version:1,autoDestroy:true,dsId:this.parentWin.ownerDsId,root:"sharelist",id:"shareId",baseParams:{blIncldMigrating:true,blIncldEncUnmount:true,blIncldRemoteAbnormal:true},fields:[{name:"shareId"},{name:"shareIdOnRec"},{name:"shareName"},{name:"sharePath"},{name:"shareVolume"},{name:"displayName"},{name:"mountType"},{name:"quota"}],listeners:{load:function(b,a,c){this.parentWin.clearStatusBusy();SYNO.SS.Utils.PatchRecShareConcatName(a,this.parentWin.ownerDsId);this.cmbboxSharelist.setValue(this.cmbboxSharelist.getValue())},loadexception:function(){this.parentWin.clearStatusBusy()},scope:this}});this.cmbboxSharelist=new SYNO.ux.ComboBox({name:"storagePath",fieldLabel:_T("snapshot","recording_storage"),cls:"ellipsis_text",store:this.dsRecShareList,valueField:"sharePath",displayField:"concat_display_name",forceSelection:true,labelWidth:this.CHKBOX_WIDTH,allowBlank:false,editable:false,listeners:{afterrender:function(e){var d=document.createElement("a");var b=SYNO.SS.Utils.CreateNonDraggableImg();var a=document.createElement("a");var c=document.createTextNode(_T("camera","migrating"));b.setAttribute("src",_IMG(SYNO.SS.Image.Syncing));b.setAttribute("style",SYNO.SS.Utils.GetTipImgStyle(30,0));b.setAttribute("id",this.WAITING_IMG_ID);d.appendChild(b);a.setAttribute("id",this.WAITING_TEXT_ID);a.setAttribute("class","snapshot-advance-waiting-text");a.appendChild(c);Ext.getDom(e.getEl()).parentNode.appendChild(d);Ext.getDom(e.getEl()).parentNode.appendChild(a);e.ShowTip(false)},select:function(){this.textLimitSizeInMB.validate()},scope:this},ShowTip:function(a){var c=Ext.getDom(this.WAITING_IMG_ID);var b=Ext.getDom(this.WAITING_TEXT_ID);if(a){if(c){c.style.display=""}if(b){b.style.display=""}}else{if(c){c.style.display="none"}if(b){b.style.display="none"}}}.createDelegate(this),setValue:function(a){SYNO.ux.ComboBox.superclass.setValue.apply(this.cmbboxSharelist,arguments);this.SetPathLabel(a)}.createDelegate(this)});this.fieldSharePath=new SYNO.ux.DisplayField({cls:"ellipsis_text",isDirty:function(){return false}})},OnRefresh:function(){this.setStatusBusy();SYNO.SS.App.Snapshot.Utils.WebAPIRequestForSetting(this.OnRefreshDone.createDelegate(this))},OnRefreshDone:function(){this.LoadSetting();this.clearStatusBusy()},LoadSetting:function(){this.advancedSetting=SYNO.SS.App.Snapshot.Utils.advancedSetting;if(!this.advancedSetting){return}var a=new Ext.data.Record(this.advancedSetting);this.getForm().loadRecord(a);if((false===this.IsSnapshotShareExist())&&(false===this.disabled)){this.parentWin.tabPanel.setActiveTab(this.parentWin.tabIndex.ADVANCED)}},OnSave:function(){if(!this.getForm().isValid()){this.setStatusError({text:_T("ss_common","forminvalid"),clear:true});return}if(!this.IsFormDirty()){this.setStatusError({text:_T("ss_common","setting_nochange")});return}var a={};this.getForm().items.items.forEach(function(c,b){a[c.getName()]=c.getValue()},this);this.WebAPIRequest("SYNO.SurveillanceStation.SnapShot",1,"SaveSetting",a,this.OnSaveDone)},OnSaveDone:function(a){if((false===this.IsSnapshotShareExist())&&(""!==a.setting.storagePath)){SYNO.ux.EmptyStyle.RemoveStyle(this.parentWin.panelMultiView);this.parentWin.blListTabActivated=false}if((!this.advancedSetting)||(this.advancedSetting.sortInfo!==a.setting.sortInfo)){this.parentWin.blListTabActivated=false}SYNO.SS.App.Snapshot.Utils.advancedSetting=a.setting;this.LoadSetting();SYNO.SS.App.Snapshot.Utils.UpdateSnapshotSetting(false,this.parentWin.ownerDsId);this.CheckMigrating()},CheckMigrating:function(){this.RemoveProgressCheckTask();var a={api:"SYNO.SurveillanceStation.SnapShot",version:1,method:"MigratingStatus",dsId:this.parentWin.ownerDsId,params:{},callback:function(e,c,d,b){this.CheckMigratingDone(e,c)},scope:this};this.sendWebAPI(a)},CheckMigratingDone:function(b,a){if(b&&a&&(true===a.blMigrating)){this.cmbboxSharelist.ShowTip(true);this.cmbboxSharelist.setDisabled(true);this.PollingMigratingStatus()}else{this.cmbboxSharelist.ShowTip(false);this.cmbboxSharelist.setDisabled(false)}},RemoveProgressCheckTask:function(){if(this.progressCheckTask){this.progressCheckTask.cancel();this.progressCheckTask=null}},PollingMigratingStatus:function(){if(!this.progressCheckTask){this.progressCheckTask=new Ext.util.DelayedTask(this.CheckMigrating,this);this.progressCheckTask.delay(this.UPDATE_POLLING_INTVAL_MS)}},IsFormDirty:function(){var c=this.getForm();var a=this.fieldSharePath;var b=false;c.items.each(function(d){if(a===d){return true}if(true===d.isDirty()){b=true;return false}});return b},Alert:function(b){var a=(b)?b:_T("ss_common","error_system");this.parentWin.getMsgBox().alert(_T("ss_common","advanced"),a)},WebAPIRequest:function(b,a,f,d,e){this.setStatusBusy({text:_T("ss_common","common_saving")});var c={api:b,version:a,method:f,params:d,callback:function(j,h,i,g){this.OnWebAPIRequestDone(j,h,i,e)},scope:this};this.sendWebAPI(c)},OnWebAPIRequestDone:function(d,a,b,c){this.clearStatusBusy();if(!d){this.setStatusError({text:_T("ss_common","forminvalid"),clear:true});this.Alert(SYNO.API.getErrorString(a.code))}else{this.setStatusOK({text:_T("ss_common","setting_applied")});if((undefined!==c)&&("function"===(typeof c))){c.call(this,a)}}},IsValidVolSize:function(f){var e=parseInt(f,10);var c=this.MIN_SNAPSHOT_LIMIT_SIZE_MB;var b=this.dsRecShareList.find("sharePath",this.cmbboxSharelist.getValue());var d=this.dsRecShareList.getAt(b);var a=parseInt(((d)?d.get("quota"):0)*1024,10);if(0>=e){return String.format(_T("event_detection","enter_value_between"),c,a)}if(0===a){return true}if((e>a)||(c>e)){return String.format(_T("event_detection","enter_value_between"),c,a)}return true},IsValidDateLimit:function(b){var a=parseInt(b,10);if((0>=a)||(this.ROTATION_BY_DATE_MAX<a)){return false}return true},LoadShareList:function(){this.parentWin.setStatusBusy();this.dsRecShareList.load()},IsSnapshotShareExist:function(){if(this.advancedSetting){return(""!==this.advancedSetting.storagePath)}return true},SetPathLabel:function(b){var a="";if(""==b){this.fieldSharePath.getEl().dom.removeAttribute("ext:qtip");this.fieldSharePath.hide()}else{this.fieldSharePath.getEl().dom.setAttribute("ext:qtip",b);this.fieldSharePath.show()}b='<span class="snapshot-advance-share-location">'+b+"</span>";a=String.format(_T("snapshot","share_location"),b);this.fieldSharePath.setValue(a);this.fieldSharePath.originalValue=this.fieldSharePath.getValue()}});Ext.namespace("SYNO.SS.App.Snapshot");Ext.define("SYNO.SS.App.Snapshot.ExpandableListView",{extend:"SYNO.ux.ExpandableListView",owner:null,constructor:function(a){this.owner=a.owner;var b=Ext.apply({iconTpl:new Ext.XTemplate("{snapshotImage:this.RenderPreview}"),titleTpl:new Ext.XTemplate('{camName:this.RenderName}<span class="title-status">{locked:this.RenderStatus}</span>'),titleRightTpl:new Ext.XTemplate("{ownerDsId:this.RenderResolution}"),descTpl:new Ext.XTemplate("{displayTm:this.RenderCreateTm}"),descRightTpl:new Ext.XTemplate("{byteSize:this.RenderSize}")},a);this.callParent([b]);SYNO.SS.App.Snapshot.ExpViewUitls.AddTplRenderer(this.tpl,this)}});Ext.define("SYNO.SS.App.Snapshot.ExpandableIconView",{extend:"SYNO.ux.ExpandableIconView",owner:null,constructor:function(a){this.owner=a.owner;var b=Ext.apply({iconTpl:this.CreateIconTpl(),descTpl:this.CreateDescTpl(),innerTpl:this.CreateInnerTpl()},a);this.callParent([b]);SYNO.SS.App.Snapshot.ExpViewUitls.AddTplRenderer(this.tpl,this)},CreateIconTpl:function(){return new Ext.XTemplate(String.format('<img src="{snapshotImage}" class="{0} {1} {2}" onerror="this.src=\'{3}\';"><img src="{lockedImg}" class="{lockedCls}" style="display: {lockedDisplay}";><img src="{modifiedImg}" class="{modifiedCls}" style="display: {modifiedDisplay}";>',this.CLS_PREVIEW,this.CLS_RECT,IS_IE10_MINUS_BROWSER?this.CLS_PLAY_ICON_MASK:"",SYNO.SS.CameraPage.IMG_DISABLED[SYNO.SS.MultiView.ICON_VIEW_IDX]))},CreateDescTpl:function(){return this.getDescTpl(['<div ext:qtip="{camName}">{camName}</div>',"<div>{displayedTime}</div>"])},CreateInnerTpl:function(){var b=[{key:_T("camera","camera_attr_resolution"),value:"{width:this.RenderResolution}"},{key:_T("ss_common","common_filesize"),value:"{byteSize:this.RenderSize}"}];var c=this.getInnerKeyValTableTpl(b);var a=new Ext.XTemplate("<div>",c.html,"</div>");return a}});Ext.namespace("SYNO.SS.App.Snapshot.ExpViewUitls");Ext.apply(SYNO.SS.App.Snapshot.ExpViewUitls,{AddTplRenderer:function(b,a){var c=(a instanceof SYNO.SS.App.Snapshot.ExpandableIconView);b.appWin=a.owner;b.RenderPreview=function(g,e){var f=SYNO.SS.MultiView.LIST_VIEW_IDX;var h=e.recordId;e.snapshotImage=(!e.snapshotImage)?"data:image/jpeg;base64,"+e.imageData:e.snapshotImage;var d=String.format('<img src="{0}" class="snapshot_list_snapshot" onerror="this.src=SYNO.SS.CameraPage.IMG_DISABLED[{1}];">',e.snapshotImage,f);return'<div class="snapshot_list_preview_ct">'+d+"</div>"};b.RenderName=function(e,d){return String.format('<span ext:qtip="{0}">{0}</span>',e)};b.RenderStatus=function(f,e){var d=[];var g="";if(true===e.locked){d.push(_T("event","event_col_archive"))}if(0!==e.modifiedCnt){d.push(_T("snapshot","modified"))}d=d.join(" , ");g=(false===Ext.isEmpty(d))?"&nbsp;-&nbsp;<span>{0}</span>":"";return String.format(g,d)};b.RenderSrcServer=function(e,d){var f=SYNO.SS.Grid.Categ.ServerId2Name(e);if(true===c){return String.format("<span>{0}</span>",f)}else{return String.format("<span>[{0}]</span>",f)}};b.RenderResolution=function(e,d){return String.format("<span>{0}x{1}</span>",d.width,d.height)};b.RenderSize=function(f,d){var e=""+Math.round(f/1024)+" KB";return String.format("<span>{0}</span>",e)};b.RenderCreateTm=function(f,d){var e=this.appWin.gridCateg.curEntry.type;return String.format('<span ext:qtip="'+_T("snapshot","snapshot_time")+": {0}<br>"+_T("snapshot","video_time")+': {1}">{2}</span>',SYNO.SS.Grid.GenDateAndTimeStrOnly(d.createdTm,{}),SYNO.SS.Grid.GenDateAndTimeStrOnly(d.videoTm,{}),SYNO.SS.Grid.GenDateAndTimeStrOnly(f,{},e))}}});Ext.namespace("SYNO.SS.App.Snapshot");Ext.define("SYNO.SS.App.Snapshot.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SS.App.Snapshot.MainWindow"});Ext.define("SYNO.SS.App.Snapshot.MainWindow",{extend:"SYNO.SDS.TabPanelAppWindow",WIN_MIN_WIDTH:940,WIN_MIN_HEIGHT:515,MAX_PLAYER_CNT:5,SNAPSHOT_ID_PREFIX:"snapshot_preview_snapshot_",SNAPSHOT_MASK_ID_PREFIX:"snapshot_mask_snapshot_",tabIndex:{NONE:-1,LIST:0,ADVANCED:1},title:null,strKeyword:"",blFiltered:false,blListTabActivated:false,initViewMode:SYNO.SS.MultiView.LIST_VIEW_IDX,panelSnapshotList:null,panelMultiView:null,panelFilter:null,dvSnapshotList:null,dsCateg:null,gridCateg:null,gridSnapshotList:null,panelSnapshot:null,panelAdvanced:null,blDataLoading:false,cbDataLoad:null,dsSnapshot:null,btnEdit:null,btnDownload:null,btnDelete:null,btnLock:null,btnFilter:null,menuLock:null,menuUnLock:null,btnSwitchView:null,contextMenu:null,categContextMenu:null,panelCategContainer:null,maskMgr:null,idPostFix:null,idList:{},panelFilterInfo:null,blOnFilter:false,filterSetting:null,constructor:function(a){SYNO.SS.App.Snapshot.winInst=this;this.idPostFix=a.appInstance.id;this.Init();this.callParent([Ext.apply({title:_T("ss_common","common_snapshot"),width:this.WIN_MIN_WIDTH,height:this.WIN_MIN_HEIGHT,minWidth:this.WIN_MIN_WIDTH,minHeight:this.WIN_MIN_HEIGHT,layout:"fit",resizable:true,blNoPadding:true,panelList:[this.panelSnapshot,this.panelAdvanced],tabIndex:this.tabIndex,plugins:[{ptype:"shortcutCreatePlugin",panelCateg:this.gridCateg,panelItems:this.panelMultiView,fnGetAppItemConfig:this.GetSnapshotItemShortcutConfig.createDelegate(this),fnGetAppCategConfig:this.GetSnapshotCategShortcutConfig.createDelegate(this)},{ptype:"shortcutLaunchPlugin",blPagelessApp:true,panelCateg:this.gridCateg,panelItems:this.panelMultiView,store:this.dsSnapshot,idProperty:"recordId",fnCheckItemValid:this.CheckSnapshotValid.createDelegate(this),fnCancelFilter:this.CancelFilterIfExist.createDelegate(this)}]},a)]);this.InitEventHandler()},onBeforeDestroy:function(){SYNO.SS.App.Snapshot.winInst=null;this.callParent(arguments)},onOpen:function(a){this.callParent(arguments);this.Activate();this.fireEvent("shortcutOnOpen",a);this.ownerDsId=this.getAppDSId();this.panelAdvanced.fireEvent("open")},onRequest:function(a){this.callParent(arguments);this.fireEvent("shortcutOnRequest",a)},onClose:function(){if(true===this.panelAdvanced.IsFormDirty()){SYNO.SS.Utils.ConfirmLostChange({msgBox:this.getMsgBox(),fnYes:function(){this.panelAdvanced.getForm().reset();this.close()},scope:this});return false}this.Deactivate();return true},getHelpParam:function(){if(this.tabIndex.LIST===this.GetCurrentTabIndex()){return"snapshot_list.html"}else{if(this.tabIndex.ADVANCED===this.GetCurrentTabIndex()){return"snapshot_advanced.html"}else{return""}}},Activate:function(c,b,a){Ext.dd.DragDropMgr.useCache=false;if(true===this.gridCateg.rendered){this.gridCateg.Reset()}this.ActivateTab();this.Resize();return true},Deactivate:function(){Ext.dd.DragDropMgr.useCache=true;this.blListTabActivated=false;return this.DeactivateTab()},CheckSnapshotValid:function(c){var d=c.itemId.split("_");var a=this.ownerDsId;var b=parseInt(d[1],10);this.WebAPIRequest("ChkSnapshotValid",{dsId:a,snapId:b},c.fnCallback.createDelegate(c.callbackScope))},Resize:function(){var d=this.GetCurrentTabIndex();var f=this.getInnerWidth();var b=this.getInnerHeight();var a,e,c;this.tabPanel.setSize(f,b);if((this.tabIndex.LIST===d)||(this.tabIndex.NONE===d)){a=this.panelSnapshot.body.getWidth();e=this.panelSnapshot.body.getHeight();if(true===this.blOnFilter){this.panelFilterInfo.setVisible(true);c=SYNO.SS.Ui.Height.FILTER_PANEL_DEFAULT}else{this.panelFilterInfo.setVisible(false);c=0}this.panelCategContainer.setSize(a,(e-c));this.panelCategContainer.syncSize();this.panelCategContainer.UpdateItemCnt()}},GetSnapshotItemShortcutConfig:function(a,c){var b=GenLocalDateTime(c.get("displayTm")*TRANS_MILLISECOND,true);Ext.apply(a,{title:String.format("<div>{0}</div><div>{1}</div>",c.get("camName")+"_"+b.date,b.time),icon:(!c.get("snapshotImage"))?"data:image/jpeg;base64,"+c.get("imageData"):c.get("snapshotImage")});Ext.apply(a.param,{blIconPathInModule:false,itemId:c.get("recordId"),blCmsApp:true,dsId:this.ownerDsId,iconError:SYNO.SS.Image.Camera.IconShortcutError,startTime:c.get("displayTm")*TRANS_MILLISECOND,categInfo:{entryVal:"",type:"date"}});Ext.apply(a,{launchParams:{"snapshot:snapshot_editor":{className:"SYNO.SS.App.SnapshotEditor.Application",filter:Ext.apply(this.GetFilterParams(true),{idList:c.get("id")}),recordId:c.get("recordId"),rowIdx:0,ownerDsId:this.ownerDsId}}});return a},GetSnapshotCategShortcutConfig:function(a,b){Ext.apply(a.param,{blCmsApp:true,dsId:this.ownerDsId});return a},Init:function(){this.title=_T("ss_common","common_snapshot");this.idList={DEL_SEL:this.GetItemUniqueId("snapshotMenuDelSelected"),DEL_CATEG:this.GetItemUniqueId("snapshotMenuDelCateg"),DEL_ALL:this.GetItemUniqueId("snapshotMenuDelAll"),LOCK_SEL:this.GetItemUniqueId("snapshotMenuLockSelected"),LOCK_CATEG:this.GetItemUniqueId("snapshotMenuLockCateg"),LOCK_ALL:this.GetItemUniqueId("snapshotMenuLockAll"),UNLOCK_SEL:this.GetItemUniqueId("snapshotMenuUnLockSelected"),UNLOCK_CATEG:this.GetItemUniqueId("snapshotMenuUnLockCateg"),UNLOCK_ALL:this.GetItemUniqueId("snapshotMenuUnLockAll")};this.panelAdvanced=this.CreateTabItemForGblSearch("SYNO.SS.App.Snapshot.AdvancedPanel",[this]);this.panelFilter=new SYNO.SS.App.Snapshot.SnapshotFilter(this);this.panelFilterInfo=new SYNO.ux.FilterInfo({fnCancel:this.OnFilterCancel,fnCancelScope:this,fnReload:this.panelFilter.OnOK,fnReloadScope:this.panelFilter});this.dsSnapshot=new SYNO.API.JsonStore({autoDestroy:true,appWindow:this,api:"SYNO.SurveillanceStation.SnapShot",version:1,method:"List",baseParams:{from:0,to:0,locked:0,modified:0},root:"data",totalProperty:"total",idProperty:"recordId",fields:SYNO.SS.App.Snapshot.Def.storeSnapshotListFields,listeners:{datachanged:function(){var c=this.gridCateg.GetTotalCount();if(0===c){this.ChgButtonStatus()}},scope:this}});this.btnEdit=new SYNO.ux.Button({text:_T("ss_common","common_edit"),cls:"btn_filter_tbar",handler:this.OnEdit,disabled:false,scope:this});this.btnDownload=new SYNO.ux.Button({text:_T("event","event_export"),cls:"btn_filter_tbar",handler:this.OnDownload,disabled:true,scope:this});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),cls:"btn_filter_tbar",menu:{items:[{id:this.idList.DEL_SEL,text:_T("event","delete_selected"),handler:this.DeletePreProcess,scope:this},{id:this.idList.DEL_CATEG,text:_T("event","delete_category"),handler:function(){this.DeleteFilterPreProcess(true)},scope:this},{id:this.idList.DEL_ALL,text:_T("ss_common","common_delete_all"),handler:function(){if(false===this.blOnFilter){this.DeleteAllPreProcess()}else{this.DeleteFilterPreProcess(false)}},scope:this}],listeners:{beforeshow:function(e){var d,c;d=(false===this.blOnFilter)?_T("event","delete_category"):_T("event","delete_filtered_category");c=e.items.itemAt(1);c.setText(d);d=(false===this.blOnFilter)?_T("ss_common","common_delete_all"):_T("event","delete_filtered");c=e.items.itemAt(2);c.setText(d)},scope:this}},CheckAvailItems:function(){var c=0;this.menu.items.each(function(d){if((false===d.hidden)&&(false===d.disabled)){c++}});return c}});this.btnFilter=new SYNO.SS.Form.FilterButton({iconCls:"icon_search",text:_T("ss_common","common_search"),tooltip:_T("ss_common","common_search"),panelFilterForm:this.panelFilter});this.panelFilter.SetToggleBtn(this.btnFilter);this.menuLock=new Ext.menu.Item({text:_T("ss_common","common_lock"),disabled:true,hideOnClick:false,menu:new SYNO.ux.Menu({items:[{id:this.idList.LOCK_SEL,text:_T("event","archive_lock_selected"),handler:this.OnLock,scope:this},{id:this.idList.LOCK_CATEG,text:_T("event","archive_lock_category"),handler:function(){this.OnLockFiltered(true)},scope:this},{id:this.idList.LOCK_ALL,text:_T("event","archive_lock_all"),handler:function(){if(false===this.blOnFilter){this.OnLockAll()}else{this.OnLockFiltered(false)}},scope:this}],listeners:{beforeshow:function(e){var d,c;d=(false===this.blOnFilter)?_T("event","archive_lock_category"):_T("event","archive_lock_filtered_category");c=e.items.itemAt(1);c.setText(d);d=(false===this.blOnFilter)?_T("event","archive_lock_all"):_T("event","archive_lock_filtered");c=e.items.itemAt(2);c.setText(d)},scope:this}})});this.menuUnLock=new Ext.menu.Item({text:_T("ss_common","common_unlock"),disabled:true,hideOnClick:false,menu:new SYNO.ux.Menu({items:[{id:this.idList.UNLOCK_SEL,text:_T("event","archive_unlock_selected"),handler:this.OnUnlock,scope:this},{id:this.idList.UNLOCK_CATEG,text:_T("event","archive_unlock_category"),handler:function(){this.OnUnlockFiltered(true)},scope:this},{id:this.idList.UNLOCK_ALL,text:_T("event","archive_unlock_all"),handler:function(){if(false===this.blFiltered){this.OnUnlockAll()}else{this.OnUnlockFiltered(false)}},scope:this}],listeners:{beforeshow:function(e){var d,c;d=(false===this.blOnFilter)?_T("event","archive_unlock_category"):_T("event","archive_unlock_filtered_category");c=e.items.itemAt(1);c.setText(d);d=(false===this.blOnFilter)?_T("event","archive_unlock_all"):_T("event","archive_unlock_filtered");c=e.items.itemAt(2);c.setText(d)},scope:this}})});this.btnLock=new SYNO.ux.Button({text:_T("ss_common","common_lock"),menu:{items:[this.menuLock,this.menuUnLock]}});this.gridSnapshotList=new SYNO.SS.App.Snapshot.ExpandableListView({owner:this,store:this.dsSnapshot,cls:"right_expandable_listView",listeners:{selectionchange:this.ChgButtonStatus,contextmenu:this.OnContextMenuListView,dblclick:function(c,f,d,g){SYNO.SS.IconView.OnClick(g,this.OnEdit,this)},scope:this},playIconOnPreview:true,fnPlay:this.OnEdit.createDelegate(this)});this.dvSnapshotList=new SYNO.SS.App.Snapshot.ExpandableIconView({owner:this,store:this.dsSnapshot,prepareData:this.PrepareDvSnapshotListData.createDelegate(this),listeners:{contextmenu:this.OnContextMenuIconView,selectionchange:this.ChgButtonStatus,dblclick:function(c,f,d,g){SYNO.SS.IconView.OnClick(g,this.OnEdit,this)},scope:this},playIconOnPreview:true,fnPlay:this.OnEdit.createDelegate(this)});this.dsCateg=new Ext.data.JsonStore({autoDestroy:true,fields:["id","type","category","entryName","entryVal","recCnt","date","grpHdrName","dsId"]});this.gridCateg=new SYNO.SS.Grid.CategoryGridPanel({cls:"flexcroll_extra_left",border:false,enableDragDrop:true,useSplitSwitchBtn:true,category:[SYNO.SS.Grid.Categ.CATEG_DATE],store:this.dsCateg,viewConfig:{forceFit:true},ShowContextMenu:this.ShowGridCategContextMenu.createDelegate(this)});this.panelMultiView=new SYNO.SS.MultiView.MultiViewPanel({grid:this.gridSnapshotList,dv:this.dvSnapshotList,btnSwitch:this.gridCateg.btnSwitch,initViewMode:this.initViewMode,listeners:{viewswitch:this.OnViewSwitch,scope:this},plugins:SYNO.SS.Pgls.CreatePglsPlugin({ptype:"synoSSPglsCategPlugin",store:this.dsSnapshot,gridCateg:this.gridCateg,pageSize:SYNO.SS.App.Snapshot.Def.SNAPSHOT_LIST_PAGE_SIZE,divLoadingHeight:64,GetParams:this.GetFilterParams.createDelegate(this),sortCfg:[{field:"displayTm",direction:"DESC"},{field:"recordId",direction:"DESC"}]})});this.btnSwitchView=this.panelMultiView.btnSwitch;this.btnSwitchView.menu.items.items[2].hide();this.btnSwitchView.menu.items.items[3].hide();this.panelSnapshotList=new SYNO.ux.Panel({region:"center",layout:"fit",border:false,items:[this.panelMultiView],bbar:new SYNO.SS.Pgls.BottomBar({panelRecord:this.panelMultiView,refreshFunction:this.OnRefresh,refreshFunctionScope:this})});var b=function(d,c){if(d){this.gridCateg.jsonRecCnt=c}this.dsRecord.resumeEvents();this.dsRecord.fireEvent("reload",this.dsRecord)};var a=(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.SNAPSHOT_VIEW))?_T("ss_privilege","no_authorized_snapshots"):_T("ss_common","no_item_category_tip");this.panelCategContainer=new SYNO.SS.Pgls.PglsCategContainerPanel({items:[this.gridCateg,this.panelSnapshotList],gridCateg:this.gridCateg,panelRecord:this.panelMultiView,labelItemCnt:this.panelSnapshotList.getBottomToolbar().labelItemCnt,dsRecord:this.dsSnapshot,countMethod:"CountByCategory",countParams:{limit:0,timezoneOffset:GetTimezoneOffset()},countCallback:b,EMPTY_MSG:a,GetParams:this.GetFilterParams.createDelegate(this),plugins:[SYNO.SS.AutoUpdate.CreatePlugin({fnRefresh:this.OnRefresh.createDelegate(this),fnCompare:function(d,c){if(d.data.displayTm>c.data.displayTm){return -1}else{if(d.data.displayTm<c.data.displayTm){return 1}else{if(d.id>c.id){return -1}else{if(d.id<c.id){return 1}else{return 0}}}}}})],listeners:{dataupdated:this.ChgButtonStatus,scope:this}});this.panelSnapshot=this.CreateTabItemForGblSearch("SYNO.SS.App.Snapshot.ListPanel",[{cls:"management_panel",title:_T("camera","list"),tbar:new SYNO.ux.Toolbar([this.btnEdit,this.btnDownload,this.btnDelete,this.btnLock,{xtype:"tbfill"},this.btnSwitchView,this.btnFilter]),items:[this.panelFilterInfo,this.panelCategContainer]}]);this.maskMgr=new SYNO.SS.App.Snapshot.MaskMgr(this);this.filterSetting={chkLocked:false,chkModified:false,chkDateTo:false,chkDateFrom:false,chkKeyword:false,Locked:0,Modified:0,timestampFrom:0,timestampTo:0,timestampClientFrom:0,timestampClientTo:0,strKeyword:""}},InitEventHandler:function(){var a;a=this.dsSnapshot;a.on("beforeload",this.OnBeforeLoadData,this);a.on("load",this.OnLoadData,this);a.on("exception",function(e,f,g,d,c,b){this.maskMgr.clearStatusBusy()},this);this.mon(this.tabPanel,"tabchange",this.OnTabChange,this);this.mon(this.tabPanel,"beforetabchange",this.OnBeforeTabChange,this);this.mon(SYNO.SDS.StatusNotifier,"snapshotUpdateStore",this.OnUpdateStore,this);this.panelFilterInfo.mon(this.gridCateg,"totalCntChanged",this.panelFilterInfo.UpdateRecCnt,this.panelFilterInfo);this.mon(this,"resize",this.Resize,this)},OnBeforeLoadData:function(a,b){this.blDataLoading=true},OnLoadData:function(c,b,d){var a=(false!==d.params.needMask);var e=this.gridCateg.curEntry.type;if(this.gridCateg.jsonRecCnt){this.gridCateg.SetTotalCount(this.gridCateg.jsonRecCnt.total)}this.gridCateg.ReloadDsCateg();this.Resize();this.blDataLoading=false;if(true===a){this.SetFilterInfoText();this.RefreshCategoryAllDates(e);this.maskMgr.clearStatusBusy()}if(this.cbDataLoad){this.cbDataLoad();this.cbDataLoad=null}this.fireEvent("shortcutDataReady")},RefreshCategoryAllDates:function(c){var a=this.gridCateg.curEntry;var b=(SYNO.SS.Grid.Categ.ENTRY_ALL!==c)&&(SYNO.SS.Grid.Categ.ENTRY_ALL===a.type);if(true===b){this.OnRefresh()}},ShowGridCategContextMenu:function(f){if(true===this.blDataLoading){this.cbDataLoad=this.ShowGridCategContextMenu.createDelegate(this,[f]);return}this.ChgButtonStatus();var b=!this.btnDelete.disabled&&!Ext.getCmp(this.idList.DEL_CATEG).disabled;var d=!this.menuLock.disabled&&!Ext.getCmp(this.idList.LOCK_CATEG).disabled;var c=!this.menuUnLock.disabled&&!Ext.getCmp(this.idList.UNLOCK_CATEG).disabled;var a=[];var g;if(true===b){a.push({text:_T("ss_common","common_delete"),scope:this,handler:function(){this.DeleteFilterPreProcess(true)}})}if(true===d){a.push({text:_T("ss_common","common_lock"),scope:this,handler:function(){this.OnLockFiltered(true)}})}if(true===c){a.push({text:_T("ss_common","common_unlock"),scope:this,handler:function(){this.OnUnlockFiltered(true)}})}if(0<a.length){a.push({itemId:"cmShortcutSeparator",xtype:"menuseparator"})}a.push({itemId:"cmAddDesktopShortcut",text:_T("desktop","add_desktop_shortcut"),handler:function(){this.fireEvent("shortcutOnAddCateg")},scope:this});g=new SYNO.ux.Menu({items:a});g.showAt(f.getXY())},PrepareDvSnapshotListData:function(e,c,b){var g;var a=this.GetStatus(e,SYNO.SS.MultiView.ICON_VIEW_IDX);var f=this.gridCateg.curEntry.type;var d=this.dvSnapshotList;e.snapshotImage=e.imageData?"data:image/jpeg;base64,"+e.imageData:SYNO.SS.CameraPage.IMG_DISABLED[SYNO.SS.MultiView.ICON_VIEW_IDX];Ext.apply(e,{lockedImg:a.lockStatus.img,lockedCls:a.lockStatus.cls,lockedDisplay:a.lockStatus.display});Ext.apply(e,{modifiedImg:a.modifiedStatus.img,modifiedCls:a.modifiedStatus.cls,modifiedDisplay:a.modifiedStatus.display});e.displayedTime=SYNO.SS.Grid.GenDateAndTimeStrOnly(e.displayTm,e,f,true);if(!e.serverName){e.serverName=SYNO.SS.GblStore.GetDsName(this.ownerDsId)}return e},GetStatus:function(d,a){var b={};var e={};var c=["snapshot_icon_view_status_first","snapshot_icon_view_status_second"];b.img="";b.tip="";b.cls="";b.display="none";e.img="";e.tip="";e.cls="";e.display="none";if(SYNO.SS.MultiView.ICON_VIEW_IDX===a){if(true===d.locked){b.img=_IMG(SYNO.SS.Image.StatusIconLock);b.tip=_T("event","event_status_locked");b.cls=c.shift();b.display=""}if(0!==d.modifiedCnt){e.img=_IMG(SYNO.SS.Image.StatusIconModified);e.tip=_T("snapshot","modified");e.cls=c.shift();e.display=""}}return{lockStatus:b,modifiedStatus:e}},ActivateTab:function(){switch(this.GetCurrentTabIndex()){case this.tabIndex.NONE:case this.tabIndex.LIST:if(false===this.blListTabActivated){this.OnFilterCancel();this.blListTabActivated=true}this.panelMultiView.ActivateDvRectSel(true);break;case this.tabIndex.ADVANCED:this.panelAdvanced.Activate();break;default:break}return true},DeactivateTab:function(a){if(this.tabIndex.LIST==this.GetCurrentTabIndex()){this.panelMultiView.ActivateDvRectSel(false)}else{if(this.tabIndex.ADVANCED==this.GetCurrentTabIndex()){if(false===this.panelAdvanced.IsSnapshotShareExist()){return false}if(true===this.panelAdvanced.IsFormDirty()){SYNO.SS.Utils.ConfirmLostChange({msgBox:this.getMsgBox(),fnYes:function(){this.panelAdvanced.getForm().reset();this.tabPanel.setActiveTab(a.getItemId())},scope:this});return false}}}return true},OnTabChange:function(){this.ActivateTab();this.Resize()},OnBeforeTabChange:function(a,b){return this.DeactivateTab(b)},InitContextMenu:function(){this.contextMenu=new SYNO.ux.Menu({items:[{itemId:"cmViewSnapshot",text:_T("ss_common","common_edit"),scope:this,handler:this.OnEdit},{itemId:"cmDownloadSnapshot",text:_T("event","event_export"),scope:this,handler:this.OnDownload},{itemId:"cmDeleteSnapshot",text:_T("ss_common","common_delete"),scope:this,handler:this.DeletePreProcess},{itemId:"cmLockSnapshot",text:_T("ss_common","common_lock"),scope:this,handler:this.OnLock},{itemId:"cmUnlockSnapshot",text:_T("ss_common","common_unlock"),scope:this,handler:this.OnUnlock},{itemId:"cmShortcutSeparator",xtype:"menuseparator"},{itemId:"cmAddDesktopShortcut",text:_T("desktop","add_desktop_shortcut"),handler:function(){this.fireEvent("shortcutOnAddItem")},scope:this}]})},OnContextMenuListView:function(b,a,c,d){d.stopEvent();if(false===b.isSelected(a)){b.select(a)}this.ShowContextMenu(d)},OnContextMenuIconView:function(d,a,f,g){var c=g.getTarget(d.itemSelector);var b=d.UpdateSelectionOnEvent(g,c);if((0>=b.length)||(null===c)){return}this.ShowContextMenu(g)},ShowContextMenu:function(b){var a;if(!this.contextMenu){this.InitContextMenu()}this.contextMenu.getComponent("cmViewSnapshot").hide();this.contextMenu.getComponent("cmDownloadSnapshot").hide();this.contextMenu.getComponent("cmDeleteSnapshot").hide();this.contextMenu.getComponent("cmLockSnapshot").hide();this.contextMenu.getComponent("cmUnlockSnapshot").hide();if(false===this.btnEdit.disabled){this.contextMenu.getComponent("cmViewSnapshot").show()}if(false===this.btnDownload.disabled){this.contextMenu.getComponent("cmDownloadSnapshot").show()}if((false===this.btnDelete.disabled)&&(false===Ext.getCmp(this.idList.DEL_SEL).disabled)){this.contextMenu.getComponent("cmDeleteSnapshot").show()}if((false===this.menuLock.disabled)&&(false===Ext.getCmp(this.idList.LOCK_SEL).disabled)){this.contextMenu.getComponent("cmLockSnapshot").show()}if((false===this.menuUnLock.disabled)&&(false===Ext.getCmp(this.idList.UNLOCK_SEL).disabled)){this.contextMenu.getComponent("cmUnlockSnapshot").show()}b.stopEvent();for(a=0;a<this.contextMenu.items.getCount();++a){if(false===this.contextMenu.items.get(a).hidden){this.contextMenu.showAt(b.getXY());break}}},OnViewSwitch:function(a,b){},OnEdit:function(){var c=this.GetFilterParams(true);var a=this.panelMultiView.GetSelected();var d=this.gridSnapshotList.getStore().indexOf(a);if(undefined===a){return}var b=a.get("recordId");var e={recordId:b,rowIdx:d,filter:c,cmsApp:true,ownerDsId:this.ownerDsId,appParams:{dsId:this.ownerDsId},alignWin:SYNO.SS.Utils.GetAlignWinParams(this),appWinId:SYNO.SDS.Utils.GetAppWinId(MODULE_ID_SNAPSHOT_EDITOR,this.ownerDsId,b)};SYNO.SDS.AppLaunch(SYNO.SS.Module.InstanceNameMap[MODULE_ID_SNAPSHOT_EDITOR],e,true)},OnDownload:function(){var a=this.panelMultiView.GetSelected();if(undefined===a){return}SYNO.SS.App.Snapshot.Utils.CheckFileExist(this.title,this.getMsgBox(),a,this.ownerDsId)},OnLock:function(){this.WebAPIRequest("Lock",{objList:this.GetSelectedObjList()},undefined,true)},OnLockFiltered:function(a){this.WebAPIRequest("LockFiltered",this.GetFilterParams(a),undefined,true)},OnLockAll:function(){this.WebAPIRequest("LockFiltered",this.GetFilterParams(false),undefined,true)},OnUnlock:function(){this.WebAPIRequest("Unlock",{objList:this.GetSelectedObjList()},undefined,true)},OnUnlockFiltered:function(a){this.WebAPIRequest("UnlockFiltered",this.GetFilterParams(a),undefined,true)},OnUnlockAll:function(){this.WebAPIRequest("UnlockFiltered",this.GetFilterParams(false),undefined,true)},OnRefresh:function(a){this.ReloadStore(a)},OnUpdateStore:function(){this.panelCategContainer.InstantUpdate()},ReloadStore:function(a){var b=this.GetFilterParams(true);b.start=0;b.limit=a?a:SYNO.SS.App.Snapshot.Def.SNAPSHOT_LIST_PAGE_SIZE;this.maskMgr.setStatusBusy();this.dsSnapshot.load({params:b})},SetBaseParamFromFitlerSetting:function(){this.dsSnapshot.setBaseParam("locked",this.filterSetting.Locked);this.dsSnapshot.setBaseParam("modified",this.filterSetting.Modified);this.dsSnapshot.setBaseParam("from",this.filterSetting.timestampFrom);this.dsSnapshot.setBaseParam("to",this.filterSetting.timestampTo);this.dsSnapshot.setBaseParam("keyword",this.filterSetting.strKeyword)},StartFilter:function(){this.SetBaseParamFromFitlerSetting();this.FilterList()},CancelFilterIfExist:function(){var a=false;if(true===this.blOnFilter){this.OnFilterCancel();a=true}return a},ResetFilter:function(){this.ShowFilterPanel(false);this.panelFilter.OnReset();this.ResetFilterSetting();this.StartFilter()},ResetFilterSetting:function(){this.filterSetting.chkLocked=false;this.filterSetting.chkModified=false;this.filterSetting.chkDateTo=false;this.filterSetting.chkDateFrom=false;this.filterSetting.chkKeyword=false;this.filterSetting.Locked=0;this.filterSetting.Modified=0;this.filterSetting.timestampFrom=0;this.filterSetting.timestampTo=0;this.filterSetting.timestampClientFrom=0;this.filterSetting.timestampClientTo=0;this.filterSetting.strKeyword=""},OnFilterCancel:function(){this.ResetFilter();this.ChgButtonStatus();this.FilterList()},FilterList:function(){this.panelMultiView.ScrollToTop();this.ReloadStore()},GetFilterParams:function(c){var e=Ext.apply({userId:_S("USER_ID")},this.dsSnapshot.baseParams);var b,d,a;e.locked=this.filterSetting.Locked;e.modified=this.filterSetting.Modified;e.from=this.filterSetting.timestampFrom;e.to=this.filterSetting.timestampTo;e.keyword=this.filterSetting.strKeyword;if(true===c){b=this.gridCateg.curEntry;switch(b.type){case SYNO.SS.Grid.Categ.ENTRY_DAY:case SYNO.SS.Grid.Categ.ENTRY_AM:case SYNO.SS.Grid.Categ.ENTRY_PM:d=SYNO.SS.Grid.Categ.GetTimeInSec(b.entryVal);a=ConvertTimestamp(d.end,false);e.from=Math.max(e.from,ConvertTimestamp(d.start,false));e.to=(0===e.to)?a:Math.min(e.to,a);break;default:break}}return e},SetFilterInfoText:function(){if(false===this.blOnFilter){return}var a={recCnt:this.gridCateg.GetTotalCount(),conditions:[]};if(true==this.filterSetting.chkLocked){a.conditions.push({header:_T("event","event_col_archive"),text:SYNO.SS.App.Snapshot.Utils.GetFilterStatusString(this.filterSetting.Locked),fnCancel:function(){this.chkboxLocked.setValue(false)},scope:this.panelFilter})}if(true==this.filterSetting.chkModified){a.conditions.push({header:_T("snapshot","modified"),text:SYNO.SS.App.Snapshot.Utils.GetFilterStatusString(this.filterSetting.Modified),fnCancel:function(){this.chkboxModified.setValue(false)},scope:this.panelFilter})}if(true===this.filterSetting.chkDateFrom){a.conditions.push({header:_T("event","event_time_from"),text:new Date(this.filterSetting.timestampClientFrom*TRANS_MILLISECOND).format("Y/m/d H:i"),fnCancel:function(){this.chkboxDateFrom.setValue(false);this.dateFrom.setValue(new Date());this.timeFrom.reset();if(true===this.parentWin.filterSetting.chkDateTo){var b=new Date(this.parentWin.filterSetting.timestampTo*TRANS_MILLISECOND);this.SetProperDateFrom(this.dateTo,b)}else{var c=new Date(new Date().getTime()+DAY_MILLISECOND);this.dateTo.setValue(c);this.timeTo.reset()}},scope:this.panelFilter})}if(true===this.filterSetting.chkDateTo){a.conditions.push({header:_T("event","event_time_to"),text:new Date(this.filterSetting.timestampClientTo*TRANS_MILLISECOND).format("Y/m/d H:i"),fnCancel:function(){var c=new Date(new Date().getTime()+DAY_MILLISECOND);this.chkboxDateTo.setValue(false);this.dateTo.setValue(c);this.timeTo.reset();if(true===this.parentWin.filterSetting.chkDateFrom){var b=new Date(this.parentWin.filterSetting.timestampFrom*TRANS_MILLISECOND);this.SetProperDateTo(this.dateFrom,b)}else{this.dateFrom.setValue(new Date());this.timeFrom.reset()}},scope:this.panelFilter})}if(true===this.filterSetting.chkKeyword){a.conditions.push({header:_T("ss_common","keyword"),text:this.filterSetting.strKeyword,fnCancel:function(){this.chkboxKeyword.setValue(false)},scope:this.panelFilter})}this.panelFilterInfo.SetInfo(a)},ShowFilterPanel:function(a){this.blOnFilter=a},DeletePreProcess:function(){this.getMsgBox().confirm(this.title,_T("snapshot","del_warning"),this.OnDelete,this)},DeleteFilterPreProcess:function(a){var c;var b="";c=(true===a)?this.gridCateg.GetEntryCount():this.gridCateg.GetTotalCount();b=String.format(_T("snapshot","del_all_warning"),c);var d=function(e){this.OnFilteredDelete(e,a)};this.getMsgBox().confirm(this.title,b,d,this)},OnDelete:function(a){if("yes"!==a){return}var b=function(){SYNO.SS.App.Snapshot.Utils.ChkSnapshotValid();this.ReloadStore(this.dsSnapshot.getCount())};this.WebAPIRequest("Delete",{objList:this.GetSelectedObjList()},b)},OnFilteredDelete:function(b,a){if("yes"!=b){return}var c=Ext.applyIf({deleteAllCommand:false},this.GetFilterParams(a));var d=function(){SYNO.SS.App.Snapshot.Utils.ChkSnapshotValid();this.OnRefresh()};this.WebAPIRequest("DeleteFiltered",c,d)},DeleteAllPreProcess:function(){this.getMsgBox().confirm(this.title,_T("snapshot","del_all_confirm_msg"),this.OnDeleteAll,this)},OnDeleteAll:function(a){if("yes"!=a){return}var b=Ext.apply({deleteAllCommand:true},this.GetFilterParams());var c=function(){SYNO.SS.App.Snapshot.Utils.ChkSnapshotValid();this.OnRefresh()};this.WebAPIRequest("DeleteFiltered",b,c)},GetSelectedObjList:function(){var a=this.panelMultiView.GetSelections();var b=[];a.forEach(function(d,c){var e={dsId:this.ownerDsId,id:"0:"+((LOCAL_DS_ID===d.get("ownerDsId"))?d.get("id"):d.get("idOnRecServer"))};b.push(e)},this);return b},ChgButtonStatus:function(){if(true===Ext.isEmpty(this.gridCateg)){return}var d=Ext.getCmp(this.idList.DEL_SEL);var i=Ext.getCmp(this.idList.DEL_CATEG);var l=Ext.getCmp(this.idList.DEL_ALL);var f=Ext.getCmp(this.idList.LOCK_SEL);var b=Ext.getCmp(this.idList.LOCK_CATEG);var e=Ext.getCmp(this.idList.LOCK_ALL);var m=Ext.getCmp(this.idList.UNLOCK_SEL);var h=Ext.getCmp(this.idList.UNLOCK_CATEG);var j=Ext.getCmp(this.idList.UNLOCK_ALL);this.btnDelete.enable();i.enable();l.enable();this.btnLock.enable();this.menuLock.enable();b.enable();e.enable();this.menuUnLock.enable();h.enable();j.enable();var c=this.panelMultiView.GetSelections();var g=c.length;var a=false;var k=false;c.forEach(function(o,n){if(true===o.data.locked){a=true}else{k=true}},this);if(0===this.dsSnapshot.getCount()){this.btnEdit.disable();this.btnDownload.disable();this.btnDelete.disable();this.btnLock.disable();this.menuLock.disable();this.menuUnLock.disable()}else{if(0===g){this.btnEdit.disable();this.btnDownload.disable();d.disable();f.disable();m.disable()}else{if(1===g){this.btnEdit.enable();this.btnDownload.enable();if(true===a){d.disable();f.disable();m.enable()}else{d.enable();f.enable();m.disable()}}else{if(1<g){this.btnEdit.enable();this.btnDownload.disable();this.menuLock.enable();this.menuUnLock.enable();if((true===a)&&(true===k)){d.enable();f.enable();m.enable()}else{if(true===a){d.disable();f.disable();m.enable()}else{if(true===k){d.enable();f.enable();m.disable()}}}}}}}if((true===this.blOnFilter)&&(SYNO.SS.App.Snapshot.Def.IMG_LOCKED===this.filterSetting.Locked)){i.disable();l.disable()}if(0==this.btnDelete.CheckAvailItems()){this.btnDelete.disable()}if(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.SNAPSHOT_DOWNLOAD)){this.btnDownload.disable()}if(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.SNAPSHOT_LOCK)){this.menuLock.disable();this.menuUnLock.disable();this.btnLock.disable()}if(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.SNAPSHOT_DELETE)){this.btnDelete.disable()}if(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.SNAPSHOT_VIEW)){this.btnEdit.disable()}},WebAPIRequest:function(d,b,c,a){this.maskMgr.setStatusBusy();this.sendWebAPI({api:"SYNO.SurveillanceStation.SnapShot",version:1,method:d,params:b,callback:function(h,f,g,e){this.OnWebAPIRequestDone(h,f,g,e,c);if(true===a){SYNO.SDS.StatusNotifier.fireEvent("snapshotUpdateStore")}},scope:this})},OnWebAPIRequestDone:function(e,b,c,a,d){if(e){if((d)&&("function"===(typeof d))){d.call(this,e,b,c,a)}else{this.ReloadStore(this.dsSnapshot.getCount())}}else{this.getMsgBox().alert(this.title,_T("ss_common","error_system"))}this.maskMgr.clearStatusBusy()},GetItemUniqueId:function(a){return a+" - "+this.idPostFix}});Ext.define("SYNO.SS.App.Snapshot.ListPanel",{extend:"SYNO.ux.Panel"});Ext.define("SYNO.SS.App.Snapshot.MaskMgr",{extend:"Object",parent:null,maskCnt:0,constructor:function(a){this.parent=a;this.callParent()},setStatusBusy:function(){if(0===this.maskCnt){this.parent.setStatusBusy()}this.maskCnt++},clearStatusBusy:function(){this.maskCnt--;if(0>this.maskCnt){this.maskCnt=0}if(0===this.maskCnt){this.parent.clearStatusBusy()}},resetStatus:function(){this.maskCnt=0;this.parent.maskCnt=0;this.parent.clearStatusBusy()}});