/* Copyright (c) 2018 Synology Inc. All rights reserved. */

Ext.define("SYNO.SS.App.System.InfoGridView",{extend:"SYNO.SS.Grid.GridPanel",pollingInterval:10,hideHeaders:true,frame:true,api:null,constructor:function(a){var b;this.owner=a.owner;b=this.FillConfig(a);this.callParent([b])},FillConfig:function(a){this.store=this.CreateGroupingStore();var c=new Ext.grid.ColumnModel({defaults:{menuDisabled:false,sortable:false},columns:[{header:_T("status","header_item"),css:"font-weight: bold;",dataIndex:"name"},{header:_T("status","header_value"),dataIndex:"value",renderer:this.SelectableRenderer.createDelegate(this)},{header:"Category",dataIndex:"category",hidden:true,groupRenderer:function(e,d,f){return f.data.category}}]});this.selModel=new Ext.grid.RowSelectionModel({singleSelect:true});var b={colModel:c,selModel:this.selModel,store:this.store,listeners:{scope:this,deactivate:this.onDeactivate,activate:this.onActivate}};b.view=new SYNO.SDS.Utils.GroupingView({forceFit:true,trackResetOnLoad:false,showGroupName:false});Ext.apply(b,a);return b},CreateGroupingStore:function(){var a=new Ext.data.ArrayReader({},[{name:"name"},{name:"value"},{name:"category"},{name:"subcategory"},{name:"devinfo"}]);return new Ext.data.GroupingStore({reader:a,data:[],groupField:"category",autoDestroy:true,sortData:Ext.emptyFn})},StartPolling:function(){if(false===Ext.isDefined(this.pollingID)){this.pollingID=this.owner.pollReg({interval:this.pollingInterval,immediate:true,webapi:this.api,status_callback:this.LoadGridData||Ext.emptyFn,scope:this})}},onActivate:function(){this.StartPolling()},onDeactivate:function(){if(true===Ext.isDefined(this.pollingID)){this.owner.pollUnreg(this.pollingID);this.pollingID=undefined}},GetSelectedRowIdx:function(){return this.store.indexOf(this.selModel.getSelected())},SelectRow:function(a){this.selModel.selectRow(a)},SelectableRenderer:function(f,b,e){var d,c,a;if(!f.match(/^</)){d='<div class ="{0}" ext:qtip="{2}">{1}</div>';if("USB"===e.data.subcategory){c=f+"<div>"+e.data.devinfo+"</div>"}else{c=f}a=String.format(d,SYNO.SDS.Utils.SelectableCLS,f,c)}else{d='<div class ="{0}">{1}</div>';a=String.format(d,SYNO.SDS.Utils.SelectableCLS,f)}return a}});Ext.define("SYNO.SS.App.System.InfoPanel",{extend:"SYNO.SS.App.System.InfoGridView",title:_T("ss_common","device_info"),api:{api:"SYNO.SurveillanceStation.System",version:1,method:"Info"},constructor:function(a){this.owner=a.owner;var b=this.FillConfig(a);this.callParent([b])},InitData:function(){this.owner.setStatusBusy();this.StartPolling()},LoadGridData:function(d,c){var b;var a=[];if(true===this.owner.isStatusBusy()){this.owner.clearStatusBusy()}if(!d){this.owner.getMsgBox().alert(this.title,SYNO.API.getErrorString(c.code));return}b=this.GetSelectedRowIdx();a=a.concat(this.LoadBasic(c));a=a.concat(this.LoadVersion(c));a=a.concat(this.LoadTime(c));a=a.concat(this.LoadExtDev(c));this.store.loadData(a);this.SelectRow(b)},LoadBasic:function(e){var f=[];var d;var a,i;var c;var g;var h;f.push([_T("ss_common","serial_number"),e.serial]);f.push([_T("visualstation","model_name"),e.model]);if(Ext.isDefined(e.cpu_vendor)&&Ext.isDefined(e.cpu_family)&&Ext.isDefined(e.cpu_series)){f.push([_T("camera","usage_cpu"),String.format("{0} {1} {2}",e.cpu_vendor,e.cpu_family,e.cpu_series)])}if(Ext.isDefined(e.cpu_clock_speed)){if(e.cpu_clock_speed<1000){c=Math.round(e.cpu_clock_speed);f.push([_T("system","cpu_clock_rate"),c+" MHz"])}else{c=Math.round(e.cpu_clock_speed/10)/100;f.push([_T("system","cpu_clock_rate"),c+" GHz"])}}if(Ext.isDefined(e.cpu_num)){f.push([_T("system","cpu_num"),e.cpu_num])}if(Ext.isDefined(e.cpu_cores)){f.push([_T("system","cpu_cores"),e.cpu_cores])}if(Ext.isDefined(e.cpu1_core)){f.push([_T("system","cpu1_core"),e.cpu1_core])}if(Ext.isDefined(e.cpu2_core)){f.push([_T("system","cpu2_core"),e.cpu2_core])}if(Ext.isDefined(e.ram_size)){if(1024*10<=e.ram_size){g=Math.round(e.ram_size*10/1024)/10;f.push([_T("system","ramsize"),g+" "+_T("ss_common","size_gb")])}else{g=e.ram_size;f.push([_T("system","ramsize"),g+" "+_T("ss_common","size_mb")])}}f.push([_T("system","sys_time"),e.time],[_T("system","uptime"),this.LoadUpTime(e.up_time)]);if(e.support_rp){f.push([_T("system","power_supply")+"1",e.rp1===1?_T("ss_common","status_normal"):'<font class="red-status" ext:qtip="'+_T("visualstation","status_abnormal")+'">'+_T("visualstation","status_abnormal")+"</font>"],[_T("system","power_supply")+"2",e.rp2===1?_T("ss_common","status_normal"):'<font class="red-status" ext:qtip="'+_T("visualstation","status_abnormal")+'">'+_T("visualstation","status_abnormal")+"</font>"])}if(e.eunit){for(h=0;h<e.eunit.length;h++){a=e.eunit[h];i=a.model?a.model:_T("system","eunit");f.push([i+_T("system","power_supply")+"1",a.rp1===1?_T("ss_common","status_normal"):'<font class="red-status" ext:qtip="'+_T("visualstation","status_abnormal")+'">'+_T("visualstation","status_abnormal")+"</font>"],[i+_T("system","power_supply")+"2",a.rp2===1?_T("ss_common","status_normal"):'<font class="red-status" ext:qtip="'+_T("visualstation","status_abnormal")+'">'+_T("visualstation","status_abnormal")+"</font>"])}}d=String.format("{0} {1} / {2} {3} &nbsp;&nbsp;{4}",e.sys_temp,_T("localdisplay","celsius"),this.C2F(e.sys_temp).toFixed(0),_T("localdisplay","fahrenheit"),"");if(null!==e.sys_tempwarn){var b=String.format('<div {3} class="syno-sysinfo-temp {0}" style="margin-right:2px;">&nbsp;</div><span class="{2}">{1}</span>',e.sys_tempwarn?"syno-sysinfo-at":"syno-sysinfo-nt",e.sys_tempwarn?_T("system","over_temperature"):_T("helpbrowser","font_normal"),e.sys_tempwarn?"orange-status":"green-status",d?('ext:qtip="'+d+'"'):"");f.push([_T("visualstation","CPU_temperature"),b])}Ext.each(f,function(j){j.push(_T("system","basic_information"))});return f},C2F:function(a){return(a*1.8+32)},LoadUpTime:function(h){var g="";var f=h.indexOf(":",0);var a=h.substring(0,f);var d=h.indexOf(":",f+1);var c=parseInt(h.substring(f+1,d),10);var e=parseInt(h.substring(d+1,h.length),10);a=parseInt(a,10);var b=(a-a%24)/24;a=a%24;g=b?String.format("{0} {1} ",b,_T("visualstation","status_day")):"";g+=(a||g!=="")?String.format("{0} {1} ",a,_T("system","status_hour")):"";g+=(c||g!=="")?String.format("{0} {1} ",c,_T("system","status_minute")):"";g+=(e||g!=="")?String.format("{0} {1}",e,_T("system","status_second")):"";return g},LoadVersion:function(c){var a=[];var b=_T("system","version_information");a.push([_T("localdisplay","dsm_version"),c.firmware_ver.replace("DSM",""),b],[_T("system","svs_version"),c.ss_version,b],[_T("system","dp_version"),c.dp_version,b]);return a},LoadTime:function(f){var a=SYNO.SDS.Utils.getTimeZoneStore();var c=[];var e,b;var d=_T("ss_common","time");if(f.hasOwnProperty("time_zone_desc")){e=f.time_zone_desc}else{b=a.getById(f.time_zone);e=b?b.get("display"):f.time_zone}c.push([_T("system","ntpdate_server"),f.enabled_ntp?f.ntp_server:f.ntp_server+" "+_T("system","status_not_enabled"),d]);c.push([_T("ss_common","time_zone"),e,d]);return c},LoadExtDev:function(c){var a=[];var b=_T("system","externaldevice");a=this.LoadUSBInfo(c.usb_dev,b);a=a.concat(this.LoadESATAInfo(c.sata_dev,b));a=a.concat(this.LoadSDInfo(c.sd_dev,b));if(0===a.length){a.push([_T("system","usb_nodevice"),"",b])}return a},LoadSDInfo:function(b,h){var g=[];var f=Ext.util.Format.htmlEncode;if(b){for(var c=0;c<b.length;c++){var a=b[c];var e=a.producer?f(a.producer):_T("ss_common","status_unknown");var d=[_T("system","sdcard"),e,h];g.push(d)}}return g},LoadESATAInfo:function(a,h){var c=[];var f=Ext.util.Format.htmlEncode;if(a){for(var b=0;b<a.length;b++){var e=a[b];var k;var g=e.id?" "+e.id:"";var i=e.isEUnit?_T("system","eunit")+g:_T("system","esata_device");if("normal"===e.status){var d=e.model?f(e.model):_T("ss_common","status_unknown");k=[i,d,h]}else{k=[i,_T("system","esata_crashed"),h]}c.push(k)}}return c},LoadUSBInfo:function(n,i){var e=[];var g=Ext.util.Format.htmlEncode;var b={printer:_T("system","usb_print"),audio:_T("system","usb_audio"),disk:_T("system","usb_disk"),hub:_T("system","usb_hub"),remote:_T("system","usb_remote"),scard:_T("system","usb_scard"),ups:_T("system","usb_ups"),other:_T("system","status_usb")};function c(p){var o="";for(var j=0;j<p;j++){o+="&nbsp; &nbsp; &nbsp;"}return o}for(var d=0;d<n.length;d++){var f=n[d];var h=f.producer?g(f.producer):_T("ss_common","status_unknown");var l=f.product?g(f.product):_T("ss_common","status_unknown");if(f.cls in b){var k=c(f.level)+b[f.cls];var a="VID:"+f.vid+" PID:"+f.pid+" REV:"+f.rev;var m=[k,l+" - "+h,i,"USB",a];e.push(m)}}return e}});Ext.define("SYNO.SS.App.System.StoragePanel",{extend:"Ext.Panel",title:_T("camera","storage"),padding:"0",isUSBStation:null,volPieStore:null,pieChartPos:["left","center","right"],pieChartLimit:6,numPerPage:3,pageIndex:1,pieChartColor:{high:"#FA4B4B",mid:"#FF7F00",low:"#0086E5"},pollingInterval:30,constructor:function(a){this.owner=a.owner;this.isUSBStation=("EDS14"===this.owner.GetModelName());var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){this.emptyPanel=new SYNO.ux.GridPanel({hideHeaders:true,store:new Ext.data.ArrayStore({fields:["NA"]}),colModel:new Ext.grid.ColumnModel({columns:[{header:"NA"}]})});if(this.isUSBStation){this.hddGridPanel=this.createHDDGrid_USBStation()}else{this.hddGridPanel=this.createHDDGrid()}this.volGridPanel=this.createVolumeGrid();this.volPrevId=Ext.id(undefined,"sysinfo_vol_prev_");this.volNextId=Ext.id(undefined,"sysinfo_vol_next_");this.volId=Ext.id(undefined,"sysinfo_vol_");this.volChartId=Ext.id(undefined,"sysinfo_vol_chart_");this.volNameId=Ext.id(undefined,"sysinfo_vol_name_");this.volDescId=Ext.id(undefined,"sysinfo_vol_desc_");this.volTextId=Ext.id(undefined,"sysinfo_vol_text_");this.volPiePanel=new Ext.DataView({tpl:new Ext.XTemplate('<tpl for=".">','<tpl if="3 &gt; volCount || 3 == volCount">','<div style="height:190px;position:relative" class="sm-vol-chart-container">',"</tpl>",'<tpl if="3 < volCount">','<div style="height:190px;position:relative">','<div id="'+this.volPrevId+'" class="sm-infocenter-vol-prev sm-infocenter-vol-btn" tabindex="0" role="button" aria-label="'+_T("common","prevpage")+'"></div>','<div class="sm-vol-chart-container">',"</tpl>",'<tpl for="volumes">','<div id="'+this.volId+'{pos}" class="sm-infocenter-vol sm-vol-hidden">','<div id="'+this.volChartId+'{pos}" class="sm-infocenter-vol-chart"></div>','<div id="'+this.volNameId+'{pos}" class="sm-infocenter-vol-name"></div>','<div id="'+this.volDescId+'{pos}" class="sm-infocenter-vol-desc"></div>','<div id="'+this.volTextId+'{pos}" class="sm-infocenter-vol-text"></div>',"</div>","</tpl>",'<tpl if="3 < volCount">',"</div>",'<div id="'+this.volNextId+'" class="sm-infocenter-vol-next sm-infocenter-vol-btn" tabindex="0" role="button" aria-label="'+_T("common","nextpage")+'"></div>',"</tpl>","</div>","</tpl>",'<div class="x-clear"></div>',{getCount:function(c){if(!c||!c.length){return 0}return c.length}}),hidden:true,store:this.volPieStore=new Ext.data.JsonStore({autoDestroy:true,fields:["volCount","volumes"]})});this.volField=new SYNO.ux.FieldSet({stateId:"SYNO.SDS.AdminCenter.InfoCenter.Main::storage::volume",title:_T("localdisplay","volume"),collapsible:true,cls:"syno-sysinfo-fieldset",items:[this.emptyPanel,this.volPiePanel,this.volGridPanel]});this.hddField=new SYNO.ux.FieldSet({stateId:"SYNO.SDS.AdminCenter.InfoCenter.Main::storage::hdd",title:(true===this.isUSBStation)?_T("system","externaldevice"):_T("system","status_hdd"),collapsible:true,cls:"syno-sysinfo-fieldset",items:this.hddGridPanel});var b={layout:"form",listeners:{scope:this,resize:this.onResize,deactivate:this.onDeactivate},items:[this.volField]};b.items.push(this.hddField);Ext.apply(b,a);return b},getMidHeight:function(){return(this.owner.getHeight()-155)/2},onResize:function(){var a=this.getMidHeight();this.emptyPanel.hide();this.volGridPanel.setHeight(a);this.volPiePanel.setHeight(a>180?a:180);if(this.hddGridPanel.isVisible()){this.hddGridPanel.setHeight(a)}this.doLayout()},InitData:function(){if(this.pollingID===undefined){this.pollingID=this.owner.pollReg({interval:this.pollingInterval,immediate:true,webapi:{api:"SYNO.Core.System",version:1,method:"info",params:{type:"storage"}},status_callback:this.loadStorageInfo,scope:this})}},onDeactivate:function(){if(this.pollingID!==undefined){this.owner.pollUnreg(this.pollingID);this.pollingID=undefined}},getHddSelectedRowIdx:function(){return this.hddStore.indexOf(this.hddSelModel.getSelected())},selectHddRow:function(a){this.hddSelModel.selectRow(a)},loadStorageInfo:function(n,k,e,a){var o=null,f=null;var l=null;var b,h,g;var c=0;var m;var d;if(!n){SYNO.Debug("[Polling] action Failed.");return}b=k;d=this.getHddSelectedRowIdx();if(this.isUSBStation){o=[];for(h=0;b.devices&&h<b.devices.length;++h){f=b.devices[h];if(f.partitions&&f.partitions.length>0){for(g=0;g<f.partitions.length;++g){o.push({status:f.partitions[g].status,total_size:parseInt(f.partitions[g].total_size_mb,10)*1024*1024,used_size:parseInt(f.partitions[g].used_size_mb,10)*1024*1024,name:f.partitions[g].share_name,volstr:f.partitions[g].share_name});++c}}else{++c}}l=this.formatHDDInfo_USBStation(b.devices)}else{o=b.vol_info;l=this.formatHDDInfo(b.hdd_info)}if(o===null||o===""){o=[]}if(this.isUSBStation){o.unshift({status:b.vol_info[0].status,total_size:b.vol_info[0].total_size,used_size:b.vol_info[0].used_size,name:b.vol_info[0].name,volstr:_T("system","system_volume")});++c}if(!this.isUSBStation){c=o.length}if(this.isDestroyed){return}this.loadVolumes(o,c);this.hddStore.loadData(l);if(this.hddGridPanel.isVisible()){m=this.hddGridPanel.view.getScrollState();this.hddGridPanel.view.setScroll(m.top,m.left)}this.selectHddRow(d)},formatHDDInfo:function(f){var h=false;var g=[];var k=SYNO.SDS.Utils.StorageUtils;if(!f){return g}for(var c=0;c<f.length;c++){var a=f[c];if(a.status=="no_disk"||!a.status){h=true}else{h=false}var e=h?"-":a.model;var b=[this.getDiskName(a.diskno,a.portType,a.order,a.ebox_order,a.pciSlot),e,k.UiRenderHelper.DiskSummaryStatusRenderV2(a.status)];var j,l;var d=(a.volume==="0")?"-":k.SpaceIDParser(a.volume).str;if(h){l="-"}else{l=(a.capacity/1024/1024/1024).toFixed(2)+" "+_T("status","status_disk_size_unit")}if(!h){j=k.UiRenderHelper.DiskTemperatureRender(a.temp)}else{j="-"}b.push(j);b.push(a.diskType);b.push(l,d,a.portType,a.order,a.ebox_order,a.pciSlot);g.push(b);g.sort(this.diskNameSort)}return g},getDiskName:function(d,b,a,g,f){var e=0;var c=this.owner.GetModelName();if(b!=="cache"){return d}switch(c.toLowerCase()){case"rs3413xs+":case"rs10613xs+":e=10;return String.format("{0} {1}",_T("volume","dedicated_ssd_cache"),a-e);default:break}if(f===0){return String.format("{0} {1}",_T("volume","dedicated_ssd_cache"),a)}return String.format("{0} {1}-{2}",_T("volume","dedicated_ssd_cache"),f,a)},diskNameSort:function(k,j){var i=k[k.length-3],g=j[j.length-3],m=k[k.length-2],l=j[j.length-2];var h=k[k.length-4],f=j[j.length-4];var e=k[k.length-1],d=j[j.length-1];var c=function(b,a){return((false===Ext.isEmpty(b))&&(false===Ext.isEmpty(a)))};if(true===c(h,f)){if(h.length>f.length){return -1}else{if(h.length<f.length){return 1}}}if(true===c(e,d)){if(e.length>d.length){return -1}else{if(e.length<d.length){return 1}}}if(true===c(m,l)){if(m>l){return 1}else{if(m<l){return -1}}}if(true===c(i,g)){if(i>g){return 1}else{if(i<g){return -1}}}return 0},createHDDGrid_USBStation:function(){var c=["device_display_name","producer","product","filesystem","status","sharedfolder"];this.hddStore=new Ext.data.ArrayStore({fields:c,autoDestroy:true});this.hddSelModel=new Ext.grid.RowSelectionModel({singleSelect:true});var a=new Ext.grid.ColumnModel({defaults:{align:"center",useHtmlEncodeRender:false,sortable:false},columns:[{header:_T("ss_common","common_name"),dataIndex:"device_display_name",width:0.2,align:"center"},{header:_T("system","usb_producer"),dataIndex:"producer",width:0.2,align:"center"},{header:_T("system","usb_devname"),dataIndex:"product",width:0.2,align:"center"},{header:_T("system","usb_FStype"),dataIndex:"filesystem",width:0.1,align:"center"},{header:_T("system","usb_status"),dataIndex:"status",width:0.1,align:"center"},{header:_T("system","usb_shname"),dataIndex:"sharedfolder",width:0.2,align:"center"}]});var b=new SYNO.SS.Grid.GridPanel({store:this.hddStore,viewConfig:{forceFit:true},enableColumnHide:false,enableColumnMove:false,enableColumnResize:false,enableHdMenu:false,selModel:this.hddSelModel,colModel:a});return b},createHDDGrid:function(){var d=["diskno","model","status"];d.push("temp");d.push("diskType");d.push("capacity","volume");this.hddStore=new Ext.data.ArrayStore({fields:d,autoDestroy:true});this.hddSelModel=new Ext.grid.RowSelectionModel({singleSelect:true});var b=[{header:_T("system","volume_disknumber"),dataIndex:"diskno"},{header:_T("ss_common","model"),dataIndex:"model",tpl:String.format('<span class="{0}" ext:qtip="{model}">{model}</span>',SYNO.SDS.Utils.SelectableCLS)}];b.push({header:_T("visualstation","temperature"),dataIndex:"temp"});b.push({header:_T("system","volume_disk_capacity"),dataIndex:"capacity"},{header:_T("ss_common","status"),dataIndex:"status"},{header:String.format("{0} / {1}",_T("localdisplay","volume"),_T("system","volume_group")),dataIndex:"volume",tpl:'<span ext:qtip="{volume}">{volume}</span>'});var a=new Ext.grid.ColumnModel({defaults:{align:"center",useHtmlEncodeRender:false,sortable:false},columns:b});var c=new SYNO.SS.Grid.GridPanel({store:this.hddStore,viewConfig:{forceFit:true},enableColumnHide:false,enableColumnMove:false,enableColumnResize:false,enableHdMenu:false,selModel:this.hddSelModel,colModel:a});return c},createVolumeGrid:function(){var a=new Ext.data.ArrayStore({fields:["id","status","total","used","percent","desc"],autoDestroy:true});var b=new SYNO.SS.Grid.GridPanel({store:a,enableColumnHide:false,enableColumnMove:false,enableColumnResize:false,enableHdMenu:false,hidden:true,viewConfig:{forceFit:true},colModel:new Ext.grid.ColumnModel({defaults:{sortable:false,align:"center",width:100},columns:[{header:_T("ss_common","common_name"),dataIndex:"id"},{header:_T("ss_common","status"),dataIndex:"status",renderer:function(c){return SYNO.SDS.Utils.StorageUtils.UiRenderHelper.VolumeStatusNameRender(c)}},{header:_T("ss_common","common_description"),dataIndex:"desc",renderer:function(e,c,d){c.attr='ext:qtip="'+Ext.util.Format.htmlEncode(e)+'"';return e?e:"-"}},{header:String.format("{0} (%)",_T("system","volume_usedsize")),align:"left",dataIndex:"percent",css:"vertical-align: middle;",renderer:function(e,i,f,k,c,j){var d=Math.ceil(f.data.percent);var g=new SYNO.SDS.Utils.PercentageBar({barWidth:120,barHeight:16,showValueText:true});var h=new Ext.XTemplate("{progressBar}");return h.apply({progressBar:g.fill(d)})}},{header:_T("system","volume_usedsize"),dataIndex:"used"},{header:_T("system","volume_totalsize"),dataIndex:"total"}]})});return b},loadVolumes:function(b,e){var a;var f;var g=[];if(0===e){this.showVolPanel("empty");this.emptyPanel.setHeight(this.getMidHeight());this.emptyPanel.body.mask(_T("volume","volume_no_volumes"),"syno-ux-mask-info");return}b.sort(this.sortVolume);f=this.formatVolumeInfo(b,g);if(e<this.pieChartLimit){a=this.showVolPanel("pie");this.volPieStore.loadData(g);this.drawPieChart(b);if(1<this.pageCount){var d=Ext.get(this.volPrevId);var c=Ext.get(this.volNextId);this.mon(d,"click",function(i,h,j){var k=new Ext.Element(h);if(!k.hasClass("sm-infocenter-vol-btn-enable")){return}--this.pageIndex;this.drawPieChart(b)},this);this.mon(c,"click",function(i,h,j){var k=new Ext.Element(h);if(!k.hasClass("sm-infocenter-vol-btn-enable")){return}++this.pageIndex;this.drawPieChart(b)},this);c.addKeyListener(Ext.EventObject.SPACE,function(){c.dom.click()},this);d.addKeyListener(Ext.EventObject.SPACE,function(){d.dom.click()},this);c.addKeyListener(Ext.EventObject.ENTER,function(){c.dom.click()},this);d.addKeyListener(Ext.EventObject.ENTER,function(){d.dom.click()},this)}}else{a=this.showVolPanel("grid");if(this.volIsChg(b,this.orgVolInfo)){this.volGridPanel.getStore().loadData(f);this.orgVolInfo=b}}},sortVolume:function(d,c){var f,e;if(-1<d.name.indexOf("volume")&&-1===c.name.indexOf("volume")){return -1}if(-1===d.name.indexOf("volume")&&-1<c.name.indexOf("volume")){return 1}if(-1<d.name.indexOf("volume")&&-1<c.name.indexOf("volume")){if(parseInt(d.name.replace("volume_",""),10)>parseInt(c.name.replace("volume_",""),10)){return 1}else{return -1}}f=d.name.replace("usbshare","").replace("-","");e=c.name.replace("usbshare","").replace("-","");while(f.length<4){f+="0"}while(e.length<4){e+="0"}if(f>e){return 1}return -1},formatVolumeInfo:function(s,k){var q=[];var r=SYNO.SDS.Utils.StorageUtils;var f,c,e,b,m,j,h,n={},l,p,a,g;this.pageCount=Math.ceil(s.length/this.numPerPage);for(j=0;j<s.length;j++){f=s[j];p=r.UiRenderHelper.GetSizeUnit(f.total_size);a=r.UiRenderHelper.GetSizeUnit(f.used_size);c=f.volstr||((f.name==="0")?"-":r.SpaceIDParser(f.name).str);g=f.status;e=p.size+" "+p.unit;b=a.size+" "+a.unit;m=f.used_size*100/f.total_size;l=Ext.util.Format.htmlEncode(f.desc);q.push([c,g,e,b,m,l])}n.volumes=[];n.volCount=s.length;for(j=0;j<this.pieChartPos.length;++j){h={};var o=this.pieChartPos[j];h.style=(3>=k.volCount)?1:2;h.pos=o;n.volumes.push(h)}k.push(n);return q},volIsChg:function(c,d){var a="";var b="";if(c){a=Ext.encode(c)}if(d){b=Ext.encode(d)}if(a!=b){return true}return false},showVolPanel:function(c){var b;var a=false;this.onResize();if("grid"==c){if(!this.volGridPanel.isVisible()){this.volGridPanel.show();a=true}if(this.volPiePanel.isVisible()){this.volPiePanel.hide();a=true}b=this.volGridPanel}else{if("pie"===c){if(this.volGridPanel.isVisible()){this.volGridPanel.hide();a=true}if(!this.volPiePanel.isVisible()){this.volPiePanel.show();a=true}b=this.volPiePanel}else{this.volGridPanel.hide();this.volPiePanel.hide();this.emptyPanel.show()}}if(a){this.doLayout()}return b},drawPieChart:function(p){var l=this,a,e,f,k,c,g,q,i,j,o,h,b,m,n=SYNO.SDS.Utils.StorageUtils;var d=null;l.pageIndex=(l.pageIndex>l.pageCount)?l.pageCount:l.pageIndex;l.pageIndex=(1>l.pageIndex)?1:l.pageIndex;a=(l.pageIndex-1)*l.numPerPage;e=(p.length<a+l.numPerPage)?p.length:a+l.numPerPage;if(1<l.pageCount){if(1===l.pageIndex){this.setVolButtonStatus(this.volPrevId,false);this.setVolButtonStatus(this.volNextId,true)}else{if(l.pageIndex===l.pageCount){this.setVolButtonStatus(this.volPrevId,true);this.setVolButtonStatus(this.volNextId,false)}else{this.setVolButtonStatus(this.volPrevId,true);this.setVolButtonStatus(this.volNextId,true)}}}l.cleanVolUsage();for(;a<e;++a){f=p[a];k=parseInt(f.used_size,10)/parseInt(f.total_size,10);if(k>0.9){c="high"}else{if(k>0.8){c="mid"}else{c="low"}}q=l.pieChartColor[c];i=String.format(this.volChartId+"{0}",l.pieChartPos[a%3]);j=new SYNO.SDS.Utils.canvas.ColorCircleGradient({radius:60,gradientWidth:20,height:120,width:120,canvasConfig:{height:120,width:120},renderTo:i});j.draw(Math.min(k,1));if(this.isUSBStation){d=this.getUSBStatus(f.status)}else{d=SYNO.SDS.Utils.StorageUtils.UiRenderHelper.VolumeStatusNameRender(f.status)}i=String.format(this.volNameId+"{0}",l.pieChartPos[a%3]);if(this.isUSBStation){Ext.get(i).update(f.volstr+" ("+d+")")}else{Ext.get(i).update(n.SpaceIDParser(f.name).str+" ("+d+")")}b=n.UiRenderHelper.GetSizeUnit(f.used_size);m=n.UiRenderHelper.GetSizeUnit(f.total_size);i=String.format(this.volTextId+"{0}",l.pieChartPos[a%3]);o=String.format('<span style="color:{0}">{1} {2}</span><span>&nbsp;/&nbsp;{3} {4}</span>',q,b.size,b.unit,m.size,m.unit);Ext.get(i).update(o);i=String.format(this.volDescId+"{0}",l.pieChartPos[a%3]);h=Ext.util.Format.htmlEncode(f.desc);if(undefined===h){Ext.get(i).update("")}else{if(""===h){Ext.get(i).update("-")}else{Ext.get(i).update(h);Ext.get(i).set({"ext:qtip":h})}}i=String.format(this.volId+"{0}",l.pieChartPos[a%3]);g=String.format("{1}{0} {2}{0} {3}{0}",l.pieChartPos[a%3],this.volNameId,this.volDescId,this.volTextId);Ext.get(i).removeClass("sm-vol-hidden");Ext.get(i).setARIA({tabindex:0,role:"presentation",labelledby:g})}},setVolButtonStatus:function(b,a){var c=Ext.get(b);if(a){if(c.hasClass("sm-infocenter-vol-btn-enable")){return}c.addClass("sm-infocenter-vol-btn-enable");c.setARIA({disabled:false})}else{c.removeClass("sm-infocenter-vol-btn-enable");c.setARIA({disabled:true})}},cleanVolUsage:function(){var b=this,a;for(a=0;a<b.pieChartPos.length;++a){Ext.get(String.format(this.volId+"{0}",b.pieChartPos[a])).set({tabindex:-1});Ext.get(String.format(this.volId+"{0}",b.pieChartPos[a])).addClass("sm-vol-hidden");Ext.get(String.format(this.volChartId+"{0}",b.pieChartPos[a])).update("");Ext.get(String.format(this.volNameId+"{0}",b.pieChartPos[a])).update("");Ext.get(String.format(this.volDescId+"{0}",b.pieChartPos[a])).update("");Ext.get(String.format(this.volDescId+"{0}",b.pieChartPos[a])).set({"ext:qtip":""});Ext.get(String.format(this.volTextId+"{0}",b.pieChartPos[a])).update("")}},formatPartitionInfo_USBStation:function(b){var a=[];a=[b.partition_title,b.producer,b.product];a.push(this.getUSBFilesystem(b.filesystem));a.push(this.getUSBStatus(b.status));a.push(b.share_name?b.share_name:_T("usb","usb_notmounted"));return a},formatHDDInfo_USBStation:function(b){var a=[];var d,c,e,f;for(d=0;b&&d<b.length;d++){e=b[d];if(e.partitions&&e.partitions.length>0){for(c=0;c<e.partitions.length;++c){f=this.formatPartitionInfo_USBStation(e.partitions[c]);a.push(f)}}else{f=this.formatPartitionInfo_USBStation(e);a.push(f)}}return a},getUSBFilesystem:function(a){switch(a){case"vfat":return _T("system","usb_fs_fat");case"ntfs":return _T("system","usb_fs_ntfs");case"ext3":return _T("system","volume_ext3");case"ext4":return _T("system","volume_ext4");case"hfsplus":return _T("system","volume_hfsplus");default:return _T("system","usb_fs_other")}},getUSBStatus:function(a){switch(a){case"normal":return'<font color="green">'+_T("system","usb_st_normal")+"</font>";case"format_fail":return'<font color="#FF0000">'+_T("system","usb_st_formatfail")+"</font>";case"hddfail":return'<font color="#FF0000">'+_T("system","usb_st_fail")+"</font>";case"corrupt":return'<font color="#FF0000">'+_T("system","usb_st_needfsck")+"</font>";case"fsck":return'<font color="#FF0000">'+_T("system","usb_st_fsck")+"</font>";case"formating":return'<font color="#FF0000">'+_T("system","usb_st_format")+"</font>";case"init":return'<font color="#FF0000">'+_T("system","usb_st_init")+"</font>";case"usbcopy":return'<font color="#FF0000">'+_T("system","usb_st_usbcopy")+"</font>";case"usbbackup":return'<font color="#FF0000">'+_T("system","usb_st_backingup")+"</font>"}return a}});Ext.define("SYNO.SS.App.System.TimePanel",{extend:"SYNO.SDS.Utils.FormPanel",constructor:function(a){this.owner=a.owner;this.tzStore=new SYNO.SS.App.System.TimezoneStore({owner:a.owner});this.ntpRetry=0;var b=this.fillConfig(a);this.callParent([b]);this.mon(this,"afterlayout",function(d,e){var c;c=new SYNO.ux.Utils.EnableRadioGroup(d.getForm(),"enable_ntp",{manual:["date","hour","minute","second"],ntp:["server",this.updateBtnId]})},this,{single:true});this.mon(this.tzStore,"load",this.onTZAfterLoad,this)},fillConfig:function(a){var b={itemId:"NTPTab",title:_T("ss_common","time"),autoScroll:true,items:[{xtype:"syno_fieldset",collapsible:true,title:_T("localdisplay","time_now"),items:this.getNowItems()},{xtype:"syno_fieldset",collapsible:true,title:_T("visualstation","time_zone_title"),items:this.getTimezoneItems()},{xtype:"syno_fieldset",collapsible:true,title:_T("localdisplay","time_setting"),items:this.getTimeSettingItems()}],buttons:this.getButtons()};Ext.apply(b,a);return b},initEvents:function(){this.tzStore.loadTimezone()},InitData:function(){this.sendWebAPI({api:"SYNO.SurveillanceStation.System",version:1,method:"TimeGet",callback:function(b,a){if(!b){this.owner.getMsgBox().alert(this.title,SYNO.API.getErrorString(a.code));return}this.getForm().setValues(a[1].data);this.isManualChangeTime=false;this.updateCurrentTime();this.doLayout()},scope:this})},onTZAfterLoad:function(){Ext.getCmp(this.tzComboBoxId).reset()},getNowItems:function(){var a=[];a.push({xtype:"syno_displayfield",htmlEncode:false,name:"now"});return a},getTimezoneItems:function(){var a=[];a.push({xtype:"syno_combobox",name:"timezone",id:this.tzComboBoxId=Ext.id(),fieldLabel:_T("ss_common","time_zone"),indent:0,width:300,displayField:"display",valueField:"value",tpl:'<tpl for="."><div ext:qtip="{display}" class="x-combo-list-item" role="option" aria-label="{'+this.displayField+'}" id="{[Ext.id()]}">{display}</div></tpl>',store:this.tzStore});return a},getTimeSettingItems:function(){var a=[];a.push({xtype:"syno_radio",boxLabel:_T("localdisplay","time_manual"),"aria-label":_T("localdisplay","time_manual"),name:"enable_ntp",inputValue:"manual"},{xtype:"syno_datefield",fieldLabel:_T("event","date"),name:"date",width:300,indent:1,format:"Y/n/j",allowBlank:false,editable:false,maxValue:"2037/12/31",minValue:"2005/1/1"},{xtype:"syno_compositefield",indent:1,width:500,fieldLabel:_T("ss_common","time"),items:[{xtype:"syno_combobox",name:"hour",width:90,displayField:"display",valueField:"value","aria-label":_T("common","time_hour"),store:SYNO.SDS.Utils.createTimeItemStore("hour")},{xtype:"syno_displayfield",value:":",tabindex:"-1",width:5},{xtype:"syno_combobox",name:"minute",width:90,displayField:"display",valueField:"value","aria-label":_T("common","time_minute"),store:SYNO.SDS.Utils.createTimeItemStore("min")},{xtype:"syno_displayfield",value:":",tabindex:"-1",width:5},{xtype:"syno_combobox",name:"second",width:90,displayField:"display",valueField:"value","aria-label":_T("common","time_second"),store:SYNO.SDS.Utils.createTimeItemStore("sec")}],reset:Ext.emptyFn},{xtype:"syno_radio",boxLabel:_T("system","ntpdate_enable"),"aria-label":_T("system","ntpdate_enable"),name:"enable_ntp",inputValue:"ntp"},{xtype:"syno_combobox",name:"server",hiddenId:Ext.id(),width:300,indent:1,fieldLabel:_T("system","ntpdate_server"),store:this.getNTPServerStore(),displayField:"value",valueField:"value",vtype:"iporhostname",allowBlank:false,typeAhead:true,editable:true,selectOnFocus:true,listeners:{scope:this,change:this.onChangeServer,select:this.onChangeServer}},{xtype:"syno_button",indent:1,id:this.updateBtnId=Ext.id(),text:_T("localdisplay","ntp_updatenow"),scope:this,handler:this.onUpdateNTPClick});return a},getButtons:function(){var a=new SYNO.ux.Button({name:"btnSave",text:_T("ss_common","common_save"),btnStyle:"blue",handler:this.OnSave,scope:this});var b=new SYNO.ux.Button({name:"btnClose",text:_T("ss_common","close"),handler:function(){this.owner.close()},scope:this});return[a,b]},getNTPServerStore:function(){var a=new Ext.data.SimpleStore({fields:["value"],data:[["time.google.com"],["pool.ntp.org"],["time.nist.gov"]]});return a},onChangeServer:function(a){Ext.getCmp(this.updateBtnId).enable()},onUpdateNTPClick:function(){var a=this.getForm();var b=a.findField("server");if(b.isValid(false)){this.OnSave()}},onUpdateNTPDone:function(f,c,b,g){this.SyncWithNtp=false;this.owner.clearStatusBusy();var a=this.getForm().findField("server").getRawValue();var e=null;if(!f){if(3>this.ntpRetry++){e=String.format(_T("system","ntp_update_progress"),this._S("PRODUCT_NAME"),a);this.sendSyncAPI(e,a)}else{this.ntpRetry=0}return}this.ntpRetry=0;if(c.has_fail){e=String.format(_T("localdisplay","ntp_update_failed"),this._S("PRODUCT_NAME"),a);this.owner.getMsgBox().alert(this.title,e);this.applyForm();return}var d=SYNO.API.Util.GetValByAPI(c,"SYNO.Core.Region.NTP","get");this.getForm().setValues({now:d.now});this.updateCurrentTime();e=String.format(_T("localdisplay","ntp_update_success"),a);this.applyForm();this.setStatusOK({text:e});if(g){g()}},onBeforeRequest:function(c){if("set"!==c){return true}if(!this.getForm().isDirty()||this.isManualChangeTime){return true}var a=this.getForm().getValues();if(a.enable_ntp==="manual"){this.owner.getMsgBox().confirm(_T("tree","leaf_time"),_T("time","logout_comfirm"),function(d){if("yes"===d){this.isManualChangeTime=true;this.module.panel.applyAllForm()}},this);return false}if(this.getForm().findField("server").isDirty()||this.getForm().findField("enable_ntp").isDirty()){var b=String.format(_T("system","ntp_update_progress"),this._S("PRODUCT_NAME"),a.server);this.sendSyncAPI(b,a.server);this.module.panel.LanguageForm.applyForm();this.module.panel.NTPServerForm.applyForm();return false}return true},sendSyncAPI:function(c,a,b){this.SyncWithNtp=true;this.owner.setStatusBusy({text:c},0.1,100);this.sendWebAPI({compound:{stopwhenerror:true,params:[{api:"SYNO.Core.Region.NTP",method:"sync",version:1,params:{server:a}},{api:"SYNO.Core.Region.NTP",method:"get",version:1}]},scope:this,callback:function(f,e,d){this.onUpdateNTPDone(f,e,d,b)}})},updateCurrentTime:function(){var f=this.getForm().findField("now");var h=(f)?(new Date(f.getValue())):(new Date());if("Invalid Date"===h.toString()){h=new Date()}var i=h.getFullYear(),e=h.getMonth()+1,g=h.getDay(),c=h.getDate();var j=_T("system","mon_"+e);var k=_T("system","weekday_"+g);var b=String.format(_T("system","date_format_with_year"),j,c,k,i);var a=String.format('{0}<span class="minute">:{1}</span>:{2}',h.format("H"),h.format("i"),h.format("s"));this.getForm().setValues({now:b+" "+a})},OnSave:function(){var c=this.getForm();var h=false;var g=this.getForm().getValues();var d=c.getValues();var f=String.format(_T("system","ntp_update_progress"),this._S("PRODUCT_NAME"),d.server);var e=0;var b=function(){this.sendWebAPI({compound:{mode:"sequential",params:[{api:"SYNO.SurveillanceStation.System",method:"TimeSet",version:1,params:{TimeSetting:g}},{api:"SYNO.SurveillanceStation.System",method:"TimeGet",version:1}]},callback:function(k,j){var i;if((!k)&&(3>e)){e++;b();return}this.clearStatusBusy();if(!k){this.owner.getMsgBox().alert(this.title,SYNO.API.getErrorString(j.code));return}i=SYNO.API.Util.GetValByAPI(j,"SYNO.SurveillanceStation.System","TimeGet");this.getForm().setValues(i[1].data);this.setStatusOK();this.updateCurrentTime()},scope:this})}.createDelegate(this);var a=function(){this.setStatusBusy({text:_T("ss_common","common_saving")});b()}.createDelegate(this);if(false===this.IsDirty()){this.setStatusError({text:_T("ss_common","setting_nochange")});return}if(c.findField("date").isDirty()||c.findField("hour").isDirty()||c.findField("second").isDirty()||c.findField("minute").isDirty()){h=true}g.change_time=h;if("manual"===g.enable_ntp){g.date=new Date(g.date).dateFormat("Y/n/j");a()}else{if((this.getForm().findField("server").isDirty())||(this.getForm().findField("enable_ntp").isDirty())){this.sendSyncAPI(f,d.server,a)}else{a()}}},IsDirty:function(){return this.getForm().isDirty()},ResetForm:function(){this.getForm().reset()}});Ext.define("SYNO.SS.App.System.TimezoneStore",{extend:"Ext.data.JsonStore",constructor:function(b){this.owner=b.owner;this.hasLoaded=false;var a=Ext.apply({fields:["value","offset","display"]},b);this.callParent([a])},loadTimezone:function(){if(!this.hasLoaded){this.owner.sendWebAPI({api:"SYNO.Core.Region.NTP",version:1,method:"listzone",params:{},scope:this,callback:this.cbListzone})}},cbListzone:function(c,b,a){if(c){this.loadData(b.zonedata,false)}else{this.loadData(SYNO.SS.Utils.GetTimeZoneStore())}this.hasLoaded=true}});Ext.define("SYNO.SS.App.System.FirmwarePanel",{extend:"SYNO.SDS.Utils.FormPanel",PACKAGE_NAME:"SurveillanceStation",INSTALL_TASK_ID:"@SYNOPKG_DOWNLOAD_SurveillanceStation",RELEASE_NOTE_URL:"http://sy.to/svsnote",BETA_PROGRAM_URL:"https://www.synology.com/zh-tw/beta",FIELD_WIDTH:280,owner:null,pollingId:null,upgradeFileName:null,fieldDesc:null,fieldVersion:null,fieldUpdateStatus:null,chkAutoUpdate:null,btnDownload:null,btnUpdate:null,btnCancel:null,btnSave:null,btnClose:null,fieldDownload:null,ctUpdate:null,constructor:function(a){this.owner=a.owner;this.Init();this.callParent([Ext.apply(a,{title:_T("firmware_update","firmware_update"),labelWidth:this.FIELD_WIDTH,items:[this.fieldDesc,this.fieldVersion,this.fieldUpdateStatus,this.ctUpdate],buttons:[this.btnSave,this.btnClose],listeners:{deactivate:this.Deactivate,scope:this}})])},Init:function(){this.fieldDesc=new SYNO.ux.DisplayField({value:_T("firmware_update","update_desc1")});this.fieldVersion=new SYNO.ux.DisplayField({fieldLabel:_T("system","svs_version")});this.fieldUpdateStatus=new SYNO.ux.DisplayField({fieldLabel:_T("ss_common","status")});this.chkAutoUpdate=new SYNO.ux.Checkbox({boxLabel:_T("addons","auto_update"),width:this.FIELD_WIDTH});this.btnDownload=new SYNO.ux.Button({text:_T("ss_common","common_download"),style:"margin-left: 5px;",hidden:true,handler:this.OnDownload,scope:this});this.btnUpdate=new SYNO.ux.Button({text:_T("localdisplay","ntp_updatenow"),style:"margin-left: 5px;",hidden:true,handler:this.OnUpdate,scope:this});this.btnCancel=new SYNO.ux.Button({text:_T("ss_common","common_cancel"),style:"margin-left: 5px;",hidden:true,handler:this.OnCancel,scope:this});this.btnSave=new SYNO.ux.Button({name:"btnSave",text:_T("ss_common","common_save"),btnStyle:"blue",handler:this.OnSave,scope:this});this.btnClose=new SYNO.ux.Button({name:"btnClose",text:_T("ss_common","close"),handler:function(){this.owner.close()},scope:this});this.fieldDownload=new SYNO.ux.DisplayField({style:"margin-left: 15px;",hidden:true});this.ctUpdate=new Ext.Container({layout:"hbox",style:"margin-top: 10px",items:[this.chkAutoUpdate,this.btnUpdate,this.btnDownload,this.btnCancel,this.fieldDownload]})},InitData:function(){this.sendWebAPI({compound:{mode:"parallel",params:this.GetWebAPIs()},callback:function(d,c){var b,a;if((false===d)||(true===c.has_fail)){this.Alert(SYNO.API.getErrorString(c));return}b=SYNO.API.Util.GetValByAPI(c,"SYNO.SurveillanceStation.System","GetFirmwareInfo");a=SYNO.API.Util.GetValByAPI(c,"SYNO.Core.Package.Installation","status");this.InitBasicInfo(b.basicInfo);this.InitUpgradeInfo(b.upgradeInfo,a)},scope:this})},Deactivate:function(){if(null!=this.pollingId){clearTimeout(this.pollingId)}},Alert:function(a){this.owner.getMsgBox().alert(this.title,a)},OnSave:function(){var a=(true===this.chkAutoUpdate.getValue())?"AutoUpdateEnable":"AutoUpdateDisable";if(false===this.IsDirty()){this.setStatusError({text:_T("ss_common","setting_nochange")});return}this.setStatusBusy();this.sendWebAPI({api:"SYNO.SurveillanceStation.System",method:a,version:1,callback:function(b){this.clearStatusBusy();if(false===b){this.Alert(SYNO.API.getErrorString(apiResp));return}this.chkAutoUpdate.originalValue=this.chkAutoUpdate.getValue();this.setStatusOK()},scope:this})},IsDirty:function(){return this.chkAutoUpdate.isDirty()},ResetForm:function(){if(false===this.IsDirty()){return}this.chkAutoUpdate.reset()},InitBasicInfo:function(b){var a=b.additional.autoupdate;this.fieldVersion.setValue(b.version);this.chkAutoUpdate.setValue(a);this.chkAutoUpdate.originalValue=a},InitUpgradeInfo:function(a,c){var b,d;var f,e;this.infoUpgradeFile={url:a.link,name:this.PACKAGE_NAME,filesize:a.size,checksum:a.checksum};if(true===a.installing){b=_T("localdisplay","installing")}else{if(true===a.blupgrade){e=(true!==a.beta)?a.version:(a.version+" ("+_T("firmware_update","beta")+")");f=(true!==a.beta)?this.RELEASE_NOTE_URL:this.BETA_PROGRAM_URL;b=String.format('<span class = "green-status">'+_T("firmware_update","update_ss_upgrade")+"</span>",e);d='(<a target="_blank" href = "'+f+'">'+_T("device_pack","update_dp_whats_new")+"</a>)";b=b+" "+d}else{b=String.format('<span class = "green-status">'+_T("firmware_update","no_new_update")+"</span>")}}this.fieldUpdateStatus.setValue(b);if((true===a.blupgrade)&&(true===c.finished)){if(true===Ext.isDefined(c.taskid)){this.btnDownload.hide();this.btnUpdate.show()}else{this.btnDownload.show();this.btnUpdate.hide()}}else{this.btnDownload.hide();this.btnUpdate.hide()}this.ctUpdate.doLayout()},GetWebAPIs:function(){return[{api:"SYNO.SurveillanceStation.System",method:"GetFirmwareInfo",version:1},{api:"SYNO.Core.Package.Installation",method:"status",version:1,params:{task_id:"@SYNOPKG_DOWNLOAD_SurveillanceStation"}}]},OnDownload:function(){this.btnDownload.setDisabled(true);this.sendWebAPI({api:"SYNO.SurveillanceStation.System",method:"CheckUpgradeEnv",version:1,params:{id:this.PACKAGE_NAME,size:this.infoUpgradeFile.size},callback:this.CheckEnvCallback,scope:this})},CheckEnvCallback:function(b,a){if(!b){this.btnDownload.setDisabled(false);this.Alert(SYNO.API.getErrorString(a));return}this.sendWebAPI({api:"SYNO.Core.Package.Installation",method:"install",version:1,params:this.infoUpgradeFile,callback:this.DownloadCallback,scope:this})},DownloadCallback:function(b,a){if(!b){this.Alert(SYNO.API.getErrorString(a));return}this.UpdateBtnToDownloading();this.PollingStatus();this.btnDownload.setDisabled(false)},UpdateBtnToDownloading:function(){this.btnDownload.hide();this.btnCancel.show();this.fieldDownload.setValue("");this.fieldDownload.show();this.ctUpdate.doLayout()},PollingStatus:function(){this.sendWebAPI({api:"SYNO.Core.Package.Installation",method:"status",version:1,params:{task_id:this.INSTALL_TASK_ID},callback:this.PollingStatusCallback,scope:this})},PollingStatusCallback:function(c,a){var b=function(d){return _T("device_pack","status_dp_downloading")+"("+Math.round(d*100)+"%)"};if(false===c){this.Alert(SYNO.API.getErrorString(a));return}if(true===a.finished){this.btnCancel.hide();this.fieldDownload.hide();if(true===Ext.isDefined(a.taskid)){this.btnUpdate.show()}else{this.btnDownload.show()}this.ctUpdate.doLayout()}else{if(1>a.progress){this.fieldDownload.setValue(b(a.progress));this.pollingId=setTimeout(this.PollingStatus.createDelegate(this),1000)}else{if(true===a.installing){this.pollingId=setTimeout(this.PollingStatus.createDelegate(this),1000)}}}},OnCancel:function(){this.btnCancel.setDisabled(true);this.fieldDownload.hide();this.sendWebAPI({api:"SYNO.Core.Package.Installation",method:"cancel",version:1,params:{taskid:this.INSTALL_TASK_ID},callback:this.CancelCallback,scope:this})},CancelCallback:function(b,a){if(false===b){this.Alert(SYNO.API.getErrorString(a))}else{this.btnCancel.hide()}this.btnCancel.setDisabled(false)},OnUpdate:function(){this.btnUpdate.setDisabled(true);this.setStatusBusy();this.sendWebAPI({api:"SYNO.Core.Package.Installation.Download",method:"check",version:1,params:{taskid:this.INSTALL_TASK_ID},callback:this.CheckPkgCallBack,scope:this})},CheckPkgCallBack:function(b,a){this.clearStatusBusy();if(false==b){this.btnDownload.show();this.btnUpdate.hide();this.upgradeFileName="";this.ctUpdate.doLayout()}else{this.upgradeFileName=a.filename;this.CheckBeforeUpgrade()}this.btnUpdate.setDisabled(false)},CheckBeforeUpgrade:function(){var a=(LOCAL_DS_ID===this.owner.getAppDSId())?String.format(_T("visualstation","firmware_restart_confirm"),this.owner.GetModelName()):_T("firmware_update","rec_firmware_upgrade_tip");this.owner.getMsgBox().confirm(this.title,a,function(b){if("yes"===b){this.DoUpgrade()}},this)},DoUpgrade:function(){if(LOCAL_DS_ID===this.owner.getAppDSId()){SYNO.SDS.Desktop.getMsgBox().show({closable:false,icon:"sm-desktop-mask-icon",msg:_T("localdisplay","installing"),title:this.title})}else{this.owner.getMsgBox().show({closable:false,icon:"sm-desktop-mask-icon",msg:_T("localdisplay","installing"),title:this.title})}this.sendWebAPI({api:"SYNO.Core.Package.Installation",method:"install",version:1,timeout:420000,params:{path:this.upgradeFileName,timeout:420},callback:this.UpgradeCallBack,scope:this})},UpgradeCallBack:function(b,a){if(false===b){if(LOCAL_DS_ID===this.owner.getAppDSId()){SYNO.SDS.Desktop.getMsgBox().hide()}else{this.owner.getMsgBox().hide()}this.Alert(SYNO.API.getErrorString(a))}else{if(LOCAL_DS_ID!==this.owner.getAppDSId()){this.findAppWindow().close()}}}});Ext.namespace("SYNO.SS.App.System");Ext.define("SYNO.SS.App.System.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SS.App.System.MainWindow"});Ext.define("SYNO.SS.App.System.MainWindow",{extend:"SYNO.SDS.TabPanelAppWindow",WIN_MIN_WIDTH:1100,WIN_MIN_HEIGHT:570,panelList:null,panelInfo:null,panelStorage:null,panelNetwork:null,panelTime:null,panelFirmware:null,tabIndex:{NONE:-1,INFO:0,STORAGE:1,NETWORK:2,TIME:3,FIRMWARE:4},constructor:function(a){this.Init();this.callParent([Ext.apply(a,{layout:"fit",deferredRender:false,width:this.WIN_MIN_WIDTH,height:this.WIN_MIN_HEIGHT,minWidth:this.WIN_MIN_WIDTH,minHeight:this.WIN_MIN_HEIGHT,tabIndex:this.tabIndex,panelList:this.panelList,listeners:{beforeclose:this.OnBeforeClose,scope:this}})]);this.mon(this.tabPanel,"beforetabchange",this.OnBeforeTabChange,this)},onOpen:function(){this.callParent(arguments);this.InitPanelData()},Init:function(){this.InitPanelInfo();this.InitPanelStorage();this.InitPanelNetwork();this.InitPanelTime();this.InitPanelFirmware();this.panelList=[this.panelInfo,this.panelStorage,this.panelNetwork,this.panelTime,this.panelFirmware]},InitPanelData:function(){Ext.each(this.panelList,function(a){if(true===Ext.isFunction(a.InitData)){a.InitData()}},this)},OnBeforeTabChange:function(b,c,a){if((!a)||(false===Ext.isFunction(a.IsDirty))||(false===a.IsDirty())){return true}this.getMsgBox().confirm(this.title,_T("ss_common","confirm_lostchange"),function(d){if("yes"===d){a.ResetForm();b.setActiveTab(c.getItemId())}});return false},OnBeforeClose:function(){if((false===this.panelTime.IsDirty())&&(false===this.panelFirmware.IsDirty())){return true}this.getMsgBox().confirm(this.title,_T("ss_common","confirm_lostchange"),function(a){if("yes"===a){this.panelTime.ResetForm();this.panelFirmware.ResetForm();this.close()}},this);return false},InitPanelInfo:function(){this.panelInfo=new SYNO.SS.App.System.InfoPanel({owner:this})},InitPanelStorage:function(){this.panelStorage=new SYNO.SS.App.System.StoragePanel({owner:this})},InitPanelNetwork:function(){this.panelNetwork=new SYNO.SS.App.System.NetworkPanel({owner:this})},InitPanelTime:function(){this.panelTime=new SYNO.SS.App.System.TimePanel({owner:this})},InitPanelFirmware:function(){this.panelFirmware=new SYNO.SS.App.System.FirmwarePanel({owner:this})},GetModelName:function(){var a=this.getAppDSId();var b;if(LOCAL_DS_ID===a){return _S("DS_MODEL_NAME")}else{b=SYNO.SS.GblStore.dsSlaveDS.getById(a);if(!b){return""}return b.get("ds_model")}}});