/* Copyright (c) 2018 Synology Inc. All rights reserved. */

Ext.define("SYNO.SS.App.TimeLapse.TaskList",{extend:"SYNO.ux.Panel",parentWin:null,dsTask:null,dsCateg:null,gridCateg:null,ALL_CATEGORIES:[],gridTaskList:null,panelGridContainer:null,btnAdd:null,btnDelete:null,btnEdit:null,menuItemEnable:null,menuItemDisable:null,btnEnable:null,btnSwitchCateg:null,searchField:null,dlgDel:null,dlgTaskWizard:null,dlgTaskEdit:null,contextMenu:null,prevScheIdx:-1,sortType:null,sortOrder:null,constructor:function(a){this.parentWin=a;this.Init();this.callParent([{title:_T("edge_storage","task"),parentWin:a,layout:"fit",tbar:new SYNO.ux.Toolbar({items:[this.btnAdd,this.btnDelete,this.btnEdit,this.btnEnable,{xtype:"tbfill"},this.btnSwitchCateg,this.searchField]}),items:[this.panelCategContainer],listeners:{activate:this.Activate,scope:this}}]);this.InitEventHandler()},Activate:function(){this.OnRefresh();if(false===this.parentWin.isStatusBusy()){this.panelCategContainer.UpdateEmptyStyle()}this.gridTaskList.refresh()},GetMsgBox:function(){return this.parentWin.getMsgBox()},Mask:function(a){if(true===a){this.parentWin.setStatusBusy()}else{this.parentWin.clearStatusBusy()}},Init:function(){if(true===this.IsLocalDSApp()){this.dsTask=new SYNO.SS.TimeLapseTaskCacheStore({cmp:this,needSort:true,fnRefresh:this.OnRefresh.createDelegate(this),saveSortInfo:true,baseParams:{blGetSortInfo:true},listeners:{load:this.LoadCurrentInfo,scope:this}})}else{this.dsTask=new SYNO.API.JsonStore({autoDestroy:true,appWindow:this,api:"SYNO.SurveillanceStation.TimeLapse",version:1,method:"ListTask",root:"task",totalProperty:"total",idProperty:"id",fields:SYNO.SS.GblStore.fieldTimeLapseTask,sortInfoModNm:SYNO.SS.Sort.TIMELAPSE_TASK,fnCompare:SYNO.SS.Sort.fnCompArchiveTask,listeners:{load:this.LoadCurrentInfo,scope:this}})}this.btnAdd=new SYNO.ux.Button({text:_T("ss_common","common_add"),handler:this.OnTaskAdd,scope:this,disabled:((false===SYNO.SS.UserPrivType.HasMgrPriv())||(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.TIMELAPSE_ADD_DEL_TASK)))});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),handler:this.OnPreDeleteTask,scope:this});this.btnEdit=new SYNO.ux.Button({text:_T("ss_common","common_edit"),handler:this.OnTaskEdit,scope:this});this.menuItemEnable=new Ext.menu.Item({text:_T("ss_common","common_enable"),handler:this.OnTaskEnable,scope:this});this.menuItemDisable=new Ext.menu.Item({text:_T("ss_common","common_disable"),handler:this.OnTaskDisable,scope:this});this.btnEnable=new SYNO.ux.Button({text:_T("ss_common","common_enable"),menu:{items:[this.menuItemEnable,this.menuItemDisable]}});this.dsCateg=new Ext.data.JsonStore({fields:["id","category","entryName","entryVal","taskCnt","type"]});this.ALL_CATEGORIES=[SYNO.SS.Grid.Categ.CATEG_TIME_LAPSE_STATUS,SYNO.SS.Grid.Categ.CATEG_TIME_LAPSE_TYPE];this.gridTaskList=new SYNO.SS.App.TimeLapse.ExpandableListView({owner:this,store:this.dsTask,toggleOnDblClick:false,listeners:{selectionchange:function(c,e){var d=this.gridTaskList.getSelectedRecords();var b=(1===d.length)?d[0]:undefined;this.ChgButtonStatus()},contextmenu:this.OnContextMenu,dblclick:this.OnTaskEdit,scope:this}});this.panelGridContainer=new SYNO.SS.Pgls.PglsGridContainerPanel({region:"center",grid:this.gridTaskList,blCheckInfoSet:true,refreshFunction:this.OnRefresh.bind(this,true),refreshFunctionScope:this});this.gridCateg=new SYNO.SS.Grid.CategoryGridPanel({border:false,category:this.ALL_CATEGORIES,store:this.dsCateg,listeners:{beforereloadcateg:this.gridTaskList.StoreUIState,afterreloadcateg:this.gridTaskList.RestoreUIState,scope:this.gridTaskList},delegate:this,owner:this,GetEntryCount:function(){var b=this.curEntry.recCnt;if(true===this.owner.searchField.IsFiltering()){return this.owner.dsTask.getCount()}return(true===Ext.isNumber(b))?b:-1},sortInfo:{defaultSortItem:SYNO.SS.Sort.ID,sortItems:[SYNO.SS.Sort.NAME,SYNO.SS.Sort.ID],fnList:function(c,b){this.sortType=c;this.sortOrder=b;this.OnRefresh()},fnListScope:this}});this.btnSwitchCateg=this.gridCateg.btnSwitch;this.panelCategContainer=new SYNO.SS.Grid.CategContainerPanel({items:[this.gridCateg,this.panelGridContainer],gridCateg:this.gridCateg,GetParams:this.GetFilterParams.createDelegate(this),fnCountByCateg:this.CountByCateg.createDelegate(this),panelRecord:this.gridTaskList,labelItemCnt:this.panelGridContainer.getBottomToolbar().labelItemCnt,dsRecord:this.dsTask,getStore:function(){return this.dsRecord},emptyStyleMonStore:this.dsTask,emptyStyleTip:_T("time_lapse","no_task_tip"),emptyStyleTipFunc:this.OnTaskAdd.createDelegate(this),fnNeedApplyEmptyStyle:this.HasNoRecord.createDelegate(this),plugins:(true===this.IsLocalDSApp())?SYNO.SS.AutoUpdate.CreateWebSocketAUPlugin({blStable:false,fnCompare:function(d,c){return SYNO.SS.Sort.fnCompArchiveTask(d,c,this.sortOrder,this.sortType)}.createDelegate(this)}):SYNO.SS.AutoUpdate.CreatePluginWithDsId("dsId","",{blUpdAllDs:false,blFromWebsocket:false,fnRefresh:this.OnRefresh.createDelegate(this)}),listeners:{dataupdated:function(){this.panelCategContainer.UpdateCategCount()},scope:this}});this.searchField=new SYNO.SS.SearchFilter({gridList:this.panelCategContainer,categContainer:this.panelCategContainer,fnRecInCateg:this.IsRecInEntry,owner:this,fieldList:["name"],noCheckGridHeader:true});this.panelGridContainer.setVisible(true);var a=SYNO.SS.Sort.RetrieveSortInfo(SYNO.SS.Sort.TIMELAPSE_TASK);sortInfoArray=SYNO.SS.Sort.ParseSortInfo(a);this.sortType=sortInfoArray[0];this.sortOrder=sortInfoArray[1]},InitEventHandler:function(){this.mon(this.dsTask,"load",this.OnStoreDataChange,this);this.mon(this.dsTask,"srcStoreUpdate",this.OnStoreDataChange,this)},OnStoreDataChange:function(){if((0===this.gridTaskList.getSelectedRecords().length)&&(0<this.dsTask.getCount())){this.gridTaskList.select(0)}else{this.ChgButtonStatus()}this.panelCategContainer.UpdateEmptyStyle()},OnTaskAdd:function(){this.dlgTaskWizard=new SYNO.SS.App.TimeLapse.Dialog.Add({parentPanel:this});this.dlgTaskWizard.open();this.mon(this.dlgTaskWizard,"saveDone",this.OnRefresh,this)},CheckBeforeEdit:function(a){if(!a){return false}if((true===a.get("deleted"))||(true===a.get("migrating"))){return false}return true},OnTaskEdit:function(){if(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.TIMELAPSE_EDIT_TASK)){return}var a=this.gridTaskList.getSelectedRecords()[0];var b="timaLapseEditDig-"+a.id;if(false===this.CheckBeforeEdit(a)){return}if(Ext.getCmp(b)){Ext.getCmp(b).show();return}this.dlgTaskEdit=new SYNO.SS.App.TimeLapse.Dialog.Edit({id:b,parentPanel:this,dsTask:this.dsTask,task:a});this.dlgTaskEdit.show();this.addManagedComponent(this.dlgTaskEdit);this.mon(this.dlgTaskEdit,"saveDone",this.OnRefresh,this)},OnTaskEnable:function(){var a=this.GetSelTaskIdList();var b={id:a.join(",")};this.SendWebAPIRequest("EnableTask",b)},OnTaskDisable:function(){var a=this.GetSelTaskIdList();var b={id:a.join(",")};this.SendWebAPIRequest("DisableTask",b)},OnPreDeleteTask:function(){if(true===SYNO.SS.App.Archiving.Utils.IsTaskAllDeleted(this.dsTask,this.GetSelTaskIdList())){this.parentWin.getMsgBox().confirm("",_T("archive","task_del_deleted_task"),function(a){if("yes"===a){this.OnDeleteTask(0)}},this)}else{if((this.dlgDel)&&(false===this.dlgDel.hidden)){return}this.dlgDel=new SYNO.SS.Window.RadioOptionWindow({owner:this.parentWin,width:400,height:200,title:_T("ss_common","common_delete"),desc:_T("time_lapse","confirm_del_task"),rdoLabelList:[_T("camera","camera_del_remove_event"),_T("camera","camera_del_keep_event")],okCallback:this.OnDeleteTask.bind(this)});this.dlgDel.show()}},OnDeleteTask:function(c){var a=this.GetSelTaskIdList();var b=0;var d;if(true===Ext.isDefined(c)){b=(1===c)?1:0}d={id:a.join(","),keepRec:b};this.SendWebAPIRequest("DeleteTask",d)},OnRefresh:function(b){if(true===this.isDestroyed){return}if(true===this.IsLocalDSApp()){if(true===b){SYNO.SS.GblStore.TimeLapseLoad();return}var a=Ext.applyIf({sortInfo:SYNO.SS.Sort.GetSortInfo(this.sortType,this.sortOrder)},this.GetFilterParams());this.dsTask.load({params:a})}else{this.parentWin.setStatusBusy();var c=function(e,d){this.parentWin.clearStatusBusy();if(true===e){this.dsTask.loadData(d,{sortInfo:SYNO.SS.Sort.GetSortInfo(this.sortType,this.sortOrder)})}};this.sendWebAPI({api:"SYNO.SurveillanceStation.TimeLapse",version:1,dsId:this.parentWin.appDSId,method:"ListTask",callback:c,scope:this})}},OnContextMenu:function(a,g,b,d){if(false===SYNO.SS.UserPrivType.HasMgrPriv()){return}if(!this.contextMenu){this.contextMenu=new SYNO.ux.Menu({items:[{itemId:"cmTaskEdit",text:_T("ss_common","common_edit"),handler:this.OnTaskEdit,scope:this},{itemId:"cmTaskEnable",text:_T("ss_common","common_enable"),handler:this.OnTaskEnable,scope:this},{itemId:"cmTaskDisable",text:_T("ss_common","common_disable"),handler:this.OnTaskDisable,scope:this},{itemId:"cmTaskDelete",text:_T("ss_common","common_delete"),handler:this.OnPreDeleteTask,scope:this}]});this.addManagedComponent(this.contextMenu)}if(false===a.isSelected(b)){a.select(b)}var f=this.contextMenu;var c=((false===this.btnEdit.disabled)||(false===this.menuItemEnable.disabled)||(false===this.menuItemDisable.disabled)||(false===this.btnDelete.disabled));d.stopEvent();if(true===c){f.getComponent("cmTaskEdit").setVisible(false===this.btnEdit.disabled);f.getComponent("cmTaskEnable").setVisible(false===this.menuItemEnable.disabled);f.getComponent("cmTaskDisable").setVisible(false===this.menuItemDisable.disabled);f.getComponent("cmTaskDelete").setVisible(false===this.btnDelete.disabled);this.contextMenu.showAt(d.getXY())}},HasNoRecord:function(){return(0===this.gridCateg.GetTotalCount())},IncreaseCntOfStsCateg:function(d,b,a){if(false===this.IsSearchFieldKeywordMatch(a)){return}var c=SYNO.SS.App.TimeLapse.Utils.GetStsCategByTaskRecord(a);d[b][c]++},IncreaseCntOfTypeCateg:function(c,b,a){if(false===this.IsSearchFieldKeywordMatch(a)){return}if(SYNO.SS.TimeLapse.TaskType.Onetime===a.type){c[b][SYNO.SS.App.TimeLapse.Def.LOG_CATEG_ONETIME]++}else{c[b][SYNO.SS.App.TimeLapse.Def.LOG_CATEG_SCHEDULE]++}},IsSearchFieldKeywordMatch:function(b){if(true===Ext.isEmpty(this.searchField.strKeyword)){return true}if(false===Ext.isDefined(b)){return false}var d=false;var c=this.searchField.fieldList;var e;for(var a=0;a<c.length;a++){if(false===Ext.isDefined(b[c[a]])){continue}e=b[c[a]].toString().toLowerCase();if(-1<e.indexOf(this.searchField.strKeyword.toLowerCase())){d=true;break}}return d},CountByCateg:function(){var e=Ext.apply(this.GetFilterParams(),{limit:0});var a=this.dsTask;var f,c;if(true===this.IsLocalDSApp()){var b=a.GetDataFromSrcStore(e);f=b[a.root];c=b[a.totalProperty]}else{f=a.reader.jsonData.task;c=a.reader.jsonData.total}var d={};Ext.each(this.ALL_CATEGORIES,function(g){d[g]={};if(SYNO.SS.Grid.Categ.CATEG_TIME_LAPSE_STATUS===g){d[g][SYNO.SS.Grid.Categ.VALUE_ALL]=0;d[g][SYNO.SS.App.TimeLapse.Def.LAPSE_STS_NORMAL]=0;d[g][SYNO.SS.App.TimeLapse.Def.LAPSE_STS_DISABLED]=0;d[g][SYNO.SS.App.TimeLapse.Def.LAPSE_STS_COMPLETED]=0;d[g][SYNO.SS.App.TimeLapse.Def.LAPSE_STS_DELETED]=0;d[g][SYNO.SS.App.TimeLapse.Def.LAPSE_STS_ABNORMAL]=0}else{if(SYNO.SS.Grid.Categ.CATEG_TIME_LAPSE_TYPE===g){d[g][SYNO.SS.Grid.Categ.VALUE_ALL]=0;d[g][SYNO.SS.App.TimeLapse.Def.LOG_CATEG_ONETIME]=0;d[g][SYNO.SS.App.TimeLapse.Def.LOG_CATEG_SCHEDULE]=0}}},this);f.forEach(function(g){this.IncreaseCntOfStsCateg(d,SYNO.SS.Grid.Categ.CATEG_TIME_LAPSE_STATUS,g);this.IncreaseCntOfTypeCateg(d,SYNO.SS.Grid.Categ.CATEG_TIME_LAPSE_TYPE,g)},this);Ext.each(this.ALL_CATEGORIES,function(h){var j=0;for(var g in d[h]){j+=d[h][g]}d[h][SYNO.SS.Grid.Categ.VALUE_ALL]=j},this);d.total=c;return d},GetFilterParams:function(){return Ext.apply({},this.dsTask.baseParams)},GetSelTaskIdList:function(){var b=this.gridTaskList.getSelectedRecords();var d=[];var a,c;for(c=0;c<b.length;c++){a=b[c];d.push(a.get("id"))}return d},ChgButtonStatus:function(){var g=this.dsTask.snapshot||this.dsTask.data;var c=this.gridTaskList.getSelectedRecords();var e=c.length;var h=false;var d=false;var a=false;var f=false;var b;this.btnDelete.disable();this.btnEnable.disable();this.btnEdit.disable();this.menuItemEnable.disable();this.menuItemDisable.disable();if(false===SYNO.SS.UserPrivType.HasMgrPriv()){return}for(i=0;i<e;i++){b=c[i];if(true===b.get("enabled")){h=true}else{d=true}if(true===b.get("deleted")){a=true}if(true===b.get("migrating")){f=true}}if(true===f){return}if(1<=e){if(true===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.TIMELAPSE_ADD_DEL_TASK)){this.btnDelete.enable()}if(true===a){return}if(((true===h)||(true===d))&&(true===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.TIMELAPSE_EDIT_TASK))){this.menuItemEnable.setDisabled(false===d);this.menuItemDisable.setDisabled(false===h);this.btnEnable.enable()}if((true===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.TIMELAPSE_EDIT_TASK))&&(1===e)&&(false===b.get("deleted"))&&(true!==b.get("configuring"))&&(false===b.get("migrating"))){this.btnEdit.enable()}}},LoadCurrentInfo:function(c,b,d){var e;var a=SYNO.SS.Sort.RetrieveSortInfo(SYNO.SS.Sort.TIMELAPSE_TASK);this.gridCateg.ReloadDsCateg();if(false===Ext.isEmpty(a)){this.gridCateg.sortMenu.SetSortInfo(a);e=SYNO.SS.Sort.ParseSortInfo(a);this.sortType=e[0];this.sortOrder=e[1]}this.ChgButtonStatus()},SendWebAPIRequest:function(b,a){this.Mask(true);this.parentWin.OnSendWebAPI({params:a,method:b,callback:this.OnWebapiDone,scope:this})},OnWebapiDone:function(b,a){this.Mask(false);this.OnRefresh()},FilterCateg:function(c,b,a){this.searchField.FilterList()},IsRecInEntry:function(d,f){var c=SYNO.SS.Grid.Categ;var b=parseInt(f.get("type"),10);var e=d.curEntry.type;var a=d.curEntry.entryVal;switch(e){case c.ENTRY_ALL:return true;case c.ENTRY_TIME_LAPSE_STATUS:return(a===SYNO.SS.App.TimeLapse.Utils.GetStsCategByTaskRecord(f,true));case c.ENTRY_TIME_LAPSE_TYPE:if(SYNO.SS.App.TimeLapse.Def.LOG_CATEG_ONETIME===a){return(SYNO.SS.TimeLapse.TaskType.Onetime===b)}else{return(SYNO.SS.TimeLapse.TaskType.Schedule===b)}}return false},IsLocalDSApp:function(){return(LOCAL_DS_ID===this.parentWin.appDSId)}});Ext.define("SYNO.SS.App.TimeLapse.ExpandableListView",{extend:"SYNO.ux.ExpandableListView",owner:null,selections:[],constructor:function(a){this.owner=a.owner;var b=Ext.apply({innerTpl:new Ext.XTemplate("{id:this.RenderTaskDetail}"),iconTpl:new Ext.XTemplate("{icon:this.RenderTaskIcon}"),titleTpl:new Ext.XTemplate('{name:this.RenderName}<span class="title-status">{status:this.RenderStatus}</span>'),titleRightTpl:new Ext.XTemplate("{task_type:this.RenderTaskType}"),descTpl:new Ext.XTemplate("{ip:this.RenderCameraName}"),descRightTpl:new Ext.XTemplate("{compress_factor:this.RenderCompressFactor}")},a);this.callParent([b]);this.AddTplRenderer()},StoreUIState:function(){this.selections=this.getSelectedItemIds()},RestoreUIState:function(){this.clearSelections();this.restoreUIState(this.selections,[]);this.UpdateSelection();this.ScrollToSelectedNode()},AddTplRenderer:function(){this.tpl.owner=this.owner;this.tpl.expView=this;this.tpl.RenderTaskDetail=function(e,d){var a=[{key:_T("ss_common","occupied"),value:this.RenderOccupiedSize(d)},{key:_T("camera","limit_to"),value:this.RenderRotateCond(d)},{key:_T("camera","storage"),value:this.RenderStoragePath(d)},{key:_T("time_lapse","recording_range"),value:this.RenderRecordingRange(d)}];var c=this.expView.getInnerKeyValTableTpl(a);var b="<div>"+c.html+"</div>";return b};this.tpl.RenderOccupiedSize=function(c){var b=function(d){var e=(d/(1<<30));return(Math.round(e*100)/100).toFixed(1)};var a=b(c.occupiedSize)+" (GB)";return String.format("<span>{0}</span>",a)};this.tpl.RenderRotateCond=function(a){var c=(true===a.blLimitByDate)?a.dayLimit:"--";var b=(true===a.blLimitBySize)?a.sizeLimitGB:"--";return String.format("<span>{0}</span>",c+" "+_T("camera","days")+" / "+b+" GB")};this.tpl.RenderStoragePath=function(a){var e=a.storagePath;var d=e.substring(e.lastIndexOf("/")+1);var c=e.substring(0,e.lastIndexOf("/"));var b=SYNO.SS.Utils.GetRecShareStatusText({shareVolume:c,mountType:SYNO.SS.App.Event.Def.MOUNT_TYPE_NONE});return String.format("<span>{0}</span>",d+" ("+b+")")};this.tpl.RenderStoragePath=function(a){var e=a.storagePath;var d=e.substring(e.lastIndexOf("/")+1);var c=e.substring(0,e.lastIndexOf("/"));var b=SYNO.SS.Utils.GetRecShareStatusText({shareVolume:c,mountType:SYNO.SS.App.Event.Def.MOUNT_TYPE_NONE});return String.format("<span>{0}</span>",d+" ("+b+")")};this.tpl.RenderRecordingRange=function(a){var c,b,d;if(SYNO.SS.TimeLapse.TaskType.Onetime===a.type){b=GenLocalDateTimeStr(a.recStartTime*TRANS_MILLISECOND,false);d=GenLocalDateTimeStr(a.recEndTime*TRANS_MILLISECOND,false);c=String.format(_T("archive","from_to_time"),b,d)}else{b=GenLocalDateTimeStr(a.recStartTime*TRANS_MILLISECOND,false);c=String.format(_T("archive","from_time_start"),b)}return String.format("<span>{0}</span>",c)};this.tpl.RenderTaskIcon=function(e,b){var a;var c=SYNO.SS.App.TimeLapse.Utils.GetStsCategByTaskRecord(b);if(SYNO.SS.App.TimeLapse.Def.LAPSE_STS_ABNORMAL===c){a=(SYNO.SS.TimeLapse.TaskType.Onetime===b.type)?"timelapse-listview-icon-onetm-abnormal":"timelapse-listview-icon-sched-abnormal"}else{if((SYNO.SS.App.TimeLapse.Def.LAPSE_STS_DELETED===c)||(SYNO.SS.App.TimeLapse.Def.LAPSE_STS_DISABLED===c)){a=(SYNO.SS.TimeLapse.TaskType.Onetime===b.type)?"timelapse-listview-icon-onetm-disabled":"timelapse-listview-icon-sched-disabled"}else{a=(SYNO.SS.TimeLapse.TaskType.Onetime===b.type)?"timelapse-listview-icon-onetm-normal":"timelapse-listview-icon-sched-normal"}}var d=String.format("<div class='syno-ux-expandable-listview-icon {0}'></div>",a);return d};this.tpl.RenderName=function(c,a){var b=a.name;return String.format('<span ext:qtip="{0}">{0}</span>',b)};this.tpl.RenderStatus=function(e,b){var c=SYNO.SS.Color.NORMAL_GRAY;var a="";if(true===b.migrating){a=_T("camera","conn_status_migrating")}else{if(true===b.configuring){a=_T("camera","conn_status_configuring")}else{if(true===b.deleted){a=_T("camera","camera_deleted")}else{if(false===b.enabled){a=_T("ss_common","common_disabled")}else{if(false===b.storageAvailable){a=_T("archive","storage_unavailable");c=SYNO.SS.Color.ABNORMAL_ORANGE}else{if((SYNO.SS.TimeLapse.TaskType.Onetime===b.type)&&(SYNO.SS.TimeLapse.TaskSts.Completed===b.status)){a=_T("archive","onetime_task_complete")}else{switch(b.status){case SYNO.SS.TimeLapse.TaskSts.Running:if(SYNO.SS.TimeLapse.TaskType.Onetime===b.type){a=b.progressPercent+"%"}break;case SYNO.SS.TimeLapse.TaskSts.ProcError:a=_T("ss_common","status_abnormal");c=SYNO.SS.Color.ALERT_RED;if(SYNO.SS.TimeLapse.TaskType.Schedule===b.type){var d=SYNO.SS.GblStore.dsCamera.getById(b.cameraId);if(d){if(true===SYNO.SS.Utils.Camera.IsDisconnSts(d.get("camStatus"))){a=_T("time_lapse","cam_disconnected")}else{if(d.get("camStatus")===SYNO.SS.CamSts.DELETED){a=_T("time_lapse","cam_deleted")}else{if(d.get("camStatus")===SYNO.SS.CamSts.DISABLED){a=_T("action_rule","cam_evt_disabled")}}}}else{a=_T("time_lapse","cam_deleted")}}break;default:break}}}}}}}return(""===a)?"":String.format("&nbsp;-&nbsp;<span style='color:{0}'>{1}</span>",c,a)};this.tpl.RenderTaskType=function(c,a){var b=SYNO.SS.Color.NORMAL_BLACK;var d=(SYNO.SS.TimeLapse.TaskType.Schedule===a.type)?_T("archive","schedule_execution"):_T("archive","one_time");return String.format("<span style='color:{0}' ext:qtip='{1}'>{1}</span>",b,d)};this.tpl.RenderCameraName=function(f,c){var d=SYNO.SS.Color.NORMAL_BLACK;var b=this.owner.parentWin.appDSId;var a=(LOCAL_DS_ID===b)?c.cameraId:SYNO.SS.GblStore.GetCamIdOnHost(b,c.cameraId);var e=SYNO.SS.GblStore.dsCamera.getById(a);return String.format("<span style='color:{0}'>{1}</span>",d,(true===Ext.isDefined(e))?e.get("name"):c.cameraName)};this.tpl.RenderCompressFactor=function(c,a){var b=SYNO.SS.Color.NORMAL_BLACK;var d=_T("time_lapse","compress_rate")+": "+a.compressFactor;return String.format("<span style='color:{0}'>{1}</span>",b,d)};this.tpl.RenderString=function(b,a){return(false===Ext.isEmpty(b))?b:"--"}}});Ext.define("SYNO.SS.App.TimeLapse.Task.General",{extend:"SYNO.SDS.Utils.FormPanel",ONETIME_DEF_START_TIME:"00:00",DATE_FILED_WIDTH:185,TIME_FIELD_WIDTH:160,SLASH_WIDTH:15,FIELD_PADDING:10,NAME_LENGTH_LIMIT:64,IMAGE_ICON_SIZE:35,SCHEDULE_TYPE_LABEL_WIDTH:285,GENERAL_FILED_WIDTH:370,SCHEDULE_ID_PREFIX:-1,parentWin:null,cmbCamera:null,cmbStreamProf:null,cmbTaskType:null,dsTask:null,task:null,dsCamera:null,dsCamNameMap:null,dsStmProfile:null,lastCam:null,lastTaskType:null,fldName:null,fldDateFrom:null,fldDateTo:null,fldTimeFrom:null,fldTimeTo:null,labelTimeFrom:null,labelTimeTo:null,slashLabelFrom:null,slashLabelTo:null,panelStartTmPeriod:null,panelEndTmPeriod:null,fsInfo:null,fsSchedule:null,blEditMode:false,appDSId:null,taskType:null,constructor:function(a){this.appDSId=a.appDSId;this.parentWin=a.parentWin;this.dsTask=a.dsTask;this.task=a.task;this.blEditMode=(true===a.blEditMode);this.SCHEDULE_ID_PREFIX=Ext.id();this.SetTaskType(a.task);this.Init();Ext.apply(a,{title:Ext.isDefined(a.title)?a.title:_T("ss_common","general"),owner:this.parentWin,defaults:{labelStyle:"width: 180px"},items:[this.fsInfo,this.fsSchedule],listeners:{activate:function(){this.Activate()},scope:this}});this.callParent([a])},Init:function(){this.PrepareStore();this.fldName=new SYNO.SS.Form.NameTextField({name:"name",width:this.GENERAL_FILED_WIDTH,fieldLabel:_T("archive","task_name"),maxLength:this.NAME_LENGTH_LIMIT,validator:this.IsTaskNameValid.createDelegate(this),listeners:{valid:function(){this.parentWin.pageStorage.UpdatePathLabel()},scope:this}});this.cmbCamera=new SYNO.ux.ComboBox({name:"cameraId",width:this.GENERAL_FILED_WIDTH,fieldLabel:_T("video_analytics","camera"),valueField:"camId",displayField:"camName",mode:"local",disabled:this.blEditMode,triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,emptyText:_T("action_rule","no_avaliable_device"),store:this.dsCamNameMap,listeners:{select:function(c,a,b){if(this.lastCam!==c.getValue()){this.UpdateStmStore(true)}this.lastCam=c.getValue()},scope:this}});this.cmbStreamProf=new SYNO.ux.ComboBox({name:"streamProfType",width:this.GENERAL_FILED_WIDTH,fieldLabel:_T("video_analytics","stream_profile"),valueField:"profileId",displayField:"profileDesc",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,store:this.dsStmProfile});this.cmbTaskType=new SYNO.ux.ComboBox({name:"type",width:this.GENERAL_FILED_WIDTH,fieldLabel:_T("archive","task_type"),valueField:"taskTypeId",displayField:"taskTypeText",mode:"local",disabled:this.blEditMode,triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,store:new Ext.data.ArrayStore({fields:["taskTypeId","taskTypeText"],data:[[SYNO.SS.TimeLapse.TaskType.Schedule,_T("archive","schedule_execution")],[SYNO.SS.TimeLapse.TaskType.Onetime,_T("archive","one_time")]]}),listeners:{afterrender:this.ShowFieldsByTaskType,select:function(c,a,b){if(this.lastTaskType!==c.getValue()){this.ShowFieldsByTaskType();this.LoadCamera()}this.lastTaskType=c.getValue()},scope:this}});this.labelTimeFrom=new Ext.form.Label({text:_T("ss_common","from")+":",cls:"timelapse-date-text-style"});this.fldDateFrom=new SYNO.ux.DateField({name:"recDateFrom",disabled:this.blEditMode,width:this.DATE_FILED_WIDTH,format:"Y/m/d",hideLabel:true,editable:false});this.slahLabelFrom=new Ext.form.Label({text:"/",cls:"timelapse-date-text-style"});this.fldTimeFrom=new SYNO.ux.TimeField({name:"recTimeFrom",disabled:this.blEditMode,width:this.TIME_FIELD_WIDTH,hideLabel:true,format:"H:i",editable:false});this.panelStartTmPeriod=new Ext.Container({autoHeight:true,layout:"form",defaults:{xtype:"container"},items:[{layout:"column",layoutConfig:{columns:4},defaults:{xtype:"container"},items:[{width:this.DATE_FILED_WIDTH,items:this.labelTimeFrom},{width:this.DATE_FILED_WIDTH+this.FIELD_PADDING,items:this.fldDateFrom},{width:this.SLASH_WIDTH,items:this.slahLabelFrom},{width:this.TIME_FIELD_WIDTH+this.FIELD_PADDING,items:this.fldTimeFrom}]}]});this.labelTimeTo=new Ext.form.Label({text:_T("ss_common","to")+":",cls:"timelapse-date-text-style"});this.fldDateTo=new SYNO.ux.DateField({name:"recDateTo",width:this.DATE_FILED_WIDTH,format:"Y/m/d",disabled:this.blEditMode,hideLabel:true,editable:false});this.slashLabelTo=new Ext.form.Label({text:"/",cls:"timelapse-date-text-style"});this.fldTimeTo=new SYNO.ux.TimeField({name:"recTimeTo",width:this.TIME_FIELD_WIDTH,hideLabel:true,disabled:this.blEditMode,format:"H:i",editable:false});this.panelEndTmPeriod=new SYNO.ux.Panel({autoHeight:true,bodyStyle:"margin-top: 4px; ",layout:"form",defaults:{xtype:"container"},items:[{layout:"column",layoutConfig:{columns:4},defaults:{xtype:"container"},items:[{width:this.DATE_FILED_WIDTH,items:this.labelTimeTo},{width:this.DATE_FILED_WIDTH+this.FIELD_PADDING,items:this.fldDateTo},{width:this.SLASH_WIDTH,items:this.slashLabelTo},{width:this.TIME_FIELD_WIDTH+this.FIELD_PADDING,items:this.fldTimeTo}]}]});this.fsInfo=new SYNO.ux.FieldSet({title:_T("action_rule","rule_info"),autoHeight:true,collapsible:true,items:[this.fldName,this.cmbCamera,this.cmbTaskType,this.cmbStreamProf,this.panelStartTmPeriod,this.panelEndTmPeriod]});this.CreateSchedulePanel();this.fsSchedule=new SYNO.ux.FieldSet({title:_T("camera","record_schedule"),autoHeight:true,collapsible:true,items:[this.panelModeSelection,this.panelScheduler]});this.InitData();this.LoadCamera();this.UpdateStmStore(true)},Activate:function(){this.panelScheduler.Activate();if(false===this.blEditMode){this.getForm().clearInvalid()}},InitData:function(){this.cmbTaskType.setValue(SYNO.SS.TimeLapse.TaskType.Schedule);var a=new Date();this.fldDateTo.setValue(a);this.fldTimeTo.setValue(this.ONETIME_DEF_START_TIME);a.setMonth(a.getMonth()-1);this.fldDateFrom.setValue(a);this.fldTimeFrom.setValue(this.ONETIME_DEF_START_TIME)},CreateSchedulePanel:function(){var a;this.panelScheduler=new SYNO.SS.Panel.SchedulerPanel({name:"schedule",htmlSchedulerId:this.SCHEDULE_ID_PREFIX,scheduleMode:SYNO.SS.Schedule.Mode.TIME_LAPSE,blTwoColor:true,disabled:this.IsEdittingOneTimeTask()});a=this.panelScheduler.getId();this.panelAllowNotify=new SYNO.ux.Panel({width:this.IMAGE_ICON_SIZE,html:"<span id='"+this.SCHEDULE_ID_PREFIX+"icon_custom2' class='btn_custom2_active'onMouseOver=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.SCHEDULE_ID_PREFIX+"', 'over', 'continue','"+a+"');\"onMouseOut=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.SCHEDULE_ID_PREFIX+"', 'out', 'continue','"+a+"');\"onMousedown=\"javascript:SYNO.SS.UTILSCHEDULER.ChkLeftMouseDown(event, SYNO.SS.UTILSCHEDULER.ScheduleMouseAction, '"+this.SCHEDULE_ID_PREFIX+"', 'down', 'continue','"+a+"');\"></span>"});this.panelEraseNotify=new SYNO.ux.Panel({width:this.IMAGE_ICON_SIZE,html:"<span id='"+this.SCHEDULE_ID_PREFIX+"icon_erase' class='btn_erase_inactive'onMouseOver=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.SCHEDULE_ID_PREFIX+"', 'over', 'erase','"+a+"');\"onMouseOut=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.SCHEDULE_ID_PREFIX+"', 'out', 'erase','"+a+"');\"onMousedown=\"javascript:SYNO.SS.UTILSCHEDULER.ChkLeftMouseDown(event, SYNO.SS.UTILSCHEDULER.ScheduleMouseAction, '"+this.SCHEDULE_ID_PREFIX+"', 'down', 'erase','"+a+"');\"></span>"});this.labelAllowNotify=new Ext.form.Label({width:this.SCHEDULE_TYPE_LABEL_WIDTH,cls:"x-form-item ss-schedule-label-normal",text:_T("action_rule","available_time")});this.labelEraseNotify=new Ext.form.Label({width:270,cls:"x-form-item ss-schedule-label-normal",text:_T("camera","camera_no_recording")});this.panelModeSelection=new SYNO.SS.Panel.ScheduleModePanel({disabled:this.IsEdittingOneTimeTask(),items:[this.panelAllowNotify,this.labelAllowNotify,this.panelEraseNotify,this.labelEraseNotify]});this.panelScheduler.SetCurrentAct("continue")},PrepareStore:function(){this.dsCamera=new Ext.data.JsonStore({autoDestroy:true,root:"cameras",fields:SYNO.SS.GblStore.fieldCamera});this.dsCamNameMap=new Ext.data.ArrayStore({autoDestroy:true,fields:["camId","camName"],data:[]});this.dsStmProfile=new Ext.data.ArrayStore({autoDestroy:true,fields:["profileId","profileDesc"],data:[]})},LoadCamera:function(){var a=this.cmbCamera.getValue();var c;var b=[];var d=SYNO.SS.GblStore.LoadFromCamStore({params:{blIncludeDeletedCam:(true===SYNO.SS.App.TimeLapse.Utils.IsOneTimeTask(this.cmbTaskType.getValue())),blServerChecked:true,ownerDsId:this.appDSId}},true);this.dsCamera.loadData(d);c=this.dsCamera.getRange();for(i=0;i<c.length;i++){b.push([c[i].get("id"),c[i].get("name")])}this.dsCamNameMap.loadData(b);if(false==Ext.isDefined(this.dsCamera.getById(a))){if(0<this.dsCamNameMap.getCount()){this.cmbCamera.setValue(this.dsCamNameMap.getAt(0).get("camId"))}}},UpdateStmStore:function(g){var j=null;var d=[];var a=[];var h;var c="";var b=this.cmbCamera.getValue();j=this.dsCamera.getById(b);if(true===Ext.isEmpty(j)){a.push([SYNO.SS.CameraProfileType.HIGH,_T("camera","profile_high_quality")]);a.push([SYNO.SS.CameraProfileType.MEDIUM,_T("camera","profile_balanced")]);a.push([SYNO.SS.CameraProfileType.LOW,_T("camera","profile_low_bandwidth")])}else{d=j.get("stm_info");for(var f=0;f<d.length;f++){h=d[f]["type"];c=SYNO.SS.App.Camera.Utils.GetStrProfileType(h)+" ("+SYNO.SS.Utils.Camera.GetCamResolution(d[f]["resolution"])+")";a.push([h,c])}}this.dsStmProfile.loadData(a);if(0<a.length){if(true==g){var e=(2<=a.length)?a[1][0]:a[0][0];this.cmbStreamProf.setValue(e)}else{this.cmbStreamProf.setValue(this.cmbStreamProf.getValue())}}},LoadData:function(a){if(LOCAL_DS_ID!==this.appDSId){a.data.cameraId=SYNO.SS.GblStore.GetCamIdOnHost(this.appDSId,a.get("cameraId"))}this.CheckToPatchCamNameBeforeLoad(a);this.getForm().loadRecord(a);this.LoadTimeRelatedField(a);this.scheduleData=SYNO.SS.Utils.Schedule.GetScheduleData(a.get("schedule"));this.panelScheduler.Activate(this.scheduleData);this.UpdateStmStore(false);this.ShowFieldsByTaskType()},CheckToPatchCamNameBeforeLoad:function(a){if(false===Ext.isDefined(this.dsCamera.getById(a.get("cameraId")))){this.dsCamNameMap.loadData([[a.get("cameraId"),a.get("cameraName")]])}},LoadTimeRelatedField:function(a){this.DoLoadTimeField(a,"recStartTime",this.fldDateFrom,this.fldTimeFrom);this.DoLoadTimeField(a,"recEndTime",this.fldDateTo,this.fldTimeTo)},DoLoadTimeField:function(b,d,a,c){var e=GenLocalDateTime(b.get(d)*TRANS_MILLISECOND,false);a.setValue(e.date);a.initValue();c.setValue(e.time);c.initValue()},ShowFieldsByTaskType:function(){var a=this.cmbTaskType.getValue();if(true===SYNO.SS.App.TimeLapse.Utils.IsOneTimeTask(a)){this.cmbStreamProf.hide();this.fsSchedule.setTitle(_T("archive","archive_recording_time"));this.panelStartTmPeriod.show();this.panelEndTmPeriod.show()}else{this.cmbStreamProf.show();this.fsSchedule.setTitle(_T("camera","record_schedule"));this.panelStartTmPeriod.hide();this.panelEndTmPeriod.hide()}},IsTaskNameValid:function(a){return SYNO.SS.Utils.IsValidName({name:a,fnValidator:function(d){if(true===Ext.isEmpty(this.dsTask)){return true}var e=this.dsTask.data;var c,b;for(c=0;c<e.length;c++){if(this.task&&(this.task.get("id")===e.items[c].get("id"))){continue}if(d===e.items[c].get("name")){return _T("camera","camera_name_repetition")}}return true},scope:this})},IsFormValid:function(){return this.getForm().isValid()},IsDirty:function(){return this.getForm().isDirty()||this.panelScheduler.IsDirty()},ClearDirty:function(){var a=this.getForm().getFieldValues();this.getForm().setValues(a);this.panelScheduler.ClearDirty()},GetSchedule:function(){return this.panelScheduler.GetSchedule()},GetTaskType:function(){return this.cmbTaskType.getValue()},GetTimeRange:function(){if(true===SYNO.SS.App.TimeLapse.Utils.IsOneTimeTask(this.cmbTaskType.getValue())){return{recStartTime:SYNO.SS.Utils.GetUTCFromDateTm(this.fldDateFrom,this.fldTimeFrom),recEndTime:SYNO.SS.Utils.GetUTCFromDateTm(this.fldDateTo,this.fldTimeTo)}}else{return{recStartTime:new Date().getTime()/TRANS_MILLISECOND}}},SetTaskType:function(a){if((a)&&(true===Ext.isDefined(a.get("type")))){this.taskType=a.get("type")}},IsEdittingOneTimeTask:function(){return((true===this.blEditMode)&&(true===SYNO.SS.App.TimeLapse.Utils.IsOneTimeTask(this.taskType)))}});Ext.define("SYNO.SS.App.TimeLapse.Task.Storage",{extend:"SYNO.SS.WIZARD.Storage",DEF_KEEP_DAYS_VAL:180,constructor:function(a){Ext.apply(a,{appFolder:"@TimeLapse",fnIsSchedTask:SYNO.SS.App.TimeLapse.Utils.IsSchedTask,fnIsOneTimeTask:SYNO.SS.App.TimeLapse.Utils.IsOneTimeTask});this.callParent([a])},InitData:function(){var a=[[SYNO.SS.Archiving.ArchiveLimit.RotateFile,_T("camera","rotate_condition_remove")],[SYNO.SS.Archiving.ArchiveLimit.StopArchiving,_T("camera","rotate_condition_stop")]];this.superclass().InitData.call(this);this.cmbboxStorage.fieldLabel=_T("camera","recording_storage");this.dsRotateFile.loadData(a);this.fieldKeepByDate.setValue(this.DEF_KEEP_DAYS_VAL)}});Ext.define("SYNO.SS.App.TimeLapse.Task.Setting",{extend:"SYNO.SDS.Utils.FormPanel",ONETIME_DEF_START_TIME:"00:00",GENERAL_FIELD_WIDTH:200,GENERAL_LABEL_WIDTH:280,ADVANCED_LABEL_WIDTH:255,TRUNCATE_MIN_MAX:240,COMPRESS_MIN:60,COMPRESS_MAX:9000,DAY_TO_HR:24,HR_TO_MINUTE:60,LOW_FPS_DESC:"10",MEDIUM_FPS_DESC:"20",HIGH_FPS_DESC:"30",BEST_FPS_DESC:"60",parentWin:null,cmbVideoSmooth:null,cmbDetectMode:null,cmbReducedType:null,fldTruncateMinute:null,fldCompressFactor:null,fldReducedCompressFactor:null,labelTimeScale:null,chkReduceTimeFactor:null,lastReducedType:null,fsRecording:null,fsAdvanced:null,blEditMode:false,constructor:function(a){this.parentWin=a.parentWin;this.blEditMode=(true===a.blEditMode);this.Init();Ext.apply(a,{title:Ext.isDefined(a.title)?a.title:_T("ss_common","setting"),trackResetOnLoad:true,owner:this.parentWin,items:[this.fsRecording,this.fsAdvanced],listeners:{activate:function(){this.Activate()},scope:this}});this.callParent([a])},Init:function(){this.fldTruncateMinute=new SYNO.ux.TextField({name:"trucateMinute",fieldLabel:_T("time_lapse","truncate_length"),width:this.GENERAL_FIELD_WIDTH,allowBlank:false,vtype:"integer",value:6,validator:this.IsValidTruncateMinute.createDelegate(this),validateOnBlur:true,invalidText:String.format(_T("event_detection","enter_value_between"),1,this.TRUNCATE_MIN_MAX),listeners:{valid:function(){this.UpdateTimeScaleText()},afterrender:function(){SYNO.SS.Utils.AddTip(this.fldTruncateMinute.getEl(),String.format(_T("time_lapse","value_range_tip"),1,this.TRUNCATE_MIN_MAX))},scope:this}});this.fldCompressFactor=new SYNO.ux.TextField({name:"compressFactor",fieldLabel:_T("time_lapse","compress_factor"),width:this.GENERAL_FIELD_WIDTH,allowBlank:false,value:240,vtype:"integer",validator:this.IsValidCompressFactor.createDelegate(this),validateOnBlur:true,listeners:{valid:function(){if(false===Ext.isEmpty(this.fldReducedCompressFactor)){this.fldReducedCompressFactor.validate()}this.UpdateTimeScaleText();this.UpdateReducedCompToolTip()},afterrender:function(){SYNO.SS.Utils.AddTip(this.fldCompressFactor.getEl(),String.format(_T("time_lapse","value_range_tip"),this.COMPRESS_MIN,this.COMPRESS_MAX))},scope:this}});this.cmbVideoSmooth=new SYNO.ux.ComboBox({name:"videoSmooth",width:this.GENERAL_FIELD_WIDTH,fieldLabel:_T("camera","camera_attr_fps"),valueField:"smoothId",displayField:"smoothDesc",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,store:new Ext.data.ArrayStore({fields:["smoothId","smoothDesc"],data:[[SYNO.SS.App.TimeLapse.Def.SMOOTH_LOW_IDX,this.LOW_FPS_DESC],[SYNO.SS.App.TimeLapse.Def.SMOOTH_MEDIUM_IDX,this.MEDIUM_FPS_DESC],[SYNO.SS.App.TimeLapse.Def.SMOOTH_HIGH_IDX,this.HIGH_FPS_DESC],[SYNO.SS.App.TimeLapse.Def.SMOOTH_BEST_IDX,this.BEST_FPS_DESC]]})});this.labelTimeScale=new SYNO.ux.DisplayField({cls:"timelapse-duration-noti-txt"});this.chkReduceTimeFactor=new SYNO.SS.Form.Checkbox({name:"blReduceTimeFactor",boxLabel:_T("time_lapse","reduce_comp_desc"),checked:false,listeners:{check:function(c,e){var d=((true===e)&&(false===c.disabled));this.fldReducedCompressFactor.setDisabled(!d);this.cmbReducedType.setDisabled(!d);this.cmbDetectMode.setDisabled(!d);if((true===d)&&(""!==this.fldReducedCompressFactor.getValue())){this.fldReducedCompressFactor.validate()}if(false===d){this.fldReducedCompressFactor.clearInvalid()}},scope:this}});var a=[[_T("ss_common","trigger_motion")],[_T("ss_common","trigger_digital_input")],[_T("ss_common","trigger_tampering")],[_T("ss_common","trigger_audio")],[_T("ss_common","trigger_pir")],[_T("ss_common","trigger_acap")]];var b=new Ext.data.ArrayStore({autoDestroy:true,fields:["mode"],data:a});this.cmbDetectMode=new SYNO.SS.Form.MultiSelectField({name:"detectMode",width:this.GENERAL_FIELD_WIDTH,fieldLabel:_T("camera","detection"),labelStyle:"margin-left: 30px; line-height: 28px; padding: 0px",editable:false,allowBlank:false,displayField:"mode",disabled:true,strAllItems:_T("axis_access_controller","all_events"),store:b});this.cmbReducedType=new SYNO.ux.ComboBox({name:"reducedCompType",width:this.GENERAL_FIELD_WIDTH,fieldLabel:_T("time_lapse","compress_option"),valueField:"reducedTypeId",displayField:"reducedTypeDesc",labelStyle:"padding-left: 30px",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,disabled:true,store:new Ext.data.ArrayStore({fields:["reducedTypeId","reducedTypeDesc"],data:[[SYNO.SS.App.TimeLapse.Def.REDUCED_TYPE_CUSTOMIZE_IDX,_T("ss_common","common_customize")],[SYNO.SS.App.TimeLapse.Def.REDUCED_TYPE_NO_COMPRESS_IDX,_T("time_lapse","original_speed")]]}),listeners:{select:function(e,c,d){if(this.lastReducedType!==e.getValue()){this.CheckToShowFldReducedComp()}this.lastReducedType=e.getValue()},scope:this}});this.fldReducedCompressFactor=new SYNO.ux.TextField({name:"reducedCompressFactor",value:this.COMPRESS_MIN,fieldLabel:_T("time_lapse","customized_compress"),width:this.GENERAL_FIELD_WIDTH,labelStyle:"padding-left: 30px",allowBlank:false,disabled:true,vtype:"integer",validator:this.IsValidReducedFactor.createDelegate(this),validateOnBlur:true,listeners:{afterrender:function(){var c=String.format(_T("time_lapse","value_range_tip"),this.COMPRESS_MIN,this.fldCompressFactor.getValue())+"<br>"+_T("time_lapse","reduce_comp_notice_tip");SYNO.SS.Utils.AddTip(this.fldReducedCompressFactor.getEl(),c)},scope:this}});this.fsRecording=new SYNO.ux.FieldSet({title:_T("camera","recording"),autoHeight:true,collapsible:true,labelWidth:this.GENERAL_LABEL_WIDTH,items:[this.fldTruncateMinute,this.fldCompressFactor,this.cmbVideoSmooth,this.labelTimeScale]});this.fsAdvanced=new SYNO.ux.FieldSet({title:_T("ss_common","advanced"),autoHeight:true,collapsible:true,labelWidth:this.ADVANCED_LABEL_WIDTH,items:[this.chkReduceTimeFactor,this.cmbDetectMode,this.cmbReducedType,this.fldReducedCompressFactor]});this.InitData();this.UpdateTimeScaleText()},InitData:function(){this.cmbVideoSmooth.setValue(SYNO.SS.App.TimeLapse.Def.SMOOTH_HIGH_IDX);this.cmbReducedType.setValue(SYNO.SS.App.TimeLapse.Def.REDUCED_TYPE_CUSTOMIZE_IDX)},Activate:function(){if(false===this.blEditMode){this.getForm().clearInvalid()}},LoadData:function(a){this.getForm().loadRecord(a);this.CheckToShowFldReducedComp();this.chkReduceTimeFactor.fireEvent("check",this.chkReduceTimeFactor,this.chkReduceTimeFactor.getValue())},IsValidTruncateMinute:function(b){var a=parseInt(b,10);if((0>=a)||(this.TRUNCATE_MIN_MAX<a)){return false}return true},IsValidCompressFactor:function(b){var a=parseInt(b,10);if((this.COMPRESS_MIN>a)||(this.COMPRESS_MAX<a)){return String.format(_T("event_detection","enter_value_between"),this.COMPRESS_MIN,this.COMPRESS_MAX)}return true},IsValidReducedFactor:function(c){var b=parseInt(c,10);var a=(true===this.fldCompressFactor.isValid())?this.fldCompressFactor.getValue():this.COMPRESS_MAX;if((this.COMPRESS_MIN>b)||(a<b)){return String.format(_T("event_detection","enter_value_between"),this.COMPRESS_MIN,a)}return true},UpdateTimeScaleText:function(){if((true===Ext.isEmpty(this.fldTruncateMinute))||(true===Ext.isEmpty(this.fldCompressFactor))){return}if((false===this.fldTruncateMinute.isValid())||(false===this.fldCompressFactor.isValid())){return}var c=this.fldTruncateMinute.getValue();var b=this.fldCompressFactor.getValue();var e=c*b/this.HR_TO_MINUTE;var d=_T("time_lapse","lapse_length_desc_hr");var a=_T("time_lapse","lapse_length_desc_day");var f;if(this.DAY_TO_HR<e){f=a;e=e/this.DAY_TO_HR}else{f=d}strFormat=String.format(f,'<span class="timelapse-duration-bold"> '+c.toString()," </span>",'<span class="timelapse-duration-bold"> '+e.toFixed(1).toString()," </span>");this.labelTimeScale.setValue(strFormat);this.labelTimeScale.originalValue=strFormat},UpdateReducedCompToolTip:function(){var a=String.format(_T("time_lapse","value_range_tip"),this.COMPRESS_MIN,this.fldCompressFactor.getValue())+"<br>"+_T("time_lapse","reduce_comp_notice_tip");SYNO.SS.Utils.UpdateTip(this.fldReducedCompressFactor.getEl(),a)},IsFormValid:function(){return this.getForm().isValid()},IsDirty:function(){return this.getForm().isDirty()},ClearDirty:function(){var a=this.getForm().getFieldValues();this.getForm().setValues(a)},CheckToShowFldReducedComp:function(){var a=SYNO.SS.App.TimeLapse.Def.REDUCED_TYPE_CUSTOMIZE_IDX===this.cmbReducedType.getValue();this.fldReducedCompressFactor.setVisible(a);if((true==this.chkReduceTimeFactor.getValue())&&(true===a)){this.fldReducedCompressFactor.enable()}else{this.fldReducedCompressFactor.disable()}}});Ext.namespace("SYNO.SS.App.TimeLapse.Dialog");Ext.define("SYNO.SS.App.TimeLapse.Dialog.Add",{extend:"SYNO.SDS.Wizard.ModalWindow",steps:null,parentWin:null,pageGeneral:null,pageSetting:null,pageStorage:null,constructor:function(a){this.parentPanel=a.parentPanel;this.parentWin=a.parentPanel.parentWin;this.InitSteps();Ext.apply(a,{owner:this.parentWin,title:_T("time_lapse","wizard"),banner:false,width:680,height:620,bodyCssClass:"ss_wizard",steps:this.steps,useStatusBar:true});this.callParent([a]);this.pageGeneral.getForm().clearInvalid()},InitSteps:function(){this.pageGeneral=new SYNO.SS.App.TimeLapse.Task.General({nextId:"setting",parentWin:this,blEditMode:false,dsTask:this.parentPanel.dsTask,appDSId:this.parentWin.appDSId,getNext:function(){if(false===this.getForm().isValid()){this.parentWin.setStatusBarError({text:_T("ss_common","forminvalid"),clear:true});return false}if(false===SYNO.SS.App.TimeLapse.Utils.IsOneTimeTask(this.cmbTaskType.getValue())){return this.nextId}this.parentWin.TestRecordingExist(this,this.nextId);return false}});this.pageSetting=new SYNO.SS.App.TimeLapse.Task.Setting({itemId:"setting",nextId:"storage",title:_T("ss_common","setting"),blEditMode:false,parentWin:this,getNext:function(){if(false===this.getForm().isValid()){this.parentWin.setStatusBarError({text:_T("ss_common","forminvalid"),clear:true});return false}return this.nextId}});this.pageStorage=new SYNO.SS.App.TimeLapse.Task.Storage({itemId:"storage",blEditMode:false,parentWin:this,title:_T("camera","storage"),appDSId:this.parentWin.appDSId,activate:function(){this.SetTaskType(this.parentWin.pageGeneral.GetTaskType());this.Activate()},getNext:function(){if(false===this.getForm().isValid()){this.parentWin.setStatusBarError({text:_T("ss_common","forminvalid"),clear:true});return false}this.parentWin.OnSubmit();return false}});this.steps=[this.pageGeneral,this.pageSetting,this.pageStorage]},OnSubmit:function(){var a={enabled:true};this.setStatusBarBusy({text:_T("ss_common","common_saving")});Ext.apply(a,SYNO.SS.App.TimeLapse.Utils.GetTaskSaveParam(this.pageGeneral,this.pageSetting,this.pageStorage,(LOCAL_DS_ID===this.parentWin.appDSId)));this.parentWin.OnSendWebAPI({params:a,method:"SaveTask",callback:this.OnSubmitDone,scope:this})},OnSubmitDone:function(e,c,d,b){var a;this.clearStatusBusy();if(false===e){a=SYNO.API.getErrorString(c);this.getMsgBox().alert(this.title,a);return}this.fireEvent("saveDone");this.close()},TestRecordingExist:function(b,c){var e={};var a=b.cmbCamera.getValue();if(LOCAL_DS_ID!==this.parentWin.appDSId){var d=SYNO.SS.GblStore.dsCamera.getById(a);a=(d)?d.get("camIdOnRecServer"):-1}Ext.apply(e,b.GetTimeRange());Ext.apply(e,{schedule:b.GetSchedule(),cameraId:a});if(e.recStartTime>=e.recEndTime){this.getMsgBox().alert(this.TITLE,_T("event_achieving","export_msg_invalid_range"));return}this.setStatusBarBusy();this.parentWin.OnSendWebAPI({params:e,method:"TestRecordingExist",callback:function(k,h,j,g){var f;this.clearStatusBusy();if(false===k){f=SYNO.API.getErrorString(h);this.getMsgBox().alert(this.title,f);return}this.goNext(c)},scope:this})}});Ext.namespace("SYNO.SS.App.TimeLapse.Dialog");Ext.define("SYNO.SS.App.TimeLapse.Dialog.Edit",{extend:"SYNO.SDS.Window",dsTask:null,btnSave:null,btnClose:null,tabPanel:null,blForceClose:false,parentWin:null,parentPanel:null,constructor:function(b){this.dsTask=b.dsTask;this.task=this.CloneTask(b.task);this.taskType=this.task.get("type");this.parentPanel=b.parentPanel;this.parentWin=b.parentPanel.parentWin;this.Init();var a={id:b.id,title:_T("time_lapse","edit_task")+" - "+this.task.get("name"),width:696,height:616,owner:b.parentWin,maximizable:false,minimizable:false,items:this.tabPanel,alignWin:SYNO.SS.Utils.GetAlignWinParams(this.parentWin)};this.callParent([a]);this.InitTaskData()},Init:function(){this.btnSave=new SYNO.ux.Button({name:"btnSave",btnStyle:"blue",text:_T("ss_common","common_save"),handler:this.CheckAndSave,scope:this});this.btnClose=new SYNO.ux.Button({name:"btnClose",text:_T("ss_common","close"),handler:this.close,scope:this});this.pageGeneral=new SYNO.SS.App.TimeLapse.Task.General({dsTask:this.dsTask,task:this.task,taskId:this.selTaskId,blEditMode:true,parentWin:this,appDSId:this.parentWin.appDSId});this.pageSetting=new SYNO.SS.App.TimeLapse.Task.Setting({title:_T("ss_common","setting"),task:this.task,taskId:this.selTaskId,blEditMode:true,parentWin:this});this.pageStorage=new SYNO.SS.App.TimeLapse.Task.Storage({taskId:this.selTaskId,title:_T("archive","storage"),taskType:this.taskType,blEditMode:true,parentWin:this,appDSId:this.parentWin.appDSId});this.tabPanel=new SYNO.SDS.Utils.TabPanel({activeTab:0,deferredRender:false,cls:"timelapse-edit-win-padding",width:660,height:580,buttons:[this.btnSave,this.btnClose],items:[this.pageGeneral,this.pageSetting,this.pageStorage],listeners:{beforetabchange:this.OnBeforeSwitchTab,scope:this}})},InitTaskData:function(){this.setStatusBusy();this.pageGeneral.LoadData(this.task);this.pageSetting.LoadData(this.task);this.pageStorage.LoadData(this.task);this.clearStatusBusy()},CloneTask:function(a){var b=a.copy();b.data=SYNO.SS.Utils.DeepCopy(a.data);return b},CheckAndSave:function(){if(false===this.IsFormValid()){this.tabPanel.setStatusError({text:_T("ss_common","forminvalid"),clear:true})}else{if(false===this.IsFormDirty()){this.tabPanel.setStatusError({text:_T("ss_common","setting_nochange"),clear:true})}else{this.tabPanel.setStatusBusy({text:_T("ss_common","common_saving")});this.OnSave()}}},OnBeforeSwitchTab:function(b,c,a){if(a&&(false===a.IsFormValid())){b.setStatusError({text:_T("ss_common","forminvalid"),clear:true});return false}},OnSave:function(){var a={id:this.task.get("id")};Ext.apply(a,SYNO.SS.App.TimeLapse.Utils.GetTaskSaveParam(this.pageGeneral,this.pageSetting,this.pageStorage));this.parentWin.OnSendWebAPI({params:a,method:"SaveTask",callback:this.OnSaveDone,scope:this})},OnSaveDone:function(d,b,c,a){this.clearStatusBusy();if(false===d){this.tabPanel.setStatusError();this.getMsgBox().alert(this.title,SYNO.API.getErrorString(b));return}this.tabPanel.setStatusOK({text:_T("ss_common","setting_applied"),clear:true});this.pageGeneral.ClearDirty();this.pageSetting.ClearDirty();this.pageStorage.ClearDirty();this.fireEvent("saveDone")},onClose:function(){if(true===this.blForceClose){return true}if(true===this.IsFormDirty()){this.ConfirmLostChange(function(a){if("yes"===a){this.blForceClose=true;this.close()}},this);return false}return true},ConfirmLostChange:function(b,a){this.getMsgBox().confirm("",_T("ss_common","confirm_lostchange"),b,a)},IsFormDirty:function(){return((true===this.pageGeneral.IsDirty())||(true===this.pageSetting.IsDirty())||(true===this.pageStorage.IsDirty()))},IsFormValid:function(){return((true===this.pageGeneral.getForm().isValid())&&(true===this.pageSetting.getForm().isValid())&&(true===this.pageStorage.getForm().isValid()))}});Ext.namespace("SYNO.SS.App.TimeLapse");Ext.define("SYNO.SS.App.TimeLapse.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SS.App.TimeLapse.MainWindow"});Ext.define("SYNO.SS.App.TimeLapse.MainWindow",{extend:"SYNO.SDS.TabPanelAppWindow",WIN_MIN_WIDTH:980,WIN_MIN_HEIGHT:515,tabIndex:{NONE:-1,TASK:0,RECORDING:1},panelTaskList:null,panelRecording:null,appDSId:null,constructor:function(a){this.Init(a.ownerDsId);this.callParent([Ext.apply({title:"TimeLapse-HC",width:this.WIN_MIN_WIDTH,height:this.WIN_MIN_HEIGHT,minWidth:this.WIN_MIN_WIDTH,minHeight:this.WIN_MIN_HEIGHT,resizable:true,layout:"fit",blNoPadding:true,tabIndex:this.tabIndex,panelList:[this.panelTaskList,this.panelRecording]},a)])},onOpen:function(){this.callParent(arguments)},onClose:function(){},onMinimize:function(){this.callParent()},Init:function(a){this.appDSId=(true===Ext.isNumber(a))?a:LOCAL_DS_ID;this.panelTaskList=this.CreateTabItemForGblSearch("SYNO.SS.App.TimeLapse.TaskList",[this]);this.panelRecording=new SYNO.SS.App.TimeLapse.RecordingListPanel({owner:this,dsTask:this.panelTaskList.dsTask})},OnSendWebAPI:function(a){this.sendWebAPI({api:"SYNO.SurveillanceStation.TimeLapse",version:1,method:a.method,params:a.params,callback:a.callback,scope:a.scope})},getHelpParam:function(){if(this.tabIndex.TASK===this.GetCurrentTabIndex()){return"smart_time_lapse_task.html"}else{if(this.tabIndex.RECORDING===this.GetCurrentTabIndex()){return"smart_time_lapse_recording.html"}}return""}});