/*
 * Decompiled with CFR 0.152.
 */
package com._1c.installer.exceptions;

import com.e1c.g5.i18n.DefaultString;
import com.e1c.g5.i18n.Localizable;
import com.e1c.g5.i18n.LocalizableFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Exceptions {
    public static String generatePrettyMessage(@Nullable String message, @Nonnull Throwable e) {
        Preconditions.checkArgument((e != null ? 1 : 0) != 0, (Object)"exception must be not null");
        StringBuilder builder = new StringBuilder();
        if (message != null) {
            builder.append(message).append(System.lineSeparator());
            builder.append(IMessagesList.Messages.cause(Exceptions.getCommandFailedMessage(e)));
        } else {
            builder.append(Exceptions.getCommandFailedMessage(e));
        }
        return builder.toString();
    }

    private static String getCommandFailedMessage(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        if (ex.getMessage() != null) {
            sb.append(ex.getMessage());
        }
        ArrayList s1 = new ArrayList(4);
        Collections.addAll(s1, ex.getSuppressed());
        Throwable cause = ex.getCause();
        if (cause != null) {
            Collections.addAll(s1, cause.getSuppressed());
        }
        for (Throwable th : s1) {
            if (th.getMessage() == null) continue;
            sb.append(System.lineSeparator());
            sb.append("  ").append(IMessagesList.Messages.cause(th.getMessage()));
        }
        if (cause != null) {
            List chain = Throwables.getCausalChain((Throwable)cause);
            int level = 0;
            for (Throwable th : chain) {
                if (th.getMessage() != null) {
                    sb.append(System.lineSeparator());
                    sb.append(Strings.repeat((String)" ", (int)level)).append(IMessagesList.Messages.cause(th.getMessage()));
                }
                for (Throwable sth : th.getSuppressed()) {
                    if (th.getMessage() == null) continue;
                    sb.append(System.lineSeparator());
                    sb.append(Strings.repeat((String)" ", (int)(level + 2))).append(IMessagesList.Messages.cause(sth.getMessage()));
                }
                ++level;
            }
        }
        return sb.toString();
    }

    private Exceptions() {
    }

    @Localizable
    static interface IMessagesList {
        public static final IMessagesList Messages = (IMessagesList)LocalizableFactory.create(IMessagesList.class);

        @DefaultString(value="cause: {0}")
        public String cause(String var1);
    }
}

