/*
 * Decompiled with CFR 0.152.
 */
package com._1c.installer.model.manifest.common;

import com._1c.installer.model.manifest.common.FileCategories;
import com._1c.installer.model.manifest.common.IMessagesList;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class FileCategoriesXmlAdapter
extends XmlAdapter<String, FileCategories> {
    public FileCategories unmarshal(String categories) throws Exception {
        if (categories == null) {
            return new FileCategories(false, false);
        }
        String[] cats = categories.split(",");
        if (cats.length != 2) {
            throw new IllegalArgumentException(IMessagesList.Messages.cannotParseFileCategories(categories));
        }
        boolean exe = this.parseExecutable(cats[0]);
        boolean mod = this.parseModifiable(cats[1]);
        return new FileCategories(exe, mod);
    }

    public String marshal(FileCategories v) throws Exception {
        throw new UnsupportedOperationException("Installer does not write manifests");
    }

    private boolean parseExecutable(String category) {
        switch (category) {
            case "executable": {
                return true;
            }
            case "nonexecutable": {
                return false;
            }
        }
        throw new IllegalArgumentException(IMessagesList.Messages.unexpectedFileCategory(category, 1));
    }

    private boolean parseModifiable(String category) {
        switch (category) {
            case "modifiable": {
                return true;
            }
            case "nonmodifiable": {
                return false;
            }
        }
        throw new IllegalArgumentException(IMessagesList.Messages.unexpectedFileCategory(category, 2));
    }
}

