/*
 * Decompiled with CFR 0.152.
 */
package com._1c.installer.model.manifest.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.text.MessageFormat;

public enum XmlKnownFolder {
    USER_DESKTOP("user-desktop"),
    COMMON_DESKTOP("common-desktop"),
    USER_DOCUMENTS("user-documents"),
    COMMON_DOCUMENTS("common-documents"),
    USER_PROGRAMS("user-programs"),
    COMMON_PROGRAMS("common-programs"),
    USER_START_MENU("user-start-menu"),
    COMMON_START_MENU("common-start-menu"),
    USER_START_MENU_CATEGORIES_LIST("user-start-menu-categories-list"),
    COMMON_START_MENU_CATEGORIES_LIST("common-start-menu-categories-list"),
    USER_STARTUP("user-startup"),
    COMMON_STARTUP("common-startup"),
    USER_QUICK_LAUNCH_PINNED("user-quick-launch-pinned");

    private final String xmlAttrName;

    public String getXmlAttrName() {
        return this.xmlAttrName;
    }

    public static XmlKnownFolder fromString(String v) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)v) ? 1 : 0) != 0, (Object)"v must not be null or empty");
        for (XmlKnownFolder kf : XmlKnownFolder.values()) {
            if (!kf.xmlAttrName.equalsIgnoreCase(v)) continue;
            return kf;
        }
        String message = MessageFormat.format("Unknown KnownFolder \"{0}\"", v);
        throw new IllegalArgumentException(message);
    }

    public String toString() {
        return this.xmlAttrName;
    }

    private XmlKnownFolder(String xmlAttrName) {
        this.xmlAttrName = xmlAttrName;
    }
}

