/*
 * Decompiled with CFR 0.152.
 */
package com._1c.installer.model.manifest.component1;

import com._1c.chassis.gears.bytesize.ByteSize;
import com._1c.chassis.gears.versions.SemanticVersion;
import com._1c.installer.model.manifest.common.ILink;
import com._1c.installer.model.manifest.common.UserPolicy;
import com._1c.installer.model.manifest.common.gears.ByteSizeXmlAdapter;
import com._1c.installer.model.manifest.common.gears.SemanticVersionXmlAdapter;
import com._1c.installer.model.manifest.component1.ApplicationLink;
import com._1c.installer.model.manifest.component1.Artifacts;
import com._1c.installer.model.manifest.component1.ComponentArch;
import com._1c.installer.model.manifest.component1.ComponentOsType;
import com._1c.installer.model.manifest.component1.ComponentShortcut;
import com._1c.installer.model.manifest.component1.DependencyList;
import com._1c.installer.model.manifest.component1.DocumentLink;
import com._1c.installer.model.manifest.component1.Env;
import com._1c.installer.model.manifest.component1.GroupPolicy;
import com._1c.installer.model.manifest.component1.InclusionType;
import com._1c.installer.model.manifest.component1.Requirements;
import com._1c.installer.model.manifest.component1.RingModulesList;
import com._1c.installer.model.manifest.component1.WebLink;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="component-manifest")
@XmlType(name="componentManifestType", propOrder={"requirements", "id", "version", "size", "inclusionType", "os", "arch", "dependencyList", "artifacts", "shortcuts", "ringModulesList", "env", "user", "group", "links"})
public class ComponentManifest {
    public static final String SCHEMA_VERSION = "1";
    @XmlElement(name="requirements", required=true)
    private Requirements requirements;
    @XmlElement(name="id", required=true)
    private String id;
    @XmlJavaTypeAdapter(value=SemanticVersionXmlAdapter.class)
    @XmlElement(name="version", required=true)
    private SemanticVersion version;
    @XmlJavaTypeAdapter(value=ByteSizeXmlAdapter.class)
    @XmlElement(name="size", required=true)
    private ByteSize size;
    @XmlElement(name="inclusion-type", required=true)
    @XmlSchemaType(name="string")
    private InclusionType inclusionType;
    @XmlElement(name="os", required=true)
    @XmlSchemaType(name="string")
    private ComponentOsType os;
    @XmlElement(name="arch", required=true)
    @XmlSchemaType(name="string")
    private ComponentArch arch;
    @XmlElement(name="dependencies")
    private DependencyList dependencyList;
    @XmlElement(name="artifacts")
    private Artifacts artifacts;
    @XmlElementWrapper(name="shortcuts")
    @XmlElements(value={@XmlElement(name="shortcut", type=ComponentShortcut.class)})
    private List<ComponentShortcut> shortcuts;
    @XmlElement(name="ring-modules")
    private RingModulesList ringModulesList;
    @XmlElement(name="env")
    private Env env;
    @XmlElement(name="user", defaultValue="create-or-update")
    @XmlSchemaType(name="string")
    private UserPolicy user = UserPolicy.CREATE_OR_UPDATE;
    @XmlElement(name="group", defaultValue="create")
    @XmlSchemaType(name="string")
    private GroupPolicy group = GroupPolicy.CREATE;
    @XmlAttribute(name="version", required=true)
    private String schemaVersion;
    @XmlAttribute(name="build-time", required=true)
    private String buildTime;
    @XmlElementWrapper(name="links")
    @XmlElements(value={@XmlElement(name="application", type=ApplicationLink.class), @XmlElement(name="document", type=DocumentLink.class), @XmlElement(name="web", type=WebLink.class)})
    private List<ILink> links;

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public SemanticVersion getVersion() {
        return this.version;
    }

    @Nonnull
    public ByteSize getSize() {
        return this.size;
    }

    @Nonnull
    public InclusionType getInclusionType() {
        return this.inclusionType;
    }

    @Nonnull
    public ComponentOsType getOs() {
        return this.os;
    }

    @Nonnull
    public ComponentArch getArch() {
        return this.arch;
    }

    @Nonnull
    public DependencyList getDependencyList() {
        if (this.dependencyList == null) {
            this.dependencyList = new DependencyList();
        }
        return this.dependencyList;
    }

    @Nonnull
    public Artifacts getArtifacts() {
        if (this.artifacts == null) {
            this.artifacts = new Artifacts();
        }
        return this.artifacts;
    }

    @Nonnull
    public List<ComponentShortcut> getShortcuts() {
        return this.shortcuts != null ? this.shortcuts : Collections.emptyList();
    }

    @Nonnull
    public RingModulesList getRingModulesList() {
        if (this.ringModulesList == null) {
            this.ringModulesList = new RingModulesList();
        }
        return this.ringModulesList;
    }

    @Nonnull
    public Env getEnv() {
        if (this.env == null) {
            this.env = new Env();
        }
        return this.env;
    }

    @Nonnull
    public UserPolicy getUser() {
        return this.user;
    }

    @Nonnull
    public GroupPolicy getGroup() {
        return this.group;
    }

    @Nonnull
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @Nonnull
    public String getBuildTime() {
        return this.buildTime;
    }

    @Nonnull
    public Requirements getRequirements() {
        return this.requirements;
    }

    @Nonnull
    public List<ILink> getLinks() {
        return this.links == null ? ImmutableList.of() : ImmutableList.copyOf(this.links);
    }
}

